/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.authoring.ui.forms;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.epf.authoring.ui.AuthoringUIResources;
import org.eclipse.epf.authoring.ui.AuthoringUIText;
import org.eclipse.epf.authoring.ui.editors.MethodElementEditor;
import org.eclipse.epf.authoring.ui.filters.WorkProductFilter;
import org.eclipse.epf.authoring.ui.forms.AssociationFormPage;
import org.eclipse.epf.library.edit.IFilter;
import org.eclipse.epf.library.edit.TngAdapterFactory;
import org.eclipse.epf.library.edit.command.IActionManager;
import org.eclipse.epf.library.edit.itemsfilter.FilterConstants;
import org.eclipse.epf.library.edit.ui.UserInteractionHelper;
import org.eclipse.epf.uma.ContentElement;
import org.eclipse.epf.uma.Domain;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.UmaPackage;
import org.eclipse.epf.uma.WorkProduct;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.forms.editor.FormEditor;

public class DomainWorkProductsPage
extends AssociationFormPage {
    private static final String FORM_PAGE_ID = "domainWorkProductsPage";
    private Domain domain;
    private IActionManager actionMgr;

    public DomainWorkProductsPage(FormEditor editor) {
        super(editor, FORM_PAGE_ID, AuthoringUIText.WORK_PRODUCTS_PAGE_TITLE);
    }

    public void init(IEditorSite site, IEditorInput input) {
        super.init(site, input);
        this.domain = (Domain)this.contentElement;
        this.actionMgr = ((MethodElementEditor)this.getEditor()).getActionManager();
        this.setUseCategory2(false);
        this.setUseCategory3(false);
    }

    protected void initContentProviderSelected() {
        this.contentProviderSelected = new AdapterFactoryContentProvider((AdapterFactory)TngAdapterFactory.INSTANCE.getNavigatorView_ComposedAdapterFactory()){

            public Object[] getElements(Object object) {
                return ((Domain)object).getWorkProducts().toArray();
            }
        };
        this.viewer_selected.setContentProvider((IContentProvider)this.contentProviderSelected);
    }

    protected void addItemsToModel1(ArrayList addItems) {
        if (!addItems.isEmpty()) {
            Iterator iter = addItems.iterator();
            while (iter.hasNext()) {
                MethodElement element = (MethodElement)iter.next();
                if (UserInteractionHelper.checkModifyOpposite((MethodElement)this.domain, (EStructuralFeature)UmaPackage.eINSTANCE.getDomain_WorkProducts(), (MethodElement)element)) continue;
                return;
            }
            this.actionMgr.doAction(5, (EObject)this.domain, (EStructuralFeature)UmaPackage.eINSTANCE.getDomain_WorkProducts(), (Object)addItems, -1);
        }
    }

    protected void removeItemsFromModel1(ArrayList rmItems) {
        if (!rmItems.isEmpty()) {
            this.actionMgr.doAction(6, (EObject)this.domain, (EStructuralFeature)UmaPackage.eINSTANCE.getDomain_WorkProducts(), (Object)rmItems, -1);
        }
    }

    protected Object getContentElement() {
        return this.domain;
    }

    protected String getTabString() {
        return FilterConstants.WORKPRODUCTS;
    }

    protected IFilter getFilter() {
        this.filter = new WorkProductFilter(){

            protected boolean childAccept(Object obj) {
                if (obj instanceof ContentElement && this.getHelper().isContributor((ContentElement)obj)) {
                    return false;
                }
                return obj instanceof WorkProduct;
            }
        };
        return this.filter;
    }

    protected String getMultipleSelectDescription(int count) {
        return super.getMultipleSelectDescription(count, AuthoringUIResources.AuthoringUI_domainWorkProductsPage_multipleSelectDescription);
    }

    protected String getSectionDescription() {
        return AuthoringUIResources.AuthoringUI_domainWorkProductsPage_sectionDescription;
    }

    protected String getSectionName() {
        return AuthoringUIResources.AuthoringUI_domainWorkProductsPage_sectionName;
    }

    protected String getSelectedLabel() {
        return AuthoringUIResources.AuthoringUI_domainWorkProductsPage_selectedLabel;
    }

    protected String getSelectedLabel2() {
        return AuthoringUIResources.AuthoringUI_domainWorkProductsPage_selectedLabel;
    }

    protected String getSelectedLabel3() {
        return AuthoringUIResources.AuthoringUI_domainWorkProductsPage_selectedLabel;
    }
}

