/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.authoring.ui.forms;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.epf.authoring.ui.AuthoringUIResources;
import org.eclipse.epf.authoring.ui.AuthoringUIText;
import org.eclipse.epf.authoring.ui.editors.MethodElementEditor;
import org.eclipse.epf.authoring.ui.filters.ContentFilter;
import org.eclipse.epf.authoring.ui.forms.DescriptionFormPage;
import org.eclipse.epf.authoring.ui.richtext.IMethodRichText;
import org.eclipse.epf.library.edit.IFilter;
import org.eclipse.epf.library.edit.itemsfilter.FilterConstants;
import org.eclipse.epf.library.edit.itemsfilter.VariabilityBaseElementFilter;
import org.eclipse.epf.library.ui.LibraryUIText;
import org.eclipse.epf.uma.Checklist;
import org.eclipse.epf.uma.Concept;
import org.eclipse.epf.uma.ContentElement;
import org.eclipse.epf.uma.EstimationConsiderations;
import org.eclipse.epf.uma.Example;
import org.eclipse.epf.uma.Guidance;
import org.eclipse.epf.uma.Guideline;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.Practice;
import org.eclipse.epf.uma.Report;
import org.eclipse.epf.uma.ReusableAsset;
import org.eclipse.epf.uma.Roadmap;
import org.eclipse.epf.uma.SupportingMaterial;
import org.eclipse.epf.uma.Template;
import org.eclipse.epf.uma.TermDefinition;
import org.eclipse.epf.uma.ToolMentor;
import org.eclipse.epf.uma.UmaPackage;
import org.eclipse.epf.uma.VariabilityElement;
import org.eclipse.epf.uma.Whitepaper;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class GuidanceDescriptionPage
extends DescriptionFormPage {
    private static final String FORM_PAGE_ID = "guidanceDescriptionPage";
    protected Guidance guidance;
    private String elementLabel;
    private IMethodRichText ctrl_content;
    private int contentFieldHeight = 400;

    public GuidanceDescriptionPage(FormEditor editor) {
        super(editor, FORM_PAGE_ID, AuthoringUIText.DESCRIPTION_PAGE_TITLE);
    }

    public void init(IEditorSite site, IEditorInput input) {
        super.init(site, input);
        this.guidance = (Guidance)this.contentElement;
        this.elementLabel = LibraryUIText.getUIText((MethodElement)this.guidance);
        this.setElementTypeOn(true);
        if (this.guidance instanceof TermDefinition) {
            this.setBriefDescOn(false);
        }
        this.setFullDescOn(false);
        this.setKeyConsiderationOn(false);
        this.setIconSectionOn(true);
    }

    protected String getFormPrefix() {
        return LibraryUIText.TEXT_GUIDANCE + " (" + this.elementLabel + "): ";
    }

    protected void createEditorContent(FormToolkit toolkit) {
        super.createEditorContent(toolkit);
        this.ctrl_content = this.createRichTextEditWithLinkForSection(toolkit, this.detailComposite, AuthoringUIText.MAIN_DESCRIPTION_TEXT, this.contentFieldHeight, 400, 2);
    }

    protected void addListeners() {
        super.addListeners();
        final MethodElementEditor editor = (MethodElementEditor)this.getEditor();
        this.ctrl_content.setModalObject((EObject)this.contentElement.getPresentation());
        this.ctrl_content.setModalObjectFeature((EStructuralFeature)UmaPackage.eINSTANCE.getContentDescription_MainDescription());
        this.ctrl_content.addModifyListener(this.contentModifyListener);
        this.ctrl_content.addListener(27, new Listener(){

            public void handleEvent(Event e) {
                boolean success;
                IMethodRichText control;
                IMethodRichText iMethodRichText = control = GuidanceDescriptionPage.this.descExpandFlag ? GuidanceDescriptionPage.this.ctrl_expanded : GuidanceDescriptionPage.this.ctrl_content;
                if (!control.getModified()) {
                    return;
                }
                String oldContent = GuidanceDescriptionPage.this.guidance.getPresentation().getMainDescription();
                if (((MethodElementEditor)GuidanceDescriptionPage.this.getEditor()).mustRestoreValue(control, oldContent)) {
                    return;
                }
                String newContent = control.getText();
                if (!newContent.equals(oldContent) && (success = editor.getActionManager().doAction(1, (EObject)GuidanceDescriptionPage.this.contentElement.getPresentation(), (EStructuralFeature)UmaPackage.eINSTANCE.getContentDescription_MainDescription(), (Object)newContent, -1)) && GuidanceDescriptionPage.this.isVersionSectionOn()) {
                    GuidanceDescriptionPage.this.updateChangeDate();
                }
            }
        });
    }

    protected void refresh(boolean editable) {
        super.refresh(editable);
        this.ctrl_content.setEditable(editable);
    }

    protected void loadData() {
        super.loadData();
        if (this.guidance != null) {
            String content = null;
            if (this.guidance.getPresentation() != null) {
                content = this.guidance.getPresentation().getMainDescription();
            }
            this.ctrl_content.setText(content == null ? "" : content);
        }
    }

    protected Object getContentElement() {
        return this.guidance;
    }

    public int getContentFieldHeight() {
        return this.contentFieldHeight;
    }

    public void setContentFieldHeight(int contentFieldHeight) {
        this.contentFieldHeight = contentFieldHeight;
    }

    protected String getTabString() {
        return FilterConstants.GUIDANCE;
    }

    protected IFilter getFilter() {
        this.filter = new ContentFilter(){

            protected boolean childAccept(Object obj) {
                if (obj instanceof Guidance) {
                    return ((ContentElement)obj).getType().equals(((Guidance)GuidanceDescriptionPage.this.contentElement).getType());
                }
                return false;
            }
        };
        ((ContentFilter)this.filter).setAdditionalFilters(new IFilter[]{new VariabilityBaseElementFilter((VariabilityElement)this.guidance)});
        return this.filter;
    }

    public void loadSectionDescription() {
        if (this.contentElement instanceof Whitepaper) {
            this.generalSectionDescription = AuthoringUIResources.AuthoringUI_whitepaper_generalInfoSection_desc;
            this.detailSectionDescription = AuthoringUIResources.AuthoringUI_whitepaper_detailSection_desc;
            this.variabilitySectionDescription = AuthoringUIResources.AuthoringUI_whitepaper_variabilitySection_desc;
            this.versionSectionDescription = AuthoringUIResources.AuthoringUI_whitepaper_versionInfoSection_desc;
            this.iconSectionDescription = AuthoringUIResources.AuthoringUI_whitepaper_iconSection_desc;
        } else if (this.contentElement instanceof Concept) {
            this.generalSectionDescription = AuthoringUIResources.AuthoringUI_concept_generalInfoSection_desc;
            this.detailSectionDescription = AuthoringUIResources.AuthoringUI_concept_detailSection_desc;
            this.variabilitySectionDescription = AuthoringUIResources.AuthoringUI_concept_variabilitySection_desc;
            this.versionSectionDescription = AuthoringUIResources.AuthoringUI_concept_versionInfoSection_desc;
            this.iconSectionDescription = AuthoringUIResources.AuthoringUI_concept_iconSection_desc;
        } else if (this.contentElement instanceof Checklist) {
            this.generalSectionDescription = AuthoringUIResources.AuthoringUI_checklist_generalInfoSection_desc;
            this.detailSectionDescription = AuthoringUIResources.AuthoringUI_checklist_detailSection_desc;
            this.variabilitySectionDescription = AuthoringUIResources.AuthoringUI_checklist_variabilitySection_desc;
            this.versionSectionDescription = AuthoringUIResources.AuthoringUI_checklist_versionInfoSection_desc;
            this.iconSectionDescription = AuthoringUIResources.AuthoringUI_checklist_iconSection_desc;
        } else if (this.contentElement instanceof Example) {
            this.generalSectionDescription = AuthoringUIResources.AuthoringUI_example_generalInfoSection_desc;
            this.detailSectionDescription = AuthoringUIResources.AuthoringUI_example_detailSection_desc;
            this.variabilitySectionDescription = AuthoringUIResources.AuthoringUI_example_variabilitySection_desc;
            this.versionSectionDescription = AuthoringUIResources.AuthoringUI_example_versionInfoSection_desc;
            this.iconSectionDescription = AuthoringUIResources.AuthoringUI_example_iconSection_desc;
        } else if (this.contentElement instanceof Guideline) {
            this.generalSectionDescription = AuthoringUIResources.AuthoringUI_guideline_generalInfoSection_desc;
            this.detailSectionDescription = AuthoringUIResources.AuthoringUI_guideline_detailSection_desc;
            this.variabilitySectionDescription = AuthoringUIResources.AuthoringUI_guideline_variabilitySection_desc;
            this.versionSectionDescription = AuthoringUIResources.AuthoringUI_guideline_versionInfoSection_desc;
            this.iconSectionDescription = AuthoringUIResources.AuthoringUI_guideline_iconSection_desc;
        } else if (this.contentElement instanceof EstimationConsiderations) {
            this.generalSectionDescription = AuthoringUIResources.AuthoringUI_estimationconsideration_generalInfoSection_desc;
            this.detailSectionDescription = AuthoringUIResources.AuthoringUI_estimationconsideration_detailSection_desc;
            this.variabilitySectionDescription = AuthoringUIResources.AuthoringUI_estimationconsideration_variabilitySection_desc;
            this.versionSectionDescription = AuthoringUIResources.AuthoringUI_estimationconsideration_versionInfoSection_desc;
            this.iconSectionDescription = AuthoringUIResources.AuthoringUI_estimationconsideration_iconSection_desc;
        } else if (this.contentElement instanceof Practice) {
            this.generalSectionDescription = AuthoringUIResources.AuthoringUI_practice_generalInfoSection_desc;
            this.detailSectionDescription = AuthoringUIResources.AuthoringUI_practice_detailSection_desc;
            this.variabilitySectionDescription = AuthoringUIResources.AuthoringUI_practice_variabilitySection_desc;
            this.versionSectionDescription = AuthoringUIResources.AuthoringUI_practice_versionInfoSection_desc;
            this.iconSectionDescription = AuthoringUIResources.AuthoringUI_practice_iconSection_desc;
        } else if (this.contentElement instanceof SupportingMaterial) {
            this.generalSectionDescription = AuthoringUIResources.AuthoringUI_supportingmaterial_generalInfoSection_desc;
            this.detailSectionDescription = AuthoringUIResources.AuthoringUI_supportingmaterial_detailSection_desc;
            this.variabilitySectionDescription = AuthoringUIResources.AuthoringUI_supportingmaterial_variabilitySection_desc;
            this.versionSectionDescription = AuthoringUIResources.AuthoringUI_supportingmaterial_versionInfoSection_desc;
            this.iconSectionDescription = AuthoringUIResources.AuthoringUI_supportingmaterial_iconSection_desc;
        } else if (this.contentElement instanceof Report) {
            this.generalSectionDescription = AuthoringUIResources.AuthoringUI_report_generalInfoSection_desc;
            this.detailSectionDescription = AuthoringUIResources.AuthoringUI_report_detailSection_desc;
            this.variabilitySectionDescription = AuthoringUIResources.AuthoringUI_report_variabilitySection_desc;
            this.versionSectionDescription = AuthoringUIResources.AuthoringUI_report_versionInfoSection_desc;
            this.iconSectionDescription = AuthoringUIResources.AuthoringUI_report_iconSection_desc;
        } else if (this.contentElement instanceof Roadmap) {
            this.generalSectionDescription = AuthoringUIResources.AuthoringUI_roadmap_generalInfoSection_desc;
            this.detailSectionDescription = AuthoringUIResources.AuthoringUI_roadmap_detailSection_desc;
            this.variabilitySectionDescription = AuthoringUIResources.AuthoringUI_roadmap_variabilitySection_desc;
            this.versionSectionDescription = AuthoringUIResources.AuthoringUI_roadmap_versionInfoSection_desc;
            this.iconSectionDescription = AuthoringUIResources.AuthoringUI_roadmap_iconSection_desc;
        } else if (this.contentElement instanceof Template) {
            this.generalSectionDescription = AuthoringUIResources.AuthoringUI_template_generalInfoSection_desc;
            this.detailSectionDescription = AuthoringUIResources.AuthoringUI_template_detailSection_desc;
            this.variabilitySectionDescription = AuthoringUIResources.AuthoringUI_template_variabilitySection_desc;
            this.versionSectionDescription = AuthoringUIResources.AuthoringUI_template_versionInfoSection_desc;
            this.iconSectionDescription = AuthoringUIResources.AuthoringUI_template_iconSection_desc;
        } else if (this.contentElement instanceof TermDefinition) {
            this.generalSectionDescription = AuthoringUIResources.AuthoringUI_termdefinition_generalInfoSection_desc;
            this.detailSectionDescription = AuthoringUIResources.AuthoringUI_termdefinition_detailSection_desc;
            this.variabilitySectionDescription = AuthoringUIResources.AuthoringUI_termdefinition_variabilitySection_desc;
            this.versionSectionDescription = AuthoringUIResources.AuthoringUI_termdefinition_versionInfoSection_desc;
            this.iconSectionDescription = AuthoringUIResources.AuthoringUI_termdefinition_iconSection_desc;
        } else if (this.contentElement instanceof ReusableAsset) {
            this.generalSectionDescription = AuthoringUIResources.AuthoringUI_resuableasset_generalInfoSection_desc;
            this.detailSectionDescription = AuthoringUIResources.AuthoringUI_resuableasset_detailSection_desc;
            this.variabilitySectionDescription = AuthoringUIResources.AuthoringUI_resuableasset_variabilitySection_desc;
            this.versionSectionDescription = AuthoringUIResources.AuthoringUI_resuableasset_versionInfoSection_desc;
            this.iconSectionDescription = AuthoringUIResources.AuthoringUI_reusableasset_iconSection_desc;
        } else if (this.contentElement instanceof ToolMentor) {
            this.generalSectionDescription = AuthoringUIResources.AuthoringUI_toolmentor_generalInfoSection_desc;
            this.detailSectionDescription = AuthoringUIResources.AuthoringUI_toolmentor_detailSection_desc;
            this.variabilitySectionDescription = AuthoringUIResources.AuthoringUI_toolmentor_variabilitySection_desc;
            this.versionSectionDescription = AuthoringUIResources.AuthoringUI_toolmentor_versionInfoSection_desc;
            this.iconSectionDescription = AuthoringUIResources.AuthoringUI_toolmentor_iconSection_desc;
        }
    }
}

