/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.authoring.ui.preferences;

import java.io.File;
import org.eclipse.epf.common.utils.FileUtil;
import org.eclipse.epf.library.LibraryPlugin;
import org.eclipse.epf.library.ui.preferences.LibraryUIPreferences;
import org.eclipse.jface.preference.IPreferenceStore;

public class LibraryLocationData {
    private String parentFolder;
    private String libName;
    private String libBriefDescription;
    private boolean isSingleLibFile;
    private String defaultLibDir;
    private boolean defLibDirChecked;
    protected static final String libraryFile = "library.xmi";
    private boolean isOkPressed;

    public boolean isOkPressed() {
        return this.isOkPressed;
    }

    public void setOkPressed(boolean isOkPressed) {
        this.isOkPressed = isOkPressed;
    }

    public boolean isSingleLibFile() {
        return this.isSingleLibFile;
    }

    public void setSingleLibFile(boolean isSingleLibFile) {
        this.isSingleLibFile = isSingleLibFile;
    }

    public String getLibName() {
        return this.libName;
    }

    public String getLibraryFile() {
        return String.valueOf(this.getParentFolder()) + File.separator + libraryFile;
    }

    public void setLibName(String libName) {
        this.libName = libName;
    }

    public String getParentFolder() {
        return this.parentFolder;
    }

    public void setParentFolder(String parentFolder) {
        this.parentFolder = parentFolder;
    }

    public String getLibBriefDescription() {
        return this.libBriefDescription;
    }

    public void setLibBriefDescription(String libBriefDescription) {
        this.libBriefDescription = libBriefDescription;
    }

    public boolean isDefLibDirChecked() {
        return this.defLibDirChecked;
    }

    public void setDefLibDirChecked(boolean defLibDirChecked) {
        this.defLibDirChecked = defLibDirChecked;
    }

    public String getDefaultLibDir() {
        return this.defaultLibDir;
    }

    public void setDefaultLibDir(String defaultLibDir) {
        this.defaultLibDir = defaultLibDir;
    }

    public void loadFromPreferenceStore() {
        IPreferenceStore store = LibraryPlugin.getDefault().getPreferenceStore();
        String lastDir = store.getString("org.eclipse.epf.library.pref.last_library__parent_directory");
        this.setParentFolder(lastDir);
        boolean lastChecked = store.getBoolean("org.eclipse.epf.library.pref.last_default_directory_checked");
        if (lastDir == null || lastDir.trim().length() == 0) {
            this.setDefLibDirChecked(true);
        } else {
            this.setDefLibDirChecked(lastChecked);
        }
        String defLibPPath = store.getString("org.eclipse.epf.library.pref.default_library_parent_directory");
        if (defLibPPath == null || defLibPPath.length() == 0) {
            defLibPPath = String.valueOf(System.getProperty("user.home")) + FileUtil.FILE_SEP + "EPF" + FileUtil.FILE_SEP + "Method Libraries";
        }
        this.setDefaultLibDir(defLibPPath);
    }

    public void saveToPreferenceStore() {
        IPreferenceStore store = LibraryPlugin.getDefault().getPreferenceStore();
        File file = new File(this.getParentFolder());
        LibraryUIPreferences.setSavedLibraryPath((String)file.getAbsolutePath());
        store.setValue("org.eclipse.epf.library.pref.last_library__parent_directory", file.getParent());
        store.setValue("org.eclipse.epf.library.pref.last_default_directory_checked", this.isDefLibDirChecked());
        LibraryPlugin.getDefault().savePluginPreferences();
    }
}

