/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.authoring.ui.views;

import java.io.File;
import java.util.Collection;
import org.eclipse.epf.authoring.gef.viewer.ActivityDiagramService;
import org.eclipse.epf.authoring.ui.AuthoringUIImages;
import org.eclipse.epf.authoring.ui.AuthoringUIPlugin;
import org.eclipse.epf.authoring.ui.AuthoringUIResources;
import org.eclipse.epf.authoring.ui.BrowsingPerspective;
import org.eclipse.epf.authoring.ui.UIActionDispatcher;
import org.eclipse.epf.authoring.ui.views.ConfigurationView;
import org.eclipse.epf.authoring.ui.views.ElementHTMLViewer;
import org.eclipse.epf.authoring.ui.views.ViewHelper;
import org.eclipse.epf.common.utils.PerspectiveUtil;
import org.eclipse.epf.library.ILibraryManager;
import org.eclipse.epf.library.ILibraryServiceListener;
import org.eclipse.epf.library.LibraryService;
import org.eclipse.epf.library.events.ILibraryChangeListener;
import org.eclipse.epf.library.layout.ElementLayoutManager;
import org.eclipse.epf.library.layout.HtmlBuilder;
import org.eclipse.epf.library.layout.diagram.IActivityDiagramService;
import org.eclipse.epf.library.ui.preferences.LibraryUIPreferences;
import org.eclipse.epf.library.util.LibraryUtil;
import org.eclipse.epf.uma.MethodConfiguration;
import org.eclipse.epf.uma.MethodLibrary;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IPerspectiveListener;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;

public class ContentView
extends ViewPart {
    public static final String VIEW_ID;
    private ElementHTMLViewer contentViewer;
    private Object displayedElement;
    private IPartListener partListener = new IPartListener(){

        public void partActivated(IWorkbenchPart part) {
            ContentView.this.handleSelection(UIActionDispatcher.getInstance().getSelectionSource(), UIActionDispatcher.getInstance().getSelection());
        }

        public void partBroughtToTop(IWorkbenchPart part) {
        }

        public void partClosed(IWorkbenchPart part) {
        }

        public void partDeactivated(IWorkbenchPart part) {
        }

        public void partOpened(IWorkbenchPart part) {
        }
    };
    private ISelectionChangedListener selectionChangeListener = new ISelectionChangedListener(){

        public void selectionChanged(SelectionChangedEvent event) {
            ContentView.this.handleSelection(event.getSource(), event.getSelection());
        }
    };
    private ILibraryChangeListener libraryChangeListener = new ILibraryChangeListener(){

        public void libraryChanged(int option, Collection changedItems) {
            if (changedItems != null && ContentView.this.displayedElement != null && changedItems.contains(ContentView.this.displayedElement)) {
                ContentView.this.displayedElement = null;
            }
        }
    };
    private ILibraryServiceListener libSvcListener = new ILibraryServiceListener(){

        public void configurationSet(MethodConfiguration config) {
        }

        public void libraryClosed(MethodLibrary library) {
        }

        public void libraryCreated(MethodLibrary library) {
            this.cleanup();
        }

        public void libraryOpened(MethodLibrary library) {
            this.cleanup();
        }

        public void libraryReopened(MethodLibrary library) {
            this.cleanup();
        }

        public void librarySet(MethodLibrary library) {
        }

        private void cleanup() {
            if (ContentView.this.contentViewer != null) {
                ContentView.this.contentViewer.setHtmlBuilder(new HtmlBuilder());
                ContentView.this.contentViewer.getBrowser().redraw();
            }
        }
    };
    private Action backAction;
    private Action forwardAction;
    private Action stopAction;
    private Action refreshAction;
    private Action printAction;
    private Composite diagramViewerHolder;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.epf.authoring.ui.views.ContentView");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        VIEW_ID = clazz.getName();
    }

    public void createPartControl(Composite parent) {
        try {
            GridLayout layout = new GridLayout();
            layout.marginWidth = 0;
            layout.marginHeight = 0;
            layout.horizontalSpacing = 0;
            layout.verticalSpacing = 0;
            parent.setLayout((Layout)layout);
            parent.setLayoutData((Object)new GridData(1808));
            this.contentViewer = new ElementHTMLViewer(parent);
            this.diagramViewerHolder = new Composite(parent, 0);
            this.diagramViewerHolder.setLayoutData((Object)new GridData(1, 1));
            this.diagramViewerHolder.setLayout((Layout)new GridLayout());
            this.diagramViewerHolder.setVisible(false);
            this.createActions();
            this.getSite().getWorkbenchWindow().getPartService().addPartListener(this.partListener);
            this.getSite().getWorkbenchWindow().addPerspectiveListener(new IPerspectiveListener(){

                public void perspectiveActivated(IWorkbenchPage page, IPerspectiveDescriptor desc) {
                }

                public void perspectiveChanged(IWorkbenchPage page, IPerspectiveDescriptor desc, String id) {
                    if (desc.getId().equals(BrowsingPerspective.PERSPECTIVE_ID) && id.equals("editorAreaShow")) {
                        page.setEditorAreaVisible(false);
                        AuthoringUIPlugin.getDefault().getMsgDialog().displayWarning(AuthoringUIResources.AuthoringUI_warningDialog_title, AuthoringUIResources.AuthoringUI_addEditorToPerspectiveWarning_msg);
                    }
                }
            });
            UIActionDispatcher.getInstance().addSelectionChangedListener(this.selectionChangeListener);
            LibraryService.getInstance().addListener(this.libSvcListener);
            ILibraryManager manager = LibraryService.getInstance().getCurrentLibraryManager();
            if (manager != null) {
                manager.addListener(this.libraryChangeListener);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setFocus() {
        this.contentViewer.setFocus();
    }

    public void dispose() {
        LibraryService.getInstance().removeListener(this.libSvcListener);
        ILibraryManager manager = LibraryService.getInstance().getCurrentLibraryManager();
        if (manager != null) {
            manager.removeListener(this.libraryChangeListener);
        }
        UIActionDispatcher.getInstance().removeSelectionChangedListener(this.selectionChangeListener);
        this.getSite().getWorkbenchWindow().getPartService().removePartListener(this.partListener);
    }

    protected void createActions() {
        this.backAction = new Action(){

            public void run() {
                Browser browser = ContentView.this.contentViewer.getBrowser();
                if (browser != null) {
                    browser.back();
                }
            }
        };
        this.backAction.setText(AuthoringUIResources.AuthoringUI_back_text);
        this.backAction.setToolTipText(AuthoringUIResources.AuthoringUI_back_text);
        this.backAction.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_TOOL_BACK"));
        this.forwardAction = new Action(){

            public void run() {
                Browser browser = ContentView.this.contentViewer.getBrowser();
                if (browser != null) {
                    browser.forward();
                }
            }
        };
        this.forwardAction.setText(AuthoringUIResources.AuthoringUI_forward_text);
        this.forwardAction.setToolTipText(AuthoringUIResources.AuthoringUI_forward_text);
        this.forwardAction.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_TOOL_FORWARD"));
        this.stopAction = new Action(){

            public void run() {
                Browser browser = ContentView.this.contentViewer.getBrowser();
                if (browser != null) {
                    browser.stop();
                }
            }
        };
        this.stopAction.setText(AuthoringUIResources.AuthoringUI_stop_text);
        this.stopAction.setToolTipText(AuthoringUIResources.AuthoringUI_stop_text);
        this.stopAction.setImageDescriptor(AuthoringUIImages.IMG_DESC_STOP);
        this.refreshAction = new Action(){

            public void run() {
                ContentView.this.contentViewer.refresh();
            }
        };
        this.refreshAction.setText(AuthoringUIResources.AuthoringUI_refresh_text);
        this.refreshAction.setToolTipText(AuthoringUIResources.AuthoringUI_refresh_text);
        this.refreshAction.setImageDescriptor(AuthoringUIImages.IMG_DESC_REFRESH);
        this.printAction = new Action(){

            public void run() {
                ContentView.this.contentViewer.print();
            }
        };
        this.printAction.setText(AuthoringUIResources.AuthoringUI_print_text);
        this.printAction.setToolTipText(AuthoringUIResources.AuthoringUI_print_text);
        this.printAction.setImageDescriptor(AuthoringUIImages.IMG_DESC_PRINT);
        IActionBars bars = this.getViewSite().getActionBars();
        IToolBarManager manager = bars.getToolBarManager();
        manager.add((IAction)this.backAction);
        manager.add((IAction)this.forwardAction);
        manager.add((IAction)this.stopAction);
        manager.add((IAction)this.refreshAction);
        manager.add((IAction)this.printAction);
    }

    protected void handleSelection(Object source, ISelection selection) {
        IStructuredSelection sel;
        Object[] selectedElements;
        if (selection == null) {
            return;
        }
        IWorkbenchPage activePage = this.getSite().getWorkbenchWindow().getActivePage();
        if (activePage == null) {
            return;
        }
        IViewPart view = activePage.findView(VIEW_ID);
        if (view == null) {
            return;
        }
        if (selection instanceof IStructuredSelection && (selectedElements = (sel = (IStructuredSelection)selection).toArray()) != null && selectedElements.length > 0) {
            Object element = selectedElements[0];
            if (this.displayedElement != null && this.displayedElement == element) {
                return;
            }
            if (this.displayContentPage(source, element)) {
                this.displayedElement = element;
            }
        }
    }

    protected boolean displayContentPage(Object source, Object raw_element) {
        boolean isConfigSource;
        Object element = LibraryUtil.unwrap((Object)raw_element);
        if ((element = ViewHelper.handleDangling(element)) == null) {
            return false;
        }
        ElementLayoutManager layoutMgr = null;
        boolean isBrowsing = PerspectiveUtil.isActivePerspective((String)BrowsingPerspective.PERSPECTIVE_ID);
        boolean bl = isConfigSource = source != null && source instanceof ConfigurationView;
        if (isBrowsing && !isConfigSource) {
            return false;
        }
        if (isConfigSource) {
            layoutMgr = LibraryService.getInstance().getCurrentConfigurationManager().getElementLayoutManager();
            ActivityDiagramService diagramService = (ActivityDiagramService)layoutMgr.getActivityDiagramService();
            if (diagramService == null) {
                diagramService = new ActivityDiagramService(this.diagramViewerHolder, new File(layoutMgr.getPublishDir()));
                layoutMgr.setActivityDiagramService((IActivityDiagramService)diagramService);
            }
            boolean option = LibraryUIPreferences.getPublishUnopenActivitydd();
            diagramService.setPublishedUnCreatedADD(option);
        }
        this.contentViewer.setLayoutManager(layoutMgr);
        this.contentViewer.showElementContent(raw_element);
        return true;
    }

    public boolean displayHTMLContentPage(Object element) {
        element = LibraryUtil.unwrap((Object)element);
        if ((element = ViewHelper.handleDangling(element)) != null) {
            this.contentViewer.setLayoutManager(null);
            this.contentViewer.showElementContent(element);
            return true;
        }
        return false;
    }
}

