/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.authoring.ui.wizards;

import org.eclipse.epf.authoring.ui.AuthoringUIPlugin;
import org.eclipse.epf.authoring.ui.AuthoringUIResources;
import org.eclipse.epf.authoring.ui.preferences.LibraryLocationData;
import org.eclipse.epf.authoring.ui.wizards.NewConfigurationMainPage;
import org.eclipse.epf.library.LibraryService;
import org.eclipse.epf.library.LibraryServiceUtil;
import org.eclipse.epf.uma.MethodLibrary;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;

public class NewConfigurationWizard
extends Wizard
implements INewWizard {
    protected NewConfigurationMainPage mainPage;
    protected boolean okToComplete = false;
    protected LibraryLocationData llData;

    public NewConfigurationWizard(LibraryLocationData llData) {
        this.llData = llData;
        this.setWindowTitle(AuthoringUIResources.AuthoringUIPlugin_newConfigurationWizard_title);
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
    }

    public void addPages() {
        this.mainPage = new NewConfigurationMainPage();
        this.addPage((IWizardPage)this.mainPage);
    }

    public boolean canFinish() {
        return this.okToComplete;
    }

    public boolean performFinish() {
        this.mainPage.saveDataToDTO(this);
        this.llData.setOkPressed(true);
        if (this.configNameExists(this.llData.getLibName().trim())) {
            this.llData.setOkPressed(false);
            return false;
        }
        return true;
    }

    private boolean configNameExists(String configName) {
        String[] configNames = LibraryServiceUtil.getMethodConfigurationNames((MethodLibrary)LibraryService.getInstance().getCurrentMethodLibrary());
        int i = 0;
        while (i < configNames.length) {
            if (configName.equals(configNames[i])) {
                AuthoringUIPlugin.getDefault().getMsgDialog().displayError(AuthoringUIResources.AuthoringUIPlugin_newConfigurationWizard_title, AuthoringUIResources.bind((String)AuthoringUIResources.AuthoringUI_duplicateElementNameError_msg, (Object)configName));
                return true;
            }
            ++i;
        }
        return false;
    }
}

