/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.authoring.ui.wizards;

import java.util.Iterator;
import java.util.List;
import org.eclipse.epf.authoring.ui.AuthoringUIPlugin;
import org.eclipse.epf.authoring.ui.AuthoringUIResources;
import org.eclipse.epf.authoring.ui.AuthoringUIText;
import org.eclipse.epf.library.ui.LibraryUIImages;
import org.eclipse.epf.library.util.LibraryUtil;
import org.eclipse.epf.library.util.ModelStorage;
import org.eclipse.epf.uma.MethodPlugin;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class NewMethodPluginWizardPage
extends WizardPage
implements Listener {
    public static final String PAGE_NAME;
    private Text nameText;
    private Text briefDescText;
    private Text authorsText;
    private CheckboxTableViewer referencedPluginsViewer;
    private List plugins;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.epf.authoring.ui.wizards.NewMethodPluginWizardPage");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        PAGE_NAME = clazz.getName();
    }

    public NewMethodPluginWizardPage() {
        super(PAGE_NAME);
        this.setTitle(AuthoringUIResources.AuthoringUI_newPluginWizardPage_title);
        this.setDescription(AuthoringUIResources.AuthoringUI_newPluginWizardPage_text);
        this.setImageDescriptor(AuthoringUIPlugin.getDefault().getImageDescriptor("full/wizban/New.gif"));
    }

    public void createControl(Composite parent) {
        GridData gridData = new GridData(768);
        GridData labelGridData = new GridData(2);
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(2, false));
        composite.setLayoutData((Object)gridData);
        Label nameLabel = new Label(composite, 0);
        nameLabel.setText(AuthoringUIText.NAME_TEXT);
        this.nameText = new Text(composite, 2048);
        this.nameText.setText("new_plug-in");
        this.nameText.setLayoutData((Object)gridData);
        Label briefDescLabel = new Label(composite, 0);
        briefDescLabel.setText(AuthoringUIText.BRIEF_DESCRIPTION_TEXT);
        briefDescLabel.setLayoutData((Object)labelGridData);
        this.briefDescText = new Text(composite, 2626);
        GridData briefDescGridData = new GridData(768);
        briefDescGridData.heightHint = 70;
        this.briefDescText.setLayoutData((Object)briefDescGridData);
        Label authorsLabel = new Label(composite, 0);
        authorsLabel.setText(AuthoringUIText.AUTHORS_TEXT);
        authorsLabel.setLayoutData((Object)labelGridData);
        this.authorsText = new Text(composite, 2626);
        GridData authorsGridData = new GridData(768);
        authorsGridData.heightHint = 35;
        this.authorsText.setLayoutData((Object)authorsGridData);
        Label referencedPluginsLabel = new Label(composite, 0);
        referencedPluginsLabel.setText(AuthoringUIText.REFERENCED_PLUGINS_SECTION_NAME);
        referencedPluginsLabel.setLayoutData((Object)labelGridData);
        this.plugins = ModelStorage.getBaseModels();
        String[] items = new String[this.plugins.size()];
        int i = 0;
        while (i < this.plugins.size()) {
            MethodPlugin model = (MethodPlugin)this.plugins.get(i);
            items[i] = model.getName();
            ++i;
        }
        this.referencedPluginsViewer = CheckboxTableViewer.newCheckList((Composite)composite, (int)2308);
        GridData referencedPluginsGridData = new GridData(768);
        referencedPluginsGridData.heightHint = 150;
        this.referencedPluginsViewer.getTable().setLayoutData((Object)referencedPluginsGridData);
        LabelProvider labelProvider = new LabelProvider(){

            public Image getImage(Object element) {
                return LibraryUIImages.IMG_METHOD_PLUGIN;
            }

            public String getText(Object element) {
                if (element instanceof MethodPlugin) {
                    return ((MethodPlugin)element).getName();
                }
                return element.toString();
            }
        };
        this.referencedPluginsViewer.setLabelProvider((IBaseLabelProvider)labelProvider);
        if (this.plugins != null) {
            Iterator it = this.plugins.iterator();
            while (it.hasNext()) {
                this.referencedPluginsViewer.add(it.next());
            }
        }
        this.setControl((Control)composite);
        Shell shell = parent.getShell();
        this.nameText.addListener(24, (Listener)this);
        this.nameText.addListener(16, (Listener)this);
        Display display = shell.getDisplay();
        if (display != null && !display.isDisposed()) {
            display.asyncExec(new Runnable(){

                public void run() {
                    NewMethodPluginWizardPage.this.nameText.setFocus();
                    NewMethodPluginWizardPage.this.nameText.setSelection(0, NewMethodPluginWizardPage.this.nameText.getText().length());
                }
            });
        }
    }

    public void handleEvent(Event event) {
        if (event.widget == this.nameText) {
            this.validateName();
        }
        this.setPageComplete(this.isPageComplete());
        this.getWizard().getContainer().updateButtons();
    }

    public boolean validateName() {
        boolean answer;
        String msg = LibraryUtil.checkPluginName(null, (String)this.nameText.getText());
        if (msg == null) {
            answer = true;
            this.setErrorMessage(null);
            this.setMessage(AuthoringUIResources.AuthoringUI_newPluginWizardPage_text);
        } else {
            int i;
            answer = false;
            int idx = msg.indexOf("'.");
            if (idx >= 0) {
                msg = msg.substring(idx + 3);
            }
            if ((i = msg.indexOf("IUPL0101E")) >= 0) {
                msg = AuthoringUIResources.bind((String)AuthoringUIResources.AuthoringUI_duplicatePluginNameError_msg, (Object)this.nameText.getText());
            }
            this.setErrorMessage(msg);
            this.setMessage(null);
        }
        return answer;
    }

    public boolean isPageComplete() {
        return NewMethodPluginWizardPage.isTextNonEmpty(this.nameText) && this.getErrorMessage() == null;
    }

    private static boolean isTextNonEmpty(Text t) {
        String text = t.getText();
        return text != null && text.trim().length() > 0;
    }

    public String getPluginName() {
        return this.nameText.getText();
    }

    public String getBriefDescription() {
        return this.briefDescText.getText();
    }

    public String getAuthors() {
        return this.authorsText.getText();
    }

    public Object[] getReferencedPlugins() {
        return this.referencedPluginsViewer.getCheckedElements();
    }
}

