/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.search.ui;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.search.internal.ui.OpenSearchDialogAction;
import org.eclipse.search.internal.ui.SearchPlugin;
import org.eclipse.search.internal.ui.SearchPreferencePage;
import org.eclipse.search.ui.IQueryListener;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.ISearchResultViewPart;
import org.eclipse.search2.internal.ui.InternalSearchUI;
import org.eclipse.search2.internal.ui.SearchMessages;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;

public class NewSearchUI {
    public static final String PLUGIN_ID = "org.eclipse.search";
    public static final String SEARCH_MARKER = "org.eclipse.search.searchmarker";
    public static final String SEARCH_VIEW_ID = "org.eclipse.search.ui.views.SearchView";
    public static final String ACTION_SET_ID = "org.eclipse.search.searchActionSet";

    public static ISearchResultViewPart activateSearchResultView() {
        return InternalSearchUI.getInstance().getSearchViewManager().activateSearchView(false);
    }

    public static ISearchResultViewPart getSearchResultView() {
        return InternalSearchUI.getInstance().getSearchViewManager().getActiveSearchView();
    }

    public static void runQuery(ISearchQuery query) {
        if (query.canRunInBackground()) {
            NewSearchUI.runQueryInBackground(query);
        } else {
            IStatus status = NewSearchUI.runQueryInForeground(null, query);
            if (status != null) {
                if (!status.isOK()) {
                    SearchPlugin.log(status);
                }
                if (status.getSeverity() == 4) {
                    ErrorDialog.openError((Shell)SearchPlugin.getActiveWorkbenchShell(), (String)SearchMessages.NewSearchUI_error_title, (String)SearchMessages.NewSearchUI_error_label, (IStatus)status);
                }
            }
        }
    }

    public static void runQueryInBackground(ISearchQuery query) throws IllegalArgumentException {
        NewSearchUI.runQueryInBackground(query, null);
    }

    public static void runQueryInBackground(ISearchQuery query, ISearchResultViewPart view) throws IllegalArgumentException {
        if (!query.canRunInBackground()) {
            throw new IllegalArgumentException("Query can not be run in background");
        }
        InternalSearchUI.getInstance().runSearchInBackground(query, view);
    }

    public static IStatus runQueryInForeground(IRunnableContext context, ISearchQuery query) {
        return NewSearchUI.runQueryInForeground(context, query, null);
    }

    public static IStatus runQueryInForeground(IRunnableContext context, ISearchQuery query, ISearchResultViewPart view) {
        return InternalSearchUI.getInstance().runSearchInForeground(context, query, view);
    }

    public static void addQueryListener(IQueryListener l) {
        InternalSearchUI.getInstance().addQueryListener(l);
    }

    public static void removeQueryListener(IQueryListener l) {
        InternalSearchUI.getInstance().removeQueryListener(l);
    }

    public static ISearchQuery[] getQueries() {
        return InternalSearchUI.getInstance().getQueries();
    }

    public static boolean isQueryRunning(ISearchQuery query) {
        return InternalSearchUI.getInstance().isQueryRunning(query);
    }

    public static void cancelQuery(ISearchQuery query) {
        InternalSearchUI.getInstance().cancelSearch(query);
    }

    public static void openSearchDialog(IWorkbenchWindow window, String pageId) {
        new OpenSearchDialogAction(window, pageId).run();
    }

    public static boolean reuseEditor() {
        return SearchPreferencePage.isEditorReused();
    }

    public static boolean arePotentialMatchesIgnored() {
        return SearchPreferencePage.arePotentialMatchesIgnored();
    }

    public static String getDefaultPerspectiveId() {
        return SearchPreferencePage.getDefaultPerspectiveId();
    }
}

