/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.export.msp;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.epf.library.LibraryService;
import org.eclipse.epf.library.edit.util.ModelStructure;
import org.eclipse.epf.library.util.LibraryUtil;
import org.eclipse.epf.uma.CapabilityPattern;
import org.eclipse.epf.uma.DeliveryProcess;
import org.eclipse.epf.uma.MethodConfiguration;
import org.eclipse.epf.uma.MethodLibrary;
import org.eclipse.epf.uma.MethodPackage;
import org.eclipse.epf.uma.MethodPlugin;
import org.eclipse.epf.uma.Process;
import org.eclipse.epf.uma.ProcessComponent;
import org.eclipse.epf.uma.ProcessPackage;
import org.eclipse.epf.uma.util.UmaUtil;

public class PlanningUtil {
    public static Map getProcesses() {
        MethodLibrary library = LibraryService.getInstance().getCurrentMethodLibrary();
        if (library == null) {
            return null;
        }
        TreeMap result = new TreeMap();
        List methodPlugins = LibraryUtil.getMethodPlugins((MethodLibrary)library);
        Iterator i = methodPlugins.iterator();
        while (i.hasNext()) {
            String[] deliveryProcessPaths;
            String[] capabilityPatternPaths;
            MethodPlugin methodPlugin = (MethodPlugin)i.next();
            MethodPackage methodPackage = UmaUtil.findMethodPackage((MethodPlugin)methodPlugin, (String[])(capabilityPatternPaths = ModelStructure.DEFAULT.capabilityPatternPath));
            if (methodPackage instanceof ProcessPackage && methodPackage instanceof ProcessPackage) {
                PlanningUtil.getCapabilityPatterns((ProcessPackage)methodPackage, result);
            }
            if (!((methodPackage = UmaUtil.findMethodPackage((MethodPlugin)methodPlugin, (String[])(deliveryProcessPaths = ModelStructure.DEFAULT.deliveryProcessPath))) instanceof ProcessPackage) || !(methodPackage instanceof ProcessPackage)) continue;
            PlanningUtil.getDeliveryProcesses((ProcessPackage)methodPackage, result);
        }
        return result;
    }

    public static Map getCapabilityPatterns() {
        MethodLibrary library = LibraryService.getInstance().getCurrentMethodLibrary();
        if (library == null) {
            return null;
        }
        TreeMap result = new TreeMap();
        List methodPlugins = LibraryUtil.getMethodPlugins((MethodLibrary)library);
        Iterator i = methodPlugins.iterator();
        while (i.hasNext()) {
            String[] capabilityPatternPaths;
            MethodPlugin methodPlugin = (MethodPlugin)i.next();
            MethodPackage methodPackage = UmaUtil.findMethodPackage((MethodPlugin)methodPlugin, (String[])(capabilityPatternPaths = ModelStructure.DEFAULT.capabilityPatternPath));
            if (!(methodPackage instanceof ProcessPackage)) continue;
            PlanningUtil.getCapabilityPatterns((ProcessPackage)methodPackage, result);
        }
        return result;
    }

    public static Map getDeliveryProcesses() {
        MethodLibrary library = LibraryService.getInstance().getCurrentMethodLibrary();
        if (library == null) {
            return null;
        }
        TreeMap result = new TreeMap();
        List methodPlugins = LibraryUtil.getMethodPlugins((MethodLibrary)library);
        Iterator i = methodPlugins.iterator();
        while (i.hasNext()) {
            String[] deliveryProcessPaths;
            MethodPlugin methodPlugin = (MethodPlugin)i.next();
            MethodPackage methodPackage = UmaUtil.findMethodPackage((MethodPlugin)methodPlugin, (String[])(deliveryProcessPaths = ModelStructure.DEFAULT.deliveryProcessPath));
            if (!(methodPackage instanceof ProcessPackage)) continue;
            PlanningUtil.getDeliveryProcesses((ProcessPackage)methodPackage, result);
        }
        return result;
    }

    public static Map getContexts(Process process) {
        if (process == null) {
            return null;
        }
        MethodLibrary library = LibraryService.getInstance().getCurrentMethodLibrary();
        if (library == null) {
            return null;
        }
        TreeMap<String, MethodConfiguration> result = new TreeMap<String, MethodConfiguration>();
        MethodConfiguration defaultContext = process.getDefaultContext();
        if (defaultContext != null) {
            result.put(defaultContext.getName(), defaultContext);
        }
        List contexts = process.getValidContext();
        Iterator i = contexts.iterator();
        while (i.hasNext()) {
            MethodConfiguration context = (MethodConfiguration)i.next();
            if (context == null) continue;
            result.put(context.getName(), context);
        }
        return result;
    }

    protected static void getCapabilityPatterns(ProcessPackage processPackage, Map result) {
        List childPackages = processPackage.getChildPackages();
        Iterator i = childPackages.iterator();
        while (i.hasNext()) {
            Object obj = i.next();
            if (obj instanceof ProcessComponent) {
                ProcessComponent processComponent = (ProcessComponent)obj;
                Process process = processComponent.getProcess();
                if (!(process instanceof CapabilityPattern)) continue;
                String name = process.getName();
                result.put(name, process);
                continue;
            }
            if (!(obj instanceof ProcessPackage)) continue;
            PlanningUtil.getCapabilityPatterns((ProcessPackage)obj, result);
        }
    }

    protected static void getDeliveryProcesses(ProcessPackage processPackage, Map result) {
        List childPackages = processPackage.getChildPackages();
        Iterator i = childPackages.iterator();
        while (i.hasNext()) {
            Object obj = i.next();
            if (obj instanceof ProcessComponent) {
                ProcessComponent processComponent = (ProcessComponent)obj;
                Process process = processComponent.getProcess();
                if (!(process instanceof DeliveryProcess)) continue;
                String name = process.getName();
                result.put(name, process);
                continue;
            }
            if (!(obj instanceof ProcessPackage)) continue;
            PlanningUtil.getDeliveryProcesses((ProcessPackage)obj, result);
        }
    }
}

