/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.search.ui.internal;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.epf.common.xml.AbstractSAXParser;
import org.eclipse.epf.library.LibraryService;
import org.eclipse.epf.library.edit.util.ModelStructure;
import org.eclipse.epf.library.util.LibraryUtil;
import org.eclipse.epf.search.ui.SearchUIPlugin;
import org.eclipse.epf.search.ui.SearchUIResources;
import org.eclipse.epf.search.ui.internal.ISearchResultCollector;
import org.eclipse.epf.search.ui.internal.MethodSearchInput;
import org.eclipse.epf.search.ui.internal.MethodSearchPattern;
import org.eclipse.epf.search.ui.internal.MethodSearchScope;
import org.eclipse.epf.uma.Activity;
import org.eclipse.epf.uma.Artifact;
import org.eclipse.epf.uma.ContentDescription;
import org.eclipse.epf.uma.ContentElement;
import org.eclipse.epf.uma.ContentPackage;
import org.eclipse.epf.uma.DescribableElement;
import org.eclipse.epf.uma.Discipline;
import org.eclipse.epf.uma.Domain;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.MethodLibrary;
import org.eclipse.epf.uma.MethodPackage;
import org.eclipse.epf.uma.MethodPlugin;
import org.eclipse.epf.uma.Practice;
import org.eclipse.epf.uma.ProcessComponent;
import org.eclipse.epf.uma.ProcessElement;
import org.eclipse.epf.uma.ProcessPackage;
import org.eclipse.epf.uma.util.UmaUtil;
import org.xml.sax.Attributes;

public class MethodSearchOperation {
    private boolean debug;
    private MethodSearchInput searchInput;
    private ISearchResultCollector result;
    private String searchString;
    private boolean caseSensitive;
    private boolean regExp;
    private Pattern searchStringPattern;
    private Pattern elementNamePattern;
    private MethodElementScanner elementScanner;
    private List parsedFiles = new ArrayList();
    private IProgressMonitor progressMonitor;

    public MethodSearchOperation(MethodSearchInput searchInput, ISearchResultCollector result) {
        this.searchInput = searchInput;
        this.result = result;
        this.caseSensitive = searchInput.getCaseSensitive();
        this.regExp = searchInput.getRegularExpression();
        this.elementNamePattern = MethodSearchPattern.createPattern(searchInput.getNamePattern(), false, false);
        this.debug = SearchUIPlugin.getDefault().isDebugging();
        this.searchString = searchInput.getSearchString();
        if (this.searchString == null) {
            this.searchString = "";
        }
        if (this.searchString.length() > 0) {
            this.elementScanner = new MethodElementScanner();
            this.searchStringPattern = MethodSearchPattern.createPattern(this.searchString, this.caseSensitive, this.regExp);
        }
        if (this.debug) {
            System.out.println("MethodSearchOperation constructor: searchString=" + this.searchString + ", elementNamePattern=" + searchInput.getNamePattern() + ", caseSensitive=" + this.caseSensitive);
        }
    }

    public void execute(IProgressMonitor progressMonitor) {
        this.progressMonitor = progressMonitor;
        this.progressMonitor.beginTask(SearchUIResources.scanLibraryTask_name, 7500);
        MethodLibrary library = LibraryService.getInstance().getCurrentMethodLibrary();
        List methodPlugins = LibraryUtil.getMethodPlugins((MethodLibrary)library);
        Iterator i = methodPlugins.iterator();
        while (i.hasNext() && !progressMonitor.isCanceled()) {
            MethodPackage methodPackage;
            MethodPlugin methodPlugin = (MethodPlugin)i.next();
            this.matchPattern((MethodElement)methodPlugin);
            if (this.searchInput.getSearchScope().includeCoreContent()) {
                methodPackage = UmaUtil.findMethodPackage((MethodPlugin)methodPlugin, (String[])ModelStructure.DEFAULT.coreContentPath);
                this.searchMethodPackages(methodPackage);
            }
            if (this.searchInput.getSearchScope().include(MethodSearchScope.STANDARD_CATEGORY)) {
                methodPackage = UmaUtil.findMethodPackage((MethodPlugin)methodPlugin, (String[])ModelStructure.DEFAULT.disciplineDefinitionPath);
                this.searchMethodPackages(methodPackage);
                methodPackage = UmaUtil.findMethodPackage((MethodPlugin)methodPlugin, (String[])ModelStructure.DEFAULT.domainPath);
                this.searchMethodPackages(methodPackage);
                methodPackage = UmaUtil.findMethodPackage((MethodPlugin)methodPlugin, (String[])ModelStructure.DEFAULT.workProductTypePath);
                this.searchMethodPackages(methodPackage);
                methodPackage = UmaUtil.findMethodPackage((MethodPlugin)methodPlugin, (String[])ModelStructure.DEFAULT.roleSetPath);
                this.searchMethodPackages(methodPackage);
                methodPackage = UmaUtil.findMethodPackage((MethodPlugin)methodPlugin, (String[])ModelStructure.DEFAULT.toolPath);
                this.searchMethodPackages(methodPackage);
            }
            if (this.searchInput.getSearchScope().include(MethodSearchScope.CUSTOM_CATEGORY)) {
                methodPackage = UmaUtil.findMethodPackage((MethodPlugin)methodPlugin, (String[])ModelStructure.DEFAULT.customCategoryPath);
                this.searchMethodPackages(methodPackage);
            }
            if (this.searchInput.getSearchScope().include(MethodSearchScope.CAPABILITY_PATTERN)) {
                methodPackage = UmaUtil.findMethodPackage((MethodPlugin)methodPlugin, (String[])ModelStructure.DEFAULT.capabilityPatternPath);
                this.searchMethodPackages(methodPackage);
            }
            if (!this.searchInput.getSearchScope().include(MethodSearchScope.DELIVERY_PROCESS)) continue;
            methodPackage = UmaUtil.findMethodPackage((MethodPlugin)methodPlugin, (String[])ModelStructure.DEFAULT.deliveryProcessPath);
            this.searchMethodPackages(methodPackage);
        }
    }

    protected void searchMethodPackages(MethodPackage methodPackage) {
        block11: {
            block10: {
                if (methodPackage == null || methodPackage.getName().equals("Hidden")) {
                    return;
                }
                if (methodPackage instanceof ProcessComponent) {
                    ProcessComponent processComponent = (ProcessComponent)methodPackage;
                    this.matchPattern((MethodElement)processComponent.getProcess());
                } else if (!this.isInternalProcessPackage(methodPackage)) {
                    this.matchPattern((MethodElement)methodPackage);
                }
                List childPackages = methodPackage.getChildPackages();
                Iterator i = childPackages.iterator();
                while (i.hasNext() && !this.progressMonitor.isCanceled()) {
                    this.searchMethodPackages((MethodPackage)i.next());
                }
                if (!(methodPackage instanceof ContentPackage)) break block10;
                ContentPackage contentPackage = (ContentPackage)methodPackage;
                List contentElements = contentPackage.getContentElements();
                Iterator j = contentElements.iterator();
                while (j.hasNext() && !this.progressMonitor.isCanceled()) {
                    ContentElement contentElement = (ContentElement)j.next();
                    this.matchPattern((MethodElement)contentElement);
                    if (contentElement instanceof Artifact) {
                        this.searchContainedArtifacts((Artifact)contentElement);
                        continue;
                    }
                    if (contentElement instanceof Practice) {
                        this.searchSubPractices((Practice)contentElement);
                        continue;
                    }
                    if (contentElement instanceof Discipline) {
                        this.searchSubDisciplines((Discipline)contentElement);
                        continue;
                    }
                    if (!(contentElement instanceof Domain)) continue;
                    this.searchSubDomains((Domain)contentElement);
                }
                break block11;
            }
            if (!(methodPackage instanceof ProcessPackage)) break block11;
            ProcessPackage processPackage = (ProcessPackage)methodPackage;
            List processElements = processPackage.getProcessElements();
            Iterator j = processElements.iterator();
            while (j.hasNext() && !this.progressMonitor.isCanceled()) {
                ProcessElement processElement = (ProcessElement)j.next();
                if (processElement instanceof Activity) continue;
                this.matchPattern((MethodElement)processElement);
            }
        }
    }

    protected boolean isInternalProcessPackage(MethodPackage methodPackage) {
        return methodPackage instanceof ProcessPackage && UmaUtil.getProcessComponent((MethodElement)methodPackage) != null;
    }

    protected void searchContainedArtifacts(Artifact artifact) {
        if (artifact != null) {
            Iterator i = artifact.getContainedArtifacts().iterator();
            while (i.hasNext() && !this.progressMonitor.isCanceled()) {
                Artifact containedArtifact = (Artifact)i.next();
                this.matchPattern((MethodElement)containedArtifact);
                this.searchContainedArtifacts(containedArtifact);
            }
        }
    }

    protected void searchSubPractices(Practice practice) {
        if (practice != null) {
            Iterator i = practice.getSubPractices().iterator();
            while (i.hasNext() && !this.progressMonitor.isCanceled()) {
                Practice subPractice = (Practice)i.next();
                this.matchPattern((MethodElement)subPractice);
                this.searchSubPractices(subPractice);
            }
        }
    }

    protected void searchSubDisciplines(Discipline discipline) {
        if (discipline != null) {
            Iterator i = discipline.getSubdiscipline().iterator();
            while (i.hasNext() && !this.progressMonitor.isCanceled()) {
                Discipline subDiscipline = (Discipline)i.next();
                this.matchPattern((MethodElement)subDiscipline);
                this.searchSubDisciplines(subDiscipline);
            }
        }
    }

    protected void searchSubDomains(Domain domain) {
        if (domain != null) {
            Iterator i = domain.getSubdomains().iterator();
            while (i.hasNext() && !this.progressMonitor.isCanceled()) {
                Domain subDomain = (Domain)i.next();
                this.matchPattern((MethodElement)subDomain);
                this.searchSubDomains(subDomain);
            }
        }
    }

    protected void matchPattern(MethodElement element) {
        block9: {
            try {
                if (!this.searchInput.getSearchScope().include(element)) break block9;
                String name = element.getName();
                String taskName = MessageFormat.format(SearchUIResources.scanElementTask_name, name);
                this.progressMonitor.setTaskName(taskName);
                boolean foundMatch = false;
                if (element instanceof DescribableElement) {
                    String presentationName = ((DescribableElement)element).getPresentationName();
                    foundMatch = name != null && this.elementNamePattern.matcher(name).matches() || presentationName != null && this.elementNamePattern.matcher(presentationName).matches();
                } else {
                    boolean bl = foundMatch = name != null && this.elementNamePattern.matcher(name).matches();
                }
                if (foundMatch) {
                    if (this.searchString.length() == 0) {
                        this.result.accept(element);
                    } else {
                        try {
                            this.elementScanner.parse(element);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                }
                this.progressMonitor.worked(1);
            }
            catch (Exception e) {
                SearchUIPlugin.getDefault().getLogger().logError((Throwable)e);
            }
        }
    }

    protected String getElementPath(MethodElement element) {
        URI resourceURI;
        Resource resource = null;
        if (element instanceof DescribableElement) {
            DescribableElement describableElement = (DescribableElement)element;
            ContentDescription contentDescription = describableElement.getPresentation();
            if (contentDescription == null) {
                return null;
            }
            resource = contentDescription.eResource();
        } else {
            resource = element.eResource();
        }
        if (resource != null && (resourceURI = resource.getURI()) != null) {
            return resourceURI.toFileString();
        }
        return null;
    }

    private class MethodElementScanner
    extends AbstractSAXParser {
        private MethodElement element;

        public MethodElementScanner() {
            super(null, false);
        }

        public void parse(MethodElement element) {
            this.element = element;
            String elementPath = MethodSearchOperation.this.getElementPath(element);
            String briefDescription = element.getBriefDescription();
            if (MethodSearchOperation.this.searchStringPattern.matcher(briefDescription).find()) {
                MethodSearchOperation.this.result.accept(element);
            }
            if (elementPath != null && !MethodSearchOperation.this.parsedFiles.contains(elementPath)) {
                super.parse(elementPath);
                MethodSearchOperation.this.parsedFiles.add(elementPath);
            }
        }

        public void startElement(String namespaceURL, String localName, String qname, Attributes attributes) {
            int i = 0;
            while (i < attributes.getLength()) {
                String name = attributes.getQName(i);
                if (!name.equals("briefDescription")) {
                    String value = attributes.getValue(i);
                    if (MethodSearchOperation.this.searchStringPattern.matcher(value).find()) {
                        MethodSearchOperation.this.result.accept(this.element);
                    }
                }
                ++i;
            }
        }

        public void endElement(String namespaceURL, String localName, String qname) {
            String value = this.strBuf.toString();
            if (MethodSearchOperation.this.searchStringPattern.matcher(value).find()) {
                MethodSearchOperation.this.result.accept(this.element);
            }
            this.strBuf.setLength(0);
        }
    }
}

