/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.persistence;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.CommonPlugin;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.NotificationImpl;
import org.eclipse.emf.common.util.AbstractTreeIterator;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.emf.ecore.xmi.impl.XMLInfoImpl;
import org.eclipse.emf.ecore.xmi.impl.XMLMapImpl;
import org.eclipse.epf.persistence.MethodLibraryPersister;
import org.eclipse.epf.persistence.MultiFileIOException;
import org.eclipse.epf.persistence.MultiFileSaveUtil;
import org.eclipse.epf.persistence.MultiFileURIConverter;
import org.eclipse.epf.persistence.MultiFileXMIResourceImpl;
import org.eclipse.epf.persistence.MultiFileXMISaveImpl;
import org.eclipse.epf.persistence.TxRecord;
import org.eclipse.epf.persistence.UnnormalizedURIException;
import org.eclipse.epf.persistence.refresh.IRefreshListener;
import org.eclipse.epf.persistence.refresh.RefreshJob;
import org.eclipse.epf.persistence.refresh.internal.RefreshEvent;
import org.eclipse.epf.persistence.util.PersistenceResources;
import org.eclipse.epf.persistence.util.UnresolvedProxyMarkerManager;
import org.eclipse.epf.resourcemanager.ResourceDescriptor;
import org.eclipse.epf.resourcemanager.ResourceManager;
import org.eclipse.epf.resourcemanager.ResourcemanagerFactory;
import org.eclipse.epf.uma.Activity;
import org.eclipse.epf.uma.BreakdownElement;
import org.eclipse.epf.uma.Descriptor;
import org.eclipse.epf.uma.Diagram;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.MethodLibrary;
import org.eclipse.epf.uma.MethodPlugin;
import org.eclipse.epf.uma.Process;
import org.eclipse.epf.uma.ProcessComponent;
import org.eclipse.epf.uma.ProcessElement;
import org.eclipse.epf.uma.ProcessPackage;
import org.eclipse.epf.uma.RoleDescriptor;
import org.eclipse.epf.uma.SemanticModelBridge;
import org.eclipse.epf.uma.TeamProfile;
import org.eclipse.epf.uma.UMASemanticModelBridge;
import org.eclipse.epf.uma.UmaFactory;
import org.eclipse.epf.uma.UmaPackage;
import org.eclipse.epf.uma.WorkOrder;
import org.eclipse.epf.uma.WorkProductDescriptor;
import org.eclipse.epf.uma.ecore.IProxyResolutionListener;
import org.eclipse.epf.uma.ecore.IUmaResourceSet;
import org.eclipse.epf.uma.ecore.ResolveException;
import org.eclipse.epf.uma.ecore.util.OppositeFeature;
import org.eclipse.epf.uma.util.AssociationHelper;
import org.eclipse.epf.uma.util.ContentDescriptionFactory;
import org.eclipse.epf.uma.util.UmaUtil;
import org.eclipse.osgi.util.NLS;

public class MultiFileResourceSetImpl
extends ResourceSetImpl
implements IProxyResolutionListener,
IUmaResourceSet {
    private static final String[] DEFAULT_DELIVERY_PROCESS_PATH = new String[]{"DeliveryProcesses"};
    private static final String[] DEFAULT_CAPABILITY_PATTERN_PATH = new String[]{"Content", "CapabilityPatterns"};
    private static final String[] DEFAULT_PROCESS_CONTRIBUTION_PATH = new String[]{"ProcessContributions"};
    public static final String[][] PROCESS_PACKAGE_PATHS = new String[][]{DEFAULT_DELIVERY_PROCESS_PATH, DEFAULT_CAPABILITY_PATTERN_PATH, DEFAULT_PROCESS_CONTRIBUTION_PATH};
    public static boolean REPORT_ERROR = true;
    static final Map DEFAULT_SAVE_OPTIONS = new HashMap();
    static final Set DEFAULT_SAVE_SEPARATELY_CLASS_SET = new HashSet();
    public static final String RESMGR_XMI = "resmgr.xmi";
    private HashMap defaultSaveOptions;
    private HashMap guidToMethodElementMap;
    private boolean loading;
    private boolean loadingResourceManagerTree;
    private Map URIToTempURIMap;
    private UnresolvedProxyMarkerManager markerMananger = new UnresolvedProxyMarkerManager((ResourceSet)this);
    private UniqueEList refreshListeners;

    static {
        DEFAULT_SAVE_SEPARATELY_CLASS_SET.add(UmaPackage.eINSTANCE.getMethodPlugin());
        DEFAULT_SAVE_SEPARATELY_CLASS_SET.add(UmaPackage.eINSTANCE.getProcessComponent());
        DEFAULT_SAVE_SEPARATELY_CLASS_SET.add(UmaPackage.eINSTANCE.getContentDescription());
        DEFAULT_SAVE_SEPARATELY_CLASS_SET.add(UmaPackage.eINSTANCE.getMethodConfiguration());
        XMLResource.XMLMap xmlMap = MultiFileResourceSetImpl.createSaveXMLMap();
        HashSet<EClass> saveTogether = new HashSet<EClass>();
        saveTogether.add(UmaPackage.eINSTANCE.getBreakdownElementDescription());
        DEFAULT_SAVE_OPTIONS.put("SAVE_SEPARATELY_CLASS_SET", DEFAULT_SAVE_SEPARATELY_CLASS_SET);
        DEFAULT_SAVE_OPTIONS.put("SAVE_ALL", "false");
        DEFAULT_SAVE_OPTIONS.put("SAVE_TOGETHER_CLASS_SET", saveTogether);
        DEFAULT_SAVE_OPTIONS.put("REFRESH_NEW_RESOURCE", "true");
        DEFAULT_SAVE_OPTIONS.put("CHECK_MODIFY", "true");
        DEFAULT_SAVE_OPTIONS.put("ENCODING", "UTF-8");
        DEFAULT_SAVE_OPTIONS.put("PROCESS_DANGLING_HREF", "DISCARD");
        DEFAULT_SAVE_OPTIONS.put("XML_MAP", xmlMap);
        AssociationHelper.init();
    }

    private static XMLResource.XMLMap createLoadXMLMap() {
        XMLMapImpl xmlMap = new XMLMapImpl();
        HashSet<EAttribute> excludedAttributes = new HashSet<EAttribute>();
        excludedAttributes.add(UmaPackage.eINSTANCE.getMethodElement_Guid());
        excludedAttributes.add(UmaPackage.eINSTANCE.getNamedElement_Name());
        Iterator iter = UmaPackage.eINSTANCE.getEClassifiers().iterator();
        while (iter.hasNext()) {
            EClassifier eClassifier = (EClassifier)iter.next();
            if (!(eClassifier instanceof EClass)) continue;
            EClass eClass = (EClass)eClassifier;
            Iterator iterator = eClass.getEAttributes().iterator();
            while (iterator.hasNext()) {
                EAttribute attrib = (EAttribute)iterator.next();
                if (excludedAttributes.contains(attrib)) continue;
                XMLInfoImpl xmlInfo = new XMLInfoImpl();
                xmlInfo.setName(attrib.getName());
                xmlInfo.setXMLRepresentation(0);
                xmlMap.add((ENamedElement)attrib, (XMLResource.XMLInfo)xmlInfo);
            }
        }
        return xmlMap;
    }

    private static boolean saveAttributeAsElement(EClass eClass, Collection selectedEClasses) {
        Iterator iter = selectedEClasses.iterator();
        while (iter.hasNext()) {
            EClass base = (EClass)iter.next();
            if (!base.isSuperTypeOf(eClass)) continue;
            return true;
        }
        return false;
    }

    private static XMLResource.XMLMap createSaveXMLMap() {
        XMLMapImpl xmlMap = new XMLMapImpl();
        HashSet<EAttribute> excludedAttributes = new HashSet<EAttribute>();
        excludedAttributes.add(UmaPackage.eINSTANCE.getMethodElement_Guid());
        excludedAttributes.add(UmaPackage.eINSTANCE.getNamedElement_Name());
        HashSet<EClass> selectedEClasses = new HashSet<EClass>();
        selectedEClasses.add(UmaPackage.eINSTANCE.getContentDescription());
        selectedEClasses.add(UmaPackage.eINSTANCE.getSection());
        Iterator iter = UmaPackage.eINSTANCE.getEClassifiers().iterator();
        while (iter.hasNext()) {
            EClass eClass;
            EClassifier eClassifier = (EClassifier)iter.next();
            if (!(eClassifier instanceof EClass) || !MultiFileResourceSetImpl.saveAttributeAsElement(eClass = (EClass)eClassifier, selectedEClasses)) continue;
            Iterator iterator = eClass.getEAttributes().iterator();
            while (iterator.hasNext()) {
                EAttribute attrib = (EAttribute)iterator.next();
                if (excludedAttributes.contains(attrib)) continue;
                XMLInfoImpl xmlInfo = new XMLInfoImpl();
                xmlInfo.setName(attrib.getName());
                xmlInfo.setXMLRepresentation(0);
                xmlMap.add((ENamedElement)attrib, (XMLResource.XMLInfo)xmlInfo);
            }
        }
        return xmlMap;
    }

    public MultiFileResourceSetImpl() {
    }

    public MultiFileResourceSetImpl(boolean reportError) {
        this();
        this.markerMananger.setEnabled(reportError);
    }

    private void handleResourceChange(IResource wsRes) {
        System.out.println("MultiFileResourceSetImpl.handleResourceChange(): " + wsRes.toString());
        MultiFileXMIResourceImpl resource = (MultiFileXMIResourceImpl)this.getResource(URI.createFileURI((String)wsRes.getLocation().toString()), false);
        if (resource != null) {
            try {
                ArrayList proxies = new ArrayList();
                resource.reload(proxies);
                NotificationImpl msg = new NotificationImpl(11, false, true);
                Iterator iter = proxies.iterator();
                while (iter.hasNext()) {
                    EObject o = (EObject)iter.next();
                    o.eNotify((Notification)msg);
                }
            }
            catch (IOException e) {
                CommonPlugin.INSTANCE.log((Object)e);
            }
        }
    }

    public Map getLoadOptions() {
        Map options = super.getLoadOptions();
        options.put("ENCODING", "UTF-8");
        options.put("XML_MAP", MultiFileResourceSetImpl.createLoadXMLMap());
        return options;
    }

    public Map getDefaultSaveOptions() {
        if (this.defaultSaveOptions == null) {
            this.defaultSaveOptions = new HashMap();
            this.defaultSaveOptions.putAll(DEFAULT_SAVE_OPTIONS);
        }
        return this.defaultSaveOptions;
    }

    private Resource getMethodLibraryResource() {
        if (this.getResources().isEmpty()) {
            return null;
        }
        return (Resource)this.getResources().get(0);
    }

    public MethodLibrary getMethodLibrary() {
        Resource resource = this.getMethodLibraryResource();
        return resource == null ? null : (MethodLibrary)MultiFileSaveUtil.getMethodElement(resource);
    }

    ResourceManager getRootResourceManager() {
        Resource resource = this.getMethodLibraryResource();
        return resource == null ? null : MultiFileSaveUtil.getResourceManager(resource);
    }

    public URIConverter getURIConverter() {
        if (this.uriConverter == null) {
            this.uriConverter = new MultiFileURIConverter(this);
        }
        return this.uriConverter;
    }

    public Resource getResource(URI uri) {
        Resource res;
        block7: {
            if (this.getURIConverter().normalize(uri) == null) {
                return null;
            }
            res = null;
            try {
                res = super.getResource(uri, false);
                if (res != null) break block7;
                Map map = this.getURIResourceMap();
                res = this.createResource(uri);
                try {
                    this.demandLoadHelper(res);
                }
                catch (RuntimeException e) {
                    this.getResources().remove((Object)res);
                    throw e;
                }
                if (map != null) {
                    map.put(uri, res);
                }
            }
            catch (WrappedException e) {
                if (e.exception() instanceof FileNotFoundException) {
                    return null;
                }
                throw e;
            }
        }
        return res;
    }

    public Resource getResource(URI uri, boolean loadOnDemand) {
        if (this.getURIConverter().normalize(uri) == null) {
            return null;
        }
        Resource res = null;
        try {
            res = super.getResource(uri, loadOnDemand);
        }
        catch (RuntimeException e) {
            String msg = null;
            msg = e.getMessage() != null ? NLS.bind((String)PersistenceResources.loadResourceErrorWithReason_msg, (Object[])new Object[]{uri, e.getMessage()}) : NLS.bind((String)PersistenceResources.loadResourceError_msg, (Object)uri);
            this.handleException(msg);
            CommonPlugin.INSTANCE.log((Object)e);
            throw e;
        }
        return res;
    }

    public void addRefreshListener(IRefreshListener listener) {
        if (this.refreshListeners == null) {
            this.refreshListeners = new UniqueEList();
        }
        this.refreshListeners.add((Object)listener);
    }

    public void removeRefreshListenter(IRefreshListener listener) {
        if (this.refreshListeners != null) {
            this.refreshListeners.remove((Object)listener);
        }
    }

    public synchronized Collection reloadResources(Collection resources) {
        Iterator iter = resources.iterator();
        while (iter.hasNext()) {
            MultiFileXMIResourceImpl resource = (MultiFileXMIResourceImpl)((Object)iter.next());
            ResourceDescriptor resDesc = MultiFileSaveUtil.getResourceDescriptor((Resource)resource);
            if (resDesc == null) continue;
            resource.setResourceDescriptor(resDesc);
        }
        ArrayList<MultiFileXMIResourceImpl> reloadedResources = new ArrayList<MultiFileXMIResourceImpl>();
        HashSet proxies = new HashSet();
        ArrayList resourceList = new ArrayList(resources);
        Resource libResource = this.getMethodLibraryResource();
        if (resourceList.remove(libResource)) {
            MultiFileXMIResourceImpl resource = (MultiFileXMIResourceImpl)libResource;
            this.markerMananger.clearMarkers((Resource)resource);
            try {
                if (resource.reload(proxies)) {
                    reloadedResources.add(resource);
                    MultiFileURIConverter uriConverter = (MultiFileURIConverter)this.getURIConverter();
                    uriConverter.resMgr = null;
                }
            }
            catch (IOException e) {
                CommonPlugin.INSTANCE.log((Object)e);
            }
        }
        Iterator iter2 = resourceList.iterator();
        while (iter2.hasNext()) {
            MultiFileXMIResourceImpl resource = (MultiFileXMIResourceImpl)((Object)iter2.next());
            this.markerMananger.clearMarkers((Resource)resource);
            try {
                if (!resource.reload(proxies)) continue;
                reloadedResources.add(resource);
            }
            catch (IOException e) {
                CommonPlugin.INSTANCE.log((Object)e);
            }
        }
        if (!reloadedResources.isEmpty()) {
            this.initialize();
            if (this.refreshListeners != null) {
                RefreshEvent event = new RefreshEvent(reloadedResources, proxies);
                Iterator iter3 = new ArrayList(this.refreshListeners).iterator();
                while (iter3.hasNext()) {
                    IRefreshListener listener = (IRefreshListener)iter3.next();
                    listener.notifyRefreshed(event);
                }
            }
        }
        return reloadedResources;
    }

    public void initialize() {
        this.loadResourceManagerTree();
        this.loadOppositeFeatures();
        MultiFileURIConverter uriConverter = (MultiFileURIConverter)this.getURIConverter();
        uriConverter.resMgr = null;
    }

    protected void handleException(Object err) {
        CommonPlugin.INSTANCE.log(err);
        if (err instanceof Exception) {
            ((Exception)err).printStackTrace();
        } else {
            System.err.println(err.toString());
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void reset() {
        if (this.uriConverter instanceof MultiFileURIConverter) {
            ((MultiFileURIConverter)this.uriConverter).dispose();
        }
        this.uriConverter = null;
        boolean notify = this.eDeliver();
        boolean reportError = REPORT_ERROR;
        boolean refresh = RefreshJob.getInstance().isEnabled();
        try {
            RefreshJob.getInstance().setEnabled(false);
            this.eSetDeliver(false);
            REPORT_ERROR = false;
            this.markerMananger.setEnabled(false);
            this.markerMananger.clearAll();
            Iterator iter = new ArrayList(this.getResources()).iterator();
            while (true) {
                block9: {
                    if (iter.hasNext()) break block9;
                    this.clearErrors();
                    break;
                }
                Resource resource = (Resource)iter.next();
                try {
                    resource.unload();
                }
                catch (Exception exception) {}
            }
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            this.eSetDeliver(notify);
            REPORT_ERROR = reportError;
            this.markerMananger.setEnabled(true);
            RefreshJob.getInstance().setEnabled(refresh);
            throw throwable;
        }
        {
            Object var6_8 = null;
        }
        this.eSetDeliver(notify);
        REPORT_ERROR = reportError;
        this.markerMananger.setEnabled(true);
        RefreshJob.getInstance().setEnabled(refresh);
        if (this.guidToMethodElementMap != null) {
            this.guidToMethodElementMap.clear();
        }
        this.getResources().clear();
        if (this.URIToTempURIMap != null) {
            this.URIToTempURIMap.clear();
        }
        MultiFileXMIResourceImpl.clearDetachedEObjectToIDMap();
    }

    private void clearErrors() {
        this.markerMananger.clearAll();
    }

    public MethodLibrary loadLibrary(String path) throws Exception {
        long begin = System.currentTimeMillis();
        this.reset();
        long afterReset = System.currentTimeMillis();
        System.out.println("Reset time: " + (afterReset - begin));
        MethodLibrary lib = this.loadLibraryWithoutReset(path);
        System.out.println("Load time: " + (System.currentTimeMillis() - begin));
        if (MultiFileSaveUtil.DEBUG) {
            System.out.println("Modified resources after loading:");
            Iterator iter = this.getResources().iterator();
            while (iter.hasNext()) {
                Resource resource = (Resource)iter.next();
                if (!resource.isModified()) continue;
                System.out.println("  " + resource.getURI());
            }
        }
        return lib;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public MethodLibrary loadLibraryWithoutReset(String path) throws Exception {
        Throwable throwable2;
        MethodLibrary methodLibrary;
        this.loading = true;
        boolean b = RefreshJob.getInstance().isEnabled();
        RefreshJob.getInstance().setEnabled(false);
        URI uri = URI.createFileURI((String)new File(path).getCanonicalPath());
        Resource res = super.getResource(uri, true);
        if (!res.getErrors().isEmpty()) {
            StringBuffer strBuf = new StringBuffer();
            strBuf.append(PersistenceResources.loadLibraryError_msg);
            Iterator iter = res.getErrors().iterator();
            while (iter.hasNext()) {
                Resource.Diagnostic error = (Resource.Diagnostic)iter.next();
                strBuf.append(NLS.bind((String)PersistenceResources.loadLibraryError_details, (Object[])new Object[]{String.valueOf(error.getLine()), String.valueOf(error.getColumn()), error.getMessage()}));
            }
            System.err.println(strBuf.toString());
        }
        try {
            this.initialize();
            methodLibrary = this.getMethodLibrary();
        }
        catch (Exception e) {
            try {
                CommonPlugin.INSTANCE.log((Object)e);
                throw new Exception(NLS.bind((String)PersistenceResources.invalidLibraryFileError_msg, (Object)path));
            }
            catch (Throwable throwable2) {
                Object var8_11 = null;
                RefreshJob.getInstance().setEnabled(b);
                this.loading = false;
            }
        }
        Object var8_10 = null;
        RefreshJob.getInstance().setEnabled(b);
        this.loading = false;
        return methodLibrary;
        throw throwable2;
    }

    private void loadOppositeFeatures() {
        ArrayList<OppositeFeature> oppositeFeatures = new ArrayList<OppositeFeature>();
        Iterator iter = AssociationHelper.getPredefinedOppositeFeatures().iterator();
        while (iter.hasNext()) {
            OppositeFeature oppositeFeature = (OppositeFeature)iter.next();
            if (!oppositeFeature.resolveOwner()) continue;
            oppositeFeatures.add(oppositeFeature);
        }
        this.loadOppositeFeatures(oppositeFeatures);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void loadResourceManagerTree() {
        begin = System.currentTimeMillis();
        this.markerMananger.setEnabled(false);
        uriConverter = (MultiFileURIConverter)this.getURIConverter();
        try {
            uriConverter.setResolveProxy(false);
            resMgr = this.getRootResourceManager();
            iterator = new AbstractTreeIterator(resMgr, false){
                private static final long serialVersionUID = 2172691017987702506L;

                protected Iterator getChildren(Object object) {
                    ResourceManager resMgr = (ResourceManager)object;
                    HashSet<String> GUIDs = new HashSet<String>();
                    ArrayList subMgrs = new ArrayList(resMgr.getSubManagers());
                    Iterator iter = subMgrs.iterator();
                    while (iter.hasNext()) {
                        InternalEObject subMgr = (InternalEObject)iter.next();
                        if (subMgr == null || subMgr.eIsProxy()) continue;
                        MethodElement e = MultiFileSaveUtil.getMethodElement(subMgr.eResource());
                        GUIDs.add(e.getGuid());
                    }
                    MethodElement parent = MultiFileSaveUtil.getMethodElement(resMgr.eResource());
                    MultiFileSaveUtil.resolveProxies(GUIDs, (EObject)parent);
                    return resMgr.getSubManagers().iterator();
                }
            };
            this.loadingResourceManagerTree = true;
            while (iterator.hasNext()) {
                iterator.next();
            }
            ** GOTO lbl-1000
        }
        catch (Throwable var7_5) {
            var6_6 = null;
            this.markerMananger.setEnabled(true);
            uriConverter.setResolveProxy(true);
            this.loadingResourceManagerTree = false;
            iter = this.getGuidToMethodElementMap().values().iterator();
        }
        while (true) {
            if (!iter.hasNext()) {
                System.out.println("MultiFileResourceSetImpl.loadResourceManagerTree(): " + (System.currentTimeMillis() - begin));
                throw var7_5;
            }
            o = (InternalEObject)iter.next();
            if (!o.eIsProxy() || o.eContainer() == null) continue;
            uri = o.eProxyURI();
            normalizedURI = this.getURIConverter().normalize(uri);
            if (normalizedURI != null) continue;
            ((InternalEObject)o.eContainer()).eResolveProxy(o);
        }
lbl-1000:
        // 1 sources

        {
            var6_7 = null;
            this.markerMananger.setEnabled(true);
            uriConverter.setResolveProxy(true);
            this.loadingResourceManagerTree = false;
            iter = this.getGuidToMethodElementMap().values().iterator();
        }
        while (true) {
            if (!iter.hasNext()) {
                System.out.println("MultiFileResourceSetImpl.loadResourceManagerTree(): " + (System.currentTimeMillis() - begin));
                return;
            }
            o = (InternalEObject)iter.next();
            if (!o.eIsProxy() || o.eContainer() == null) continue;
            uri = o.eProxyURI();
            normalizedURI = this.getURIConverter().normalize(uri);
            if (normalizedURI != null) continue;
            ((InternalEObject)o.eContainer()).eResolveProxy(o);
        }
    }

    protected ResourceManager getResourceManager() {
        return ((MultiFileURIConverter)this.getURIConverter()).getResourceManager();
    }

    protected EObject findEObjectInUnloadedResources(String id) {
        return this.findEObjectInUnloadedResources(this.getResourceManager(), id);
    }

    private EObject findEObjectInUnloadedResources(ResourceManager resMgr, String id) {
        Iterator iter = resMgr.getResourceDescriptors().iterator();
        while (iter.hasNext()) {
            EObject eObject;
            ResourceDescriptor desc = (ResourceDescriptor)iter.next();
            Resource resource = super.getResource(desc.getResolvedURI(), false);
            if (resource != null && resource.isLoaded()) continue;
            try {
                resource = super.getResource(desc.getResolvedURI(), true);
            }
            catch (Exception exception) {}
            if (resource == null || (eObject = resource.getEObject(id)) == null) continue;
            return eObject;
        }
        iter = resMgr.getSubManagers().iterator();
        while (iter.hasNext()) {
            EObject eObject = this.findEObjectInUnloadedResources((ResourceManager)iter.next(), id);
            if (eObject == null) continue;
            return eObject;
        }
        return null;
    }

    public EObject getEObject(String id) {
        EObject eObject = (EObject)this.getGuidToMethodElementMap().get(id);
        if (eObject != null) {
            return eObject;
        }
        URI uri = MultiFileURIConverter.createURI(id).appendFragment(id);
        URI normalized = this.getURIConverter().normalize(uri);
        if (normalized == null) {
            eObject = this.findEObjectInUnloadedResources(id);
            if (eObject == null && REPORT_ERROR) {
                this.handleException(NLS.bind((String)PersistenceResources.objNotFoundError_msg, (Object)id));
            }
            return eObject;
        }
        try {
            return this.getEObject(uri, true);
        }
        catch (RuntimeException runtimeException) {
            return null;
        }
    }

    public EObject getEObject(URI uri, boolean loadOnDemand) {
        return this.getEObject(null, uri, loadOnDemand);
    }

    public Resource createResource(URI uri) {
        MultiFileXMIResourceImpl result = new MultiFileXMIResourceImpl(uri);
        result.setTrackingModification(true);
        this.getResources().add((Object)result);
        return result;
    }

    private static boolean backupRequired(Map options) {
        Boolean backup = (Boolean)options.get("BACK_UP_BEFORE_SAVE");
        return backup != null && backup != false;
    }

    private void backup(Resource res) {
        try {
            if (res.getContents().isEmpty()) {
                return;
            }
            Object object = res.getContents().get(0);
            if (!(object instanceof MethodLibrary || object instanceof ResourceManager || object instanceof MethodPlugin)) {
                return;
            }
            MethodLibrary library = this.getMethodLibrary();
            String backupDir = String.valueOf(new File(library.eResource().getURI().toFileString()).getParent()) + File.separator + ".bak";
            SimpleDateFormat dateFormatter = new SimpleDateFormat("yyMMddHHmmss.S");
            if (res == library.eResource()) {
                DateFormat.getInstance().format(Calendar.getInstance().getTime());
                File backupFile = new File(backupDir, "library.xmi_" + dateFormatter.format(Calendar.getInstance().getTime()));
                if (!backupFile.getParentFile().exists()) {
                    backupFile.getParentFile().mkdirs();
                }
                new File(res.getURI().toFileString()).renameTo(backupFile);
            } else {
                String relativePath = res.getURI().deresolve(library.eResource().getURI()).toFileString();
                File backupFile = new File(backupDir, String.valueOf(relativePath) + '_' + dateFormatter.format(Calendar.getInstance().getTime()));
                if (!backupFile.getParentFile().exists()) {
                    backupFile.getParentFile().mkdirs();
                }
                new File(res.getURI().toFileString()).renameTo(backupFile);
            }
        }
        catch (Exception e) {
            this.handleException(e);
            this.handleException(NLS.bind((String)PersistenceResources.backupError_msg, (Object)res));
        }
    }

    void removeURIMappings(EObject eObj, Set modifiedResources) {
        ResourceDescriptor desc;
        ResourceManager resMgr = MultiFileSaveUtil.getResourceManager(eObj.eResource());
        if (resMgr != null && resMgr.eContainer() != null) {
            EcoreUtil.remove((EObject)resMgr);
        }
        if ((desc = MultiFileSaveUtil.findResourceDescriptor(this.getRootResourceManager(), MultiFileSaveUtil.getGuid(eObj), null, true)) != null) {
            if (modifiedResources != null && desc.eResource() != null) {
                modifiedResources.add(desc.eResource());
            }
            EcoreUtil.remove((EObject)desc);
        }
    }

    protected void cleanUp(Resource removedResource) throws IOException {
        this.cleanUp(removedResource, null);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void cleanUp(Resource removedResource, Set modifiedResources) throws IOException {
        try {
            if (removedResource.getContents().isEmpty()) {
                removedResource.unload();
                try {
                    removedResource.load(null);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    Object var4_3 = null;
                    this.getResources().remove((Object)removedResource);
                    URI oldURI = ((MultiFileXMIResourceImpl)removedResource).getOldURI();
                    if (oldURI == null) return;
                    this.getURIToTempURIMap().remove(oldURI);
                    return;
                }
            }
            MethodElement obj = MultiFileSaveUtil.getMethodElement(removedResource);
            this.removeURIMappings((EObject)obj, modifiedResources);
            removedResource.unload();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.getResources().remove((Object)removedResource);
            URI oldURI = ((MultiFileXMIResourceImpl)removedResource).getOldURI();
            if (oldURI == null) throw throwable;
            this.getURIToTempURIMap().remove(oldURI);
            throw throwable;
        }
        {
            Object var4_5 = null;
        }
        this.getResources().remove((Object)removedResource);
        URI oldURI = ((MultiFileXMIResourceImpl)removedResource).getOldURI();
        if (oldURI == null) return;
        this.getURIToTempURIMap().remove(oldURI);
    }

    private void cleanUp(ProcessPackage procPkg) {
        this.removeContentDescriptions(procPkg);
        EcoreUtil.remove((EObject)procPkg);
    }

    private void removeContentDescriptions(ProcessPackage procPkg) {
        Iterator iter = procPkg.getProcessElements().iterator();
        while (iter.hasNext()) {
            ProcessElement element = (ProcessElement)iter.next();
            if (!ContentDescriptionFactory.hasPresentation((MethodElement)element) || element.getPresentation().eResource() == null) continue;
            this.removePresentation(element);
        }
        iter = procPkg.getChildPackages().iterator();
        while (iter.hasNext()) {
            Object pkg = iter.next();
            if (!(pkg instanceof ProcessPackage)) continue;
            this.removeContentDescriptions((ProcessPackage)pkg);
        }
    }

    private void removePresentation(ProcessElement element) {
        Resource resource = element.getPresentation().eResource();
        resource.getContents().remove((Object)element.getPresentation());
    }

    boolean save(Collection resources, Map options, boolean prepareSave) throws Exception {
        if (options == null) {
            options = this.getDefaultSaveOptions();
        }
        HashSet modifiedResources = new HashSet();
        options.put("MODIFIED_RESOURCE_SET", modifiedResources);
        try {
            Iterator iter = resources.iterator();
            while (iter.hasNext()) {
                Resource res = (Resource)iter.next();
                this.save(res, options, prepareSave);
            }
            this.saveModifiedResources(options);
            Object var7_7 = null;
            options.remove("MODIFIED_RESOURCE_SET");
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            options.remove("MODIFIED_RESOURCE_SET");
            throw throwable;
        }
        return true;
    }

    boolean save(Resource res, Map options, boolean prepareSave) throws Exception {
        Set modifiedResources = (Set)options.get("MODIFIED_RESOURCE_SET");
        TxRecord txRecord = (TxRecord)options.get("TX_RECORD");
        List resourcesToCommit = txRecord != null ? txRecord.getResourcesToCommit() : null;
        try {
            MethodElement eObj = MultiFileSaveUtil.getMethodElement(res);
            if (eObj != null) {
                if (prepareSave && eObj instanceof ProcessComponent) {
                    ProcessComponent procComp = (ProcessComponent)eObj;
                    Resource content = procComp.getProcess() != null && ContentDescriptionFactory.hasPresentation((MethodElement)procComp.getProcess()) ? procComp.getProcess().getPresentation().eResource() : null;
                    boolean alreadyModified = content != null && content.isModified();
                    this.prepareSave(procComp);
                    if (content != null && content.isModified() && !alreadyModified) {
                        modifiedResources.add(content);
                    }
                }
                if (res.isModified()) {
                    boolean backupRequired = MultiFileResourceSetImpl.backupRequired(options);
                    if (backupRequired) {
                        this.backup(res);
                    }
                    if (resourcesToCommit != null) {
                        ((MultiFileXMIResourceImpl)res).setTempURI(txRecord.getTxID());
                        resourcesToCommit.add(res);
                    }
                    MultiFileSaveUtil.save(res, options);
                    return true;
                }
            }
        }
        catch (Exception exception) {
            this.handleException(exception);
            throw exception;
        }
        return false;
    }

    public boolean save(Resource res, Map options) throws Exception {
        boolean bl;
        this.markerMananger.clearMarkers(res);
        if (res == null || res.getContents().isEmpty()) {
            return false;
        }
        if (options == null) {
            options = this.getDefaultSaveOptions();
        }
        HashSet modifiedResources = new HashSet();
        options.put("MODIFIED_RESOURCE_SET", modifiedResources);
        try {
            boolean ret = this.save(res, options, true);
            this.saveModifiedResources(options);
            bl = ret;
            Object var5_6 = null;
            options.remove("MODIFIED_RESOURCE_SET");
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            options.remove("MODIFIED_RESOURCE_SET");
            throw throwable;
        }
        return bl;
    }

    public void save(Map options) throws Exception {
        this.save(options, false, true);
    }

    void saveModifiedResources(Map options) {
        List resourcesToCommit;
        Set modifiedResources = (Set)options.get("MODIFIED_RESOURCE_SET");
        TxRecord txRecord = (TxRecord)options.get("TX_RECORD");
        List list = resourcesToCommit = txRecord != null ? txRecord.getResourcesToCommit() : null;
        if (modifiedResources == null) {
            return;
        }
        boolean backupRequired = MultiFileResourceSetImpl.backupRequired(options);
        boolean checkModify = MultiFileXMISaveImpl.checkModifyRequired(options);
        while (!modifiedResources.isEmpty()) {
            Iterator iter = new ArrayList(modifiedResources).iterator();
            modifiedResources.clear();
            while (iter.hasNext()) {
                Resource resource = (Resource)iter.next();
                if (checkModify) {
                    MultiFileSaveUtil.checkModify(resource);
                }
                if (backupRequired) {
                    this.backup(resource);
                }
                if (resourcesToCommit != null) {
                    ((MultiFileXMIResourceImpl)resource).setTempURI(txRecord.getTxID());
                    resourcesToCommit.add(resource);
                }
                MultiFileSaveUtil.save(resource, options);
            }
        }
    }

    public void save(Map options, boolean saveAll) throws Exception {
        this.save(options, saveAll, false);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void save(Map options, boolean saveAll, boolean failSafe) throws Exception {
        if (options == null) {
            options = new HashMap(this.getDefaultSaveOptions());
        }
        MethodLibrary library = this.getMethodLibrary();
        MultiFileSaveUtil.setGuid((MethodElement)library);
        this.prepareSave(library);
        this.cleanUp();
        MultiFileURIConverter umaUriConverter = (MultiFileURIConverter)this.getURIConverter();
        umaUriConverter.setLibraryURIs(library);
        HashSet modifiedResources = new HashSet();
        options.put("MODIFIED_RESOURCE_SET", modifiedResources);
        MethodLibraryPersister.FailSafePersister persister = null;
        if (failSafe) {
            persister = MethodLibraryPersister.INSTANCE.getFailSafePersister(options);
            options = persister.getSaveOptions();
        }
        try {
            block16: {
                try {
                    EList list = this.getResources();
                    int size = list.size();
                    boolean backupRequired = MultiFileResourceSetImpl.backupRequired(options);
                    ArrayList<Resource> saveResources = new ArrayList<Resource>();
                    ArrayList moveResources = new ArrayList();
                    int i = 0;
                    while (i < size) {
                        Resource res = (Resource)list.get(i);
                        MethodElement eObj = MultiFileSaveUtil.getMethodElement(res);
                        if (eObj != null && eObj instanceof MethodElement && (saveAll || res.isModified())) {
                            if (failSafe) {
                                saveResources.add(res);
                            } else {
                                if (backupRequired) {
                                    this.backup(res);
                                }
                                MultiFileSaveUtil.save(res, options);
                            }
                        }
                        ++i;
                    }
                    if (failSafe) {
                        try {
                            MultiFileSaveUtil.checkModify(saveResources);
                            this.save(saveResources, options, false);
                            persister.commit();
                            persister.adjustLocation(moveResources);
                            break block16;
                        }
                        catch (Exception e) {
                            persister.rollback();
                            throw e;
                        }
                    }
                    Iterator iter = moveResources.iterator();
                    while (iter.hasNext()) {
                        Resource resource = (Resource)iter.next();
                        MultiFileSaveUtil.adjustLocation(resource, modifiedResources);
                    }
                    this.saveModifiedResources(options);
                }
                catch (Exception exception) {
                    this.handleException(exception);
                    throw exception;
                }
            }
            Object var16_21 = null;
            options.remove("MODIFIED_RESOURCE_SET");
            return;
        }
        catch (Throwable throwable) {
            Object var16_20 = null;
            options.remove("MODIFIED_RESOURCE_SET");
            throw throwable;
        }
    }

    public void saveAs(String newLocation, boolean regenerateGUID, IProgressMonitor monitor) throws Exception {
        MethodLibrary lib = this.getMethodLibrary();
        if (lib == null) {
            return;
        }
        if (monitor != null) {
            monitor.setTaskName(PersistenceResources.loadResourcesTask_name);
        }
        TreeIterator iter = lib.eAllContents();
        while (iter.hasNext()) {
            EObject element = (EObject)iter.next();
            if (regenerateGUID && element instanceof MethodElement) {
                ((MethodElement)element).setGuid(UmaUtil.generateGUID());
            }
            Iterator iterator = element.eCrossReferences().iterator();
            while (iterator.hasNext()) {
                iterator.next();
            }
        }
        URI oldDir = URI.createFileURI((String)(String.valueOf(new File(lib.eResource().getURI().toFileString()).getParent()) + File.separator));
        URI newDir = URI.createFileURI((String)(String.valueOf(newLocation) + File.separator));
        Iterator iter2 = this.getResources().iterator();
        while (iter2.hasNext()) {
            Resource resource = (Resource)iter2.next();
            resource.setURI(resource.getURI().replacePrefix(oldDir, newDir));
        }
        ResourceManager resMgr = ((MultiFileURIConverter)this.getURIConverter()).getResourceManager();
        if (resMgr != null) {
            resMgr.getResourceDescriptors().clear();
        }
        if (monitor != null) {
            monitor.setTaskName(PersistenceResources.saveLibraryTask_name);
        }
        this.save(null, true);
    }

    private void cleanUp() throws IOException {
        Resource res;
        MethodLibrary library = this.getMethodLibrary();
        ArrayList<Resource> removedResources = new ArrayList<Resource>();
        EList list = this.getResources();
        int size = list.size();
        int i = 0;
        while (i < size) {
            res = (Resource)list.get(i);
            boolean remove = false;
            if (res.getContents().isEmpty()) {
                System.out.println("MultiFileResourceSetImpl.cleanUp(): empty resource: " + res);
                remove = true;
            } else {
                MethodElement eObj = MultiFileSaveUtil.getMethodElement(res);
                if (eObj == null || eObj != library && eObj.eContainer() == null) {
                    if (eObj == null) {
                        System.out.println("MultiFileResourceSetImpl.cleanUp(): resource without any MethodElement: " + res);
                        remove = true;
                    } else if (eObj != library && eObj.eContainer() == null) {
                        System.out.println("MultiFileResourceSetImpl.cleanUp(): resource without a container: " + res);
                    }
                }
            }
            if (remove) {
                removedResources.add(res);
            }
            ++i;
        }
        System.out.println("MultiFileResourceSetImpl.cleanUp(): removed resources: " + removedResources);
        Iterator iter = removedResources.iterator();
        while (iter.hasNext()) {
            res = (Resource)iter.next();
            try {
                this.cleanUp(res);
            }
            catch (Exception e) {
                this.handleException(e);
            }
        }
    }

    private void prepareSave(MethodLibrary library) {
        MultiFileXMIResourceImpl resource = (MultiFileXMIResourceImpl)library.eResource();
        ResourceManager libResMgr = MultiFileSaveUtil.getResourceManager((Resource)resource);
        if (libResMgr == null) {
            libResMgr = ResourcemanagerFactory.eINSTANCE.createResourceManager();
            resource.getContents().add(0, (Object)libResMgr);
            MultiFileSaveUtil.registerWithResourceManager(libResMgr, library, resource.getFinalURI());
        }
        List models = library.getMethodPlugins();
        int size = models.size();
        int i = 0;
        while (i < size) {
            this.prepareSave((MethodPlugin)models.get(i));
            ++i;
        }
        i = 0;
        while (i < size) {
            MultiFileResourceSetImpl.cleanUp((MethodPlugin)models.get(i));
            ++i;
        }
    }

    private static void cleanUp(MethodPlugin plugin) {
        int i = 0;
        while (i < PROCESS_PACKAGE_PATHS.length) {
            ProcessPackage pkg = (ProcessPackage)UmaUtil.findMethodPackage((MethodPlugin)plugin, (String[])PROCESS_PACKAGE_PATHS[i]);
            if (pkg != null) {
                MultiFileResourceSetImpl.cleanUpProcesses(pkg);
            }
            ++i;
        }
    }

    private void prepareSave(MethodPlugin model) {
        int i = 0;
        while (i < PROCESS_PACKAGE_PATHS.length) {
            ProcessPackage pkg = (ProcessPackage)UmaUtil.findMethodPackage((MethodPlugin)model, (String[])PROCESS_PACKAGE_PATHS[i]);
            if (pkg != null) {
                this.prepareSave(pkg);
            }
            ++i;
        }
    }

    private static void cleanUpProcesses(ProcessPackage pkg) {
        List list = pkg.getChildPackages();
        int size = list.size();
        int i = 0;
        while (i < size) {
            Object obj = list.get(i);
            if (obj instanceof ProcessComponent) {
                ProcessComponent procComp = (ProcessComponent)obj;
                ArrayList packages = new ArrayList();
                Iterator iter = procComp.getChildPackages().iterator();
                while (iter.hasNext()) {
                    Object element = iter.next();
                    if (!(element instanceof ProcessPackage)) continue;
                    MultiFileResourceSetImpl.getRemovedPackages((ProcessPackage)element, packages);
                }
                Iterator iterator = packages.iterator();
                while (iterator.hasNext()) {
                    EcoreUtil.remove((EObject)((EObject)iterator.next()));
                }
            }
            ++i;
        }
    }

    private static void getRemovedPackages(ProcessPackage pkg, List removedPackages) {
        Activity act = MultiFileResourceSetImpl.getActivity(pkg);
        if (act == null || MultiFileResourceSetImpl.getParent((BreakdownElement)act) == null) {
            removedPackages.add(pkg);
        } else {
            Iterator iter = pkg.getChildPackages().iterator();
            while (iter.hasNext()) {
                Object element = iter.next();
                if (!(element instanceof ProcessPackage)) continue;
                MultiFileResourceSetImpl.getRemovedPackages((ProcessPackage)element, removedPackages);
            }
        }
    }

    private static Activity getActivity(ProcessPackage pkg) {
        Activity act = null;
        Iterator iter = pkg.getProcessElements().iterator();
        while (iter.hasNext()) {
            Object element = iter.next();
            if (!(element instanceof Activity)) continue;
            act = (Activity)element;
            break;
        }
        return act;
    }

    private static Object getParent(BreakdownElement e) {
        return UmaUtil.getParentActivity((BreakdownElement)e);
    }

    private void prepareSave(ProcessPackage pkg) {
        List list = pkg.getChildPackages();
        int size = list.size();
        int i = 0;
        while (i < size) {
            Object obj = list.get(i);
            if (obj instanceof ProcessComponent) {
                this.prepareSave((ProcessComponent)obj);
            }
            ++i;
        }
    }

    private void prepareSave(ProcessComponent procComp) {
        Process proc = procComp.getProcess();
        if (proc != null) {
            MultiFileResourceSetImpl.prepareSave((Activity)proc);
            MultiFileResourceSetImpl.cleanUpDanglingDescriptors((ProcessPackage)procComp);
            ArrayList danglingPkgs = new ArrayList();
            Iterator iter = new ArrayList(procComp.getChildPackages()).iterator();
            while (iter.hasNext()) {
                Object element = iter.next();
                if (!(element instanceof ProcessPackage)) continue;
                ProcessPackage pkg = (ProcessPackage)element;
                this.reorganize(pkg, danglingPkgs);
            }
            iter = danglingPkgs.iterator();
            while (iter.hasNext()) {
                this.cleanUp((ProcessPackage)iter.next());
            }
        }
    }

    private static void prepareSave(Activity activity) {
        ProcessPackage parentPkg = (ProcessPackage)activity.eContainer();
        List elements = activity.getBreakdownElements();
        Iterator iter = elements.iterator();
        while (iter.hasNext()) {
            EObject element = (EObject)iter.next();
            if (element instanceof Activity || element.eContainer() != null) continue;
            parentPkg.getProcessElements().add(element);
        }
        iter = activity.getLinkToPredecessor().iterator();
        while (iter.hasNext()) {
            WorkOrder workOrder = (WorkOrder)iter.next();
            if (workOrder.eContainer() == null) {
                if (workOrder.getPred() == null || MultiFileResourceSetImpl.getParent((BreakdownElement)workOrder.getPred()) == null) continue;
                parentPkg.getProcessElements().add(workOrder);
                continue;
            }
            if (workOrder.getPred() != null && MultiFileResourceSetImpl.getParent((BreakdownElement)workOrder.getPred()) != null) continue;
            if (MultiFileSaveUtil.DEBUG) {
                System.err.println("Invalid WorkOrder: " + workOrder);
            }
            parentPkg.getProcessElements().remove(workOrder);
        }
        iter = parentPkg.getDiagrams().iterator();
        while (iter.hasNext()) {
            MethodElement element;
            Diagram diagram = (Diagram)iter.next();
            SemanticModelBridge bridge = diagram.getSemanticModel();
            if (!(bridge instanceof UMASemanticModelBridge) || !((element = ((UMASemanticModelBridge)bridge).getElement()) instanceof Activity) || element instanceof Process || MultiFileResourceSetImpl.getParent((BreakdownElement)((Activity)element)) != null) continue;
            iter.remove();
        }
        int size = elements.size();
        int i = 0;
        while (i < size) {
            Object e = elements.get(i);
            if (e instanceof Activity) {
                Activity act = (Activity)e;
                if (act.eContainer() == null) {
                    ProcessPackage pkg = UmaFactory.eINSTANCE.createProcessPackage();
                    pkg.setName(act.getName());
                    pkg.getProcessElements().add(act);
                    ArrayList descriptors = new ArrayList();
                    int j = 0;
                    while (j < act.getBreakdownElements().size()) {
                        Object obj = act.getBreakdownElements().get(j);
                        if (obj instanceof Descriptor) {
                            descriptors.add(obj);
                        }
                        ++j;
                    }
                    pkg.getProcessElements().addAll(descriptors);
                    parentPkg.getChildPackages().add(pkg);
                }
                MultiFileResourceSetImpl.prepareSave(act);
            }
            ++i;
        }
    }

    private static void cleanUpDanglingDescriptors(ProcessPackage pkg) {
        Iterator iter = pkg.getProcessElements().iterator();
        while (iter.hasNext()) {
            Object element = iter.next();
            if (!(element instanceof BreakdownElement) || ((BreakdownElement)element).getSuperActivities() != null) continue;
            boolean remove = false;
            if (element instanceof RoleDescriptor) {
                if (AssociationHelper.getTeamProfiles((RoleDescriptor)((RoleDescriptor)element)).isEmpty()) {
                    remove = true;
                }
            } else if (element instanceof WorkProductDescriptor) {
                if (AssociationHelper.getDeliverableDescriptors((WorkProductDescriptor)((WorkProductDescriptor)element)).isEmpty()) {
                    remove = true;
                }
            } else if (element instanceof TeamProfile) {
                if (((TeamProfile)element).getSuperTeam() == null) {
                    remove = true;
                }
            } else {
                remove = true;
            }
            if (!remove) continue;
            iter.remove();
        }
    }

    private void reorganize(ProcessPackage pkg, List danglingPkgs) {
        EObject parentAct;
        Activity act = MultiFileResourceSetImpl.getActivity(pkg);
        if (act == null) {
            return;
        }
        if (!pkg.getName().equals(act.getName())) {
            pkg.setName(act.getName());
        }
        if ((parentAct = (EObject)MultiFileResourceSetImpl.getParent((BreakdownElement)act)) == null) {
            danglingPkgs.add(pkg);
        } else if (parentAct != MultiFileResourceSetImpl.getActivity((ProcessPackage)pkg.eContainer())) {
            ProcessPackage parentPkg = (ProcessPackage)parentAct.eContainer();
            parentPkg.getChildPackages().add(pkg);
        }
        if (parentAct != null) {
            MultiFileResourceSetImpl.cleanUpDanglingDescriptors(pkg);
        }
        Iterator iter = pkg.getChildPackages().iterator();
        while (iter.hasNext()) {
            Object element = iter.next();
            if (!(element instanceof ProcessPackage)) continue;
            this.reorganize((ProcessPackage)element, danglingPkgs);
        }
    }

    public Map getGuidToMethodElementMap() {
        if (this.guidToMethodElementMap == null) {
            this.guidToMethodElementMap = new HashMap();
        }
        return this.guidToMethodElementMap;
    }

    public void eNotify(Notification notification) {
        try {
            super.eNotify(notification);
        }
        catch (RuntimeException e) {
            CommonPlugin.INSTANCE.log((Object)("ERROR notifying changes: resourceSet=" + (Object)((Object)this) + ", notification=" + notification));
            CommonPlugin.INSTANCE.log((Object)e);
            e.printStackTrace();
        }
    }

    public void addMarker(Exception e) {
        block2: {
            try {
                this.markerMananger.notifyException(e);
            }
            catch (RuntimeException ex) {
                CommonPlugin.INSTANCE.log((Object)ex);
                if (!MultiFileSaveUtil.DEBUG) break block2;
                ex.printStackTrace();
            }
        }
    }

    public void setLoading(boolean b) {
        this.loading = b;
    }

    public void notifyException(Exception e) {
        if (this.loadingResourceManagerTree && e instanceof ResolveException && ((ResolveException)e).exception() instanceof MultiFileIOException) {
            return;
        }
        try {
            this.addMarker(e);
        }
        catch (Exception exception) {}
    }

    public void proxyResolved(Object proxy, Object resolved) {
        String guid = MultiFileSaveUtil.getGuid(resolved);
        if (guid != null) {
            this.getGuidToMethodElementMap().put(guid, resolved);
        }
        this.markerMananger.proxyResolved(proxy, resolved);
    }

    private EObject getEObjectByGUID(String guid) {
        return (EObject)this.getGuidToMethodElementMap().get(guid);
    }

    public EObject getEObject(EObject resolver, URI uri, boolean loadOnDemand) {
        URI normalized = ((MultiFileURIConverter)this.getURIConverter()).normalize(uri, resolver);
        if (normalized == null) {
            EObject eObject;
            String guid = uri.fragment();
            if (uri.authority().equals(guid) && (eObject = this.getEObjectByGUID(guid)) != null) {
                return eObject;
            }
            String msg = NLS.bind((String)PersistenceResources.normalizeURIError_msg, (Object)uri);
            throw new UnnormalizedURIException(msg);
        }
        Resource resource = this.getResource(normalized.trimFragment(), loadOnDemand);
        if (resource != null) {
            String fragment = normalized.fragment();
            if (fragment == null || fragment.length() == 0) {
                return MultiFileSaveUtil.getMethodElement(resource);
            }
            EObject eObject = resource.getEObject(fragment);
            if (eObject == null && !fragment.equals(uri.authority())) {
                return this.getEObjectByGUID(fragment);
            }
            return eObject;
        }
        return null;
    }

    public void loadOppositeFeatures(List oppositeFeatures) {
        int max = oppositeFeatures.size() - 1;
        if (max < 0) {
            return;
        }
        ArrayList elements = new ArrayList(this.getGuidToMethodElementMap().values());
        HashSet loadedElements = new HashSet();
        while (!elements.isEmpty()) {
            loadedElements.clear();
            loadedElements.addAll(this.getGuidToMethodElementMap().values());
            Iterator iter = elements.iterator();
            while (iter.hasNext()) {
                Object obj = iter.next();
                if (!(obj instanceof MethodElement)) continue;
                MethodElement element = (MethodElement)obj;
                int i = max;
                while (i > -1) {
                    EStructuralFeature eFeature = ((OppositeFeature)oppositeFeatures.get(i)).getTargetFeature();
                    if (eFeature.getContainerClass().isInstance(element)) {
                        if (eFeature.isMany()) {
                            InternalEList list = (InternalEList)element.eGet(eFeature);
                            if (!list.isEmpty()) {
                                Iterator iterator = list.iterator();
                                while (iterator.hasNext()) {
                                    iterator.next();
                                }
                            }
                        } else {
                            element.eGet(eFeature);
                        }
                    }
                    --i;
                }
            }
            elements = new ArrayList(this.getGuidToMethodElementMap().values());
            elements.removeAll(loadedElements);
        }
    }

    public void loadOppositeFeatures(List oppositeFeatures, Set deletedGUIDs) {
        int max = oppositeFeatures.size() - 1;
        if (max < 0) {
            return;
        }
        ArrayList elements = new ArrayList(this.getGuidToMethodElementMap().values());
        while (!elements.isEmpty()) {
            Iterator iter = elements.iterator();
            while (iter.hasNext()) {
                Object obj = iter.next();
                if (!(obj instanceof MethodElement)) continue;
                MethodElement element = (MethodElement)obj;
                int i = max;
                while (i > -1) {
                    EStructuralFeature eFeature = ((OppositeFeature)oppositeFeatures.get(i)).getTargetFeature();
                    if (eFeature.getContainerClass().isInstance(element)) {
                        if (eFeature.isMany()) {
                            InternalEList list = (InternalEList)element.eGet(eFeature);
                            if (!list.isEmpty()) {
                                boolean resolve = false;
                                Iterator iterator = list.basicIterator();
                                while (iterator.hasNext()) {
                                    String guid;
                                    InternalEObject e = (InternalEObject)iterator.next();
                                    if (!e.eIsProxy() || !deletedGUIDs.contains(guid = e.eProxyURI().fragment())) continue;
                                    resolve = true;
                                    break;
                                }
                                if (resolve) {
                                    iterator = list.iterator();
                                    while (iterator.hasNext()) {
                                        iterator.next();
                                    }
                                }
                            }
                        } else {
                            String guid;
                            InternalEObject e;
                            Object value = element.eGet(eFeature, false);
                            if (value instanceof InternalEObject && (e = (InternalEObject)value).eIsProxy() && deletedGUIDs.contains(guid = e.eProxyURI().fragment())) {
                                element.eGet(eFeature);
                            }
                        }
                    }
                    --i;
                }
            }
            ArrayList loadedElements = elements;
            elements = new ArrayList(this.getGuidToMethodElementMap().values());
            elements.removeAll(loadedElements);
        }
    }

    public boolean hasUnresolvedProxy() {
        return this.markerMananger.hasUnresolvedProxy();
    }

    protected Map getURIToTempURIMap() {
        if (this.URIToTempURIMap == null) {
            this.URIToTempURIMap = new HashMap();
        }
        return this.URIToTempURIMap;
    }

    public UnresolvedProxyMarkerManager getMarkerMananger() {
        return this.markerMananger;
    }
}

