/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.richtext;

import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Platform;
import org.eclipse.epf.common.html.HTMLFormatter;
import org.eclipse.epf.common.serviceability.Logger;
import org.eclipse.epf.common.utils.FileUtil;
import org.eclipse.epf.common.utils.XMLUtil;
import org.eclipse.epf.common.xml.XSLTProcessor;
import org.eclipse.epf.richtext.IRichText;
import org.eclipse.epf.richtext.RichTextListener;
import org.eclipse.epf.richtext.RichTextPlugin;
import org.eclipse.epf.richtext.RichTextResources;
import org.eclipse.epf.richtext.actions.CopyAction;
import org.eclipse.epf.richtext.actions.CutAction;
import org.eclipse.epf.richtext.actions.FindReplaceAction;
import org.eclipse.epf.richtext.actions.PasteAction;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.LocationAdapter;
import org.eclipse.swt.browser.LocationEvent;
import org.eclipse.swt.browser.LocationListener;
import org.eclipse.swt.browser.StatusTextEvent;
import org.eclipse.swt.browser.StatusTextListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.HelpListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.ui.PlatformUI;

public class RichText
implements IRichText {
    private static final String ENCODED_SINGLE_QUOTE = "%sq%";
    private static final String ENCODED_NEWLINE = "%EOL%";
    private static final String STATUS_PREFIX = "$$$";
    private static final int STATUS_PREFIX_LENGTH = "$$$".length();
    private static final int STATUS_INITIALIZED = 1;
    private static final int STATUS_MODIFIED = 2;
    private static final int STATUS_GET_TEXT = 3;
    private static final int STATUS_KEY_DOWN = 4;
    private static final int STATUS_KEY_UP = 5;
    private static final int STATUS_SELECT_TEXT = 6;
    private static final int STATUS_SELECT_CONTROL = 7;
    private static final int STATUS_SELECT_NONE = 8;
    private static final int STATUS_EXEC_CMD = 9;
    private static final String DEFAULT_BASE_PATH = String.valueOf(System.getProperty("user.home")) + System.getProperty("file.separator") + "rte";
    protected boolean debug;
    protected Logger logger;
    protected Browser editor;
    protected Control editorControl;
    private Menu contextMenu;
    private String rteFolder;
    private String rteURL;
    private String basePath;
    private boolean initialized;
    private boolean initializedWithFocus;
    private String initialText;
    private String currentText;
    private boolean editable;
    private boolean modified;
    private boolean selection;
    protected String selectedText;
    private int status;
    private HTMLFormatter htmlFormatter;
    private Map listeners;
    private List modifyListeners;
    private boolean notifyingModifyListeners;
    private boolean hasFocus;

    public RichText(Composite parent, int style, String basePath) {
        block3: {
            this.currentText = "";
            this.editable = true;
            this.selectedText = "";
            this.status = 0;
            this.notifyingModifyListeners = false;
            this.hasFocus = false;
            this.debug = RichTextPlugin.getDefault().isDebugging();
            this.logger = RichTextPlugin.getDefault().getLogger();
            this.rteFolder = String.valueOf(RichTextPlugin.getDefault().getInstallPath()) + "rte/";
            this.rteURL = XMLUtil.escape((String)("file://" + this.rteFolder));
            this.setBasePath(basePath);
            try {
                this.editor = new Browser(parent, 0);
                if (this.debug) {
                    this.printDebugMessage("RichText", "basePath=" + basePath);
                }
                this.editor.setLayoutData((Object)new GridData(1808));
                this.editor.setData("richText", (Object)this);
                this.init(parent, style);
            }
            catch (Exception e) {
                this.editor = null;
                String msg = "Failed to create RichText with basePath=" + basePath;
                this.logger.logError(msg, (Throwable)e);
                if (!this.debug) break block3;
                System.out.println(msg);
                e.printStackTrace();
            }
        }
    }

    public RichText(Composite parent, int style) {
        this(parent, style, null);
    }

    protected void setBasePath(String path) {
        this.basePath = path != null && path.length() > 0 ? (path.startsWith("\\\\") ? "\\\\" + FileUtil.appendSeparator((String)path.substring(FileUtil.UNC_PATH_PREFIX_LENGTH).replace('\\', '/'), (String)"/") : FileUtil.appendSeparator((String)path).replace('\\', '/')) : FileUtil.appendSeparator((String)DEFAULT_BASE_PATH).replace('\\', '/');
    }

    protected void init(Composite parent, int style) throws Exception {
        try {
            this.addStatusTextListener();
            if (this.debug) {
                this.printDebugMessage("init", "added status text listener");
            }
            String editorHTML = this.generateEditorHTML();
            if (this.debug) {
                this.printDebugMessage("init", "generated editor HTML");
            }
            this.editor.setText(editorHTML);
            if (this.debug) {
                this.printDebugMessage("init", "loaded editor HTML");
            }
            this.contextMenu = new Menu((Decorations)parent.getShell(), 8);
            this.editor.setMenu(this.contextMenu);
            this.fillContextMenu(this.contextMenu);
            if (this.debug) {
                this.printDebugMessage("init", "added context menu");
            }
            this.addListeners();
            if (this.debug) {
                this.printDebugMessage("init", "added listeners");
            }
            this.htmlFormatter = new HTMLFormatter();
            if (this.debug) {
                this.printDebugMessage("init", "instantiated HTMLFormatter");
            }
        }
        catch (Exception e) {
            this.editor = null;
            this.dispose();
            throw e;
        }
    }

    public Control getControl() {
        return this.editor;
    }

    public void setLayoutData(Object layoutData) {
        if (this.editor != null) {
            this.editor.setLayoutData(layoutData);
        }
    }

    public Object getLayoutData() {
        if (this.editor != null) {
            return this.editor.getLayoutData();
        }
        return null;
    }

    public void setFocus() {
        if (this.debug) {
            this.printDebugMessage("setFocus");
        }
        if (this.editor != null) {
            if (this.initialized) {
                if (!Platform.getOS().equals("win32")) {
                    this.editor.setFocus();
                }
                this.executeCommand("setFocus");
                this.hasFocus = true;
            } else {
                this.initializedWithFocus = true;
            }
        }
    }

    public boolean hasFocus() {
        if (this.editor != null) {
            return this.hasFocus;
        }
        return false;
    }

    public String getBasePath() {
        return this.basePath;
    }

    public boolean getEditable() {
        return this.editable;
    }

    public void setEditable(boolean editable) {
        this.editable = editable;
        if (this.initialized) {
            this.executeCommand("setEditable", "" + editable);
        }
    }

    public boolean getModified() {
        return this.modified;
    }

    public void setModified(boolean modified) {
        this.modified = modified;
    }

    public String getText() {
        if (this.editor != null) {
            try {
                this.executeCommand("getText");
                if (this.currentText != null && this.currentText.length() > 0) {
                    this.currentText = this.currentText.replaceAll("<P>&nbsp;</P>", "<br/>");
                    try {
                        this.currentText = this.htmlFormatter.formatHTML(this.currentText);
                    }
                    catch (Exception e) {
                        this.logger.logError((Throwable)e);
                    }
                    this.currentText = this.tidyText(this.currentText);
                } else {
                    this.currentText = "";
                }
                if (this.debug) {
                    this.printDebugMessage("getText", "text=", this.currentText);
                }
                return this.currentText;
            }
            catch (Exception e) {
                this.logger.logError((Throwable)e);
            }
        }
        return "";
    }

    public void setText(String text) {
        if (this.editor != null) {
            String newText;
            if (this.debug) {
                this.printDebugMessage("setText", "text=", text);
            }
            if ((newText = text) != null && newText.length() > 0) {
                try {
                    newText = this.htmlFormatter.formatHTML(newText);
                }
                catch (Exception e) {
                    this.logger.logError((Throwable)e);
                }
                newText = this.tidyText(newText);
            } else {
                newText = "";
            }
            this.modified = !newText.equals(this.currentText);
            this.initialText = newText;
            if (this.debug) {
                this.printDebugMessage("setText", "modified=" + this.modified + ", newText=", newText);
            }
            if (this.initialized) {
                try {
                    this.executeCommand("setText", newText);
                }
                catch (Exception e) {
                    this.logger.logError((Throwable)e);
                }
            }
            this.currentText = newText;
        }
    }

    public void restoreText() {
        this.setText(this.initialText);
    }

    public String getSelectedText() {
        this.executeCommand("getSelectedText");
        return this.selectedText;
    }

    public Object getData(String key) {
        if (this.editor != null) {
            this.editor.getData(key);
        }
        return null;
    }

    public void setData(String key, Object value) {
        if (this.editor != null) {
            this.editor.setData(key, value);
        }
    }

    protected int execute(String script) {
        block4: {
            this.status = 0;
            if (this.editor != null && script != null && script.length() > 0) {
                try {
                    this.editor.execute(script);
                    if (this.debug) {
                        this.printDebugMessage("execute", script);
                    }
                }
                catch (Exception e) {
                    String msg = "Failed to execute " + script;
                    this.logger.logError(msg, (Throwable)e);
                    if (!this.debug) break block4;
                    this.printDebugMessage("execute", msg);
                    e.printStackTrace();
                }
            }
        }
        return this.status;
    }

    public int executeCommand(String command) {
        this.status = 0;
        if (command != null && command.equals("clearContent")) {
            String oldInitialText = this.initialText;
            this.setText("");
            this.initialText = oldInitialText;
            this.status = 1;
            this.modified = true;
            this.notifyModifyListeners();
        } else {
            this.status = this.execute(String.valueOf(command) + "();");
        }
        return this.status;
    }

    public int executeCommand(String command, String param) {
        if (param == null) {
            return this.executeCommand(command);
        }
        return this.execute(String.valueOf(command) + "('" + this.formatText(param) + "');");
    }

    public int executeCommand(String command, String[] params) {
        if (params == null || params.length == 0) {
            return this.executeCommand(command);
        }
        StringBuffer sb = new StringBuffer();
        int paramsLength = params.length;
        int i = 0;
        while (i < paramsLength) {
            sb.append('\'').append(this.formatText(params[i])).append('\'');
            if (i < paramsLength - 1) {
                sb.append(',');
            }
            ++i;
        }
        String param = sb.toString();
        return this.execute(String.valueOf(command) + "(" + param + ");");
    }

    public void dispose() {
        if (this.contextMenu != null && !this.contextMenu.isDisposed()) {
            this.contextMenu.dispose();
            this.contextMenu = null;
        }
        if (this.listeners != null) {
            this.listeners.clear();
            this.listeners = null;
        }
        if (this.modifyListeners != null) {
            this.modifyListeners.clear();
            this.modifyListeners = null;
        }
        if (this.htmlFormatter != null) {
            this.htmlFormatter = null;
        }
    }

    public boolean isDisposed() {
        return this.editor.isDisposed();
    }

    public Iterator getModifyListeners() {
        return this.modifyListeners.iterator();
    }

    public void addKeyListener(KeyListener listener) {
        if (this.editor != null) {
            this.editor.addKeyListener(listener);
        }
    }

    public void removeKeyListener(KeyListener listener) {
        if (this.editor != null) {
            this.editor.removeKeyListener(listener);
        }
    }

    public void addModifyListener(ModifyListener listener) {
        if (this.editor != null && listener != null && !this.modifyListeners.contains(listener)) {
            this.modifyListeners.add(listener);
        }
    }

    public void removeModifyListener(ModifyListener listener) {
        if (this.editor != null && listener != null && this.modifyListeners.contains(listener)) {
            this.modifyListeners.remove(listener);
        }
    }

    public void addDisposeListener(DisposeListener listener) {
        if (this.editor != null) {
            this.editor.addDisposeListener(listener);
        }
    }

    public void removeDisposeListener(DisposeListener listener) {
        if (this.editor != null) {
            this.editor.removeDisposeListener(listener);
        }
    }

    public void addHelpListener(HelpListener listener) {
        if (this.editor != null) {
            this.editor.addHelpListener(listener);
        }
    }

    public void removeHelpListener(HelpListener listener) {
        if (this.editor != null) {
            this.editor.removeHelpListener(listener);
        }
    }

    public void addListener(int eventType, Listener listener) {
        if (this.editor != null && !this.listeners.containsKey(listener)) {
            if (this.editorControl == null || eventType != 26 && eventType != 27 && eventType != 15 && eventType != 16) {
                this.editor.addListener(eventType, listener);
            }
            this.listeners.put(listener, new RichTextListener(eventType, listener));
        }
    }

    public void removeListener(int eventType, Listener listener) {
        if (this.editor != null && this.listeners.containsKey(listener)) {
            if (this.editorControl == null || eventType != 26 && eventType != 27 && eventType != 15 && eventType != 16) {
                this.editor.removeListener(eventType, listener);
            }
            this.listeners.remove(listener);
        }
    }

    public Iterator getListeners() {
        return this.listeners.values().iterator();
    }

    protected void addStatusTextListener() {
        this.editor.addStatusTextListener(new StatusTextListener(){

            public void changed(StatusTextEvent event) {
                String eventText = event.text;
                int eventTextLength = eventText.length();
                if (eventText.startsWith(RichText.STATUS_PREFIX) && eventTextLength > STATUS_PREFIX_LENGTH) {
                    try {
                        int endStatusIndex = STATUS_PREFIX_LENGTH + 1;
                        if (eventText.length() > STATUS_PREFIX_LENGTH + 1 && Character.isDigit(eventText.charAt(endStatusIndex))) {
                            ++endStatusIndex;
                        }
                        int statusType = Integer.parseInt(eventText.substring(STATUS_PREFIX_LENGTH, endStatusIndex));
                        switch (statusType) {
                            case 1: {
                                if (!RichText.this.initialized) {
                                    RichText.this.initialized = true;
                                    if (RichText.this.debug) {
                                        RichText.this.printDebugMessage("statusTextListener", "STATUS_INITIALIZED");
                                    }
                                    if (!Platform.getOS().equals("win32")) {
                                        RichText.this.executeCommand("setHeight", "" + RichText.this.editor.getBounds().height);
                                    }
                                    RichText.this.executeCommand("setText", RichText.this.currentText);
                                    if (RichText.this.initializedWithFocus) {
                                        RichText.this.setFocus();
                                    }
                                    if (!RichText.this.editable) {
                                        RichText.this.executeCommand("setEditable", "" + RichText.this.editable);
                                    }
                                }
                                break;
                            }
                            case 2: {
                                if (RichText.this.debug) {
                                    RichText.this.printDebugMessage("statusTextListener", "STATUS_MODIFIED");
                                }
                                RichText.this.checkModify();
                                break;
                            }
                            case 3: {
                                if (eventTextLength >= STATUS_PREFIX_LENGTH + 2) {
                                    RichText.this.currentText = eventText.substring(STATUS_PREFIX_LENGTH + 2);
                                } else {
                                    RichText.this.currentText = "";
                                }
                                if (RichText.this.debug) {
                                    RichText.this.printDebugMessage("statusTextListener", "STATUS_GET_TEXT, currentText=", RichText.this.currentText);
                                }
                                break;
                            }
                            case 4: {
                                if (eventTextLength >= STATUS_PREFIX_LENGTH + 2) {
                                    String cmd = eventText.substring(STATUS_PREFIX_LENGTH + 2);
                                    if (RichText.this.debug) {
                                        RichText.this.printDebugMessage("statusTextListener", "STATUS_KEY_DOWN, cmd=" + cmd);
                                    }
                                    if (cmd.equals("findText")) {
                                        FindReplaceAction action = new FindReplaceAction();
                                        action.execute(RichText.this);
                                        break;
                                    }
                                    if (cmd.equals("paste")) {
                                        PasteAction action = new PasteAction();
                                        action.execute(RichText.this);
                                        break;
                                    }
                                    if (cmd.equals("save")) {
                                        PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor().doSave(null);
                                        break;
                                    }
                                    if (cmd.equals("saveAll")) {
                                        PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().saveAllEditors(false);
                                    }
                                }
                                break;
                            }
                            case 5: {
                                if (RichText.this.debug) {
                                    RichText.this.printDebugMessage("statusTextListener", "STATUS_KEY_UP, modified=" + RichText.this.modified);
                                }
                                RichText.this.checkModify();
                                break;
                            }
                            case 6: {
                                if (eventTextLength >= STATUS_PREFIX_LENGTH + 2) {
                                    RichText.this.selectedText = eventText.substring(STATUS_PREFIX_LENGTH + 2);
                                    RichText.this.selection = true;
                                } else {
                                    RichText.this.selectedText = "";
                                    RichText.this.selection = false;
                                }
                                if (RichText.this.debug) {
                                    RichText.this.printDebugMessage("statusTextListener", "STATUS_SELECT_TEXT, selectedText=", RichText.this.selectedText);
                                }
                                break;
                            }
                            case 7: {
                                RichText.this.selection = true;
                                break;
                            }
                            case 8: {
                                RichText.this.selection = false;
                                break;
                            }
                            case 9: {
                                if (eventTextLength >= STATUS_PREFIX_LENGTH + 3) {
                                    try {
                                        RichText.this.status = Integer.parseInt(eventText.substring(STATUS_PREFIX_LENGTH + 2, STATUS_PREFIX_LENGTH + 3));
                                    }
                                    catch (Exception exception) {
                                        RichText.this.status = -1;
                                    }
                                }
                                if (!RichText.this.debug || RichText.this.status == 1) break;
                                RichText.this.printDebugMessage("statusTextListener", "STATUS_EXEC_CMD, status=" + RichText.this.status);
                            }
                            default: {
                                break;
                            }
                        }
                    }
                    catch (Exception exception) {}
                }
            }
        });
    }

    protected String generateEditorHTML() throws Exception {
        String escapedBasePath = this.basePath;
        if (escapedBasePath.startsWith("\\\\")) {
            escapedBasePath = escapedBasePath.replaceFirst("^\\\\\\\\", "\\\\\\\\\\\\\\\\");
        }
        escapedBasePath = XMLUtil.escape((String)("file://" + escapedBasePath.replaceAll("'", "\\\\'")));
        String escapedRteUTL = this.rteURL.replaceAll("&apos;", "%27");
        StringBuffer rteXML = new StringBuffer();
        rteXML.append("<rte id=\"").append("rte").append("\" css=\"").append(String.valueOf(escapedRteUTL) + "rte.css").append("\" js=\"").append(String.valueOf(escapedRteUTL) + "rte.js").append("\" baseURL=\"").append(escapedBasePath).append("\"/>");
        StringWriter result = new StringWriter();
        XSLTProcessor.transform((String)(String.valueOf(this.rteFolder) + "rte.xsl"), (String)rteXML.toString(), (Writer)result);
        return result.toString();
    }

    protected void fillContextMenu(Menu contextMenu) {
        final MenuItem cutItem = new MenuItem(contextMenu, 8);
        cutItem.setText(RichTextResources.cutAction_text);
        cutItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                CutAction action = new CutAction();
                action.execute(RichText.this);
            }
        });
        final MenuItem copyItem = new MenuItem(contextMenu, 8);
        copyItem.setText(RichTextResources.copyAction_text);
        copyItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                CopyAction action = new CopyAction();
                action.execute(RichText.this);
            }
        });
        final MenuItem pasteItem = new MenuItem(contextMenu, 8);
        pasteItem.setText(RichTextResources.pasteAction_text);
        pasteItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                PasteAction action = new PasteAction();
                action.execute(RichText.this);
            }
        });
        contextMenu.addMenuListener(new MenuListener(){

            public void menuHidden(MenuEvent e) {
            }

            public void menuShown(MenuEvent e) {
                RichText.this.getSelectedText();
                cutItem.setEnabled(RichText.this.editable && RichText.this.selection);
                copyItem.setEnabled(RichText.this.selection);
                pasteItem.setEnabled(RichText.this.editable);
            }
        });
    }

    protected void addListeners() {
        this.editorControl = this.getControlSite((Composite)this.editor);
        if (this.editorControl != null) {
            if (this.debug) {
                this.printDebugMessage("init", "editorControl=" + this.editorControl.getClass().getName());
            }
            this.editorControl.addListener(26, new Listener(){

                public void handleEvent(Event event) {
                    if (RichText.this.debug) {
                        RichText.this.printDebugMessage("activateListener");
                    }
                    RichText.this.notifyListeners(26, event);
                }
            });
            this.editorControl.addListener(27, new Listener(){

                public void handleEvent(Event event) {
                    if (RichText.this.debug) {
                        RichText.this.printDebugMessage("deactivateListener");
                    }
                    RichText.this.notifyListeners(27, event);
                }
            });
            this.editorControl.addListener(15, new Listener(){

                public void handleEvent(Event event) {
                    if (RichText.this.debug) {
                        RichText.this.printDebugMessage("focusInListener");
                    }
                    RichText.this.executeCommand("updateSelection");
                    RichText.this.notifyListeners(15, event);
                }
            });
            this.editorControl.addListener(16, new Listener(){

                public void handleEvent(Event event) {
                    if (RichText.this.debug) {
                        RichText.this.printDebugMessage("focusOutListener");
                    }
                    RichText.this.notifyListeners(16, event);
                }
            });
            this.editor.addKeyListener((KeyListener)new KeyAdapter(){

                public void keyReleased(KeyEvent e) {
                    if ((e.stateMask & 0x40000) > 0 || (e.stateMask & 0x10000) > 0) {
                        return;
                    }
                    if (RichText.this.editable) {
                        switch (e.keyCode) {
                            case 131072: 
                            case 0x1000001: 
                            case 0x1000002: 
                            case 0x1000003: 
                            case 0x1000004: 
                            case 0x1000005: 
                            case 0x1000006: 
                            case 0x1000007: 
                            case 0x1000008: {
                                break;
                            }
                            default: {
                                RichText.this.checkModify();
                            }
                        }
                    }
                }
            });
            this.editor.addLocationListener((LocationListener)new LocationAdapter(){

                public void changing(LocationEvent event) {
                    event.doit = RichText.this.editable;
                }
            });
        } else {
            this.editor.addKeyListener(new KeyListener(){

                public void keyPressed(KeyEvent e) {
                    if (!RichText.this.hasFocus) {
                        RichText.this.editor.setFocus();
                    }
                    if (!RichText.this.editable) {
                        e.doit = false;
                    }
                }

                public void keyReleased(KeyEvent e) {
                    if (RichText.this.editable) {
                        RichText.this.checkModify();
                    }
                }
            });
        }
        this.editor.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (RichText.this.debug) {
                    RichText.this.printDebugMessage("disposeListener");
                }
                RichText.this.dispose();
            }
        });
        this.listeners = new Hashtable();
        this.modifyListeners = new ArrayList();
    }

    protected void notifyListeners(int eventType, Event event) {
        if (this.notifyingModifyListeners) {
            return;
        }
        event.display = Display.getCurrent();
        event.widget = this.editor;
        Iterator i = this.listeners.values().iterator();
        while (i.hasNext()) {
            RichTextListener listener = (RichTextListener)i.next();
            if (listener.getEventType() != eventType) continue;
            if (this.debug) {
                this.printDebugMessage("notifyListeners", "notifying listener, " + listener + ", eventType=" + eventType);
            }
            listener.getListener().handleEvent(event);
            if (!this.debug) continue;
            this.printDebugMessage("notifyListeners", "notified listener, " + listener + ", eventType=" + eventType);
        }
    }

    public void notifyModifyListeners() {
        this.notifyingModifyListeners = true;
        Event event = new Event();
        event.display = Display.getCurrent();
        event.widget = this.editor;
        Iterator i = this.modifyListeners.iterator();
        while (i.hasNext()) {
            ModifyListener listener = (ModifyListener)i.next();
            if (this.debug) {
                this.printDebugMessage("notifyModifyListeners", "notifying listener, " + listener);
            }
            listener.modifyText(new ModifyEvent(event));
            if (!this.debug) continue;
            this.printDebugMessage("notifyModifyListeners", "notified listener, " + listener);
        }
        this.notifyingModifyListeners = false;
    }

    protected void checkModify() {
        if (this.modified) {
            this.notifyModifyListeners();
        } else if (!this.getText().equals(this.initialText)) {
            this.modified = true;
            this.notifyModifyListeners();
        }
        if (this.debug) {
            this.printDebugMessage("checkModify", "modified=" + this.modified);
        }
    }

    protected String tidyText(String text) {
        return text;
    }

    protected String formatText(String text) {
        if (text == null || text.length() == 0) {
            return text;
        }
        StringBuffer result = new StringBuffer();
        int textSize = text.length();
        int i = 0;
        while (i < textSize) {
            char ch = text.charAt(i);
            switch (ch) {
                case '\r': {
                    break;
                }
                case '\t': {
                    result.append(' ');
                    break;
                }
                case '\n': {
                    result.append(ENCODED_NEWLINE);
                    break;
                }
                case '\'': {
                    result.append(ENCODED_SINGLE_QUOTE);
                    break;
                }
                case '\\': {
                    result.append("\\\\");
                    break;
                }
                default: {
                    result.append(ch);
                }
            }
            ++i;
        }
        return result.toString();
    }

    private Control getControlSite(Composite composite) {
        if (Platform.getOS().equals("win32")) {
            Control[] controls = composite.getChildren();
            int i = 0;
            while (i < controls.length) {
                String controlClass = controls[i].getClass().getName();
                if (controlClass.equals("org.eclipse.swt.browser.WebSite")) {
                    return controls[i];
                }
                if (controls[i] instanceof Composite) {
                    return this.getControlSite((Composite)controls[i]);
                }
                ++i;
            }
        }
        return null;
    }

    private void printDebugMessage(String method, String msg, String text) {
        StringBuffer strBuf = new StringBuffer();
        strBuf.append("RichText[").append(this.editor.handle).append(']').append('.').append(method);
        if (msg != null && msg.length() > 0) {
            strBuf.append(": ").append(msg);
        }
        if (text != null && text.length() > 0) {
            strBuf.append('\n').append(text);
        }
        System.out.println(strBuf);
    }

    private void printDebugMessage(String method, String msg) {
        this.printDebugMessage(method, msg, null);
    }

    private void printDebugMessage(String method) {
        this.printDebugMessage(method, null);
    }
}

