/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.richtext;

import java.util.Iterator;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.epf.common.serviceability.Logger;
import org.eclipse.epf.richtext.IRichText;
import org.eclipse.epf.richtext.IRichTextEditor;
import org.eclipse.epf.richtext.IRichTextToolBar;
import org.eclipse.epf.richtext.RichText;
import org.eclipse.epf.richtext.RichTextPlugin;
import org.eclipse.epf.richtext.RichTextResources;
import org.eclipse.epf.richtext.RichTextToolBar;
import org.eclipse.epf.richtext.actions.CopyAction;
import org.eclipse.epf.richtext.actions.CutAction;
import org.eclipse.epf.richtext.actions.FindReplaceAction;
import org.eclipse.epf.richtext.actions.PasteAction;
import org.eclipse.jface.bindings.Binding;
import org.eclipse.jface.bindings.TriggerSequence;
import org.eclipse.jface.bindings.keys.KeySequence;
import org.eclipse.jface.bindings.keys.KeyStroke;
import org.eclipse.jface.bindings.keys.SWTKeySupport;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.custom.ViewForm;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.HelpListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.keys.IBindingService;

public class RichTextEditor
implements IRichTextEditor {
    protected static final String HTML_TAB_NAME = RichTextResources.htmlTab_text;
    protected boolean debug;
    protected Logger logger;
    protected String basePath;
    protected ViewForm form;
    protected IRichTextToolBar toolBar;
    protected Composite content;
    protected CTabFolder tabFolder;
    protected CTabItem richTextTab;
    protected CTabItem htmlTab;
    protected IRichText richText;
    protected StyledText sourceEdit;
    protected Menu contextMenu;
    protected boolean sourceModified = false;
    protected boolean editable = true;
    protected ModifyListener sourceEditModifyListener = new ModifyListener(){

        public void modifyText(ModifyEvent e) {
            RichTextEditor.this.sourceModified = true;
            if (RichTextEditor.this.richText != null && RichTextEditor.this.richText instanceof RichText) {
                ((RichText)RichTextEditor.this.richText).notifyModifyListeners();
            }
        }
    };
    protected Listener sourceEditDeactivateListener = new Listener(){

        public void handleEvent(Event event) {
            if (RichTextEditor.this.sourceModified) {
                RichTextEditor.this.setText(RichTextEditor.this.sourceEdit.getText());
                RichTextEditor.this.setModified(true);
                RichTextEditor.this.sourceModified = false;
            }
        }
    };
    protected KeyListener sourceEditKeyListener = new KeyListener(){

        public void keyPressed(KeyEvent e) {
            String cmdId;
            ParameterizedCommand command;
            int accel;
            KeyStroke stroke;
            KeySequence seq;
            Binding bind;
            Object adapter;
            IWorkbench iWorkbench = PlatformUI.getWorkbench();
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.ui.keys.IBindingService");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((adapter = iWorkbench.getAdapter((Class)clazz)) != null && adapter instanceof IBindingService && (bind = ((IBindingService)adapter).getPerfectMatch((TriggerSequence)(seq = KeySequence.getInstance((KeyStroke)(stroke = SWTKeySupport.convertAcceleratorToKeyStroke((int)(accel = SWTKeySupport.convertEventToUnmodifiedAccelerator((KeyEvent)e)))))))) != null && (command = bind.getParameterizedCommand()) != null && (cmdId = command.getId()) != null && cmdId.equals("org.eclipse.ui.edit.findReplace")) {
                FindReplaceAction action = new FindReplaceAction();
                action.execute(RichTextEditor.this);
            }
        }

        public void keyReleased(KeyEvent e) {
        }
    };
    static /* synthetic */ Class class$0;

    public RichTextEditor(Composite parent, int style) {
        this(parent, style, null);
    }

    public RichTextEditor(Composite parent, int style, String basePath) {
        this.basePath = basePath;
        this.debug = RichTextPlugin.getDefault().isDebugging();
        this.logger = RichTextPlugin.getDefault().getLogger();
        this.init(parent, style);
    }

    protected void init(Composite parent, int style) {
        try {
            this.form = new ViewForm(parent, style);
            this.form.marginHeight = 0;
            this.form.marginWidth = 0;
            this.toolBar = new RichTextToolBar((Composite)this.form, 0x800000, this);
            this.fillToolBar(this.toolBar);
            this.content = new Composite((Composite)this.form, 0x800000);
            GridLayout layout = new GridLayout();
            layout.marginHeight = 0;
            layout.marginWidth = 0;
            this.content.setLayout((Layout)layout);
            this.tabFolder = this.createEditorTabFolder(this.content, style);
            this.form.setTopLeft((Control)this.toolBar);
            this.form.setContent((Control)this.content);
        }
        catch (Exception e) {
            this.logger.logError((Throwable)e);
        }
    }

    public Control getControl() {
        return this.form;
    }

    public IRichText getRichTextControl() {
        return this.richText;
    }

    public void setLayoutData(Object layoutData) {
        if (this.form != null) {
            this.form.setLayoutData(layoutData);
        }
    }

    public Object getLayoutData() {
        if (this.form != null) {
            return this.form.getLayoutData();
        }
        return null;
    }

    public void setFocus() {
        if (this.richText != null) {
            this.richText.setFocus();
        }
        this.setSelection(0);
    }

    public boolean hasFocus() {
        if (this.richText != null) {
            return this.richText.hasFocus();
        }
        return false;
    }

    public void setSelection(int index) {
        if (this.tabFolder != null) {
            this.tabFolder.setSelection(index);
        }
    }

    public String getBasePath() {
        return this.basePath;
    }

    public boolean getEditable() {
        return this.editable;
    }

    public void setEditable(boolean editable) {
        this.editable = editable;
        if (this.toolBar != null && this.tabFolder != null && this.tabFolder.getSelection() == this.richTextTab) {
            this.toolBar.updateToolBar(editable);
        }
        if (this.richText != null) {
            this.richText.setEditable(editable);
        }
        if (this.sourceEdit != null) {
            this.sourceEdit.setEditable(editable);
            this.sourceEdit.getEditable();
        }
    }

    public boolean getModified() {
        if (this.richText != null) {
            return this.richText.getModified();
        }
        return false;
    }

    public void setModified(boolean modified) {
        if (this.richText != null) {
            this.richText.setModified(modified);
        }
    }

    public String getText() {
        if (this.sourceModified) {
            this.setText(this.sourceEdit.getText());
            this.setModified(true);
            this.sourceModified = false;
        }
        if (this.richText != null) {
            return this.richText.getText();
        }
        return "";
    }

    public void setText(String text) {
        if (this.richText != null) {
            this.richText.setText(text);
        }
        this.sourceModified = false;
        if (this.tabFolder != null && this.toolBar != null) {
            this.toolBar.updateToolBar(this.editable);
        }
    }

    public void restoreText() {
        if (this.richText != null) {
            this.richText.restoreText();
        }
    }

    public String getSelectedText() {
        if (this.tabFolder.getSelection() == this.richTextTab) {
            return this.richText.getSelectedText();
        }
        if (this.tabFolder.getSelection() == this.htmlTab) {
            String HTMLsource = this.sourceEdit.getText();
            Point sel = this.sourceEdit.getSelectionRange();
            int selStartIndex = sel.x;
            int selEndIndex = sel.x + sel.y - 1;
            return HTMLsource.substring(selStartIndex, selEndIndex + 1);
        }
        return "";
    }

    public Object getData(String key) {
        if (this.richText != null) {
            this.richText.getData(key);
        }
        return null;
    }

    public void setData(String key, Object value) {
        if (this.richText != null) {
            this.richText.setData(key, value);
        }
    }

    public int executeCommand(String command) {
        if (this.richText != null) {
            return this.richText.executeCommand(command);
        }
        return 0;
    }

    public int executeCommand(String command, String param) {
        if (this.richText != null) {
            return this.richText.executeCommand(command, param);
        }
        return 0;
    }

    public int executeCommand(String command, String[] params) {
        if (this.richText != null) {
            return this.richText.executeCommand(command, params);
        }
        return 0;
    }

    public void dispose() {
        if (this.contextMenu != null && !this.contextMenu.isDisposed()) {
            this.contextMenu.dispose();
            this.contextMenu = null;
        }
        if (this.sourceEdit != null) {
            this.sourceEdit.removeModifyListener(this.sourceEditModifyListener);
            this.sourceEdit.removeListener(27, this.sourceEditDeactivateListener);
            this.sourceEdit.removeKeyListener(this.sourceEditKeyListener);
            this.sourceEditModifyListener = null;
            this.sourceEditDeactivateListener = null;
            this.sourceEditKeyListener = null;
        }
        if (this.richText != null) {
            this.richText.dispose();
            this.richText = null;
        }
    }

    public boolean isDisposed() {
        if (this.richText != null) {
            return this.richText.isDisposed();
        }
        return true;
    }

    public Iterator getModifyListeners() {
        if (this.richText != null) {
            this.richText.getModifyListeners();
        }
        return null;
    }

    public void addKeyListener(KeyListener listener) {
        if (this.richText != null) {
            this.richText.addKeyListener(listener);
        }
    }

    public void removeKeyListener(KeyListener listener) {
        if (this.richText != null) {
            this.richText.removeKeyListener(listener);
        }
    }

    public void addModifyListener(ModifyListener listener) {
        if (this.richText != null) {
            this.richText.addModifyListener(listener);
        }
    }

    public void removeModifyListener(ModifyListener listener) {
        if (this.richText != null) {
            this.richText.removeModifyListener(listener);
        }
    }

    public void addDisposeListener(DisposeListener listener) {
        if (this.richText != null) {
            this.richText.addDisposeListener(listener);
        }
    }

    public void removeDisposeListener(DisposeListener listener) {
        if (this.richText != null) {
            this.richText.removeDisposeListener(listener);
        }
    }

    public void addHelpListener(HelpListener listener) {
        if (this.richText != null) {
            this.richText.addHelpListener(listener);
        }
    }

    public void removeHelpListener(HelpListener listener) {
        if (this.richText != null) {
            this.richText.removeHelpListener(listener);
        }
    }

    public void addListener(int eventType, Listener listener) {
        if (this.richText != null) {
            this.richText.addListener(eventType, listener);
        }
    }

    public void removeListener(int eventType, Listener listener) {
        if (this.richText != null) {
            this.richText.removeListener(eventType, listener);
        }
    }

    public Iterator getListeners() {
        if (this.richText != null) {
            return this.richText.getListeners();
        }
        return null;
    }

    protected void notifyModifyListeners() {
        if (this.richText != null) {
            Event event = new Event();
            event.display = Display.getCurrent();
            event.widget = this.richText.getControl();
            Iterator i = this.getModifyListeners();
            while (i != null && i.hasNext()) {
                ModifyListener listener = (ModifyListener)i.next();
                listener.modifyText(new ModifyEvent(event));
            }
        }
    }

    public void fillToolBar(IRichTextToolBar toolBar) {
    }

    protected IRichText createRichTextControl(Composite parent, int style, String basePath) {
        return new RichText(parent, style, basePath);
    }

    protected CTabFolder createEditorTabFolder(Composite parent, int style) {
        CTabFolder folder = new CTabFolder(parent, 0x800400);
        folder.setLayout((Layout)new GridLayout(1, true));
        folder.setLayoutData((Object)new GridData(1808));
        Composite richTextComposite = new Composite((Composite)folder, 0x800000);
        GridLayout richTextCompositeLayout = new GridLayout(1, false);
        richTextCompositeLayout.marginHeight = 0;
        richTextCompositeLayout.marginWidth = 0;
        richTextComposite.setLayout((Layout)richTextCompositeLayout);
        richTextComposite.setLayoutData((Object)new GridData(1808));
        this.richText = this.createRichTextControl(richTextComposite, style, this.basePath);
        this.richText.setData("richText", this);
        this.richTextTab = new CTabItem(folder, 0x800000);
        this.richTextTab.setText(RichTextResources.richTextTab_text);
        this.richTextTab.setToolTipText(RichTextResources.richTextTab_toolTipText);
        this.richTextTab.setControl((Control)richTextComposite);
        Composite htmlComposite = new Composite((Composite)folder, 0x800000);
        htmlComposite.setLayout((Layout)new FillLayout());
        this.sourceEdit = new StyledText(htmlComposite, 8389186);
        this.sourceEdit.addModifyListener(this.sourceEditModifyListener);
        this.sourceEdit.addListener(27, this.sourceEditDeactivateListener);
        this.sourceEdit.addKeyListener(this.sourceEditKeyListener);
        this.contextMenu = new Menu((Decorations)parent.getShell(), 8);
        this.sourceEdit.setMenu(this.contextMenu);
        this.fillContextMenu(this.contextMenu);
        this.htmlTab = new CTabItem(folder, 0);
        this.htmlTab.setText(HTML_TAB_NAME);
        this.htmlTab.setToolTipText(RichTextResources.htmlTab_toolTipText);
        this.htmlTab.setControl((Control)htmlComposite);
        folder.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                CTabItem item = (CTabItem)event.item;
                if (item.getText().equals(HTML_TAB_NAME)) {
                    RichTextEditor.this.sourceEdit.removeModifyListener(RichTextEditor.this.sourceEditModifyListener);
                    RichTextEditor.this.sourceEdit.setText(RichTextEditor.this.getText());
                    RichTextEditor.this.sourceModified = false;
                    RichTextEditor.this.sourceEdit.addModifyListener(RichTextEditor.this.sourceEditModifyListener);
                    if (RichTextEditor.this.toolBar != null) {
                        RichTextEditor.this.toolBar.updateToolBar(RichTextEditor.this.editable);
                    }
                } else {
                    RichTextEditor.this.setText(RichTextEditor.this.sourceEdit.getText());
                    RichTextEditor.this.setModified(true);
                    if (RichTextEditor.this.toolBar != null) {
                        RichTextEditor.this.toolBar.updateToolBar(RichTextEditor.this.editable);
                    }
                }
            }
        });
        folder.setSelection(0);
        return folder;
    }

    public StyledText getSourceEdit() {
        return this.sourceEdit;
    }

    public void addHTML(String text) {
        if (this.tabFolder.getSelection() == this.richTextTab) {
            this.executeCommand("addHTML", text);
        } else if (this.tabFolder.getSelection() == this.htmlTab) {
            String oldHTML = this.sourceEdit.getText();
            Point sel = this.sourceEdit.getSelectionRange();
            int selStartIndex = sel.x;
            int selEndIndex = sel.x + sel.y - 1;
            String newHTML = String.valueOf(oldHTML.substring(0, selStartIndex)) + text + oldHTML.substring(selEndIndex + 1);
            this.setText(newHTML);
        }
    }

    public boolean isHTMLTabSelected() {
        return this.tabFolder.getSelection() == this.htmlTab;
    }

    protected void fillContextMenu(Menu contextMenu) {
        final MenuItem cutItem = new MenuItem(contextMenu, 8);
        cutItem.setText(RichTextResources.cutAction_text);
        cutItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                CutAction action = new CutAction();
                action.execute(RichTextEditor.this);
            }
        });
        final MenuItem copyItem = new MenuItem(contextMenu, 8);
        copyItem.setText(RichTextResources.copyAction_text);
        copyItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                CopyAction action = new CopyAction();
                action.execute(RichTextEditor.this);
            }
        });
        final MenuItem pasteItem = new MenuItem(contextMenu, 8);
        pasteItem.setText(RichTextResources.pasteAction_text);
        pasteItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                PasteAction action = new PasteAction();
                action.execute(RichTextEditor.this);
            }
        });
        contextMenu.addMenuListener(new MenuListener(){

            public void menuHidden(MenuEvent e) {
            }

            public void menuShown(MenuEvent e) {
                String selectedText = RichTextEditor.this.getSelectedText();
                boolean selection = selectedText.length() > 0;
                cutItem.setEnabled(RichTextEditor.this.editable && selection);
                copyItem.setEnabled(selection);
                pasteItem.setEnabled(RichTextEditor.this.editable);
            }
        });
    }
}

