/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.ui.actions;

import java.util.Collection;
import java.util.Iterator;
import org.eclipse.epf.library.ILibraryManager;
import org.eclipse.epf.library.ILibraryServiceListener;
import org.eclipse.epf.library.LibraryPlugin;
import org.eclipse.epf.library.LibraryService;
import org.eclipse.epf.library.LibraryServiceUtil;
import org.eclipse.epf.library.events.ILibraryChangeListener;
import org.eclipse.epf.library.services.SafeUpdateController;
import org.eclipse.epf.library.ui.LibraryUIResources;
import org.eclipse.epf.library.util.LibraryUtil;
import org.eclipse.epf.uma.MethodConfiguration;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.MethodLibrary;
import org.eclipse.jface.action.ContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.CoolBar;
import org.eclipse.swt.widgets.CoolItem;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;

public class ConfigurationContributionItem
extends ContributionItem
implements SelectionListener,
FocusListener {
    protected Combo addressBox;
    protected ToolItem item;
    protected CoolItem coolItem;
    public static final String CONTRIBUTION_ID;
    private static final String SELECT_CONFIGURATION;
    private static Combo configCombo;
    private static boolean needUpdate;
    private static boolean needCleanList;
    private static boolean needSpecialUpdare;
    private static String currentSelectconfig;
    private ILibraryChangeListener libListener;
    private ILibraryServiceListener libSvcListener;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.epf.library.ui.actions.ConfigurationContributionItem");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        CONTRIBUTION_ID = clazz.getName();
        SELECT_CONFIGURATION = LibraryUIResources.selectConfigLabel_text;
        needUpdate = false;
        needCleanList = false;
        needSpecialUpdare = false;
    }

    public ConfigurationContributionItem(IAction action) {
    }

    public void fill(ToolBar parent, int index) {
        this.item = new ToolItem(parent, 2);
        Control box = this.createControl((Composite)parent);
        this.item.setControl(box);
        this.item.setWidth(240);
    }

    public void fill(CoolBar coolBar, int index) {
        Control box = this.createControl((Composite)coolBar);
        int flags = 4;
        this.coolItem = index >= 0 ? new CoolItem(coolBar, flags, index) : new CoolItem(coolBar, flags);
        this.coolItem.setData((Object)this);
        this.coolItem.setControl(box);
        Point toolBarSize = box.computeSize(-1, -1);
        this.coolItem.setMinimumSize(toolBarSize);
        this.coolItem.setPreferredSize(toolBarSize);
        this.coolItem.setSize(toolBarSize);
    }

    public void fill(Composite parent) {
        this.createControl(parent);
    }

    private Control createControl(Composite parent) {
        configCombo = new Combo(parent, 12);
        configCombo.setVisibleItemCount(10);
        configCombo.addSelectionListener((SelectionListener)this);
        configCombo.addFocusListener((FocusListener)this);
        this.libListener = new ILibraryChangeListener(){

            public void libraryChanged(int option, Collection changedItems) {
                if ((option == 8 || option == 16) && changedItems != null) {
                    Iterator it = changedItems.iterator();
                    while (it.hasNext()) {
                        Object element = it.next();
                        if (!(element instanceof MethodConfiguration)) continue;
                        needUpdate = true;
                        ConfigurationContributionItem.updateComboList(true);
                        if (option != 16 || !((MethodConfiguration)element).getName().equals(currentSelectconfig)) break;
                        needSpecialUpdare = true;
                        break;
                    }
                }
                if (needSpecialUpdare) {
                    ConfigurationContributionItem.updateComboListSpecial();
                    needSpecialUpdare = false;
                }
            }
        };
        this.libSvcListener = new ILibraryServiceListener(){

            public void configurationSet(MethodConfiguration config) {
                System.out.println("configuration set: " + LibraryUtil.getTypeName((MethodElement)config));
                String currentConfig = config != null ? config.getName() : null;
                ConfigurationContributionItem.this.selectConfiguration(currentConfig);
            }

            public void libraryClosed(MethodLibrary library) {
                System.out.println("Library closed: " + LibraryUtil.getTypeName((MethodElement)library));
            }

            public void libraryCreated(MethodLibrary library) {
                System.out.println("Library created: " + LibraryUtil.getTypeName((MethodElement)library));
                needCleanList = true;
                needUpdate = true;
                ConfigurationContributionItem.updateComboList(false);
            }

            public void libraryOpened(MethodLibrary library) {
                System.out.println("Library opened: " + LibraryUtil.getTypeName((MethodElement)library));
                needCleanList = true;
                needUpdate = true;
                ConfigurationContributionItem.updateComboList(false);
            }

            public void libraryReopened(MethodLibrary library) {
                System.out.println("Library reopened: " + LibraryUtil.getTypeName((MethodElement)library));
                needCleanList = true;
                needUpdate = true;
                ConfigurationContributionItem.updateComboList(false);
            }

            public void librarySet(MethodLibrary library) {
                System.out.println("Library set: " + LibraryUtil.getTypeName((MethodElement)library));
            }
        };
        LibraryService.getInstance().addListener(this.libSvcListener);
        ILibraryManager manager = LibraryService.getInstance().getCurrentLibraryManager();
        if (manager != null) {
            manager.addListener(this.libListener);
        }
        String[] configNames = LibraryServiceUtil.getMethodConfigurationNames((MethodLibrary)LibraryService.getInstance().getCurrentMethodLibrary());
        int lastSessionConfigIdx = ConfigurationContributionItem.chooseSelectedIdex(configNames);
        if (configNames != null && configNames.length > 0) {
            if (lastSessionConfigIdx < 0) {
                configCombo.add(SELECT_CONFIGURATION);
            }
            int i = 0;
            while (i < configNames.length) {
                String configName = configNames[i];
                if (configName != null) {
                    configCombo.add(configName);
                }
                ++i;
            }
        } else {
            configCombo.add(SELECT_CONFIGURATION);
        }
        if (lastSessionConfigIdx < 0) {
            configCombo.select(0);
        } else {
            configCombo.select(lastSessionConfigIdx);
            currentSelectconfig = ConfigurationContributionItem.getSavedLastConfig();
            ConfigurationContributionItem.performSelectionChanged();
        }
        configCombo.setEnabled(true);
        return configCombo;
    }

    public void focusGained(FocusEvent e) {
        if (needUpdate) {
            ConfigurationContributionItem.updateComboList(true);
            needUpdate = false;
        }
    }

    public void focusLost(FocusEvent e) {
    }

    public void widgetSelected(SelectionEvent e) {
        int selectedIndex = configCombo.getSelectionIndex();
        if (selectedIndex > 0 && configCombo.getItem(0).equals(SELECT_CONFIGURATION)) {
            configCombo.remove(0);
            configCombo.select(selectedIndex - 1);
        }
        int currentIdx = configCombo.getSelectionIndex();
        currentSelectconfig = configCombo.getItem(currentIdx);
        ConfigurationContributionItem.performSelectionChanged();
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public static void refresh() {
        needCleanList = true;
        ConfigurationContributionItem.updateComboList(true);
    }

    private static void updateComboList(final boolean setCurrentConfig) {
        SafeUpdateController.syncExec((Runnable)new Runnable(){

            public void run() {
                try {
                    if (configCombo.isDisposed() || configCombo == null) {
                        return;
                    }
                    int index = configCombo.getSelectionIndex();
                    String currentSelection = "";
                    if (index >= 0) {
                        currentSelection = configCombo.getItem(index);
                    }
                    if (needCleanList) {
                        configCombo.removeAll();
                        needCleanList = false;
                    }
                    index = -1;
                    configCombo.setEnabled(true);
                    String[] configNames = LibraryServiceUtil.getMethodConfigurationNames((MethodLibrary)LibraryService.getInstance().getCurrentMethodLibrary());
                    configCombo.removeAll();
                    if (configNames != null && configNames.length > 0) {
                        int i = 0;
                        while (i < configNames.length) {
                            String configName = configNames[i];
                            if (configName != null) {
                                configCombo.add(configName);
                                if (configName.equals(currentSelection)) {
                                    index = i;
                                }
                            }
                            ++i;
                        }
                    } else {
                        index = 0;
                        configCombo.add(SELECT_CONFIGURATION);
                        configCombo.select(0);
                    }
                    if (index >= 0) {
                        configCombo.select(index);
                    }
                    if (index == -1) {
                        configCombo.add(SELECT_CONFIGURATION, 0);
                        configCombo.select(0);
                    }
                    int currentIdx = configCombo.getSelectionIndex();
                    currentSelectconfig = configCombo.getItem(currentIdx);
                    configCombo.setVisibleItemCount(10);
                    if (setCurrentConfig) {
                        ConfigurationContributionItem.performSelectionChanged();
                    } else {
                        ConfigurationContributionItem.saveSelectedConfigIntoPersistence();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }

    private static void updateComboListSpecial() {
        SafeUpdateController.syncExec((Runnable)new Runnable(){

            public void run() {
                if (needCleanList) {
                    configCombo.removeAll();
                    currentSelectconfig = null;
                }
                try {
                    if (currentSelectconfig != null) {
                        configCombo.remove(currentSelectconfig);
                    }
                    configCombo.add(SELECT_CONFIGURATION, 0);
                    configCombo.select(0);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }

    private void selectConfiguration(String cfgName) {
        if (cfgName == null || cfgName.equals(currentSelectconfig)) {
            return;
        }
        ConfigurationContributionItem.updateComboList(false);
        int currentIdx = configCombo.getSelectionIndex();
        String currentName = "";
        if (currentIdx >= 0) {
            currentName = configCombo.getItem(currentIdx);
        }
        if (!currentName.equals(cfgName)) {
            int selectIndex = -1;
            int i = 0;
            while (i < configCombo.getItemCount()) {
                if (configCombo.getItem(i).equals(cfgName)) {
                    selectIndex = i;
                    break;
                }
                ++i;
            }
            if (selectIndex > 0 && configCombo.getItem(0).equals(SELECT_CONFIGURATION)) {
                configCombo.remove(0);
                --selectIndex;
            }
            if (selectIndex != -1) {
                configCombo.select(selectIndex);
            }
            currentIdx = configCombo.getSelectionIndex();
            currentSelectconfig = configCombo.getItem(currentIdx);
            ConfigurationContributionItem.saveSelectedConfigIntoPersistence();
        }
    }

    private static void performSelectionChanged() {
        MethodConfiguration config = LibraryServiceUtil.getMethodConfiguration((MethodLibrary)LibraryService.getInstance().getCurrentMethodLibrary(), (String)currentSelectconfig);
        LibraryService.getInstance().setCurrentMethodConfiguration(config);
        ConfigurationContributionItem.saveSelectedConfigIntoPersistence();
    }

    private static int chooseSelectedIdex(String[] configNames) {
        int index = -1;
        String lastSessionConfig = ConfigurationContributionItem.getSavedLastConfig();
        if (lastSessionConfig != null) {
            int i = 0;
            while (i < configNames.length) {
                if (lastSessionConfig.equals(configNames[i])) {
                    index = i;
                    break;
                }
                ++i;
            }
        }
        return index;
    }

    private static void saveSelectedConfigIntoPersistence() {
        IPreferenceStore store = LibraryPlugin.getDefault().getPreferenceStore();
        store.setValue("org.eclipse.epf.library.pref.selected_config_in_last_session", currentSelectconfig);
        LibraryPlugin.getDefault().savePluginPreferences();
    }

    private static String getSavedLastConfig() {
        IPreferenceStore store = LibraryPlugin.getDefault().getPreferenceStore();
        return store.getString("org.eclipse.epf.library.pref.selected_config_in_last_session");
    }

    public void dispose() {
        ILibraryManager manager;
        if (this.libListener != null && (manager = LibraryService.getInstance().getCurrentLibraryManager()) != null) {
            manager.removeListener(this.libListener);
        }
        if (this.libSvcListener != null) {
            LibraryService.getInstance().removeListener(this.libSvcListener);
        }
        super.dispose();
    }
}

