/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.authoring.gef.commands;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.epf.authoring.gef.util.DiagramUIResources;
import org.eclipse.epf.authoring.ui.AuthoringUIPlugin;
import org.eclipse.epf.common.serviceability.MsgBox;
import org.eclipse.epf.diagram.model.Diagram;
import org.eclipse.epf.library.edit.ui.UserInteractionHelper;
import org.eclipse.gef.commands.Command;
import org.eclipse.swt.widgets.Shell;

public abstract class DiagramModifyCommand
extends Command {
    private EObject object;
    private boolean canUndo = true;

    public DiagramModifyCommand(String label) {
        super(label);
    }

    protected void setDiagram(Diagram diagram) {
        Object obj = diagram.getObject();
        if (obj instanceof EObject) {
            this.object = (EObject)obj;
        }
    }

    protected boolean prepareExecute() {
        IStatus status = UserInteractionHelper.checkModify((EObject)this.object, (Shell)MsgBox.getDefaultShell());
        if (status.isOK()) {
            return true;
        }
        AuthoringUIPlugin.getDefault().getMsgDialog().displayWarning(DiagramUIResources.DiagramUI_errorDialog_title, DiagramUIResources.DiagramUI_command_cannotEdit, status);
        return false;
    }

    public void execute() {
        if (this.prepareExecute()) {
            this.doExecute();
            this.canUndo = true;
        } else {
            this.canUndo = false;
        }
    }

    public boolean canUndo() {
        return this.canUndo;
    }

    protected abstract void doExecute();
}

