/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.authoring.ui.actions;

import org.eclipse.core.internal.resources.ResourceException;
import org.eclipse.epf.authoring.ui.AuthoringUIPlugin;
import org.eclipse.epf.authoring.ui.AuthoringUIResources;
import org.eclipse.epf.authoring.ui.PerspectiveListUtil;
import org.eclipse.epf.authoring.ui.UIActionDispatcher;
import org.eclipse.epf.authoring.ui.preferences.LibraryLocationData;
import org.eclipse.epf.authoring.ui.views.ViewHelper;
import org.eclipse.epf.authoring.ui.wizards.NewLibraryWizard;
import org.eclipse.epf.library.LibraryService;
import org.eclipse.epf.library.ui.LibraryUIUtil;
import org.eclipse.epf.library.ui.preferences.LibraryUIPreferences;
import org.eclipse.epf.library.xmi.XMILibraryUtil;
import org.eclipse.epf.uma.MethodLibrary;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;

public class NewLibrary {
    static IStructuredSelection selection;
    protected static boolean debug;

    public static void create() {
        debug = AuthoringUIPlugin.getDefault().isDebugging();
        LibraryLocationData llData = new LibraryLocationData();
        llData.loadFromPreferenceStore();
        String libPath = null;
        String libName = null;
        String libFileName = null;
        NewLibraryWizard wizard = new NewLibraryWizard(llData);
        wizard.init(PlatformUI.getWorkbench(), selection);
        WizardDialog dialog = new WizardDialog(Display.getCurrent().getActiveShell(), (IWizard)wizard);
        dialog.create();
        dialog.open();
        if (!llData.isOkPressed()) {
            return;
        }
        llData.saveToPreferenceStore();
        libPath = llData.getParentFolder();
        libName = llData.getLibName();
        libFileName = "library.xmi";
        if (debug) {
            System.out.println("$$$ libPath = " + libPath);
            System.out.println("$$$ libName = " + libName);
            System.out.println("$$$ libFileName = " + libFileName);
        }
        try {
            ViewHelper.closeAllEditors();
            ViewHelper.closeMessageView();
            LibraryService.getInstance().closeCurrentMethodLibrary();
            MethodLibrary library = XMILibraryUtil.createMethodLibrary((String)libName, (String)libPath);
            LibraryService.getInstance().setCurrentMethodLibrary(library);
            LibraryUIPreferences.setSavedLibraryPath((String)(String.valueOf(libPath) + System.getProperty("file.separator") + libFileName));
            LibraryUIUtil.updateShellTitle();
        }
        catch (Exception e) {
            if (e instanceof ResourceException) {
                ResourceException re = (ResourceException)e;
                if (re.getStatus() != null && re.getStatus().getCode() == 77) {
                    String title = AuthoringUIResources.AuthoringUI_errorDialog_title;
                    String error = AuthoringUIResources.AuthoringUI_errorDialog_error;
                    String message = AuthoringUIResources.bind((String)AuthoringUIResources.AuthoringUI_errorDialog_message, (Object)error);
                    AuthoringUIPlugin.getDefault().getMsgDialog().displayError(title, message);
                }
            }
            e.printStackTrace();
            String title = AuthoringUIResources.AuthoringUI_errorDialog_title;
            String message = AuthoringUIResources.bind((String)AuthoringUIResources.AuthoringUI_errorDialog_message, (Object)e.toString());
            AuthoringUIPlugin.getDefault().getMsgDialog().displayError(title, message);
        }
        if (!PerspectiveListUtil.isAuthoringPerspective()) {
            UIActionDispatcher.openAuthoringPerspective();
        }
    }
}

