/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.authoring.ui.editors;

import org.eclipse.epf.authoring.ui.AuthoringUIImages;
import org.eclipse.epf.authoring.ui.AuthoringUIResources;
import org.eclipse.epf.authoring.ui.views.ElementHTMLViewer;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.custom.ViewForm;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;

public class PreviewPage {
    private ElementHTMLViewer previewer = null;

    public PreviewPage(Composite composite) {
        ViewForm viewForm = new ViewForm(composite, -1);
        viewForm.marginHeight = 0;
        viewForm.marginWidth = 0;
        viewForm.setLayout((Layout)new GridLayout());
        viewForm.setLayoutData((Object)new GridData(1808));
        ToolBar toolbar = this.createToolbar(viewForm);
        viewForm.setTopRight((Control)toolbar);
        Control content = this.createContent(viewForm);
        viewForm.setContent(content);
    }

    private Control createContent(ViewForm parent) {
        Composite content = new Composite((Composite)parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = 0;
        content.setLayout((Layout)layout);
        GridData gridData = new GridData(1808);
        content.setLayoutData((Object)gridData);
        this.previewer = new ElementHTMLViewer(content);
        return content;
    }

    public ElementHTMLViewer getPreviewViewer() {
        return this.previewer;
    }

    private ToolBar createToolbar(ViewForm parent) {
        ToolBar toolbar = new ToolBar((Composite)parent, 0x800000);
        ToolItem backButton = new ToolItem(toolbar, 0);
        backButton.setImage(AuthoringUIImages.IMG_BACK);
        backButton.setToolTipText(AuthoringUIResources.AuthoringUI_backButton_text);
        backButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Browser browser = PreviewPage.this.previewer.getBrowser();
                if (browser != null) {
                    browser.back();
                }
            }
        });
        ToolItem forwardButton = new ToolItem(toolbar, 0);
        forwardButton.setImage(AuthoringUIImages.IMG_FORWARD);
        forwardButton.setToolTipText(AuthoringUIResources.AuthoringUI_forwardButton_text);
        forwardButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Browser browser = PreviewPage.this.previewer.getBrowser();
                if (browser != null) {
                    browser.forward();
                }
            }
        });
        ToolItem stopButton = new ToolItem(toolbar, 0);
        stopButton.setImage(AuthoringUIImages.IMG_STOP);
        stopButton.setToolTipText(AuthoringUIResources.AuthoringUI_stopButton_text);
        stopButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Browser browser = PreviewPage.this.previewer.getBrowser();
                if (browser != null) {
                    browser.stop();
                }
            }
        });
        ToolItem refreshButton = new ToolItem(toolbar, 0);
        refreshButton.setImage(AuthoringUIImages.IMG_REFRESH);
        refreshButton.setToolTipText(AuthoringUIResources.AuthoringUI_refreshButton_text);
        refreshButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                PreviewPage.this.previewer.refresh();
            }
        });
        ToolItem printButton = new ToolItem(toolbar, 0);
        printButton.setImage(AuthoringUIImages.IMG_PRINT);
        printButton.setToolTipText(AuthoringUIResources.AuthoringUI_printButton_text);
        printButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                PreviewPage.this.previewer.print();
            }
        });
        return toolbar;
    }
}

