/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.authoring.ui.forms;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.ItemProviderAdapter;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.epf.authoring.ui.AuthoringUIPlugin;
import org.eclipse.epf.authoring.ui.AuthoringUIResources;
import org.eclipse.epf.authoring.ui.AuthoringUIText;
import org.eclipse.epf.authoring.ui.actions.LibraryViewDeleteAction;
import org.eclipse.epf.authoring.ui.filters.AllFilter;
import org.eclipse.epf.authoring.ui.forms.AssociationFormPage;
import org.eclipse.epf.authoring.ui.views.LibraryView;
import org.eclipse.epf.library.LibraryService;
import org.eclipse.epf.library.edit.IFilter;
import org.eclipse.epf.library.edit.TngAdapterFactory;
import org.eclipse.epf.library.edit.command.IResourceAwareCommand;
import org.eclipse.epf.library.edit.command.MoveInCategoryCommand;
import org.eclipse.epf.library.edit.itemsfilter.FilterConstants;
import org.eclipse.epf.library.edit.util.ModelStructure;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.library.ui.LibraryUIManager;
import org.eclipse.epf.library.util.LibraryManager;
import org.eclipse.epf.uma.ContentCategory;
import org.eclipse.epf.uma.ContentElement;
import org.eclipse.epf.uma.CustomCategory;
import org.eclipse.epf.uma.DescribableElement;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.Process;
import org.eclipse.epf.uma.ProcessComponent;
import org.eclipse.epf.uma.ProcessPackage;
import org.eclipse.epf.uma.TermDefinition;
import org.eclipse.epf.uma.UmaPackage;
import org.eclipse.epf.uma.util.AssociationHelper;
import org.eclipse.epf.uma.util.MessageException;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.forms.editor.FormEditor;

public class CustomCategoryAssignPage
extends AssociationFormPage {
    private static final String FORM_PAGE_ID = "customCategoryAssignPage";
    private CustomCategory category;
    static /* synthetic */ Class class$0;

    public CustomCategoryAssignPage(FormEditor editor) {
        super(editor, FORM_PAGE_ID, AuthoringUIText.ASSIGN_PAGE_TITLE);
    }

    public void init(IEditorSite site, IEditorInput input) {
        super.init(site, input);
        this.category = (CustomCategory)this.contentElement;
        this.setUseCategory2(false);
        this.setUseCategory3(false);
        this.setAllowChange1(true);
        this.setIsUpAndDownButtonsRequired1(true);
    }

    protected void initContentProviderSelected() {
        this.contentProviderSelected = new AdapterFactoryContentProvider((AdapterFactory)TngAdapterFactory.INSTANCE.getNavigatorView_ComposedAdapterFactory()){

            public Object[] getElements(Object object) {
                ArrayList list = new ArrayList();
                list.addAll(CustomCategoryAssignPage.this.category.getCategorizedElements());
                return list.toArray();
            }
        };
        this.viewer_selected.setContentProvider((IContentProvider)this.contentProviderSelected);
    }

    protected void addItemsToModel1(ArrayList addItems) {
        List ancestors = this.getAncestors(this.category);
        if (!addItems.isEmpty()) {
            Iterator it = addItems.iterator();
            while (it.hasNext()) {
                MethodElement customCategory = (MethodElement)it.next();
                if (customCategory instanceof CustomCategory && TngUtil.isRootCustomCategory((CustomCategory)((CustomCategory)customCategory)) || ancestors.contains(customCategory)) continue;
                if (customCategory instanceof ProcessComponent) {
                    Process object = ((ProcessComponent)customCategory).getProcess();
                    LibraryManager.getInstance().addToCustomCategory(this.getActionManager(), this.category, (MethodElement)object);
                    continue;
                }
                LibraryManager.getInstance().addToCustomCategory(this.getActionManager(), this.category, customCategory);
            }
            this.setDirty(true);
        }
    }

    protected void removeItemsFromModel1(ArrayList rmItems) {
        if (!rmItems.isEmpty()) {
            ArrayList customCategoriesToDelete = new ArrayList();
            Iterator it = rmItems.iterator();
            while (it.hasNext()) {
                MethodElement e = (MethodElement)it.next();
                if (e instanceof CustomCategory) {
                    Adapter adapter;
                    ComposedAdapterFactory composedAdapterFactory = TngAdapterFactory.INSTANCE.getNavigatorView_ComposedAdapterFactory();
                    Class<?> clazz = class$0;
                    if (clazz == null) {
                        try {
                            clazz = Class.forName("org.eclipse.emf.edit.provider.ITreeItemContentProvider");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    if ((adapter = composedAdapterFactory.adapt((Notifier)this.category, (Object)clazz)) == null || !(adapter instanceof ItemProviderAdapter)) continue;
                    Iterator iter = ((ItemProviderAdapter)adapter).getChildren((Object)this.category).iterator();
                    while (iter.hasNext()) {
                        Object o = iter.next();
                        if (TngUtil.unwrap(o) != e) continue;
                        customCategoriesToDelete.add(o);
                    }
                    continue;
                }
                LibraryManager.getInstance().removeFromCustomCategory(this.getActionManager(), this.category, e);
            }
            if (customCategoriesToDelete.size() > 0) {
                LibraryViewDeleteAction deleteAction = new LibraryViewDeleteAction(){

                    public void run() {
                        String title = AuthoringUIResources.AuthoringUI_actions_LibraryActionBarContributor_deleteErrorTitle;
                        try {
                            super.run();
                        }
                        catch (MessageException e) {
                            AuthoringUIPlugin.getDefault().getMsgDialog().displayError(title, e.getMessage());
                        }
                        catch (Exception e) {
                            String details = TngUtil.toStackTraceString((Throwable)e);
                            String message = AuthoringUIResources.AuthoringUI_actions_LibraryActionBarContributor_deleteErrorMessage;
                            String reason = AuthoringUIResources.AuthoringUI_actions_LibraryActionBarContributor_deleteErrorReason;
                            AuthoringUIPlugin.getDefault().getMsgDialog().displayError(title, message, reason, details, (Throwable)e);
                        }
                    }

                    protected void deleteFailed() {
                        String libDir = LibraryService.getInstance().getCurrentMethodLibraryPath();
                        LibraryUIManager.getInstance().openLibrary(libDir);
                    }
                };
                deleteAction.setEditingDomain(LibraryView.getView().getEditingDomain());
                deleteAction.selectionChanged((IStructuredSelection)new StructuredSelection(customCategoriesToDelete));
                deleteAction.run();
            }
            this.setDirty(true);
        }
    }

    protected void moveUpItemsInSelectedItems1(ArrayList moveUpItems) {
        if (!moveUpItems.isEmpty()) {
            EReference feature = UmaPackage.eINSTANCE.getCustomCategory_CategorizedElements();
            MoveInCategoryCommand cmd = new MoveInCategoryCommand((ContentCategory)this.category, (List)moveUpItems, (EStructuralFeature)feature, ModelStructure.DEFAULT.customCategoryPath, true, 1);
            this.getActionManager().execute((IResourceAwareCommand)cmd);
        }
    }

    protected void moveDownItemsInSelectedItems1(ArrayList moveDownItems) {
        if (!moveDownItems.isEmpty()) {
            EReference feature = UmaPackage.eINSTANCE.getCustomCategory_CategorizedElements();
            MoveInCategoryCommand cmd = new MoveInCategoryCommand((ContentCategory)this.category, (List)moveDownItems, (EStructuralFeature)feature, ModelStructure.DEFAULT.customCategoryPath, true, 0);
            this.getActionManager().execute((IResourceAwareCommand)cmd);
        }
    }

    private List getAncestors(CustomCategory methodObject) {
        ArrayList ancestorList = new ArrayList();
        ArrayList<CustomCategory> objList = new ArrayList<CustomCategory>();
        objList.add(methodObject);
        this.getAncestors(ancestorList, objList);
        return ancestorList;
    }

    private List getAncestors(List ancestorList, List methodObjectList) {
        if (methodObjectList.isEmpty()) {
            return ancestorList;
        }
        ArrayList allParentCustCats = new ArrayList();
        Iterator iter = methodObjectList.iterator();
        while (iter.hasNext()) {
            CustomCategory element = (CustomCategory)iter.next();
            List parentList = AssociationHelper.getCustomCategories((DescribableElement)element);
            allParentCustCats.addAll(parentList);
        }
        ancestorList.addAll(methodObjectList);
        ArrayList nextCheckList = new ArrayList();
        Iterator iter2 = allParentCustCats.iterator();
        while (iter2.hasNext()) {
            Object element = iter2.next();
            if (ancestorList.contains(element)) continue;
            nextCheckList.add(element);
        }
        return this.getAncestors(ancestorList, nextCheckList);
    }

    protected Object getContentElement() {
        return this.category;
    }

    protected String getTabString() {
        return FilterConstants.ALL_ELEMENTS;
    }

    protected IFilter getFilter() {
        this.filter = new CustomCategoryAssignFilter();
        return this.filter;
    }

    protected String getMultipleSelectDescription(int count) {
        return super.getMultipleSelectDescription(count, AuthoringUIResources.AuthoringUI_customCategoryAssignPage_multipleSelectDescription);
    }

    protected String getSectionDescription() {
        return AuthoringUIResources.AuthoringUI_customCategoryAssignPage_sectionDescription;
    }

    protected String getSectionName() {
        return AuthoringUIResources.AuthoringUI_customCategoryAssignPage_sectionName;
    }

    protected String getSelectedLabel() {
        return AuthoringUIResources.AuthoringUI_customCategoryAssignPage_selectedLabel;
    }

    protected String getSelectedLabel2() {
        return null;
    }

    protected String getSelectedLabel3() {
        return null;
    }

    private class CustomCategoryAssignFilter
    extends AllFilter {
        private CustomCategoryAssignFilter() {
        }

        protected boolean childAccept(Object obj) {
            if (obj instanceof ProcessPackage) {
                return true;
            }
            if (obj instanceof Process) {
                return true;
            }
            if (obj instanceof CustomCategory && TngUtil.isRootCustomCategory((CustomCategory)((CustomCategory)obj))) {
                return !((CustomCategory)obj).getCategorizedElements().isEmpty();
            }
            if (obj instanceof TermDefinition) {
                return false;
            }
            if (obj instanceof ContentElement) {
                return !this.getHelper().isContributor((ContentElement)obj);
            }
            return false;
        }
    }
}

