/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.authoring.ui.forms;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.epf.authoring.ui.AuthoringUIResources;
import org.eclipse.epf.authoring.ui.AuthoringUIText;
import org.eclipse.epf.authoring.ui.filters.ContentFilter;
import org.eclipse.epf.authoring.ui.forms.AssociationFormPage;
import org.eclipse.epf.library.edit.IFilter;
import org.eclipse.epf.library.edit.TngAdapterFactory;
import org.eclipse.epf.library.edit.itemsfilter.FilterConstants;
import org.eclipse.epf.library.util.LibraryManager;
import org.eclipse.epf.uma.ContentElement;
import org.eclipse.epf.uma.Discipline;
import org.eclipse.epf.uma.Task;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.forms.editor.FormEditor;

public class DisciplineTasksPage
extends AssociationFormPage {
    private static final String FORM_PAGE_ID = "disciplineTasksPage";
    private Discipline discipline;

    public DisciplineTasksPage(FormEditor editor) {
        super(editor, FORM_PAGE_ID, AuthoringUIText.TASKS_PAGE_TITLE);
    }

    public void init(IEditorSite site, IEditorInput input) {
        super.init(site, input);
        this.discipline = (Discipline)this.contentElement;
        this.setUseCategory2(false);
        this.setUseCategory3(false);
        this.setAllowChange1(true);
    }

    protected void initContentProviderSelected() {
        this.contentProviderSelected = new AdapterFactoryContentProvider((AdapterFactory)TngAdapterFactory.INSTANCE.getNavigatorView_ComposedAdapterFactory()){

            public Object[] getElements(Object object) {
                return ((Discipline)object).getTasks().toArray();
            }
        };
        this.viewer_selected.setContentProvider((IContentProvider)this.contentProviderSelected);
    }

    protected void addItemsToModel1(ArrayList addItems) {
        if (!addItems.isEmpty()) {
            Iterator it = addItems.iterator();
            while (it.hasNext()) {
                Task task = (Task)it.next();
                LibraryManager.getInstance().addToDiscipline(this.getActionManager(), this.discipline, task);
            }
        }
    }

    protected void removeItemsFromModel1(ArrayList rmItems) {
        if (!rmItems.isEmpty()) {
            Iterator it = rmItems.iterator();
            while (it.hasNext()) {
                Task task = (Task)it.next();
                LibraryManager.getInstance().removeFromDiscipline(this.getActionManager(), this.discipline, task);
            }
        }
    }

    protected Object getContentElement() {
        return this.discipline;
    }

    protected String getTabString() {
        return FilterConstants.TASKS;
    }

    protected IFilter getFilter() {
        this.filter = new ContentFilter(){

            protected boolean childAccept(Object obj) {
                if (obj instanceof ContentElement && this.getHelper().isContributor((ContentElement)obj)) {
                    return false;
                }
                return obj instanceof Task;
            }
        };
        return this.filter;
    }

    protected String getMultipleSelectDescription(int count) {
        return super.getMultipleSelectDescription(count, AuthoringUIResources.AuthoringUI_disciplineTasksPage_multipleSelectDescription);
    }

    protected String getSectionDescription() {
        return AuthoringUIResources.AuthoringUI_disciplineTasksPage_sectionDescription;
    }

    protected String getSectionName() {
        return AuthoringUIResources.AuthoringUI_disciplineTasksPage_sectionName;
    }

    protected String getSelectedLabel() {
        return AuthoringUIResources.AuthoringUI_disciplineTasksPage_selectedLabel;
    }

    protected String getSelectedLabel2() {
        return AuthoringUIResources.AuthoringUI_disciplineTasksPage_selectedLabel;
    }

    protected String getSelectedLabel3() {
        return AuthoringUIResources.AuthoringUI_disciplineTasksPage_selectedLabel;
    }
}

