/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.authoring.ui.preferences;

import org.eclipse.epf.authoring.ui.AuthoringUIResources;
import org.eclipse.epf.authoring.ui.AuthoringUIText;
import org.eclipse.epf.common.utils.FileUtil;
import org.eclipse.epf.library.LibraryPlugin;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class LibraryPrefPage
extends PreferencePage
implements IWorkbenchPreferencePage,
SelectionListener,
ModifyListener {
    Composite composite_tab;
    Text ctrl_libParentPath;
    Button ctrl_browseButton;
    String defLibPPath = "/";
    private Button bakCheckbox;
    private Button discardUnresolvedRefCheckBox;

    protected Control createContents(Composite parent) {
        this.composite_tab = this.createComposite(parent, 3);
        this.createLabel(this.composite_tab, " ", 3);
        this.createLabel(this.composite_tab, AuthoringUIResources.AuthoringUI_chooseDefaultDirectory_text, 3);
        this.createLabel(this.composite_tab, AuthoringUIResources.AuthoringUI_directory_text, 1);
        this.ctrl_libParentPath = new Text(this.composite_tab, 2048);
        GridData gridData = new GridData(769);
        gridData.widthHint = 400;
        this.ctrl_libParentPath.setLayoutData((Object)gridData);
        this.ctrl_libParentPath.setText(this.defLibPPath);
        this.ctrl_browseButton = new Button(this.composite_tab, 0);
        this.ctrl_browseButton.setText(AuthoringUIText.BROWSE_BUTTON_TEXT);
        gridData = new GridData(515);
        this.ctrl_browseButton.setLayoutData((Object)gridData);
        this.createLabel(this.composite_tab, " ", 3);
        this.createLine(this.composite_tab, 3);
        this.createLabel(this.composite_tab, " ", 3);
        this.createLabel(this.composite_tab, " ", 1);
        this.bakCheckbox = new Button(this.composite_tab, 32);
        this.bakCheckbox.setText(AuthoringUIResources.AuthoringUI_backupbeforesave_text);
        this.createLabel(this.composite_tab, " ", 1);
        this.createLabel(this.composite_tab, " ", 1);
        this.discardUnresolvedRefCheckBox = new Button(this.composite_tab, 32);
        this.discardUnresolvedRefCheckBox.setText(AuthoringUIResources.AuthoringUI_discardunresolvedref);
        this.createLabel(this.composite_tab, " ", 1);
        this.createLabel(this.composite_tab, " ", 3);
        this.createLine(this.composite_tab, 3);
        this.initializeValues();
        this.ctrl_browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LibraryPrefPage.this.openDirectoryDialog();
            }
        });
        return new Composite(parent, 0);
    }

    private void openDirectoryDialog() {
        try {
            DirectoryDialog dd = new DirectoryDialog(this.composite_tab.getShell(), 0);
            String destination = dd.open();
            if (destination != null) {
                this.ctrl_libParentPath.setText(destination);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private Composite createComposite(Composite parent, int numColumns) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = numColumns;
        composite.setLayout((Layout)layout);
        GridData data = new GridData();
        data.verticalAlignment = 4;
        data.horizontalAlignment = 4;
        composite.setLayoutData((Object)data);
        return composite;
    }

    private Label createLabel(Composite parent, String text, int span) {
        Label label = new Label(parent, 16384);
        label.setText(text);
        GridData data = new GridData();
        data.horizontalSpan = span;
        data.horizontalAlignment = 4;
        label.setLayoutData((Object)data);
        return label;
    }

    private void createLine(Composite parent, int ncol) {
        Label line = new Label(parent, 259);
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = ncol;
        line.setLayoutData((Object)gridData);
    }

    protected IPreferenceStore doGetPreferenceStore() {
        return LibraryPlugin.getDefault().getPreferenceStore();
    }

    private void initializeDefaults() {
        IPreferenceStore store = this.getPreferenceStore();
        this.defLibPPath = store.getDefaultString("org.eclipse.epf.library.pref.default_library_parent_directory");
        if (this.defLibPPath == null || this.defLibPPath.length() == 0) {
            this.defLibPPath = String.valueOf(System.getProperty("user.home")) + FileUtil.FILE_SEP + "EPF" + FileUtil.FILE_SEP + "Method Libraries";
        }
        this.ctrl_libParentPath.setText(this.defLibPPath);
        this.bakCheckbox.setSelection(store.getDefaultBoolean("org.eclipse.epf.library.pref.back_up_before_save"));
        this.discardUnresolvedRefCheckBox.setSelection(store.getDefaultBoolean("org.eclipse.epf.library.pref.discard_unresolved_references"));
    }

    private void initializeValues() {
        IPreferenceStore store = this.getPreferenceStore();
        this.defLibPPath = store.getString("org.eclipse.epf.library.pref.default_library_parent_directory");
        if (this.defLibPPath == null || this.defLibPPath.length() == 0) {
            this.defLibPPath = String.valueOf(System.getProperty("user.home")) + FileUtil.FILE_SEP + "EPF" + FileUtil.FILE_SEP + "Method Libraries";
        }
        this.ctrl_libParentPath.setText(this.defLibPPath);
        this.bakCheckbox.setSelection(store.getBoolean("org.eclipse.epf.library.pref.back_up_before_save"));
        this.discardUnresolvedRefCheckBox.setSelection(store.getBoolean("org.eclipse.epf.library.pref.discard_unresolved_references"));
    }

    protected void performDefaults() {
        super.performDefaults();
        this.initializeDefaults();
    }

    public boolean performOk() {
        this.storeValues();
        LibraryPlugin.getDefault().savePluginPreferences();
        return true;
    }

    private void storeValues() {
        IPreferenceStore store = this.getPreferenceStore();
        this.defLibPPath = this.ctrl_libParentPath.getText().trim();
        System.out.println("DEBUG: defLibPPath = " + this.defLibPPath);
        store.setValue("org.eclipse.epf.library.pref.default_library_parent_directory", this.defLibPPath);
        store.setValue("org.eclipse.epf.library.pref.back_up_before_save", this.bakCheckbox.getSelection());
        store.setValue("org.eclipse.epf.library.pref.discard_unresolved_references", this.discardUnresolvedRefCheckBox.getSelection());
    }

    public void init(IWorkbench workbench) {
    }

    public void widgetSelected(SelectionEvent e) {
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void modifyText(ModifyEvent e) {
    }
}

