/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.authoring.ui.util;

import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.epf.authoring.ui.AuthoringUIPlugin;
import org.eclipse.epf.authoring.ui.AuthoringUIResources;
import org.eclipse.epf.authoring.ui.views.LibraryView;
import org.eclipse.epf.persistence.MultiFileSaveUtil;
import org.eclipse.epf.persistence.refresh.RefreshJob;
import org.eclipse.epf.uma.ContentDescription;
import org.eclipse.epf.uma.ContentElement;
import org.eclipse.epf.uma.ContentPackage;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.MethodPlugin;
import org.eclipse.epf.uma.ProcessComponent;
import org.eclipse.epf.uma.ProcessPackage;
import org.eclipse.epf.uma.util.ContentDescriptionFactory;
import org.eclipse.epf.uma.util.IMethodLibraryPersister;
import org.eclipse.epf.uma.util.UmaUtil;
import org.eclipse.ui.IMarkerResolution;
import org.eclipse.ui.IMarkerResolutionGenerator;

public class MarkerResolutionGenerator
implements IMarkerResolutionGenerator {
    private static final IMarkerResolution[] EMPTY_RESOLUTIONS = new IMarkerResolution[0];

    public IMarkerResolution[] getResolutions(IMarker marker) {
        block8: {
            try {
                EObject owner;
                Resource resource;
                String proxyURI = (String)marker.getAttribute("proxyURI");
                String ownerGUID = (String)marker.getAttribute("ownerGUID");
                if (proxyURI == null || ownerGUID == null || (resource = RefreshJob.getInstance().getResource(marker.getResource())) == null || (owner = resource.getEObject(ownerGUID)) == null) break block8;
                URI uri = URI.createURI((String)proxyURI);
                int index = -1;
                EReference reference = null;
                Iterator iter = owner.eClass().getEAllReferences().iterator();
                block2: while (iter.hasNext()) {
                    EReference ref = (EReference)iter.next();
                    if (!ref.isChangeable() || ref.isDerived()) continue;
                    if (ref.isMany()) {
                        InternalEList list = (InternalEList)owner.eGet((EStructuralFeature)ref);
                        int id = 0;
                        Iterator iterator = list.basicIterator();
                        while (iterator.hasNext()) {
                            InternalEObject o = (InternalEObject)iterator.next();
                            if (o.eIsProxy() && uri.equals((Object)o.eProxyURI())) {
                                index = id;
                                reference = ref;
                                break block2;
                            }
                            ++id;
                        }
                        continue;
                    }
                    InternalEObject o = (InternalEObject)owner.eGet((EStructuralFeature)ref, false);
                    if (o == null || !o.eIsProxy() || !uri.equals((Object)o.eProxyURI())) continue;
                    reference = ref;
                    break;
                }
                if (reference != null) {
                    Object selectableOwner = MarkerResolutionGenerator.getSelectableObject(owner);
                    if (selectableOwner != null) {
                        return new IMarkerResolution[]{new MarkerResolution(owner, reference, index), new ShowOwnerInLibraryView(selectableOwner)};
                    }
                    return new IMarkerResolution[]{new MarkerResolution(owner, reference, index)};
                }
            }
            catch (Exception e) {
                AuthoringUIPlugin.getDefault().getLogger().logError((Throwable)e);
            }
        }
        return EMPTY_RESOLUTIONS;
    }

    private static Object getSelectableObject(EObject owner) {
        ProcessComponent procComp;
        if (owner instanceof MethodPlugin || owner instanceof ContentElement || owner instanceof ContentPackage || owner instanceof ProcessComponent) {
            return owner;
        }
        if (owner instanceof MethodElement && (procComp = UmaUtil.getProcessComponent((MethodElement)((MethodElement)owner))) != null) {
            return procComp;
        }
        if (owner instanceof ProcessPackage) {
            return owner;
        }
        if (owner instanceof ContentDescription && owner.eContainer() instanceof ContentElement) {
            return owner.eContainer();
        }
        Resource resource = owner.eResource();
        MethodElement e = MultiFileSaveUtil.getMethodElement((Resource)resource);
        if (e != owner) {
            return MarkerResolutionGenerator.getSelectableObject((EObject)e);
        }
        return null;
    }

    private static class ShowOwnerInLibraryView
    implements IMarkerResolution {
        private Object owner;

        private ShowOwnerInLibraryView(Object owner) {
            this.owner = owner;
        }

        public String getLabel() {
            return AuthoringUIResources.MarkerResolutionGenerator_showOwnerInLibraryView;
        }

        public void run(IMarker marker) {
            LibraryView.getView().setSelectionToViewer(this.owner);
        }
    }

    private static class MarkerResolution
    implements IMarkerResolution {
        private EObject owner;
        private EReference reference;
        private int index;

        private MarkerResolution(EObject owner, EReference ref, int index) {
            this.owner = owner;
            this.reference = ref;
            this.index = index;
        }

        public String getLabel() {
            return AuthoringUIResources.MarkerResolutionGenerator_removeUnresolvedReference;
        }

        public void run(IMarker marker) {
            if (this.reference.isMany()) {
                ((List)this.owner.eGet((EStructuralFeature)this.reference)).remove(this.index);
            } else {
                this.owner.eSet((EStructuralFeature)this.reference, null);
            }
            IMethodLibraryPersister persister = ContentDescriptionFactory.getMethodLibraryPersister();
            try {
                persister.save(this.owner.eResource());
                IResource wsRes = marker.getResource();
                wsRes.refreshLocal(0, null);
            }
            catch (Exception e) {
                AuthoringUIPlugin.getDefault().getLogger().logError((Throwable)e);
            }
        }
    }
}

