/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.authoring.ui.views;

import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.eclipse.emf.edit.provider.ItemProviderAdapter;
import org.eclipse.epf.authoring.ui.AuthoringUIPlugin;
import org.eclipse.epf.authoring.ui.AuthoringUIResources;
import org.eclipse.epf.authoring.ui.views.MessageView;
import org.eclipse.epf.common.serviceability.MsgBox;
import org.eclipse.epf.common.serviceability.MsgDialog;
import org.eclipse.epf.library.ILibraryManager;
import org.eclipse.epf.library.LibraryService;
import org.eclipse.epf.library.edit.FeatureValueWrapperItemProvider;
import org.eclipse.epf.library.edit.ui.UserInteractionHelper;
import org.eclipse.epf.library.edit.util.Misc;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.library.ui.LibraryUIManager;
import org.eclipse.epf.uma.BreakdownElementDescription;
import org.eclipse.epf.uma.ContentDescription;
import org.eclipse.epf.uma.DescribableElement;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.MethodLibrary;
import org.eclipse.epf.uma.NamedElement;
import org.eclipse.epf.uma.ProcessComponent;
import org.eclipse.epf.uma.util.ContentDescriptionFactory;
import org.eclipse.epf.uma.util.IMethodLibraryPersister;
import org.eclipse.epf.uma.util.UmaUtil;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;

public final class ViewHelper {
    public static boolean promptSave() {
        ILibraryManager manager = LibraryService.getInstance().getCurrentLibraryManager();
        if (manager != null && manager.isMethodLibraryModified()) {
            int ret = MsgBox.prompt((String)AuthoringUIResources.AuthoringUI_saveLibraryDialog_title, (String)AuthoringUIResources.AuthoringUI_saveLibraryDialog_text, (int)448);
            switch (ret) {
                case 64: {
                    try {
                        LibraryService.getInstance().saveCurrentMethodLibrary();
                        break;
                    }
                    catch (Exception e) {
                        MsgDialog dialog = AuthoringUIPlugin.getDefault().getMsgDialog();
                        dialog.displayError(AuthoringUIResources.AuthoringUI_saveLibraryDialog_title, AuthoringUIResources.AuthoringUI_saveLibraryError_msg, AuthoringUIResources.AuthoringUI_error_reason, (Throwable)e);
                        return dialog.displayPrompt(AuthoringUIResources.AuthoringUI_openLibraryDialog_title, AuthoringUIResources.AuthoringUI_openLibraryDialog_text);
                    }
                }
                case 128: {
                    manager.discardMethodLibraryChanges();
                    break;
                }
                case 256: {
                    return false;
                }
            }
        }
        return true;
    }

    public static int promptSaveInt() {
        ILibraryManager manager = LibraryService.getInstance().getCurrentLibraryManager();
        if (manager != null && manager.isMethodLibraryModified()) {
            int ret = MsgBox.prompt((String)AuthoringUIResources.AuthoringUI_saveLibraryDialog_title, (String)AuthoringUIResources.AuthoringUI_saveLibraryDialog_text, (int)448);
            switch (ret) {
                case 64: {
                    try {
                        LibraryService.getInstance().saveCurrentMethodLibrary();
                    }
                    catch (Exception e) {
                        MsgDialog dialog = AuthoringUIPlugin.getDefault().getMsgDialog();
                        dialog.displayError(AuthoringUIResources.AuthoringUI_saveLibraryDialog_title, AuthoringUIResources.AuthoringUI_saveLibraryError_msg, AuthoringUIResources.AuthoringUI_error_reason, (Throwable)e);
                    }
                    return 64;
                }
                case 128: {
                    manager.discardMethodLibraryChanges();
                    return 128;
                }
                case 256: {
                    return 256;
                }
            }
        }
        return 256;
    }

    public static void closeAllEditors() {
        PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().closeAllEditors(true);
    }

    public static void closeMessageView() {
        PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().hideView((IViewPart)MessageView.getView());
    }

    public static Object handleDangling(Object object) {
        FeatureValueWrapperItemProvider adapter;
        Object value;
        if (object instanceof MethodElement && ((EObject)object).eResource() == null) {
            AuthoringUIPlugin.getDefault().getMsgDialog().displayError(AuthoringUIResources.AuthoringUI_errorDialog_title, AuthoringUIResources.bind((String)AuthoringUIResources.AuthoringUI_elementAlreadyDeletedError_msg, (Object)((MethodElement)object).getName()));
            return null;
        }
        if (object instanceof FeatureValueWrapperItemProvider && (value = (adapter = (FeatureValueWrapperItemProvider)object).getValue()) instanceof MethodElement && ((EObject)value).eResource() == null) {
            Object owner = TngUtil.unwrap((Object)adapter.getParent(value));
            if (owner instanceof ItemProviderAdapter) {
                owner = ((ItemProviderAdapter)owner).getTarget();
            }
            String ownerName = ((MethodElement)owner).getName();
            EStructuralFeature feature = adapter.getFeature();
            if (feature != null) {
                if (AuthoringUIPlugin.getDefault().getMsgDialog().displayPrompt(AuthoringUIResources.AuthoringUI_deleteDialog_title, AuthoringUIResources.bind((String)AuthoringUIResources.AuthoringUI_ViewHelper_alreadydeletedconfirm_text, (Object)((MethodElement)value).getName(), (Object)ownerName)) && feature.isMany()) {
                    ((Collection)((EObject)owner).eGet(feature)).remove(value);
                }
            } else {
                AuthoringUIPlugin.getDefault().getMsgDialog().displayError(AuthoringUIResources.AuthoringUI_errorDialog_title, AuthoringUIResources.bind((String)AuthoringUIResources.AuthoringUI_elementAlreadyDeletedError_msg, (Object)((MethodElement)value).getName()));
            }
            return null;
        }
        return object;
    }

    public static boolean isLocked(IStructuredSelection selection) {
        Iterator iter = selection.iterator();
        while (iter.hasNext()) {
            Object element = iter.next();
            while (element instanceof ITreeItemContentProvider) {
                element = ((ITreeItemContentProvider)element).getParent(null);
            }
            if (!((element = TngUtil.unwrap(element)) instanceof EObject) || !TngUtil.isLocked((EObject)((EObject)element))) continue;
            return true;
        }
        return false;
    }

    public static void fixContentDescriptionGUIDs() {
        final MethodLibrary lib = LibraryService.getInstance().getCurrentMethodLibrary();
        if (lib == null) {
            return;
        }
        IRunnableWithProgress runnable = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                HashSet<Resource> modifiedResources = new HashSet<Resource>();
                TreeIterator iter = lib.eAllContents();
                while (iter.hasNext()) {
                    InternalEObject element = (InternalEObject)iter.next();
                    if (element.eProxyURI() == null) {
                        String guid;
                        if (!(element instanceof ContentDescription)) continue;
                        ContentDescription content = (ContentDescription)element;
                        DescribableElement container = (DescribableElement)element.eContainer();
                        if (container == null || (guid = UmaUtil.generateGUID((String)container.getGuid())).equals(content.getGuid())) continue;
                        content.setGuid(guid);
                        modifiedResources.add(content.eResource());
                        modifiedResources.add(container.eResource());
                        continue;
                    }
                    AuthoringUIPlugin.getDefault().getLogger().logError("Unresolved proxy in '" + element.eResource().getURI().toFileString() + "': " + element);
                }
                monitor.subTask(AuthoringUIResources.AuthoringUI_savingFilesTask_name);
                IMethodLibraryPersister.FailSafeMethodLibraryPersister persister = ContentDescriptionFactory.getMethodLibraryPersister().getFailSafePersister();
                try {
                    Iterator iter2 = modifiedResources.iterator();
                    while (iter2.hasNext()) {
                        Resource resource = (Resource)iter2.next();
                        monitor.subTask(AuthoringUIResources.bind((String)AuthoringUIResources.AuthoringUI_savingTask_name, (Object)resource.getURI().toFileString()));
                        persister.save(resource);
                    }
                    persister.commit();
                }
                catch (Exception e) {
                    persister.rollback();
                    throw new WrappedException(e);
                }
            }
        };
        UserInteractionHelper.runWithProgress((IRunnableWithProgress)runnable, (String)AuthoringUIResources.AuthoringUI_fixingContentDescriptionGUIDsTask_name);
    }

    private static String checkProxy(InternalEObject element, EReference ref, Object value) {
        InternalEObject eObj;
        if (value instanceof InternalEObject && (eObj = (InternalEObject)value).eIsProxy()) {
            EObject resolved = element.eResolveProxy(eObj);
            String errMsg = null;
            if (resolved == eObj) {
                errMsg = "Unresolved proxy";
            } else if (!ref.getEType().isInstance((Object)resolved)) {
                errMsg = "Invalid data";
            }
            if (errMsg != null) {
                String path = element instanceof NamedElement ? String.valueOf(ref.getEType().getName()) + "(" + Misc.getPathRelativeToLibrary((NamedElement)((NamedElement)element)) + ")." + ref.getName() + " = " : "";
                return String.valueOf(errMsg) + " in '" + element.eResource().getURI().toFileString() + "': " + path + resolved;
            }
        }
        return null;
    }

    public static void checkLibraryHealth() {
        final MethodLibrary lib = LibraryService.getInstance().getCurrentMethodLibrary();
        if (lib == null) {
            return;
        }
        IRunnableWithProgress runnable = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                AuthoringUIPlugin.getDefault().getLogger().logInfo("++++ LIBRARY HEALTH CHECK REPORT - START +++");
                StringWriter strWriter = new StringWriter();
                PrintWriter printWriter = new PrintWriter(strWriter);
                printWriter.println();
                printWriter.println("UNRESOLVED/INVALID PROXIES IN X-REFERENCES");
                printWriter.println("------------------------------------------");
                TreeIterator iter = lib.eAllContents();
                while (iter.hasNext()) {
                    InternalEObject element = (InternalEObject)iter.next();
                    if (element.eProxyURI() == null) {
                        if (element instanceof ContentDescription) {
                            String contentPath;
                            File contentDir;
                            String modelPath;
                            File dir;
                            ProcessComponent procComp;
                            ContentDescription content = (ContentDescription)element;
                            DescribableElement container = (DescribableElement)element.eContainer();
                            if (container != null) {
                                String guid = UmaUtil.generateGUID((String)container.getGuid());
                                if (!guid.equals(content.getGuid())) {
                                    AuthoringUIPlugin.getDefault().getLogger().logError("ContentDescription with invalid GUID: " + content.getGuid() + " in '" + content.eResource().getURI().toFileString() + "'");
                                }
                            } else {
                                AuthoringUIPlugin.getDefault().getLogger().logError("ContentDescription without a container: " + content);
                            }
                            if (content instanceof BreakdownElementDescription && (procComp = UmaUtil.getProcessComponent((MethodElement)content)) != null && !(dir = new File(modelPath = procComp.eResource().getURI().toFileString()).getParentFile()).equals(contentDir = new File(contentPath = content.eResource().getURI().toFileString()).getParentFile())) {
                                AuthoringUIPlugin.getDefault().getLogger().logError("Content file of " + container.eClass().getName() + " '" + container.getName() + "' in '" + modelPath + " is misplaced: " + contentPath);
                            }
                        }
                        ArrayList xReferences = new ArrayList(element.eClass().getEAllReferences());
                        xReferences.removeAll((Collection<?>)element.eClass().getEAllContainments());
                        Iterator iterator = xReferences.iterator();
                        while (iterator.hasNext()) {
                            EReference ref = (EReference)iterator.next();
                            Object value = element.eGet((EStructuralFeature)ref, false);
                            if (ref.isMany()) {
                                if (!(value instanceof InternalEList)) continue;
                                InternalEList list = (InternalEList)value;
                                Iterator iter1 = list.basicIterator();
                                while (iter1.hasNext()) {
                                    String msg = ViewHelper.checkProxy(element, ref, iter1.next());
                                    if (msg == null) continue;
                                    printWriter.println(msg);
                                }
                                continue;
                            }
                            String msg = ViewHelper.checkProxy(element, ref, value);
                            if (msg == null) continue;
                            printWriter.println(msg);
                        }
                        continue;
                    }
                    AuthoringUIPlugin.getDefault().getLogger().logError("Unresolved proxy in '" + element.eResource().getURI().toFileString() + "': " + element);
                }
                AuthoringUIPlugin.getDefault().getLogger().logError(strWriter.toString());
                AuthoringUIPlugin.getDefault().getLogger().logInfo("++++ LIBRARY HEALTH CHECK REPORT - END +++");
            }
        };
        if (UserInteractionHelper.runWithProgress((IRunnableWithProgress)runnable, (String)AuthoringUIResources.AuthoringUI_viewHelper_performHealthCheck)) {
            String title = AuthoringUIResources.AuthoringUI_viewHelperHealthCheckDialog_title;
            String message = AuthoringUIResources.AuthoringUI_viewHelperHealthCheckDialog_message;
            AuthoringUIPlugin.getDefault().getMsgDialog().displayInfo(title, message);
        }
    }

    public static void removeInvalidReferences() {
        final MethodLibrary lib = LibraryService.getInstance().getCurrentMethodLibrary();
        if (lib == null) {
            return;
        }
        IRunnableWithProgress runnable = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                HashSet<Resource> modifiedResources = new HashSet<Resource>();
                TreeIterator iter = lib.eAllContents();
                while (iter.hasNext()) {
                    InternalEObject element = (InternalEObject)iter.next();
                    if (element.eProxyURI() == null) {
                        ArrayList xReferences = new ArrayList(element.eClass().getEAllReferences());
                        xReferences.removeAll((Collection<?>)element.eClass().getEAllContainments());
                        Iterator iterator = xReferences.iterator();
                        while (iterator.hasNext()) {
                            EReference ref = (EReference)iterator.next();
                            Object value = element.eGet((EStructuralFeature)ref, false);
                            if (ref.isMany()) {
                                if (!(value instanceof InternalEList)) continue;
                                InternalEList list = (InternalEList)value;
                                ArrayList invalidProxies = new ArrayList();
                                Iterator iter1 = list.basicIterator();
                                while (iter1.hasNext()) {
                                    Object v = iter1.next();
                                    if (!this.isInvalidReference(element, ref, v)) continue;
                                    invalidProxies.add(v);
                                }
                                if (invalidProxies.isEmpty()) continue;
                                this.removeInvalidReferences(element, list, invalidProxies);
                                modifiedResources.add(element.eResource());
                                continue;
                            }
                            if (!this.isInvalidReference(element, ref, value)) continue;
                            element.eSet((EStructuralFeature)ref, null);
                            modifiedResources.add(element.eResource());
                        }
                        continue;
                    }
                    AuthoringUIPlugin.getDefault().getLogger().logError("Unresolved proxy in '" + element.eResource().getURI().toFileString() + "': " + element);
                }
                monitor.subTask(AuthoringUIResources.AuthoringUI_savingFilesTask_name);
                IMethodLibraryPersister.FailSafeMethodLibraryPersister persister = ContentDescriptionFactory.getMethodLibraryPersister().getFailSafePersister();
                try {
                    Iterator iter2 = modifiedResources.iterator();
                    while (iter2.hasNext()) {
                        Resource resource = (Resource)iter2.next();
                        monitor.subTask(AuthoringUIResources.bind((String)AuthoringUIResources.AuthoringUI_savingTask_name, (Object)resource.getURI().toFileString()));
                        persister.save(resource);
                    }
                    persister.commit();
                }
                catch (Exception e) {
                    persister.rollback();
                    throw new WrappedException(e);
                }
            }

            private boolean isInvalidReference(InternalEObject element, EReference ref, Object value) {
                InternalEObject eObj;
                if (value instanceof InternalEObject && (eObj = (InternalEObject)value).eIsProxy()) {
                    EObject resolved = element.eResolveProxy(eObj);
                    if (!ref.getEType().isInstance((Object)resolved)) {
                        return true;
                    }
                }
                return false;
            }

            private void removeInvalidReferences(InternalEObject element, InternalEList values, Collection invalidProxies) {
                int max;
                ArrayList<EObject> list = new ArrayList<EObject>(values.basicList());
                list.removeAll(invalidProxies);
                values.clear();
                int i = max = list.size() - 1;
                while (i > -1) {
                    list.set(i, element.eResolveProxy((InternalEObject)list.get(i)));
                    --i;
                }
                values.addAll(list);
            }
        };
        UserInteractionHelper.runWithProgress((IRunnableWithProgress)runnable, (String)AuthoringUIResources.AuthoringUI_deletingInvalidReferencesTask_name);
    }

    public static void reloadCurrentLibaryOnRollbackError(Shell shell) {
        ViewHelper.reloadCurrentLibrary(shell, AuthoringUIResources.AuthoringUI_ViewHelper_reloadLibOnRollbackError);
    }

    public static void reloadCurrentLibrary(Shell shell, String message) {
        if (shell == null) {
            MsgBox.getDefaultShell();
        }
        String title = AuthoringUIResources.AuthoringUI_reloadDialog_title;
        if (message == null) {
            message = AuthoringUIResources.AuthoringUI_reloadDialog_message;
        }
        AuthoringUIPlugin.getDefault().getMsgDialog().displayInfo(title, message);
        String libDir = LibraryService.getInstance().getCurrentMethodLibraryPath();
        LibraryUIManager.getInstance().openLibrary(libDir);
    }

    public static IViewPart openView(String viewId) {
        try {
            IWorkbenchPage activePage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
            if (activePage != null) {
                IViewPart view = activePage.findView(viewId);
                if (view == null) {
                    view = activePage.showView(viewId);
                }
                return view;
            }
        }
        catch (Exception e) {
            AuthoringUIPlugin.getDefault().getMsgDialog().displayError(AuthoringUIResources.AuthoringUI_errorDialog_title, AuthoringUIResources.AuthoringUI_internalError_msg, (Throwable)e);
        }
        return null;
    }
}

