/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.authoring.ui.wizards;

import org.eclipse.epf.authoring.ui.AuthoringUIResources;
import org.eclipse.epf.authoring.ui.wizards.SynchronizationChoices;
import org.eclipse.epf.library.ui.wizards.BaseWizardPage;
import org.eclipse.epf.uma.MethodConfiguration;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.Process;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class SynchronizationSelectConfigPage
extends BaseWizardPage
implements ISelectionChangedListener {
    private SynchronizationChoices syncChoices = null;
    private ComboViewer configComboViewer;
    private MethodConfiguration[] validConfigurations;

    public SynchronizationSelectConfigPage(String pageName, SynchronizationChoices choices) {
        super(pageName);
        this.setTitle(AuthoringUIResources.AuthoringUI_synchronizationWizard_selectConfigPage_title);
        this.setDescription(AuthoringUIResources.AuthoringUI_synchronizationWizard_selectConfigPage_text);
        this.syncChoices = choices;
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        composite.setLayout((Layout)layout);
        this.createLabel(composite, " ", 2);
        this.createLabel(composite, AuthoringUIResources.AuthoringUI_synchronizationWizard_selectConfigPage_configLabel);
        this.configComboViewer = new ComboViewer(composite, 2056);
        this.configComboViewer.getCombo().setLayoutData((Object)new GridData(769));
        LabelProvider labelProvider = new LabelProvider(){

            public String getText(Object element) {
                if (element instanceof MethodElement) {
                    return ((MethodElement)element).getName();
                }
                return element.toString();
            }
        };
        this.configComboViewer.setLabelProvider((IBaseLabelProvider)labelProvider);
        Process selectedProcess = this.syncChoices.getSelectedProcess();
        this.validConfigurations = (MethodConfiguration[])selectedProcess.getValidContext().toArray();
        this.configComboViewer.add((Object[])this.validConfigurations);
        MethodConfiguration defaultConfig = selectedProcess.getDefaultContext();
        this.syncChoices.setSelectedConfig(defaultConfig);
        StructuredSelection defaultSelection = new StructuredSelection((Object)defaultConfig);
        this.configComboViewer.setSelection((ISelection)defaultSelection, true);
        this.addListeners(composite);
        this.setControl((Control)composite);
    }

    private void addListeners(Composite composite) {
        this.configComboViewer.addSelectionChangedListener((ISelectionChangedListener)this);
    }

    public void selectionChanged(SelectionChangedEvent event) {
        StructuredSelection selection = (StructuredSelection)event.getSelection();
        if (!selection.isEmpty()) {
            Object[] config = selection.toArray();
            this.syncChoices.setSelectedConfig((MethodConfiguration)config[0]);
        }
    }
}

