/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.layout.diagram;

import java.awt.Rectangle;
import java.util.Iterator;
import org.eclipse.epf.library.layout.diagram.HTMLArea;
import org.eclipse.epf.library.layout.diagram.HTMLMap;
import org.eclipse.epf.library.layout.util.XmlElement;
import org.eclipse.epf.uma.MethodElement;

public class MethodElementDiagram {
    private MethodElement element;
    private String imageFileName;
    private HTMLMap htmlMap;

    public MethodElementDiagram(MethodElement element) {
        this.element = element;
    }

    public MethodElement getMethodElement() {
        return this.element;
    }

    public String getImageFileName() {
        return this.imageFileName;
    }

    public void setImageFileName(String imageFileName) {
        this.imageFileName = imageFileName;
    }

    public HTMLMap getHTMLMap() {
        return this.htmlMap;
    }

    public void setHTMLMap(HTMLMap htmlMap) {
        this.htmlMap = htmlMap;
    }

    public String getHTML() {
        StringBuffer html = new StringBuffer();
        html.append("<p>");
        if (this.imageFileName != null && this.htmlMap != null) {
            String mapName = this.htmlMap.getName();
            html.append("<map name=\"").append(this.htmlMap.getName()).append("\">");
            Iterator areas = this.htmlMap.getAreas();
            while (areas.hasNext()) {
                HTMLArea htmlArea = (HTMLArea)areas.next();
                Rectangle coords = htmlArea.getCoordinates();
                html.append("<area href=\"").append(htmlArea.getHref()).append("\"").append(" shape=\"").append(htmlArea.getShape()).append("\"").append(" coords=\"").append((int)coords.getX()).append(", ").append((int)coords.getY()).append(", ").append((int)(coords.getX() + coords.getWidth())).append(", ").append((int)(coords.getY() + coords.getHeight())).append("\"").append(" alt=\"").append(htmlArea.getAltTag()).append("\"").append("/>");
            }
            html.append("</map>");
            html.append("<img border=\"0\" src=\"").append(this.imageFileName).append("\"").append(" alt=\"").append(mapName).append("\"").append(" usemap=\"#").append(mapName).append("\"/>");
        }
        html.append("</p>");
        return html.toString();
    }

    public XmlElement getXmlElement() {
        XmlElement xmlElement = null;
        if (this.imageFileName != null && this.htmlMap != null) {
            String mapName = this.htmlMap.getName();
            xmlElement = new XmlElement("map").setAttribute("name", mapName).setAttribute("src", this.imageFileName).setAttribute("alt", mapName);
            Iterator areas = this.htmlMap.getAreas();
            while (areas.hasNext()) {
                HTMLArea htmlArea = (HTMLArea)areas.next();
                Rectangle coords = htmlArea.getCoordinates();
                StringBuffer buffer = new StringBuffer();
                buffer.append((int)coords.getX()).append(", ").append((int)coords.getY()).append(", ").append((int)(coords.getX() + coords.getWidth())).append(", ").append((int)(coords.getY() + coords.getHeight()));
                xmlElement.newChild("area").setAttribute("href", htmlArea.getHref()).setAttribute("shape", htmlArea.getShape()).setAttribute("coords", buffer.toString()).setAttribute("alt", htmlArea.getAltTag());
            }
        }
        return xmlElement;
    }
}

