/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.util;

import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.epf.library.LibraryPlugin;
import org.eclipse.epf.library.LibraryResources;
import org.eclipse.epf.library.LibraryService;
import org.eclipse.epf.library.edit.command.DeleteMethodElementCommand;
import org.eclipse.epf.library.util.ContentResourceScanner;
import org.eclipse.epf.persistence.MethodLibraryPersister;
import org.eclipse.epf.uma.Activity;
import org.eclipse.epf.uma.BreakdownElement;
import org.eclipse.epf.uma.ContentDescription;
import org.eclipse.epf.uma.DescribableElement;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.ProcessComponent;
import org.eclipse.epf.uma.ProcessPackage;
import org.eclipse.epf.uma.UmaFactory;
import org.eclipse.epf.uma.VariabilityElement;
import org.eclipse.epf.uma.VariabilityType;
import org.eclipse.epf.uma.util.AssociationHelper;
import org.eclipse.epf.uma.util.ContentDescriptionFactory;
import org.eclipse.epf.uma.util.IMethodLibraryPersister;
import org.eclipse.epf.uma.util.UmaUtil;
import org.eclipse.osgi.util.NLS;

public class ConvertActivityType {
    private static Activity oldActivity = null;
    private static Activity newActivity = null;
    private static ProcessPackage oldActivityContainer = null;
    private static List oldActivityBreakdown = null;
    private static int oldActivityBreakdownIndex = -1;
    private static Activity superAct = null;
    private static EList superActbreakdownList = null;
    private static VariabilityType oldActVarType = null;
    private static VariabilityElement oldActVarElement = null;
    private static List oldActImmediateVarietiesList = null;
    public static int[] compatibleActivities = new int[]{52, 56, 57, 104, 102};
    public static List compatibleActivitiesList = new ArrayList();

    static {
        int i = 0;
        while (i < compatibleActivities.length) {
            compatibleActivitiesList.add(new Integer(compatibleActivities[i]));
            ++i;
        }
    }

    public static Activity convertActivity(Activity oldActivity, int newType, DeleteMethodElementCommand command) {
        ConvertActivityType.oldActivity = oldActivity;
        if (newType == oldActivity.eClass().getClassifierID()) {
            return null;
        }
        if (!compatibleActivitiesList.contains(new Integer(newType))) {
            return null;
        }
        Activity newActivity = ConvertActivityType.doConvert(newType, command);
        return newActivity;
    }

    private static Activity doConvert(int newType, DeleteMethodElementCommand command) {
        String oldActivityGuid;
        Iterator iter;
        block17: {
            File oldActivityPathFile = new File(LibraryService.getInstance().getCurrentMethodLibraryPath(), MethodLibraryPersister.getElementPath((MethodElement)oldActivity));
            newActivity = ConvertActivityType.createNewActivity(newType);
            oldActivityBreakdown = new ArrayList();
            iter = oldActivity.getBreakdownElements().iterator();
            while (iter.hasNext()) {
                oldActivityBreakdown.add(iter.next());
            }
            oldActivityBreakdownIndex = ConvertActivityType.getIndexInBreakdown(oldActivity);
            iter = oldActivity.eClass().getEAllStructuralFeatures().iterator();
            while (iter.hasNext()) {
                EStructuralFeature feature = (EStructuralFeature)iter.next();
                Object o = oldActivity.eGet(feature);
                if (feature.getFeatureID() == 7 || feature.getFeatureID() == 1 || feature.getFeatureID() == 26 || feature.getFeatureID() == 17 || feature.getFeatureID() == 35 || feature.getFeatureID() == 37 || feature.getFeatureID() == 36 || feature.getFeatureID() == 39 || feature.getFeatureID() == 38) continue;
                newActivity.eSet(feature, o);
            }
            oldActivityGuid = oldActivity.getGuid();
            oldActivityContainer = (ProcessPackage)oldActivity.eContainer();
            oldActivityContainer.getProcessElements().remove(oldActivity);
            oldActivityContainer.getProcessElements().add(newActivity);
            ContentDescription newContentDesc = ContentDescriptionFactory.createContentDescription((DescribableElement)newActivity);
            newActivity.setPresentation(newContentDesc);
            File newActivityPathFile = new File(LibraryService.getInstance().getCurrentMethodLibraryPath(), MethodLibraryPersister.getElementPath((MethodElement)newActivity));
            ContentResourceScanner scanner = new ContentResourceScanner(oldActivityPathFile);
            scanner.setTargetRootPath(newActivityPathFile);
            ContentDescription oldContentDesc = oldActivity.getPresentation();
            iter = oldContentDesc.eClass().getEAllAttributes().iterator();
            while (iter.hasNext()) {
                EAttribute attrib = (EAttribute)iter.next();
                if (attrib.getFeatureID() == 18 || attrib.getFeatureID() == 19 || attrib.getFeatureID() == 20 || attrib.getFeatureID() == 24 || attrib.getFeatureID() == 22 || attrib.getFeatureID() == 25 || attrib.getFeatureID() == 23 || attrib.getFeatureID() == 21 || attrib.getFeatureID() == 26) continue;
                Object o = oldContentDesc.eGet((EStructuralFeature)attrib);
                if (o instanceof String && ((String)o).trim().length() > 0) {
                    scanner.resolveResources((MethodElement)newActivity, (String)o, "");
                }
                newContentDesc.eSet((EStructuralFeature)attrib, o);
            }
            ArrayList oldActBreakdownList = new ArrayList();
            oldActBreakdownList.addAll(oldActivity.getBreakdownElements());
            iter = oldActBreakdownList.iterator();
            while (iter.hasNext()) {
                BreakdownElement be = (BreakdownElement)iter.next();
                be.setSuperActivities(null);
            }
            oldActivity.getBreakdownElements().clear();
            newActivity.getBreakdownElements().addAll(oldActivityBreakdown);
            superAct = UmaUtil.getParentActivity((BreakdownElement)oldActivity);
            superActbreakdownList = (EList)superAct.getBreakdownElements();
            superActbreakdownList.add(oldActivityBreakdownIndex, (Object)newActivity);
            oldActVarElement = oldActivity.getVariabilityBasedOnElement();
            oldActVarType = oldActivity.getVariabilityType();
            oldActImmediateVarietiesList = new ArrayList();
            oldActImmediateVarietiesList.addAll(AssociationHelper.getImmediateVarieties((VariabilityElement)oldActivity));
            if (oldActVarElement != null && oldActVarType != null) {
                newActivity.setVariabilityBasedOnElement(oldActVarElement);
                newActivity.setVariabilityType(oldActVarType);
            }
            iter = oldActImmediateVarietiesList.iterator();
            while (iter.hasNext()) {
                VariabilityElement ve = (VariabilityElement)iter.next();
                ve.setVariabilityBasedOnElement((VariabilityElement)newActivity);
            }
            ProcessPackage tempParent = UmaFactory.eINSTANCE.createProcessPackage();
            tempParent.getProcessElements().add(oldActivity);
            tempParent.setName("temp PP for deletion");
            command.execute();
            if (command.executed && !command.failed) break block17;
            ConvertActivityType.undo();
            newActivity = null;
            newContentDesc = null;
            return null;
        }
        try {
            newActivity.setGuid(oldActivityGuid);
            HashSet<Resource> modifiedResourceSet = new HashSet<Resource>();
            IMethodLibraryPersister.FailSafeMethodLibraryPersister persister = ContentDescriptionFactory.getMethodLibraryPersister().getFailSafePersister();
            try {
                if (newActivity.eResource() != null) {
                    modifiedResourceSet.add(newActivity.eResource());
                }
                if (newActivity.getPresentation().eResource() != null) {
                    modifiedResourceSet.add(newActivity.getPresentation().eResource());
                }
                if (oldActivityContainer.eResource() != null) {
                    modifiedResourceSet.add(oldActivityContainer.eResource());
                }
                if (superAct.eResource() != null) {
                    modifiedResourceSet.add(superAct.eResource());
                }
                iter = modifiedResourceSet.iterator();
                while (iter.hasNext()) {
                    Resource res = (Resource)iter.next();
                    persister.save(res);
                }
                persister.commit();
            }
            catch (Exception e) {
                persister.rollback();
                command.undo();
                ConvertActivityType.undo();
                LibraryPlugin.getDefault().getMsgDialog().displayError(LibraryResources.convertActivityError_title, NLS.bind((String)LibraryResources.saveConvertedActivityError_msg, (Object)newActivity.getName()), LibraryResources.error_reason, (Throwable)e);
                newActivity = null;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            command.undo();
            ConvertActivityType.undo();
            LibraryPlugin.getDefault().getMsgDialog().displayError(LibraryResources.convertActivityError_title, NLS.bind((String)LibraryResources.convertActivityError_msg, (Object)newActivity.getName()), LibraryResources.error_reason, (Throwable)ex);
            newActivity = null;
        }
        return newActivity;
    }

    private static Activity createNewActivity(int newType) {
        switch (newType) {
            case 52: {
                return UmaFactory.eINSTANCE.createActivity();
            }
            case 56: {
                return UmaFactory.eINSTANCE.createIteration();
            }
            case 57: {
                return UmaFactory.eINSTANCE.createPhase();
            }
        }
        return null;
    }

    private static int getIndexInBreakdown(Activity act) {
        int index = -1;
        Activity superAct = UmaUtil.getParentActivity((BreakdownElement)act);
        index = superAct instanceof ProcessComponent ? ((ProcessComponent)superAct).getProcess().getBreakdownElements().indexOf(act) : superAct.getBreakdownElements().indexOf(act);
        return index;
    }

    private static void undo() {
        if (oldActivityContainer != null) {
            oldActivityContainer.getProcessElements().remove(newActivity);
            if (!oldActivityContainer.getProcessElements().contains(oldActivity)) {
                oldActivityContainer.getProcessElements().add(oldActivity);
            }
        }
        if (newActivity != null) {
            newActivity.getBreakdownElements().clear();
        }
        if (oldActivityBreakdown != null && oldActivity != null) {
            oldActivity.getBreakdownElements().addAll(oldActivityBreakdown);
        }
        if (superActbreakdownList != null) {
            if (newActivity != null) {
                superActbreakdownList.remove((Object)newActivity);
            }
            if (oldActivityBreakdownIndex != -1 && oldActivity != null && !superActbreakdownList.contains((Object)oldActivity)) {
                superActbreakdownList.add(oldActivityBreakdownIndex, (Object)oldActivity);
            }
        }
        if (oldActVarElement != null && oldActVarType != null) {
            oldActivity.setVariabilityBasedOnElement(oldActVarElement);
            oldActivity.setVariabilityType(oldActVarType);
        }
        if (oldActImmediateVarietiesList != null) {
            Iterator iter = oldActImmediateVarietiesList.iterator();
            while (iter.hasNext()) {
                VariabilityElement ve = (VariabilityElement)iter.next();
                ve.setVariabilityBasedOnElement((VariabilityElement)oldActivity);
            }
        }
    }
}

