/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.export.msp.wizards;

import java.util.Map;
import org.eclipse.epf.export.msp.ExportMspResources;
import org.eclipse.epf.export.msp.MspPlugin;
import org.eclipse.epf.export.msp.PlanningUtil;
import org.eclipse.epf.uma.Process;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;

public class ExportToMSProjectWizardPage1
extends WizardPage
implements Listener {
    public static final String PAGE_NAME;
    private static final String[] EMPTY_ARRAY;
    private Button capabilityPatternRadioButton;
    private Button deliveryProcessRadioButton;
    private Combo processCombo;
    private Combo contextCombo;
    private Button publishConfigurationCheckBox;
    private Button exportOnlyPlannedElementsCheckBox;
    private Combo templateNameCombo;
    private Combo templateDirCombo;
    private Map capabilityPatterns;
    private Map deliveryProcesses;
    private ModifyListener modifyListener = new ModifyListener(){

        public void modifyText(ModifyEvent e) {
            ExportToMSProjectWizardPage1.this.setPageComplete(ExportToMSProjectWizardPage1.this.isPageComplete());
        }
    };
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.epf.export.msp.wizards.ExportToMSProjectWizardPage1");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        PAGE_NAME = clazz.getName();
        EMPTY_ARRAY = new String[0];
    }

    public ExportToMSProjectWizardPage1(String pageName) {
        super(pageName);
        this.setTitle(ExportMspResources.exportTemplateWizard_pageTitle);
        this.setDescription(ExportMspResources.exportTemplateWizard_text);
        this.setImageDescriptor(MspPlugin.getDefault().getImageDescriptor("full/wizban/ExportProjectTemplate.gif"));
    }

    public void createControl(Composite parent) {
        final Shell shell = parent.getShell();
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(1, false));
        Group processGroup = new Group(composite, 0);
        processGroup.setLayout((Layout)new GridLayout(1, false));
        processGroup.setLayoutData((Object)new GridData(768));
        processGroup.setText(ExportMspResources.processGroup_text);
        Composite buttonComposite = new Composite((Composite)processGroup, 0);
        buttonComposite.setLayout((Layout)new GridLayout(2, false));
        this.capabilityPatternRadioButton = new Button(buttonComposite, 16);
        this.capabilityPatternRadioButton.setText(ExportMspResources.capabilityPatternRadioButton_text);
        this.capabilityPatternRadioButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                ExportToMSProjectWizardPage1.this.updateProcessCombo(ExportToMSProjectWizardPage1.this.capabilityPatterns);
            }

            public void widgetDefaultSelected(SelectionEvent event) {
            }
        });
        this.deliveryProcessRadioButton = new Button(buttonComposite, 16);
        this.deliveryProcessRadioButton.setText(ExportMspResources.deliveryProcessRadioButton_text);
        this.deliveryProcessRadioButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                ExportToMSProjectWizardPage1.this.updateProcessCombo(ExportToMSProjectWizardPage1.this.deliveryProcesses);
            }

            public void widgetDefaultSelected(SelectionEvent event) {
            }
        });
        Composite processComposite = new Composite((Composite)processGroup, 0);
        processComposite.setLayout((Layout)new GridLayout(2, false));
        processComposite.setLayoutData((Object)new GridData(768));
        Label processNameLabel = new Label(processComposite, 0);
        processNameLabel.setText(ExportMspResources.processNameLabel_text);
        this.processCombo = new Combo(processComposite, 2056);
        this.processCombo.setLayoutData((Object)new GridData(768));
        this.processCombo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                ExportToMSProjectWizardPage1.this.updateContextCombo(ExportToMSProjectWizardPage1.this.getProcess());
            }

            public void widgetDefaultSelected(SelectionEvent event) {
            }
        });
        Label contextNameLabel = new Label(processComposite, 0);
        contextNameLabel.setText(ExportMspResources.contextNameLabel_text);
        this.contextCombo = new Combo(processComposite, 2056);
        this.contextCombo.setLayoutData((Object)new GridData(768));
        this.contextCombo.addModifyListener(this.modifyListener);
        this.capabilityPatterns = PlanningUtil.getCapabilityPatterns();
        this.deliveryProcesses = PlanningUtil.getDeliveryProcesses();
        String savedProcessType = MspPlugin.getDefault().getPreferenceStore().getString("processType");
        if (savedProcessType != null && savedProcessType.equals("DeliveryProcess") && this.deliveryProcesses.size() > 0) {
            this.deliveryProcessRadioButton.setSelection(true);
            this.updateProcessCombo(this.deliveryProcesses);
        } else if (savedProcessType != null && this.capabilityPatterns.size() > 0) {
            this.capabilityPatternRadioButton.setSelection(true);
            this.updateProcessCombo(this.capabilityPatterns);
        } else if (this.capabilityPatterns.size() > 0) {
            this.capabilityPatternRadioButton.setSelection(true);
            this.updateProcessCombo(this.capabilityPatterns);
        } else {
            this.deliveryProcessRadioButton.setSelection(true);
            this.updateProcessCombo(this.deliveryProcesses);
        }
        Composite checkBoxComposite = new Composite((Composite)processGroup, 0);
        checkBoxComposite.setLayout((Layout)new GridLayout(1, false));
        this.publishConfigurationCheckBox = new Button(checkBoxComposite, 32);
        this.publishConfigurationCheckBox.setText(ExportMspResources.publishConfigurationCheckBox_text);
        this.publishConfigurationCheckBox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ExportToMSProjectWizardPage1.this.setPageComplete(ExportToMSProjectWizardPage1.this.isPageComplete());
            }
        });
        this.exportOnlyPlannedElementsCheckBox = new Button(checkBoxComposite, 32);
        this.exportOnlyPlannedElementsCheckBox.setText(ExportMspResources.isPlannedCheckBox_text);
        Group templateGroup = new Group(composite, 0);
        templateGroup.setLayout((Layout)new GridLayout(1, false));
        templateGroup.setLayoutData((Object)new GridData(768));
        templateGroup.setText(ExportMspResources.templateGroup_text);
        Composite templateComposite = new Composite((Composite)templateGroup, 0);
        templateComposite.setLayout((Layout)new GridLayout(3, false));
        templateComposite.setLayoutData((Object)new GridData(768));
        Label templateNameLabel = new Label(templateComposite, 0);
        templateNameLabel.setText(ExportMspResources.templateNameLabel_text);
        this.templateNameCombo = new Combo(templateComposite, 2048);
        this.templateNameCombo.setLayoutData((Object)new GridData(768));
        String prevName = MspPlugin.getDefault().getPreferenceStore().getString("templateNames");
        if (prevName != null) {
            this.templateNameCombo.add(prevName);
        }
        this.templateNameCombo.addModifyListener(this.modifyListener);
        new Label(templateComposite, 0);
        Label dirLabel = new Label(templateComposite, 0);
        dirLabel.setText(ExportMspResources.dirLabel_text);
        this.templateDirCombo = new Combo(templateComposite, 2048);
        this.templateDirCombo.setLayoutData((Object)new GridData(768));
        String savedDir = MspPlugin.getDefault().getPreferenceStore().getString("targetDirs");
        if (savedDir != null) {
            this.templateDirCombo.add(savedDir);
            this.templateDirCombo.setText(savedDir);
        }
        this.templateDirCombo.addModifyListener(this.modifyListener);
        Button browseButton = new Button(templateComposite, 0);
        browseButton.setText(ExportMspResources.browseButton_text);
        browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                try {
                    DirectoryDialog dialog = new DirectoryDialog(shell, 0);
                    String selectedDir = dialog.open();
                    if (selectedDir != null) {
                        ExportToMSProjectWizardPage1.this.templateDirCombo.add(selectedDir, 0);
                        ExportToMSProjectWizardPage1.this.templateDirCombo.setText(selectedDir);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
        this.setControl((Control)composite);
    }

    public void handleEvent(Event event) {
        this.setPageComplete(this.isPageComplete());
        this.getWizard().getContainer().updateButtons();
    }

    public boolean isPageComplete() {
        return this.processCombo.getText().trim().length() > 0 && this.contextCombo.getText().trim().length() > 0 && this.templateNameCombo.getText().trim().length() > 0 && this.templateDirCombo.getText().trim().length() > 0;
    }

    public IWizardPage getNextPage() {
        if (this.getPublishedConfiguration()) {
            return super.getNextPage();
        }
        return null;
    }

    public Process getProcess() {
        if (this.capabilityPatternRadioButton.getSelection()) {
            String name = this.processCombo.getText();
            return (Process)this.capabilityPatterns.get(name);
        }
        String name = this.processCombo.getText();
        return (Process)this.deliveryProcesses.get(name);
    }

    public String getProcessContextName() {
        return this.contextCombo.getText();
    }

    public boolean getExportOnlyPlannedElements() {
        return this.exportOnlyPlannedElementsCheckBox.getSelection();
    }

    public boolean getPublishedConfiguration() {
        return this.publishConfigurationCheckBox.getSelection();
    }

    public String getTemplateName() {
        return this.templateNameCombo.getText();
    }

    public String getTargetDirectory() {
        return this.templateDirCombo.getText();
    }

    protected void updateProcessCombo(Map processes) {
        if (processes != null && processes.size() > 0) {
            String[] names = new String[processes.size()];
            processes.keySet().toArray(names);
            this.processCombo.setItems(names);
            String savedProcess = MspPlugin.getDefault().getPreferenceStore().getString("processName");
            if (savedProcess != null && processes.containsKey(savedProcess)) {
                this.processCombo.setText(savedProcess);
            } else {
                this.processCombo.setText(this.processCombo.getItem(0));
            }
            this.updateContextCombo(this.getProcess());
        }
    }

    protected void updateContextCombo(Process process) {
        try {
            Map contexts = PlanningUtil.getContexts(process);
            if (contexts != null && contexts.size() > 0) {
                String[] names = new String[contexts.size()];
                contexts.keySet().toArray(names);
                this.contextCombo.setItems(names);
                String savedContext = MspPlugin.getDefault().getPreferenceStore().getString("context");
                if (savedContext != null && contexts.containsKey(savedContext)) {
                    this.contextCombo.setText(savedContext);
                } else {
                    String defaultContext = process.getDefaultContext().getName();
                    this.contextCombo.setText(defaultContext);
                }
            } else {
                this.contextCombo.setItems(EMPTY_ARRAY);
            }
        }
        catch (Exception exception) {}
    }
}

