/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.rcp;

import java.net.URL;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.epf.authoring.ui.AuthoringPerspective;
import org.eclipse.epf.common.serviceability.Logger;
import org.eclipse.epf.library.ui.LibraryUIManager;
import org.eclipse.epf.rcp.MainPlugin;
import org.eclipse.epf.rcp.MainWorkbenchWindowAdvisor;
import org.eclipse.epf.rcp.RCPResources;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.application.IWorkbenchConfigurer;
import org.eclipse.ui.application.IWorkbenchWindowConfigurer;
import org.eclipse.ui.application.WorkbenchAdvisor;
import org.eclipse.ui.application.WorkbenchWindowAdvisor;
import org.eclipse.ui.internal.WorkbenchPage;
import org.eclipse.ui.internal.ide.model.WorkbenchAdapterBuilder;
import org.osgi.framework.Bundle;

public class MainWorkbenchAdvisor
extends WorkbenchAdvisor {
    protected Logger logger;

    private void declareWorkbenchImage(Bundle ideBundle, String symbolicName, String path, boolean shared) {
        URL url = FileLocator.find((Bundle)ideBundle, (IPath)new Path(path), null);
        ImageDescriptor desc = ImageDescriptor.createFromURL((URL)url);
        this.getWorkbenchConfigurer().declareImage(symbolicName, desc, shared);
    }

    private void declareWorkbenchImages() {
        Bundle ideBundle = Platform.getBundle((String)"org.eclipse.ui.ide");
        this.declareWorkbenchImage(ideBundle, "IMG_OBJ_PROJECT", "$nl$/icons/full/obj16/prj_obj.gif", true);
        this.declareWorkbenchImage(ideBundle, "IMG_OBJ_PROJECT_CLOSED", "$nl$/icons/full/obj16/cprj_obj.gif", true);
        this.declareWorkbenchImage(ideBundle, "IMG_OBJS_ERROR_PATH", "$nl$/icons/full/obj16/error_tsk.gif", true);
        this.declareWorkbenchImage(ideBundle, "IMG_OBJS_WARNING_PATH", "$nl$/icons/full/obj16/warn_tsk.gif", true);
        this.declareWorkbenchImage(ideBundle, "IMG_OBJS_INFO_PATH", "$nl$/icons/full/obj16/info_tsk.gif", true);
        this.declareWorkbenchImage(ideBundle, "IMG_ETOOL_PROBLEM_CATEGORY", "$nl$/icons/full/etool16/problem_category.gif", true);
    }

    public void initialize(IWorkbenchConfigurer configurer) {
        this.logger = MainPlugin.getDefault().getLogger();
        super.initialize(configurer);
        configurer.setSaveAndRestore(true);
        String appStartDir = System.getProperty("user.dir");
        this.logger.logInfo(String.valueOf(RCPResources.rmc_startup_dir_log_info_text) + appStartDir);
        String[] rmcArgs = Platform.getApplicationArgs();
        int i = 0;
        while (i < rmcArgs.length) {
            if (rmcArgs[i].equalsIgnoreCase("-library") && i < rmcArgs.length - 1) {
                LibraryUIManager.setCommandLineLibraryPath((String)rmcArgs[i + 1]);
            }
            ++i;
        }
        this.declareWorkbenchImages();
    }

    public WorkbenchWindowAdvisor createWorkbenchWindowAdvisor(IWorkbenchWindowConfigurer configurer) {
        return new MainWorkbenchWindowAdvisor(configurer);
    }

    public String getInitialWindowPerspectiveId() {
        return AuthoringPerspective.PERSPECTIVE_ID;
    }

    public void preStartup() {
        super.preStartup();
        WorkbenchAdapterBuilder.registerAdapters();
    }

    public boolean preShutdown() {
        IWorkbenchWindow activeWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        IWorkbenchPage page = activeWindow.getActivePage();
        if (page != null && page instanceof WorkbenchPage) {
            IViewReference[] vwRefList = page.getViewReferences();
            boolean introViewExists = false;
            int i = 0;
            while (i < vwRefList.length) {
                if (vwRefList[i].getId().equals("org.eclipse.ui.internal.introview")) {
                    introViewExists = true;
                    break;
                }
                ++i;
            }
            IPreferenceStore store = MainPlugin.getDefault().getPreferenceStore();
            store.setValue("welcome_intro_view_exists", introViewExists);
            MainPlugin.getDefault().savePluginPreferences();
        }
        return true;
    }

    public void postShutdown() {
        try {
            ResourcesPlugin.getWorkspace().save(true, null);
        }
        catch (CoreException coreException) {}
    }
}

