/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.publishing.services;

import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Iterator;
import java.util.List;
import org.eclipse.epf.library.layout.DefaultContentValidator;
import org.eclipse.epf.library.layout.LinkInfo;
import org.eclipse.epf.library.layout.util.XmlElement;
import org.eclipse.epf.library.util.LibraryUtil;
import org.eclipse.epf.library.util.ResourceHelper;
import org.eclipse.epf.publishing.PublishingPlugin;
import org.eclipse.epf.publishing.PublishingResources;
import org.eclipse.epf.publishing.util.http.HttpUtil;
import org.eclipse.epf.uma.ContentCategory;
import org.eclipse.epf.uma.MethodConfiguration;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.osgi.util.NLS;

public class PublishingContentValidator
extends DefaultContentValidator {
    private boolean debug = PublishingPlugin.getDefault().isDebugging();
    public static final String LOGS_FOLDER = "logs";
    public static final String ERROR_LOG_FILENAME = "error.log";
    public static final String WARNING_LOG_FILENAME = "warning.log";
    public static final String INFO_LOG_FILENAME = "info.log";
    protected File logPath;
    protected boolean validateExternalLinks = false;
    protected List invalidExternalLinks = new ArrayList();
    protected List validatedExternalLinks = new ArrayList();
    protected List missingReferences = new ArrayList();
    protected List missingResources = new ArrayList();
    protected List discardedElements = new ArrayList();
    protected List validCategories = new ArrayList();
    protected long publishing_start = 0L;
    protected long time_for_external_link_checking = 0L;
    protected List referencedElements = new ArrayList();
    protected List publishedElements = new ArrayList();
    protected MethodElement defaultTarget = null;

    public PublishingContentValidator(String pubDir, boolean validateExternalLinks) {
        super(pubDir);
        this.validateExternalLinks = validateExternalLinks;
        this.logPath = new File(pubDir, LOGS_FOLDER);
        this.info = this.getStream(INFO_LOG_FILENAME);
        this.warning = this.getStream(WARNING_LOG_FILENAME);
        this.error = this.getStream(ERROR_LOG_FILENAME);
        this.publishing_start = Calendar.getInstance().getTimeInMillis();
    }

    public void dispose() {
        this.invalidExternalLinks.clear();
        this.validatedExternalLinks.clear();
        this.missingReferences.clear();
        this.missingResources.clear();
        this.discardedElements.clear();
        this.validCategories.clear();
        this.referencedElements.clear();
        this.publishedElements.clear();
        this.info.close();
        this.warning.close();
        this.error.close();
    }

    protected PrintStream getStream(String fileName) {
        try {
            File f = new File(this.logPath, fileName);
            File dir = f.getParentFile();
            dir.mkdirs();
            if (!f.exists()) {
                f.createNewFile();
            }
            return new PrintStream(new FileOutputStream(f), true);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public LinkInfo validateLink(MethodElement owner, String attributes, String text, MethodConfiguration config) {
        String url;
        LinkInfo info = super.validateLink(owner, attributes, text, config);
        if (this.validateExternalLinks && (url = info.getUrl()) != null && ResourceHelper.isExternalLink((String)url) && !url.startsWith("ftp://")) {
            if (!this.validatedExternalLinks.contains(url)) {
                try {
                    long start = Calendar.getInstance().getTimeInMillis();
                    HttpUtil.doGet(url, null, 6000);
                    long time = Calendar.getInstance().getTimeInMillis() - start;
                    this.time_for_external_link_checking += time;
                }
                catch (UnknownHostException unknownHostException) {
                    this.logInvalidExternalLink(owner, url, null);
                }
                catch (Exception e) {
                    this.logInvalidExternalLink(owner, url, e.getMessage());
                }
                this.validatedExternalLinks.add(url);
            }
            this.logInfo(owner, NLS.bind((String)PublishingResources.externalUrl_msg, (Object)url));
        }
        return info;
    }

    public void logMissingReference(MethodElement owner, MethodElement refElement) {
        super.logMissingReference(owner, refElement);
        this.missingReferences.add(new MissingReference(owner, refElement));
    }

    public void logMissingReference(MethodElement owner, String guid, String linkedText) {
        super.logMissingReference(owner, guid, linkedText);
        this.missingReferences.add(new MissingReference(owner, guid, linkedText));
    }

    public void logMissingResource(MethodElement owner, File resourceFile, String url) {
        super.logMissingResource(owner, resourceFile, url);
        this.missingResources.add(new MissingResource(owner, resourceFile, url));
    }

    public void logInvalidExternalLink(MethodElement owner, String url, String message) {
        super.logInvalidExternalLink(owner, url, message);
        this.invalidExternalLinks.add(new InvalidExternalLinkInfo(owner, url, message));
    }

    public XmlElement getReport() {
        Object info;
        Iterator it;
        XmlElement reportXml = new XmlElement("validatorInfo");
        if (this.invalidExternalLinks.size() > 0) {
            this.logInfo(String.valueOf(this.time_for_external_link_checking / 1000L) + " seconds validating external links");
            XmlElement invalidExternalLinksXml = reportXml.newChild("invalidExternalLinks");
            it = this.invalidExternalLinks.iterator();
            while (it.hasNext()) {
                info = (InvalidExternalLinkInfo)it.next();
                invalidExternalLinksXml.newChild("entry").setAttribute("url", ((InvalidExternalLinkInfo)info).url).setAttribute("owner", LibraryUtil.getTypeName((MethodElement)((InvalidExternalLinkInfo)info).owner)).setAttribute("message", ((InvalidExternalLinkInfo)info).message);
            }
        }
        if (this.missingReferences.size() > 0) {
            XmlElement invalidReferencesXml = reportXml.newChild("invalidReferences");
            XmlElement missingReferencesXml = reportXml.newChild("missingReferences");
            Iterator it2 = this.missingReferences.iterator();
            while (it2.hasNext()) {
                MissingReference info2 = (MissingReference)it2.next();
                if (info2.refElement == null) {
                    invalidReferencesXml.newChild("entry").setAttribute("element", info2.linkedText).setAttribute("guid", info2.guid).setAttribute("owner", LibraryUtil.getTypeName((MethodElement)info2.owner));
                    continue;
                }
                missingReferencesXml.newChild("entry").setAttribute("element", LibraryUtil.getTypeName((MethodElement)info2.refElement)).setAttribute("guid", info2.refElement.getGuid()).setAttribute("owner", LibraryUtil.getTypeName((MethodElement)info2.owner));
            }
        }
        if (this.missingResources.size() > 0) {
            XmlElement missingResourcesXml = reportXml.newChild("missingResources");
            it = this.missingResources.iterator();
            while (it.hasNext()) {
                info = (MissingResource)it.next();
                missingResourcesXml.newChild("entry").setAttribute("url", ((MissingResource)info).url).setAttribute("resource", ((MissingResource)info).resourceFile == null ? "" : ((MissingResource)info).resourceFile.getPath()).setAttribute("owner", ((MissingResource)info).owner == null ? "" : LibraryUtil.getTypeName((MethodElement)((MissingResource)info).owner));
            }
        }
        long publishing_time = (Calendar.getInstance().getTimeInMillis() - this.publishing_start) / 1000L;
        int minutes = (int)publishing_time / 60;
        int seconds = (int)publishing_time - minutes * 60;
        this.logInfo("Publishing time: " + minutes + " minutes " + seconds + " seconds");
        return reportXml;
    }

    public void addValidCategory(ContentCategory e) {
        if (!this.validCategories.contains(e)) {
            this.validCategories.add(e);
        }
    }

    public boolean isDiscarded(MethodElement owner, Object feature, MethodElement e) {
        if (this.discardedElements.contains(e)) {
            return true;
        }
        if (e instanceof ContentCategory) {
            if (this.validCategories.contains(e)) {
                return false;
            }
            return false;
        }
        return false;
    }

    public void addReferencedElement(MethodElement owner, MethodElement e) {
        if (e == null) {
            return;
        }
        if (this.isDiscarded(owner, null, e)) {
            if (this.debug) {
                System.out.println("Element is discarded: " + LibraryUtil.getTypeName((MethodElement)e));
            }
            return;
        }
        if (e != null && !this.referencedElements.contains(e) && !this.publishedElements.contains(e)) {
            this.referencedElements.add(e);
            this.logReference(owner, e);
        }
    }

    public void logReference(MethodElement owner, MethodElement e) {
        if (this.debug) {
            System.out.println("--- Referenece Element Added: " + LibraryUtil.getTypeName((MethodElement)e));
        }
    }

    public void removeReferencedElement(MethodElement e) {
        if (this.referencedElements.contains(e)) {
            this.referencedElements.remove(e);
            if (this.debug) {
                System.out.println("--- Reference Element Removed: " + LibraryUtil.getTypeName((MethodElement)e));
            }
        }
    }

    public List getReferencedElements() {
        return this.referencedElements;
    }

    public void setDiscardedElement(MethodElement e) {
        if (e == null) {
            return;
        }
        if (!this.discardedElements.contains(e)) {
            this.discardedElements.add(e);
        }
        this.removeReferencedElement(e);
    }

    public boolean isReferencedElement(MethodElement e) {
        return e != null && this.referencedElements.contains(e);
    }

    public List getPublishedElements() {
        return this.publishedElements;
    }

    public void setTargetElement(MethodElement target) {
        this.defaultTarget = target;
    }

    public boolean hasClosure() {
        return false;
    }

    public boolean inClosure(MethodElement e) {
        return true;
    }

    public void addClosureElements(List items) {
    }

    public void makeElementClosure() {
    }

    public class InvalidExternalLinkInfo {
        public MethodElement owner;
        public String url;
        public String message;

        public InvalidExternalLinkInfo(MethodElement owner, String url, String message) {
            this.owner = owner;
            this.url = url;
            this.message = message;
        }
    }

    public class MissingReference {
        public MethodElement owner;
        public MethodElement refElement;
        public String guid;
        public String linkedText;

        public MissingReference(MethodElement owner, MethodElement refElement) {
            this.owner = owner;
            this.refElement = refElement;
        }

        public MissingReference(MethodElement owner, String guid, String linkedText) {
            this.owner = owner;
            this.guid = guid;
            this.linkedText = linkedText;
        }
    }

    public class MissingResource {
        public MethodElement owner;
        public File resourceFile;
        public String url;

        public MissingResource(MethodElement owner, File resourceFile, String url) {
            this.owner = owner;
            this.resourceFile = resourceFile;
            this.url = url;
        }
    }
}

