/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.common.ui.wizard;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.jar.JarFile;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.emf.common.CommonPlugin;
import org.eclipse.emf.common.ui.CommonUIPlugin;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.DiagnosticException;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.actions.DeleteResourceAction;
import org.eclipse.ui.actions.RenameResourceAction;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.dialogs.IOverwriteQuery;
import org.eclipse.ui.wizards.datatransfer.FileSystemStructureProvider;
import org.eclipse.ui.wizards.datatransfer.IImportStructureProvider;
import org.eclipse.ui.wizards.datatransfer.ImportOperation;
import org.eclipse.ui.wizards.datatransfer.ZipFileStructureProvider;

public abstract class AbstractExampleInstallerWizard
extends Wizard
implements INewWizard {
    protected static final IOverwriteQuery OVERWRITE_ALL_QUERY = new IOverwriteQuery(){

        public String queryOverwrite(String pathString) {
            return "ALL";
        }
    };
    protected IWorkbench workbench;
    protected IStructuredSelection structuredSelection;
    protected ProjectPage projectPage;

    public AbstractExampleInstallerWizard() {
        this.setNeedsProgressMonitor(true);
        this.setWindowTitle(CommonUIPlugin.INSTANCE.getString("_UI_ExampleInstallerWizard_title"));
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.workbench = workbench;
        this.structuredSelection = selection;
    }

    protected abstract List getProjectDescriptors();

    public void dispose() {
        this.projectPage = null;
        super.dispose();
    }

    public void addPages() {
        this.projectPage = new ProjectPage("projectPage", CommonUIPlugin.INSTANCE.getString("_UI_ProjectPage_title"), null);
        this.projectPage.setDescription(CommonUIPlugin.INSTANCE.getString("_UI_ProjectPage_description"));
        this.addPage((IWizardPage)this.projectPage);
    }

    public boolean performFinish() {
        final List projectDescriptors = this.getProjectDescriptors();
        final Exception exceptionWrapper = new Exception();
        try {
            this.getContainer().run(true, false, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    WorkspaceModifyOperation op = new WorkspaceModifyOperation(this, projectDescriptors, exceptionWrapper){
                        final /* synthetic */ 7 this$1;
                        private final /* synthetic */ List val$projectDescriptors;
                        private final /* synthetic */ Exception val$exceptionWrapper;
                        {
                            this.this$1 = var1_1;
                            this.val$projectDescriptors = list;
                            this.val$exceptionWrapper = exception;
                        }

                        protected void execute(IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
                            monitor.beginTask(CommonUIPlugin.INSTANCE.getString("_UI_CreatingProjects_message"), 2 * this.val$projectDescriptors.size());
                            Iterator<E> i = this.val$projectDescriptors.iterator();
                            while (i.hasNext()) {
                                try {
                                    ProjectDescriptor projectDescriptor = (ProjectDescriptor)i.next();
                                    ImportOperation importOperation = 7.access$0(this.this$1).createImportOperation(projectDescriptor);
                                    7.access$0(this.this$1).createProject(projectDescriptor, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                                    importOperation.setContext(7.access$0(this.this$1).getShell());
                                    importOperation.run((IProgressMonitor)new SubProgressMonitor(monitor, 1));
                                }
                                catch (Exception exception) {
                                    this.val$exceptionWrapper.initCause(exception);
                                    throw new InterruptedException();
                                }
                            }
                        }
                    };
                    op.run(monitor);
                }

                static /* synthetic */ AbstractExampleInstallerWizard access$0(7 var0) {
                    return var0.AbstractExampleInstallerWizard.this;
                }
            });
            return true;
        }
        catch (InterruptedException interruptedException) {
            if (exceptionWrapper.getCause() != null) {
                this.openErrorDialog(CommonUIPlugin.INSTANCE.getString("_UI_InstallExampleError_message"), exceptionWrapper.getCause());
            }
        }
        catch (InvocationTargetException e) {
            CommonUIPlugin.INSTANCE.log(e);
        }
        if (this.projectPage != null && !this.projectPage.getControl().isDisposed()) {
            this.projectPage.refresh();
        }
        return false;
    }

    protected void openErrorDialog(String message, Throwable throwable) {
        CoreException coreException = throwable instanceof CoreException ? (CoreException)throwable : DiagnosticException.toCoreException((DiagnosticException)new DiagnosticException(BasicDiagnostic.toDiagnostic((Throwable)throwable)));
        ErrorDialog.openError((Shell)this.getShell(), (String)CommonUIPlugin.INSTANCE.getString("_UI_Error_label"), (String)message, (IStatus)coreException.getStatus());
    }

    protected void createProject(ProjectDescriptor projectDescriptor, IProgressMonitor monitor) throws CoreException {
        monitor.beginTask(CommonUIPlugin.INSTANCE.getString("_UI_CreateProject_message", new String[]{projectDescriptor.getName()}), 3);
        IProject project = projectDescriptor.getProject();
        project.create((IProgressMonitor)new SubProgressMonitor(monitor, 1));
        project.open((IProgressMonitor)new SubProgressMonitor(monitor, 1));
        monitor.done();
    }

    protected ImportOperation createImportOperation(ProjectDescriptor projectDescriptor) throws Exception {
        URI contentURI = projectDescriptor.getContentURI();
        if (contentURI.hasTrailingPathSeparator()) {
            return this.createDirectoryImportOperation(projectDescriptor);
        }
        return this.createFileImportOperation(projectDescriptor);
    }

    protected ImportOperation createDirectoryImportOperation(ProjectDescriptor projectDescriptor) throws Exception {
        File directory;
        String location;
        URI contentURI = projectDescriptor.getContentURI();
        if ("platform".equals(contentURI.scheme())) {
            contentURI = CommonPlugin.asLocalURI((URI)contentURI);
        }
        if ((location = contentURI.toFileString()) != null && (directory = new File(location)).isDirectory() && directory.canRead()) {
            ArrayList<File> filesToImport = new ArrayList<File>();
            filesToImport.addAll(Arrays.asList(directory.listFiles()));
            ImportOperation importOperation = new ImportOperation(projectDescriptor.getProject().getFullPath(), (Object)directory, (IImportStructureProvider)FileSystemStructureProvider.INSTANCE, OVERWRITE_ALL_QUERY, filesToImport);
            importOperation.setCreateContainerStructure(false);
            return importOperation;
        }
        throw new Exception(CommonUIPlugin.INSTANCE.getString("_UI_DirectoryError_message", new String[]{contentURI.toString()}));
    }

    protected ImportOperation createFileImportOperation(ProjectDescriptor projectDescriptor) throws Exception {
        File file;
        String location;
        URI contentURI = projectDescriptor.getContentURI();
        if ("platform".equals(contentURI.scheme())) {
            contentURI = CommonPlugin.asLocalURI((URI)contentURI);
        }
        if ((location = contentURI.toFileString()) != null && (file = new File(location)).isFile() && file.canRead() && this.isZipFile(file)) {
            return this.createZipImportOperation(projectDescriptor, file);
        }
        throw new Exception(CommonUIPlugin.INSTANCE.getString("_UI_FileError_message", new String[]{contentURI.toString()}));
    }

    protected boolean isZipFile(File file) {
        try {
            ZipFile zipFile = new ZipFile(file);
            zipFile.close();
            return true;
        }
        catch (ZipException zipException) {
        }
        catch (IOException iOException) {}
        return false;
    }

    protected ImportOperation createZipImportOperation(ProjectDescriptor projectDescriptor, File file) throws Exception {
        ZipFile zipFile = file.getName().endsWith(".jar") ? new JarFile(file) : new ZipFile(file);
        ZipFileStructureProvider zipFileStructureProvider = new ZipFileStructureProvider(zipFile);
        return new ImportOperation(projectDescriptor.getProject().getFullPath(), (Object)zipFileStructureProvider.getRoot(), (IImportStructureProvider)zipFileStructureProvider, OVERWRITE_ALL_QUERY);
    }

    public static class ProjectDescriptor {
        protected String name;
        protected URI contentURI;
        protected String description;
        protected IProject project;

        public URI getContentURI() {
            return this.contentURI;
        }

        public void setContentURI(URI contentURI) {
            this.contentURI = contentURI;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public IProject getProject() {
            if (this.project == null) {
                this.project = ResourcesPlugin.getWorkspace().getRoot().getProject(this.getName());
            }
            return this.project;
        }
    }

    public class ProjectPage
    extends WizardPage {
        protected org.eclipse.swt.widgets.List projectList;
        protected Text descriptionText;
        protected Button deleteButton;
        protected Button deleteAllButton;
        protected Button renameButton;

        public ProjectPage(String pageName, String title, ImageDescriptor titleImage) {
            super(pageName, title, titleImage);
        }

        public void createControl(Composite parent) {
            SashForm sashForm = new SashForm(parent, 512);
            sashForm.setLayoutData((Object)new GridData(1808));
            Composite composite = new Composite((Composite)sashForm, 0);
            GridLayout layout = new GridLayout(2, false);
            int margin = -5;
            int spacing = 3;
            layout.marginTop = margin;
            layout.marginLeft = margin;
            layout.marginRight = margin;
            layout.marginBottom = margin;
            layout.horizontalSpacing = spacing;
            layout.verticalSpacing = spacing;
            composite.setLayout((Layout)layout);
            this.projectList = new org.eclipse.swt.widgets.List(composite, 2052);
            this.projectList.setLayoutData((Object)new GridData(1808));
            this.projectList.addSelectionListener((SelectionListener)new SelectionAdapter(this){
                final /* synthetic */ ProjectPage this$1;
                {
                    this.this$1 = projectPage;
                }

                public void widgetSelected(SelectionEvent e) {
                    this.this$1.itemSelected();
                }
            });
            this.projectList.setFocus();
            Composite buttonComposite = new Composite(composite, 0);
            buttonComposite.setLayoutData((Object)new GridData(130));
            buttonComposite.setLayout((Layout)new GridLayout());
            GridLayout layout2 = new GridLayout();
            int margin2 = -5;
            int spacing2 = 3;
            layout2.marginTop = margin2;
            layout2.marginLeft = margin2;
            layout2.marginRight = margin2;
            layout2.marginBottom = margin2;
            layout2.horizontalSpacing = spacing2;
            layout2.verticalSpacing = spacing2;
            buttonComposite.setLayout((Layout)layout2);
            this.renameButton = new Button(buttonComposite, 8);
            this.renameButton.setLayoutData((Object)new GridData(800));
            this.renameButton.setText(CommonUIPlugin.INSTANCE.getString("_UI_Rename_label"));
            this.renameButton.addSelectionListener((SelectionListener)new SelectionAdapter(this){
                final /* synthetic */ ProjectPage this$1;
                {
                    this.this$1 = projectPage;
                }

                public void widgetSelected(SelectionEvent e) {
                    this.this$1.renameExistingProject();
                }
            });
            this.renameButton.setEnabled(false);
            this.deleteButton = new Button(buttonComposite, 8);
            this.deleteButton.setLayoutData((Object)new GridData(800));
            this.deleteButton.setText(CommonUIPlugin.INSTANCE.getString("_UI_Delete_label"));
            this.deleteButton.addSelectionListener((SelectionListener)new SelectionAdapter(this){
                final /* synthetic */ ProjectPage this$1;
                {
                    this.this$1 = projectPage;
                }

                public void widgetSelected(SelectionEvent e) {
                    this.this$1.deleteExistingProject();
                }
            });
            this.deleteButton.setEnabled(false);
            Label label = new Label(buttonComposite, 0);
            GridData gridData = new GridData(1808);
            gridData.heightHint = 3;
            label.setLayoutData((Object)gridData);
            this.deleteAllButton = new Button(buttonComposite, 8);
            this.deleteAllButton.setLayoutData((Object)new GridData(800));
            this.deleteAllButton.setText(CommonUIPlugin.INSTANCE.getString("_UI_DeleteAll_label"));
            this.deleteAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(this){
                final /* synthetic */ ProjectPage this$1;
                {
                    this.this$1 = projectPage;
                }

                public void widgetSelected(SelectionEvent e) {
                    this.this$1.deleteAllExistingProjects();
                }
            });
            this.deleteAllButton.setEnabled(false);
            this.descriptionText = new Text((Composite)sashForm, 2634);
            gridData = new GridData(1808);
            gridData.heightHint = this.convertHeightInCharsToPixels(2);
            gridData.grabExcessVerticalSpace = true;
            this.descriptionText.setLayoutData((Object)gridData);
            this.refresh();
            sashForm.setWeights(new int[]{70, 30});
            this.setControl((Control)sashForm);
        }

        public void refresh() {
            if (AbstractExampleInstallerWizard.this.getProjectDescriptors().isEmpty()) {
                this.setErrorMessage(CommonUIPlugin.INSTANCE.getString("_UI_NoProjectError_message"));
                this.setPageComplete(false);
            } else {
                int selectionIndex = this.projectList.getSelectionIndex();
                if (selectionIndex < 0) {
                    selectionIndex = 0;
                }
                boolean atLeastOneExists = false;
                this.projectList.removeAll();
                Iterator i = AbstractExampleInstallerWizard.this.getProjectDescriptors().iterator();
                while (i.hasNext()) {
                    ProjectDescriptor projectDescriptor = (ProjectDescriptor)i.next();
                    String name = projectDescriptor.getName();
                    boolean exists = projectDescriptor.getProject().exists();
                    atLeastOneExists |= exists;
                    String item = exists ? CommonUIPlugin.INSTANCE.getString("_UI_ExistingProjectName_message", new String[]{name}) : CommonUIPlugin.INSTANCE.getString("_UI_ProjectName_message", new String[]{name});
                    this.projectList.add(item);
                    this.projectList.setData(item, (Object)projectDescriptor);
                }
                this.setErrorMessage(null);
                this.projectList.setSelection(selectionIndex);
                this.itemSelected();
                this.deleteAllButton.setEnabled(atLeastOneExists);
                this.setPageComplete(!atLeastOneExists);
            }
        }

        protected ProjectDescriptor getSelectedProjectDescriptor() {
            return (ProjectDescriptor)this.projectList.getData(this.projectList.getSelection()[0]);
        }

        protected void itemSelected() {
            ProjectDescriptor projectDescriptor = this.getSelectedProjectDescriptor();
            boolean exists = projectDescriptor.getProject().exists();
            this.deleteButton.setEnabled(exists);
            this.renameButton.setEnabled(exists);
            this.descriptionText.setText(projectDescriptor.getDescription() != null ? projectDescriptor.getDescription() : "");
        }

        protected void deleteAllExistingProjects() {
            ArrayList<IProject> projects = new ArrayList<IProject>();
            Iterator i = AbstractExampleInstallerWizard.this.getProjectDescriptors().iterator();
            while (i.hasNext()) {
                ProjectDescriptor projectDescriptor = (ProjectDescriptor)i.next();
                if (!projectDescriptor.getProject().exists()) continue;
                projects.add(projectDescriptor.getProject());
            }
            if (!projects.isEmpty()) {
                DeleteResourceAction deleteResourceAction = new DeleteResourceAction(this.getShell());
                deleteResourceAction.selectionChanged((IStructuredSelection)new StructuredSelection(projects));
                deleteResourceAction.run();
                IProject project = (IProject)projects.get(projects.size() - 1);
                this.waitForDeleteJob(project);
                this.refresh();
            }
        }

        protected void deleteExistingProject() {
            ProjectDescriptor projectDescriptor = this.getSelectedProjectDescriptor();
            if (projectDescriptor.getProject().exists()) {
                DeleteResourceAction deleteResourceAction = new DeleteResourceAction(this.getShell());
                deleteResourceAction.selectionChanged((IStructuredSelection)new StructuredSelection((Object)projectDescriptor.getProject()));
                deleteResourceAction.run();
                this.waitForDeleteJob(projectDescriptor.getProject());
                this.refresh();
            }
        }

        protected void renameExistingProject() {
            ProjectDescriptor projectDescriptor = this.getSelectedProjectDescriptor();
            if (projectDescriptor.getProject().exists()) {
                RenameResourceAction renameResourceAction = new RenameResourceAction(this.getShell());
                renameResourceAction.selectionChanged((IStructuredSelection)new StructuredSelection((Object)projectDescriptor.getProject()));
                renameResourceAction.run();
                projectDescriptor.project = null;
                this.refresh();
            }
        }

        protected void waitForDeleteJob(IProject project) {
            BusyIndicator.showWhile((Display)this.getShell().getDisplay(), (Runnable)new Runnable(this, project){
                final /* synthetic */ ProjectPage this$1;
                private final /* synthetic */ IProject val$project;
                {
                    this.this$1 = projectPage;
                    this.val$project = iProject;
                }

                public void run() {
                    while (this.val$project.exists()) {
                        try {
                            Thread.sleep(100L);
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                }
            });
        }
    }
}

