/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.common.ui.wizard;

import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.ui.CommonUIPlugin;
import org.eclipse.emf.common.ui.wizard.AbstractExampleInstallerWizard;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jface.resource.ImageDescriptor;
import org.osgi.framework.Bundle;

public class ExampleInstallerWizard
extends AbstractExampleInstallerWizard
implements IExecutableExtension {
    protected IConfigurationElement wizardConfigurationElement;
    protected List projectDescriptors;

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
        this.wizardConfigurationElement = config;
    }

    protected List getProjectDescriptors() {
        if (this.projectDescriptors == null) {
            this.projectDescriptors = this.createProjectDescriptors();
        }
        return this.projectDescriptors;
    }

    protected List createProjectDescriptors() {
        ArrayList<AbstractExampleInstallerWizard.ProjectDescriptor> projectDescriptors = new ArrayList<AbstractExampleInstallerWizard.ProjectDescriptor>();
        String wizardID = this.wizardConfigurationElement.getAttribute("id");
        IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint(CommonUIPlugin.INSTANCE.getSymbolicName(), "examples");
        IConfigurationElement[] exampleElements = extensionPoint.getConfigurationElements();
        int i = 0;
        while (i < exampleElements.length) {
            IConfigurationElement exampleElement = exampleElements[i];
            if ("example".equals(exampleElement.getName()) && wizardID.equals(exampleElement.getAttribute("wizardID"))) {
                IConfigurationElement[] projectDescriptorElements = exampleElement.getChildren("projectDescriptor");
                int j = 0;
                while (j < projectDescriptorElements.length) {
                    String contentURI;
                    IConfigurationElement projectDescriptorElement = projectDescriptorElements[j];
                    String projectName = projectDescriptorElement.getAttribute("name");
                    if (projectName != null && (contentURI = projectDescriptorElement.getAttribute("contentURI")) != null) {
                        AbstractExampleInstallerWizard.ProjectDescriptor projectDescriptor = new AbstractExampleInstallerWizard.ProjectDescriptor();
                        projectDescriptor.setName(projectName);
                        URI uri = URI.createURI((String)contentURI);
                        if (uri.isRelative()) {
                            uri = URI.createURI((String)("platform:/plugin/" + projectDescriptorElement.getContributor().getName() + "/" + contentURI));
                        }
                        projectDescriptor.setContentURI(uri);
                        projectDescriptor.setDescription(projectDescriptorElement.getAttribute("description"));
                        projectDescriptors.add(projectDescriptor);
                    }
                    ++j;
                }
                if (!projectDescriptors.isEmpty()) {
                    String imagePath = exampleElement.getAttribute("pageImage");
                    if (imagePath == null) break;
                    if (!(imagePath = imagePath.replace('\\', '/')).startsWith("/")) {
                        imagePath = "/" + imagePath;
                    }
                    Bundle pluginBundle = Platform.getBundle((String)exampleElement.getDeclaringExtension().getContributor().getName());
                    try {
                        ImageDescriptor imageDescriptor = ImageDescriptor.createFromURL((URL)pluginBundle.getEntry(imagePath));
                        this.setDefaultPageImageDescriptor(imageDescriptor);
                    }
                    catch (Exception exception) {}
                    break;
                }
            }
            ++i;
        }
        return projectDescriptors;
    }
}

