/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.importing.xml.wizards;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.epf.common.serviceability.MsgBox;
import org.eclipse.epf.importing.xml.XmlImportPlugin;
import org.eclipse.epf.importing.xml.XmlImportResources;
import org.eclipse.epf.importing.xml.services.XmlImportService;
import org.eclipse.epf.importing.xml.wizards.SelectXmlFilePage;
import org.eclipse.epf.library.ILibraryManager;
import org.eclipse.epf.library.LibraryService;
import org.eclipse.epf.library.ui.wizards.LibraryBackupUtil;
import org.eclipse.epf.uma.util.ContentDescriptionFactory;
import org.eclipse.epf.uma.util.IFileManager;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.IImportWizard;
import org.eclipse.ui.IWorkbench;

public class ImportXmlWizard
extends Wizard
implements IImportWizard {
    XmlImportService service = new XmlImportService();
    private SelectXmlFilePage filePage = null;

    public ImportXmlWizard() {
        this.setWindowTitle(XmlImportResources.ImportXmlWizard_title);
        this.setNeedsProgressMonitor(true);
    }

    public boolean performFinish() {
        LibraryBackupUtil.promptBackupLibrary(null, (File)new File(LibraryService.getInstance().getCurrentMethodLibraryPath()));
        IRunnableWithProgress op = new IRunnableWithProgress(){

            /*
             * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void run(IProgressMonitor monitor) throws InvocationTargetException {
                try {
                    try {
                        monitor.beginTask(XmlImportResources.importXmlProgress_text, -1);
                        String path = ImportXmlWizard.this.filePage.getPath();
                        ImportXmlWizard.this.service.loadXml(path);
                        ImportXmlWizard.this.service.doImport(monitor);
                    }
                    catch (Exception e) {
                        throw new InvocationTargetException(e);
                    }
                }
                catch (Throwable throwable) {
                    Object var3_5 = null;
                    monitor.done();
                    throw throwable;
                }
                {
                    Object var3_6 = null;
                }
                monitor.done();
            }
        };
        try {
            this.getContainer().run(true, false, op);
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        catch (InvocationTargetException e) {
            Throwable realException = e.getTargetException();
            XmlImportPlugin.getDefault().getMsgDialog().displayError(XmlImportResources.ImportXmlWizardError_title, realException.getMessage(), realException);
            return false;
        }
        String msg = String.valueOf(XmlImportResources.ImportXmlWizard_review_log) + this.service.getLogPath();
        MsgBox.prompt((String)msg, (int)32);
        return true;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
    }

    public void addPages() {
        IFileManager fileMgr = ContentDescriptionFactory.getFileManager();
        fileMgr.checkModify(LibraryService.getInstance().getCurrentMethodLibrary().eResource().getURI().toFileString(), (Object)MsgBox.getDefaultShell());
        ILibraryManager manager = LibraryService.getInstance().getCurrentLibraryManager();
        if (manager != null && manager.isMethodLibraryReadOnly()) {
            File libraryFile = new File(LibraryService.getInstance().getCurrentMethodLibraryPath(), "library.xmi");
            XmlImportPlugin.getDefault().getMsgDialog().displayError(XmlImportResources.ImportXmlWizardError_title, XmlImportResources.ImportXmlWizardError_msg, NLS.bind((String)XmlImportResources.ImportXmlWizardError_reason, (Object)libraryFile.getAbsolutePath()));
            return;
        }
        this.filePage = new SelectXmlFilePage();
        this.addPage((IWizardPage)this.filePage);
    }

    public void dispose() {
        this.service.dispose();
    }
}

