/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.views.properties;

import com.ibm.icu.text.SimpleDateFormat;
import java.io.File;
import java.util.Date;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IPath;
import org.eclipse.ui.internal.views.properties.IDEPropertiesMessages;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.IResourcePropertyConstants;
import org.eclipse.ui.views.properties.PropertyDescriptor;

public class ResourcePropertySource
implements IPropertySource {
    protected static String NOT_LOCAL_TEXT = IDEPropertiesMessages.PropertySource_notLocal;
    protected static String FILE_NOT_FOUND = IDEPropertiesMessages.PropertySource_notFound;
    protected static String UNDEFINED_PATH_VARIABLE = IDEPropertiesMessages.PropertySource_undefinedPathVariable;
    protected static String FILE_NOT_EXIST_TEXT = IDEPropertiesMessages.PropertySource_fileNotExist;
    protected IResource element;
    protected String errorMessage = IDEPropertiesMessages.PropertySource_readOnly;
    protected static IPropertyDescriptor[] propertyDescriptors = new IPropertyDescriptor[7];
    protected static IPropertyDescriptor[] propertyDescriptorsLinkVariable = new IPropertyDescriptor[8];

    static {
        PropertyDescriptor descriptor = new PropertyDescriptor((Object)"org.eclipse.jface.text", IResourcePropertyConstants.P_LABEL_RES);
        descriptor.setAlwaysIncompatible(true);
        descriptor.setCategory(IResourcePropertyConstants.P_FILE_SYSTEM_CATEGORY);
        ResourcePropertySource.propertyDescriptors[0] = descriptor;
        ResourcePropertySource.propertyDescriptorsLinkVariable[0] = descriptor;
        descriptor = new PropertyDescriptor((Object)"org.eclipse.ui.path", IResourcePropertyConstants.P_DISPLAYPATH_RES);
        descriptor.setAlwaysIncompatible(true);
        descriptor.setCategory(IResourcePropertyConstants.P_FILE_SYSTEM_CATEGORY);
        ResourcePropertySource.propertyDescriptors[1] = descriptor;
        ResourcePropertySource.propertyDescriptorsLinkVariable[1] = descriptor;
        descriptor = new PropertyDescriptor((Object)"org.eclipse.ui.editable", IResourcePropertyConstants.P_DISPLAYEDITABLE_RES);
        descriptor.setAlwaysIncompatible(true);
        descriptor.setCategory(IResourcePropertyConstants.P_FILE_SYSTEM_CATEGORY);
        ResourcePropertySource.propertyDescriptors[2] = descriptor;
        ResourcePropertySource.propertyDescriptorsLinkVariable[2] = descriptor;
        descriptor = new PropertyDescriptor((Object)"org.eclipse.ui.derived", IResourcePropertyConstants.P_DISPLAYDERIVED_RES);
        descriptor.setAlwaysIncompatible(true);
        descriptor.setCategory(IResourcePropertyConstants.P_FILE_SYSTEM_CATEGORY);
        ResourcePropertySource.propertyDescriptors[3] = descriptor;
        ResourcePropertySource.propertyDescriptorsLinkVariable[3] = descriptor;
        descriptor = new PropertyDescriptor((Object)"org.eclipse.ui.lastmodified", IResourcePropertyConstants.P_DISPLAY_LAST_MODIFIED);
        descriptor.setAlwaysIncompatible(true);
        descriptor.setCategory(IResourcePropertyConstants.P_FILE_SYSTEM_CATEGORY);
        ResourcePropertySource.propertyDescriptors[4] = descriptor;
        ResourcePropertySource.propertyDescriptorsLinkVariable[4] = descriptor;
        descriptor = new PropertyDescriptor((Object)"org.eclipse.ui.linked", IResourcePropertyConstants.P_DISPLAYLINKED_RES);
        descriptor.setAlwaysIncompatible(true);
        descriptor.setCategory(IResourcePropertyConstants.P_FILE_SYSTEM_CATEGORY);
        ResourcePropertySource.propertyDescriptors[5] = descriptor;
        ResourcePropertySource.propertyDescriptorsLinkVariable[5] = descriptor;
        descriptor = new PropertyDescriptor((Object)"org.eclipse.ui.location", IResourcePropertyConstants.P_DISPLAYLOCATION_RES);
        descriptor.setAlwaysIncompatible(true);
        descriptor.setCategory(IResourcePropertyConstants.P_FILE_SYSTEM_CATEGORY);
        ResourcePropertySource.propertyDescriptors[6] = descriptor;
        ResourcePropertySource.propertyDescriptorsLinkVariable[6] = descriptor;
        descriptor = new PropertyDescriptor((Object)"org.eclipse.ui.resolvedLocation", IResourcePropertyConstants.P_DISPLAYRESOLVED_LOCATION_RES);
        descriptor.setAlwaysIncompatible(true);
        descriptor.setCategory(IResourcePropertyConstants.P_FILE_SYSTEM_CATEGORY);
        ResourcePropertySource.propertyDescriptorsLinkVariable[7] = descriptor;
    }

    public ResourcePropertySource(IResource res) {
        Assert.isNotNull((Object)res);
        this.element = res;
    }

    private String getDateStringValue(IResource resource) {
        if (!resource.isLocal(0)) {
            return NOT_LOCAL_TEXT;
        }
        IPath location = resource.getLocation();
        if (location == null) {
            if (resource.isLinked()) {
                return UNDEFINED_PATH_VARIABLE;
            }
            return FILE_NOT_FOUND;
        }
        File localFile = location.toFile();
        if (localFile.exists()) {
            SimpleDateFormat format = new SimpleDateFormat();
            return format.format(new Date(localFile.lastModified()));
        }
        return FILE_NOT_FOUND;
    }

    public Object getEditableValue() {
        return this;
    }

    private String getLocationText(IResource resource) {
        File file;
        IPath resolvedLocation;
        if (!resource.isLocal(0)) {
            return NOT_LOCAL_TEXT;
        }
        IPath location = resolvedLocation = resource.getLocation();
        if (resource.isLinked()) {
            location = resource.getRawLocation();
        }
        if (location == null) {
            return FILE_NOT_FOUND;
        }
        String locationString = location.toOSString();
        if (resolvedLocation != null && !this.isPathVariable(resource) && !(file = resolvedLocation.toFile()).exists()) {
            locationString = String.valueOf(locationString) + " " + FILE_NOT_EXIST_TEXT;
        }
        return locationString;
    }

    private String getResolvedLocationText(IResource resource) {
        if (!resource.isLocal(0)) {
            return NOT_LOCAL_TEXT;
        }
        IPath location = resource.getLocation();
        if (location == null) {
            if (resource.isLinked()) {
                return UNDEFINED_PATH_VARIABLE;
            }
            return FILE_NOT_FOUND;
        }
        String locationString = location.toOSString();
        File file = location.toFile();
        if (!file.exists()) {
            locationString = String.valueOf(locationString) + " " + FILE_NOT_EXIST_TEXT;
        }
        return locationString;
    }

    public IPropertyDescriptor[] getPropertyDescriptors() {
        if (this.isPathVariable(this.element)) {
            return propertyDescriptorsLinkVariable;
        }
        return propertyDescriptors;
    }

    public Object getPropertyValue(Object name) {
        if (name.equals("org.eclipse.jface.text")) {
            return this.element.getName();
        }
        if (name.equals("org.eclipse.ui.path")) {
            return this.element.getFullPath().toString();
        }
        if (name.equals("org.eclipse.ui.lastmodified")) {
            return this.getDateStringValue(this.element);
        }
        if (name.equals("org.eclipse.ui.editable")) {
            if (this.element.isReadOnly()) {
                return IDEPropertiesMessages.ResourceProperty_false;
            }
            return IDEPropertiesMessages.ResourceProperty_true;
        }
        if (name.equals("org.eclipse.ui.derived")) {
            return String.valueOf(this.element.isDerived());
        }
        if (name.equals("org.eclipse.ui.linked")) {
            return String.valueOf(this.element.isLinked());
        }
        if (name.equals("org.eclipse.ui.location")) {
            return this.getLocationText(this.element);
        }
        if (name.equals("org.eclipse.ui.resolvedLocation")) {
            return this.getResolvedLocationText(this.element);
        }
        return null;
    }

    private boolean isPathVariable(IResource resource) {
        if (!resource.isLinked()) {
            return false;
        }
        IPath resolvedLocation = resource.getLocation();
        if (resolvedLocation == null) {
            return true;
        }
        IPath rawLocation = resource.getRawLocation();
        return !resolvedLocation.equals((Object)rawLocation);
    }

    public boolean isPropertySet(Object property) {
        return false;
    }

    public void resetPropertyValue(Object property) {
    }

    public void setPropertyValue(Object name, Object value) {
    }

    protected File getFile(IResource resource) {
        IPath location = resource.getLocation();
        if (location == null) {
            return null;
        }
        return location.toFile();
    }
}

