/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.publishing.wizards;

import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.epf.common.serviceability.MsgDialog;
import org.eclipse.epf.library.services.SafeUpdateController;
import org.eclipse.epf.publishing.PublishingResources;
import org.eclipse.epf.publishing.services.AbstractPublishManager;
import org.eclipse.epf.publishing.services.AbstractViewBuilder;
import org.eclipse.epf.publishing.ui.PublishingUIPlugin;
import org.eclipse.epf.publishing.ui.PublishingUIResources;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.SWT;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class PublishingOperation
implements IRunnableWithProgress {
    private static final String PUBLISH_CONFIG_ERROR_TITLE = PublishingUIResources.publishConfigDialog_title;
    private static final String PUBLISH_CONFIG_ERROR_MSG = PublishingUIResources.publishConfigError_msg;
    private static final String PUBLISH_CONFIG_ERROR_REASON = PublishingUIResources.publishConfigError_reason;
    private static final String PREVIEW_CONFIG_ERROR_TITLE = PublishingUIResources.previewConfigError_title;
    private static final String PREVIEW_CONFIG_ERROR_MSG = PublishingUIResources.previewConfigError_msg;
    private static final String VIEW_REPORT_ERROR_TITLE = PublishingUIResources.viewReportError_title;
    private static final String VIEW_REPORT_ERROR_MSG = PublishingUIResources.viewReportError_msg;
    private static final String OPEN_BROWSER_ERROR_REASON = PublishingUIResources.openBrowserError_reason;
    private static final String PUBLISH_CONFIG_CANCEL_MSG = PublishingUIResources.cancelPublishConfig_msg;
    private AbstractPublishManager publishMgr;
    private String published_url;
    private String report_url;
    private MsgDialog msgDialog;
    private Exception runException;

    public PublishingOperation(AbstractPublishManager publishMgr) {
        this.publishMgr = publishMgr;
        this.msgDialog = PublishingUIPlugin.getDefault().getMsgDialog();
    }

    public AbstractViewBuilder getViewBuilder() {
        return this.publishMgr.getViewBuilder();
    }

    public String getPublishedUrl() {
        return this.published_url;
    }

    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        this.runException = null;
        try {
            monitor.setTaskName(PublishingResources.publishingConfigurationTask_name);
            this.publishMgr.publish(monitor);
            this.published_url = this.publishMgr.getPublishedUrl();
            this.report_url = this.publishMgr.getPublishReportUrl();
        }
        catch (Exception e) {
            this.runException = e;
        }
        final boolean canceled = monitor.isCanceled();
        SafeUpdateController.syncExec((Runnable)new Runnable(){

            public void run() {
                String reason;
                if (canceled) {
                    PublishingOperation.this.msgDialog.displayInfo(PUBLISH_CONFIG_ERROR_TITLE, PUBLISH_CONFIG_CANCEL_MSG);
                    return;
                }
                if (PublishingOperation.this.published_url == null || PublishingOperation.this.report_url == null) {
                    PublishingOperation.this.msgDialog.displayError(PUBLISH_CONFIG_ERROR_TITLE, PUBLISH_CONFIG_ERROR_MSG, PUBLISH_CONFIG_ERROR_REASON, (Throwable)PublishingOperation.this.runException);
                    return;
                }
                if (!PublishingOperation.this.openBrowser(PublishingOperation.this.published_url)) {
                    reason = MessageFormat.format(OPEN_BROWSER_ERROR_REASON, PublishingOperation.this.published_url);
                    PublishingOperation.this.msgDialog.displayError(PREVIEW_CONFIG_ERROR_TITLE, PREVIEW_CONFIG_ERROR_MSG, reason);
                }
                if (!PublishingOperation.this.openBrowser(PublishingOperation.this.report_url)) {
                    reason = MessageFormat.format(OPEN_BROWSER_ERROR_REASON, PublishingOperation.this.report_url);
                    PublishingOperation.this.msgDialog.displayError(VIEW_REPORT_ERROR_TITLE, VIEW_REPORT_ERROR_MSG, reason);
                }
            }
        });
    }

    public boolean openBrowser(final String url) {
        boolean success = false;
        try {
            if (SWT.getPlatform().equals("win32")) {
                success = Program.launch((String)url);
            } else {
                success = true;
                Display.getCurrent().asyncExec(new Runnable(){

                    public void run() {
                        Shell shell = new Shell();
                        shell.setText(url);
                        GridLayout layout = new GridLayout();
                        layout.marginHeight = 0;
                        layout.marginWidth = 0;
                        shell.setLayout((Layout)layout);
                        Browser popup_browser = new Browser((Composite)shell, 0);
                        popup_browser.setLayoutData((Object)new GridData(1808));
                        popup_browser.setUrl(url);
                        shell.open();
                    }
                });
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            success = false;
        }
        return success;
    }
}

