/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.views.properties.tabbed;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.internal.views.properties.tabbed.view.Tab;
import org.eclipse.ui.internal.views.properties.tabbed.view.TabDescriptor;
import org.eclipse.ui.internal.views.properties.tabbed.view.TabListContentProvider;
import org.eclipse.ui.internal.views.properties.tabbed.view.TabbedPropertyComposite;
import org.eclipse.ui.internal.views.properties.tabbed.view.TabbedPropertyRegistry;
import org.eclipse.ui.internal.views.properties.tabbed.view.TabbedPropertyRegistryFactory;
import org.eclipse.ui.internal.views.properties.tabbed.view.TabbedPropertyTitle;
import org.eclipse.ui.internal.views.properties.tabbed.view.TabbedPropertyViewer;
import org.eclipse.ui.part.IContributedContentsView;
import org.eclipse.ui.part.Page;
import org.eclipse.ui.views.properties.IPropertySheetPage;
import org.eclipse.ui.views.properties.PropertySheet;
import org.eclipse.ui.views.properties.tabbed.ITabSelectionListener;
import org.eclipse.ui.views.properties.tabbed.ITabbedPropertySheetPageContributor;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;

public class TabbedPropertySheetPage
extends Page
implements IPropertySheetPage,
ILabelProviderListener {
    private TabbedPropertyComposite tabbedPropertyComposite;
    private TabbedPropertySheetWidgetFactory widgetFactory;
    private ITabbedPropertySheetPageContributor contributor;
    private TabbedPropertyRegistry registry;
    private ITabbedPropertySheetPageContributor selectionContributor = null;
    private String currentContributorId;
    protected IStructuredContentProvider tabListContentProvider;
    private ISelection currentSelection;
    private boolean activePropertySheet;
    private TabbedPropertyViewer tabbedPropertyViewer;
    private Tab currentTab;
    private Map descriptorToTab;
    private Map tabToComposite;
    private List selectionQueue;
    private boolean selectionQueueLocked;
    private List tabSelectionListeners;
    private IWorkbenchWindow cachedWorkbenchWindow;
    private boolean hasTitleBar;
    private IPartListener partActivationListener = new IPartListener(){

        public void partActivated(IWorkbenchPart part) {
            TabbedPropertySheetPage.this.handlePartActivated(part);
        }

        public void partBroughtToTop(IWorkbenchPart part) {
        }

        public void partClosed(IWorkbenchPart part) {
        }

        public void partDeactivated(IWorkbenchPart part) {
        }

        public void partOpened(IWorkbenchPart part) {
        }
    };
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public TabbedPropertySheetPage(ITabbedPropertySheetPageContributor tabbedPropertySheetPageContributor) {
        this.contributor = tabbedPropertySheetPageContributor;
        this.tabToComposite = new HashMap();
        this.selectionQueue = new ArrayList(10);
        this.tabSelectionListeners = new ArrayList();
        this.initContributor(this.contributor.getContributorId());
    }

    protected void handlePartActivated(IWorkbenchPart part) {
        boolean thisActivated;
        boolean bl = thisActivated = part instanceof PropertySheet && ((PropertySheet)part).getCurrentPage() == this;
        if (!thisActivated && !part.equals(this.contributor)) {
            IContributedContentsView view;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.ui.part.IContributedContentsView");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((view = (IContributedContentsView)part.getAdapter((Class)clazz)) == null || view.getContributingPart() != null && !view.getContributingPart().equals(this.contributor)) {
                if (this.activePropertySheet) {
                    if (this.currentTab != null) {
                        this.currentTab.aboutToBeHidden();
                    }
                    this.activePropertySheet = false;
                }
                return;
            }
        }
        if (!this.activePropertySheet && this.currentTab != null) {
            this.currentTab.aboutToBeShown();
            this.currentTab.refresh();
        }
        this.activePropertySheet = true;
    }

    public void createControl(Composite parent) {
        this.widgetFactory = new TabbedPropertySheetWidgetFactory();
        this.tabbedPropertyComposite = new TabbedPropertyComposite(parent, this.widgetFactory, this.hasTitleBar);
        this.widgetFactory.paintBordersFor(this.tabbedPropertyComposite);
        this.tabbedPropertyComposite.setLayout((Layout)new FormLayout());
        FormData formData = new FormData();
        formData.left = new FormAttachment(0, 0);
        formData.right = new FormAttachment(100, 0);
        formData.top = new FormAttachment(0, 0);
        formData.bottom = new FormAttachment(100, 0);
        this.tabbedPropertyComposite.setLayoutData(formData);
        this.tabbedPropertyViewer = new TabbedPropertyViewer(this.tabbedPropertyComposite.getList());
        this.tabbedPropertyViewer.setContentProvider((IContentProvider)this.tabListContentProvider);
        this.tabbedPropertyViewer.setLabelProvider((IBaseLabelProvider)new TabbedPropertySheetPageLabelProvider());
        this.tabbedPropertyViewer.addSelectionChangedListener(new SelectionChangedListener());
        this.tabbedPropertyComposite.getScrolledComposite().addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                TabbedPropertySheetPage.this.resizeScrolledComposite();
            }
        });
        this.cachedWorkbenchWindow = this.getSite().getWorkbenchWindow();
        this.cachedWorkbenchWindow.getPartService().addPartListener(this.partActivationListener);
        if (this.hasTitleBar) {
            this.registry.getLabelProvider().addListener((ILabelProviderListener)this);
        }
    }

    private void initContributor(String contributorId) {
        this.descriptorToTab = new HashMap();
        if (this.contributor.getContributorId().equals(contributorId)) {
            this.registry = TabbedPropertyRegistryFactory.getInstance().createRegistry(this.contributor);
        } else {
            this.selectionContributor = new TabbedPropertySheetPageContributorFromSelection(contributorId);
            this.registry = TabbedPropertyRegistryFactory.getInstance().createRegistry(this.selectionContributor);
        }
        this.currentContributorId = contributorId;
        this.tabListContentProvider = this.getTabListContentProvider();
        boolean bl = this.hasTitleBar = this.registry.getLabelProvider() != null;
        if (this.tabbedPropertyViewer != null) {
            this.tabbedPropertyViewer.setContentProvider((IContentProvider)this.tabListContentProvider);
        }
        if (this.hasTitleBar) {
            this.registry.getLabelProvider().addListener((ILabelProviderListener)this);
        }
    }

    protected IStructuredContentProvider getTabListContentProvider() {
        return new TabListContentProvider(this.registry);
    }

    private void disposeContributor() {
        if (this.currentTab != null) {
            this.currentTab.aboutToBeHidden();
            this.currentTab = null;
        }
        this.disposeTabs(this.descriptorToTab.values());
        this.descriptorToTab = new HashMap();
        if (this.hasTitleBar && this.registry != null) {
            this.registry.getLabelProvider().removeListener((ILabelProviderListener)this);
        }
        if (this.selectionContributor != null) {
            TabbedPropertyRegistryFactory.getInstance().disposeRegistry(this.selectionContributor);
            this.selectionContributor = null;
        }
    }

    public void dispose() {
        this.disposeContributor();
        if (this.widgetFactory != null) {
            this.widgetFactory.dispose();
            this.widgetFactory = null;
        }
        if (this.cachedWorkbenchWindow != null) {
            this.cachedWorkbenchWindow.getPartService().removePartListener(this.partActivationListener);
            this.cachedWorkbenchWindow = null;
        }
        if (this.registry != null) {
            TabbedPropertyRegistryFactory.getInstance().disposeRegistry(this.contributor);
            this.registry = null;
        }
    }

    public Control getControl() {
        return this.tabbedPropertyComposite;
    }

    public void setActionBars(IActionBars actionBars) {
        if (this.contributor instanceof IEditorPart) {
            IEditorPart editorPart = (IEditorPart)this.contributor;
            IActionBars editorActionBars = editorPart.getEditorSite().getActionBars();
            actionBars.setGlobalActionHandler(ActionFactory.UNDO.getId(), editorActionBars.getGlobalActionHandler(ActionFactory.UNDO.getId()));
            actionBars.setGlobalActionHandler(ActionFactory.REDO.getId(), editorActionBars.getGlobalActionHandler(ActionFactory.REDO.getId()));
        }
    }

    public void setFocus() {
        this.getControl().setFocus();
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        this.setInput(part, selection);
    }

    private void storeCurrentTabSelection(String label) {
        if (!this.selectionQueueLocked) {
            this.selectionQueue.remove(label);
            this.selectionQueue.add(0, label);
        }
    }

    private void resizeScrolledComposite() {
        Point currentTabSize = new Point(0, 0);
        if (this.currentTab != null) {
            Composite sizeReference = (Composite)this.tabToComposite.get(this.currentTab);
            currentTabSize.y = sizeReference != null ? sizeReference.computeSize((int)-1, (int)-1).y : 0;
            int n = currentTabSize.x = sizeReference != null ? sizeReference.computeSize((int)-1, (int)-1).x : 0;
        }
        if (this.hasTitleBar) {
            int titleHeight = this.tabbedPropertyComposite.getTitle().computeSize((int)-1, (int)-1).y;
            currentTabSize.y += titleHeight;
        }
        this.tabbedPropertyComposite.getScrolledComposite().setMinSize(currentTabSize.x, currentTabSize.y);
    }

    private void disposeTabs(Collection tabs) {
        Iterator iter = tabs.iterator();
        while (iter.hasNext()) {
            Tab tab = (Tab)iter.next();
            Composite composite = (Composite)this.tabToComposite.remove(tab);
            tab.dispose();
            if (composite == null) continue;
            composite.dispose();
        }
    }

    private int getLastTabSelection(IWorkbenchPart part, ISelection input) {
        TabDescriptor[] descriptors = this.registry.getTabDescriptors(part, input);
        if (descriptors.length != 0) {
            Iterator iter = this.selectionQueue.iterator();
            while (iter.hasNext()) {
                String text = (String)iter.next();
                int i = 0;
                while (i < descriptors.length) {
                    if (text.equals(descriptors[i].getLabel())) {
                        return i;
                    }
                    ++i;
                }
            }
        }
        return 0;
    }

    protected void updateTabs(TabDescriptor[] descriptors) {
        HashMap<TabDescriptor, Tab> newTabs = new HashMap<TabDescriptor, Tab>(descriptors.length * 2);
        boolean disposingCurrentTab = this.currentTab != null;
        int i = 0;
        while (i < descriptors.length) {
            Tab tab = (Tab)this.descriptorToTab.remove(descriptors[i]);
            if (tab != null && tab.controlsHaveBeenCreated()) {
                if (tab == this.currentTab) {
                    disposingCurrentTab = false;
                }
            } else {
                tab = descriptors[i].createTab();
            }
            newTabs.put(descriptors[i], tab);
            ++i;
        }
        if (disposingCurrentTab) {
            this.currentTab.aboutToBeHidden();
            this.currentTab = null;
        }
        this.disposeTabs(this.descriptorToTab.values());
        this.descriptorToTab = newTabs;
    }

    private Composite createTabComposite() {
        Composite result = this.widgetFactory.createComposite(this.tabbedPropertyComposite.getTabComposite(), 524288);
        result.setVisible(false);
        result.setLayout((Layout)new FillLayout());
        FormData data = new FormData();
        data.top = this.hasTitleBar ? new FormAttachment((Control)this.tabbedPropertyComposite.getTitle(), 0) : new FormAttachment(0, 0);
        data.bottom = new FormAttachment(100, 0);
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment(100, 0);
        result.setLayoutData((Object)data);
        return result;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void setInput(IWorkbenchPart part, ISelection selection) {
        if (selection.equals(this.currentSelection)) {
            return;
        }
        this.currentSelection = selection;
        this.validateRegistry(selection);
        TabDescriptor[] descriptors = this.registry.getTabDescriptors(part, this.currentSelection);
        if (descriptors.length > 0) {
            this.updateTabs(descriptors);
        }
        this.tabbedPropertyViewer.setInput(part, this.currentSelection);
        int lastTabSelectionIndex = this.getLastTabSelection(part, this.currentSelection);
        Object selectedTab = this.tabbedPropertyViewer.getElementAt(lastTabSelectionIndex);
        this.selectionQueueLocked = true;
        try {
            if (selectedTab == null) {
                this.tabbedPropertyViewer.setSelection(null);
            } else {
                this.tabbedPropertyViewer.setSelection((ISelection)new StructuredSelection(selectedTab));
            }
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            this.selectionQueueLocked = false;
            throw throwable;
        }
        {
            Object var6_8 = null;
            this.selectionQueueLocked = false;
            this.refreshTitleBar();
            return;
        }
    }

    public void refresh() {
        this.currentTab.refresh();
    }

    public Tab getCurrentTab() {
        return this.currentTab;
    }

    private void handleTabSelection(TabDescriptor tabDescriptor) {
        if (this.selectionQueueLocked) {
            return;
        }
        Iterator i = this.tabSelectionListeners.iterator();
        while (i.hasNext()) {
            ITabSelectionListener listener = (ITabSelectionListener)i.next();
            listener.tabSelected(tabDescriptor);
        }
    }

    public void addTabSelectionListener(ITabSelectionListener listener) {
        this.tabSelectionListeners.add(listener);
    }

    public void removeTabSelectionListener(ITabSelectionListener listener) {
        this.tabSelectionListeners.remove(listener);
    }

    public TabbedPropertySheetWidgetFactory getWidgetFactory() {
        return this.widgetFactory;
    }

    private void refreshTitleBar() {
        if (this.hasTitleBar) {
            TabbedPropertyTitle title = this.tabbedPropertyComposite.getTitle();
            if (this.currentTab == null) {
                title.setTitle(null, null);
            } else {
                String text = this.registry.getLabelProvider().getText((Object)this.currentSelection);
                Image image = this.registry.getLabelProvider().getImage((Object)this.currentSelection);
                title.setTitle(text, image);
            }
        }
    }

    public void labelProviderChanged(LabelProviderChangedEvent event) {
        this.refreshTitleBar();
    }

    private ITabbedPropertySheetPageContributor getTabbedPropertySheetPageContributor(Object object) {
        Object object2;
        if (object instanceof IAdaptable) {
            IAdaptable iAdaptable = (IAdaptable)object;
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("org.eclipse.ui.views.properties.tabbed.ITabbedPropertySheetPageContributor");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            object2 = iAdaptable.getAdapter((Class)clazz);
        } else {
            object2 = object;
        }
        Object element = object2;
        return element instanceof ITabbedPropertySheetPageContributor ? (ITabbedPropertySheetPageContributor)element : null;
    }

    private void validateRegistry(ISelection selection) {
        if (selection == null) {
            return;
        }
        if (!(selection instanceof IStructuredSelection)) {
            return;
        }
        IStructuredSelection structuredSelection = (IStructuredSelection)selection;
        if (structuredSelection.size() == 0) {
            return;
        }
        ITabbedPropertySheetPageContributor newContributor = this.getTabbedPropertySheetPageContributor(structuredSelection.getFirstElement());
        if (newContributor == null) {
            return;
        }
        String selectionContributorId = newContributor.getContributorId();
        if (selectionContributorId.equals(this.currentContributorId)) {
            return;
        }
        Iterator i = structuredSelection.iterator();
        i.next();
        while (i.hasNext()) {
            newContributor = this.getTabbedPropertySheetPageContributor(i.next());
            if (newContributor != null && newContributor.getContributorId().equals(selectionContributorId)) continue;
            if (this.selectionContributor != null) {
                this.disposeContributor();
                this.currentContributorId = this.contributor.getContributorId();
                this.initContributor(this.currentContributorId);
            }
            return;
        }
        this.disposeContributor();
        this.currentContributorId = selectionContributorId;
        this.initContributor(this.currentContributorId);
    }

    class SelectionChangedListener
    implements ISelectionChangedListener {
        SelectionChangedListener() {
        }

        public void selectionChanged(SelectionChangedEvent event) {
            IStructuredSelection selection = (IStructuredSelection)event.getSelection();
            Tab tab = null;
            TabDescriptor descriptor = (TabDescriptor)selection.getFirstElement();
            if (descriptor == null) {
                this.hideTab(TabbedPropertySheetPage.this.currentTab);
            } else {
                Composite tabComposite;
                tab = (Tab)TabbedPropertySheetPage.this.descriptorToTab.get(descriptor);
                if (tab != TabbedPropertySheetPage.this.currentTab) {
                    this.hideTab(TabbedPropertySheetPage.this.currentTab);
                }
                if ((tabComposite = (Composite)TabbedPropertySheetPage.this.tabToComposite.get(tab)) == null) {
                    tabComposite = TabbedPropertySheetPage.this.createTabComposite();
                    tab.createControls(tabComposite, TabbedPropertySheetPage.this);
                    TabbedPropertySheetPage.this.tabToComposite.put(tab, tabComposite);
                }
                tab.setInput(TabbedPropertySheetPage.this.tabbedPropertyViewer.getWorkbenchPart(), (ISelection)TabbedPropertySheetPage.this.tabbedPropertyViewer.getInput());
                TabbedPropertySheetPage.this.storeCurrentTabSelection(descriptor.getLabel());
                if (tab != TabbedPropertySheetPage.this.currentTab) {
                    this.showTab(tab);
                }
                tab.refresh();
            }
            TabbedPropertySheetPage.this.tabbedPropertyComposite.getTabComposite().layout(true);
            TabbedPropertySheetPage.this.currentTab = tab;
            TabbedPropertySheetPage.this.resizeScrolledComposite();
            if (descriptor != null) {
                TabbedPropertySheetPage.this.handleTabSelection(descriptor);
            }
        }

        private void showTab(Tab target) {
            Composite tabComposite;
            if (target != null && (tabComposite = (Composite)TabbedPropertySheetPage.this.tabToComposite.get(target)) != null) {
                tabComposite.moveAbove(null);
                target.aboutToBeShown();
                tabComposite.setVisible(true);
            }
        }

        private void hideTab(Tab target) {
            Composite tabComposite;
            if (target != null && (tabComposite = (Composite)TabbedPropertySheetPage.this.tabToComposite.get(target)) != null) {
                target.aboutToBeHidden();
                tabComposite.setVisible(false);
            }
        }
    }

    private class TabbedPropertySheetPageContributorFromSelection
    implements ITabbedPropertySheetPageContributor {
        private String contributorId;

        public TabbedPropertySheetPageContributorFromSelection(String contributorId) {
            this.contributorId = contributorId;
        }

        public String getContributorId() {
            return this.contributorId;
        }
    }

    class TabbedPropertySheetPageLabelProvider
    extends LabelProvider {
        TabbedPropertySheetPageLabelProvider() {
        }

        public String getText(Object element) {
            if (element instanceof TabDescriptor) {
                return ((TabDescriptor)element).getLabel();
            }
            return null;
        }
    }
}

