/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.importing.xml.wizards;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.epf.authoring.ui.wizards.SaveAllEditorsPage;
import org.eclipse.epf.common.serviceability.MsgBox;
import org.eclipse.epf.export.xml.ExportXMLPlugin;
import org.eclipse.epf.importing.xml.ImportXMLPlugin;
import org.eclipse.epf.importing.xml.ImportXMLResources;
import org.eclipse.epf.importing.xml.preferences.ImportXMLPreferences;
import org.eclipse.epf.importing.xml.services.ImportXMLService;
import org.eclipse.epf.importing.xml.wizards.SelectXMLFilePage;
import org.eclipse.epf.library.ILibraryManager;
import org.eclipse.epf.library.LibraryService;
import org.eclipse.epf.library.ui.wizards.LibraryBackupUtil;
import org.eclipse.epf.uma.util.ContentDescriptionFactory;
import org.eclipse.epf.uma.util.IFileManager;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IImportWizard;
import org.eclipse.ui.IWorkbench;

public class ImportXMLWizard
extends Wizard
implements IImportWizard {
    ImportXMLService service = new ImportXMLService();
    private boolean succeed = true;
    private SelectXMLFilePage filePage = null;

    public ImportXMLWizard() {
        this.setWindowTitle(ImportXMLResources.importXMLWizard_title);
        this.setNeedsProgressMonitor(true);
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
    }

    public void addPages() {
        IFileManager fileMgr = ContentDescriptionFactory.getFileManager();
        fileMgr.checkModify(LibraryService.getInstance().getCurrentMethodLibrary().eResource().getURI().toFileString(), (Object)MsgBox.getDefaultShell());
        ILibraryManager manager = LibraryService.getInstance().getCurrentLibraryManager();
        if (manager != null && manager.isMethodLibraryReadOnly()) {
            File libraryFile = new File(LibraryService.getInstance().getCurrentMethodLibraryPath(), "library.xmi");
            ImportXMLPlugin.getDefault().getMsgDialog().displayError(ImportXMLResources.importXMLWizard_title, ImportXMLResources.importXMLError_msg, NLS.bind((String)ImportXMLResources.importXMLError_reason, (Object)libraryFile.getAbsolutePath()));
            return;
        }
        SaveAllEditorsPage.addPageIfNeeded((Wizard)this, (boolean)true, null, null, (ImageDescriptor)ImportXMLPlugin.getDefault().getImageDescriptor("full/wizban/ImportXML.gif"));
        this.filePage = new SelectXMLFilePage();
        this.addPage((IWizardPage)this.filePage);
    }

    public void createPageControls(Composite pageContainer) {
        super.createPageControls(pageContainer);
        pageContainer.getShell().setImage(ExportXMLPlugin.getDefault().getSharedImage("full/obj16/XMLFile.gif"));
    }

    public boolean performFinish() {
        LibraryBackupUtil.promptBackupLibrary(null, (File)new File(LibraryService.getInstance().getCurrentMethodLibraryPath()));
        IRunnableWithProgress op = new IRunnableWithProgress(){

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void run(IProgressMonitor monitor) throws InvocationTargetException {
                block7: {
                    block6: {
                        try {
                            try {
                                monitor.beginTask(ImportXMLResources.importingXML_text, -1);
                                String xmlFile = ImportXMLWizard.this.filePage.getPath();
                                boolean mergeOption = ImportXMLWizard.this.filePage.getMergeOption();
                                ImportXMLWizard.this.service.setOverwrite(!mergeOption);
                                ImportXMLWizard.this.succeed = ImportXMLWizard.this.service.loadXml(xmlFile);
                                if (!ImportXMLWizard.this.succeed) {
                                    Object var4_5 = null;
                                    break block6;
                                }
                                ImportXMLWizard.this.service.doImport(monitor);
                                ImportXMLPreferences.setXMLFile(xmlFile);
                                ImportXMLPreferences.setMergeOption(mergeOption);
                                break block7;
                            }
                            catch (Exception e) {
                                throw new InvocationTargetException(e);
                            }
                        }
                        catch (Throwable throwable) {
                            Object var4_6 = null;
                            monitor.done();
                            throw throwable;
                        }
                    }
                    monitor.done();
                    return;
                }
                Object var4_7 = null;
                monitor.done();
            }
        };
        try {
            this.getContainer().run(true, false, op);
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        catch (InvocationTargetException e) {
            Throwable realException = e.getTargetException();
            ImportXMLPlugin.getDefault().getMsgDialog().displayError(ImportXMLResources.importXMLWizard_title, realException.getMessage(), realException);
            return false;
        }
        if (!this.succeed) {
            return false;
        }
        String msg = NLS.bind((String)ImportXMLResources.review_log_files, (Object)this.service.getLogPath());
        MsgBox.prompt((String)msg, (int)32);
        return true;
    }

    public void dispose() {
        this.service.dispose();
    }
}

