/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.authoring.ui.actions;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.epf.authoring.ui.AuthoringPerspective;
import org.eclipse.epf.authoring.ui.AuthoringUIPlugin;
import org.eclipse.epf.authoring.ui.AuthoringUIResources;
import org.eclipse.epf.authoring.ui.PerspectiveListUtil;
import org.eclipse.epf.authoring.ui.wizards.NewMethodPluginWizard;
import org.eclipse.epf.common.utils.PerspectiveUtil;
import org.eclipse.epf.library.LibraryService;
import org.eclipse.epf.library.edit.ui.UserInteractionHelper;
import org.eclipse.epf.uma.MethodLibrary;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.ui.PlatformUI;

public class NewPluginAction
extends Action
implements IWorkbenchWindowActionDelegate {
    private IWorkbenchWindow window;

    public NewPluginAction() {
    }

    public NewPluginAction(String text) {
        super(text);
    }

    public void init(IWorkbenchWindow window) {
        this.window = window;
    }

    public void run(IAction action) {
        NewPluginAction.execute(this.window.getWorkbench(), null);
    }

    public void run() {
        NewPluginAction.execute(PlatformUI.getWorkbench(), null);
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }

    public void dispose() {
    }

    public static void execute(IWorkbench workbench, ISelection selection) {
        MethodLibrary targetLib = LibraryService.getInstance().getCurrentMethodLibrary();
        if (targetLib == null) {
            AuthoringUIPlugin.getDefault().getMsgDialog().displayError(AuthoringUIResources.newPluginWizard_title, AuthoringUIResources.noOpenLibraryError_msg);
            return;
        }
        Shell shell = Display.getCurrent().getActiveShell();
        IStatus status = UserInteractionHelper.checkModify((EObject)targetLib, (Shell)shell);
        if (!status.isOK()) {
            AuthoringUIPlugin.getDefault().getMsgDialog().display(AuthoringUIResources.newPluginWizard_title, AuthoringUIResources.newPluginWizard_createError, status);
            return;
        }
        NewMethodPluginWizard wizard = new NewMethodPluginWizard();
        if (selection instanceof IStructuredSelection || selection == null) {
            wizard.init(workbench, (IStructuredSelection)selection);
        }
        WizardDialog dialog = new WizardDialog(shell, (IWizard)wizard);
        dialog.create();
        dialog.open();
        if (!PerspectiveListUtil.isAuthoringPerspective()) {
            PerspectiveUtil.openPerspective((String)AuthoringPerspective.PERSPECTIVE_ID);
        }
    }
}

