/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.authoring.ui.actions;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.edit.domain.IEditingDomainProvider;
import org.eclipse.emf.edit.ui.action.CommandActionHandler;
import org.eclipse.epf.authoring.ui.AuthoringUIPlugin;
import org.eclipse.epf.authoring.ui.actions.IWorkbenchPartAction;
import org.eclipse.epf.authoring.ui.actions.ProcessDeleteAction;
import org.eclipse.epf.authoring.ui.editors.MethodElementEditorInput;
import org.eclipse.epf.library.edit.LibraryEditResources;
import org.eclipse.epf.library.edit.process.BreakdownElementWrapperItemProvider;
import org.eclipse.epf.library.edit.process.command.SynchronizeCommand;
import org.eclipse.epf.library.edit.ui.UserInteractionHelper;
import org.eclipse.epf.library.edit.util.ProcessUtil;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.uma.Activity;
import org.eclipse.epf.uma.BreakdownElement;
import org.eclipse.epf.uma.Descriptor;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.Process;
import org.eclipse.epf.uma.ProcessComponent;
import org.eclipse.epf.uma.TeamProfile;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPart;

public class ProcessAutoSynchronizeAction
extends CommandActionHandler
implements IWorkbenchPartAction {
    protected IWorkbenchPart activeWorkbenchPart;
    protected boolean canRun;

    public ProcessAutoSynchronizeAction() {
        super(null, LibraryEditResources.AutoSynchronizeCommand_label);
    }

    public ProcessAutoSynchronizeAction(String labelText) {
        super(null, labelText);
    }

    public void setActiveWorkbenchPart(IWorkbenchPart workbenchPart) {
        this.activeWorkbenchPart = workbenchPart;
        if (workbenchPart instanceof IEditingDomainProvider) {
            this.domain = ((IEditingDomainProvider)workbenchPart).getEditingDomain();
        }
    }

    public Command createCommand(Collection selection) {
        return new SynchronizeCommand(this.getText(), selection){

            protected Command delete(List elements) {
                try {
                    return ProcessDeleteAction.delete(elements);
                }
                catch (OperationCanceledException operationCanceledException) {
                    this.aborted = true;
                    return null;
                }
            }
        };
    }

    protected Process getProcess() {
        MethodElement e;
        IEditorInput input;
        if (this.activeWorkbenchPart instanceof IEditorPart && (input = ((IEditorPart)this.activeWorkbenchPart).getEditorInput()) instanceof MethodElementEditorInput && (e = ((MethodElementEditorInput)input).getMethodElement()) instanceof ProcessComponent) {
            return ((ProcessComponent)e).getProcess();
        }
        return null;
    }

    public boolean updateSelection(IStructuredSelection selection) {
        ArrayList selected = new ArrayList();
        Iterator iter = selection.iterator();
        while (iter.hasNext()) {
            Object element = iter.next();
            if (element instanceof BreakdownElementWrapperItemProvider && !((BreakdownElementWrapperItemProvider)element).isReadOnly()) {
                element = TngUtil.unwrap(element);
            }
            boolean valid = false;
            if (element instanceof BreakdownElement) {
                if (element instanceof Descriptor) {
                    Descriptor desc = (Descriptor)element;
                    valid = ProcessUtil.getAssociatedElement((Descriptor)desc) != null && desc.getSuppressed() == false;
                } else if (((BreakdownElement)element).getSuperActivities() == null) {
                    if (element instanceof Process && ((Process)element).eContainer() instanceof ProcessComponent) {
                        valid = true;
                    }
                } else {
                    boolean bl = valid = element instanceof Activity || element instanceof TeamProfile;
                }
            }
            if (!valid) continue;
            selected.add(element);
        }
        if (selected.isEmpty()) {
            return false;
        }
        return super.updateSelection((IStructuredSelection)new StructuredSelection(selected));
    }

    public void run() {
        IRunnableWithProgress runnable = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                ProcessAutoSynchronizeAction.this.canRun = ((SynchronizeCommand)ProcessAutoSynchronizeAction.this.command).initilize();
            }
        };
        UserInteractionHelper.runWithProgress((IRunnableWithProgress)runnable, (String)LibraryEditResources.ProcessAutoSynchronizeAction_prepare);
        if (this.canRun) {
            super.run();
        } else {
            AuthoringUIPlugin.getDefault().getMsgDialog().displayInfo(this.getText(), LibraryEditResources.ProcessAutoSynchronizeAction_noDescriptorToSynch);
        }
    }
}

