/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.authoring.ui.forms;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.epf.authoring.ui.AuthoringUIResources;
import org.eclipse.epf.authoring.ui.AuthoringUIText;
import org.eclipse.epf.authoring.ui.editors.MethodElementEditor;
import org.eclipse.epf.authoring.ui.filters.ContentFilter;
import org.eclipse.epf.authoring.ui.forms.DescriptionFormPage;
import org.eclipse.epf.authoring.ui.richtext.IMethodRichText;
import org.eclipse.epf.library.edit.IFilter;
import org.eclipse.epf.library.edit.itemsfilter.FilterConstants;
import org.eclipse.epf.library.edit.itemsfilter.VariabilityBaseElementFilter;
import org.eclipse.epf.library.ui.LibraryUIText;
import org.eclipse.epf.uma.Checklist;
import org.eclipse.epf.uma.Concept;
import org.eclipse.epf.uma.ContentElement;
import org.eclipse.epf.uma.EstimationConsiderations;
import org.eclipse.epf.uma.Example;
import org.eclipse.epf.uma.Guidance;
import org.eclipse.epf.uma.Guideline;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.Practice;
import org.eclipse.epf.uma.Report;
import org.eclipse.epf.uma.ReusableAsset;
import org.eclipse.epf.uma.Roadmap;
import org.eclipse.epf.uma.SupportingMaterial;
import org.eclipse.epf.uma.Template;
import org.eclipse.epf.uma.TermDefinition;
import org.eclipse.epf.uma.ToolMentor;
import org.eclipse.epf.uma.UmaPackage;
import org.eclipse.epf.uma.VariabilityElement;
import org.eclipse.epf.uma.Whitepaper;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class GuidanceDescriptionPage
extends DescriptionFormPage {
    private static final String FORM_PAGE_ID = "guidanceDescriptionPage";
    protected Guidance guidance;
    private String elementLabel;
    private IMethodRichText ctrl_content;
    private int contentFieldHeight = 400;

    public GuidanceDescriptionPage(FormEditor editor) {
        super(editor, FORM_PAGE_ID, AuthoringUIText.DESCRIPTION_PAGE_TITLE);
    }

    public void init(IEditorSite site, IEditorInput input) {
        super.init(site, input);
        this.guidance = (Guidance)this.contentElement;
        this.elementLabel = LibraryUIText.getUIText((MethodElement)this.guidance);
        this.setElementTypeOn(true);
        if (this.guidance instanceof TermDefinition) {
            this.setBriefDescOn(false);
        }
        this.setFullDescOn(false);
        this.setKeyConsiderationOn(false);
        this.setIconSectionOn(true);
    }

    protected String getFormPrefix() {
        return LibraryUIText.TEXT_GUIDANCE + " (" + this.elementLabel + "): ";
    }

    protected void createEditorContent(FormToolkit toolkit) {
        super.createEditorContent(toolkit);
        this.ctrl_content = this.createRichTextEditWithLinkForSection(toolkit, this.detailComposite, AuthoringUIText.MAIN_DESCRIPTION_TEXT, this.contentFieldHeight, 400, 2);
    }

    protected void addListeners() {
        super.addListeners();
        final MethodElementEditor editor = (MethodElementEditor)this.getEditor();
        this.ctrl_content.setModalObject((EObject)this.contentElement.getPresentation());
        this.ctrl_content.setModalObjectFeature((EStructuralFeature)UmaPackage.eINSTANCE.getContentDescription_MainDescription());
        this.ctrl_content.addModifyListener(this.contentModifyListener);
        this.ctrl_content.addListener(27, new Listener(){

            public void handleEvent(Event e) {
                boolean success;
                IMethodRichText control;
                IMethodRichText iMethodRichText = control = GuidanceDescriptionPage.this.descExpandFlag ? GuidanceDescriptionPage.this.ctrl_expanded : GuidanceDescriptionPage.this.ctrl_content;
                if (!control.getModified()) {
                    return;
                }
                String oldContent = GuidanceDescriptionPage.this.guidance.getPresentation().getMainDescription();
                if (((MethodElementEditor)GuidanceDescriptionPage.this.getEditor()).mustRestoreValue(control, oldContent)) {
                    return;
                }
                String newContent = control.getText();
                if (!newContent.equals(oldContent) && (success = editor.getActionManager().doAction(1, (EObject)GuidanceDescriptionPage.this.contentElement.getPresentation(), (EStructuralFeature)UmaPackage.eINSTANCE.getContentDescription_MainDescription(), (Object)newContent, -1)) && GuidanceDescriptionPage.this.isVersionSectionOn()) {
                    GuidanceDescriptionPage.this.updateChangeDate();
                }
            }
        });
    }

    protected void refresh(boolean editable) {
        super.refresh(editable);
        this.ctrl_content.setEditable(editable);
    }

    protected void loadData() {
        super.loadData();
        if (this.guidance != null) {
            String content = null;
            if (this.guidance.getPresentation() != null) {
                content = this.guidance.getPresentation().getMainDescription();
            }
            this.ctrl_content.setText(content == null ? "" : content);
        }
    }

    protected Object getContentElement() {
        return this.guidance;
    }

    public int getContentFieldHeight() {
        return this.contentFieldHeight;
    }

    public void setContentFieldHeight(int contentFieldHeight) {
        this.contentFieldHeight = contentFieldHeight;
    }

    protected String getTabString() {
        return FilterConstants.GUIDANCE;
    }

    protected IFilter getFilter() {
        this.filter = new ContentFilter(){

            protected boolean childAccept(Object obj) {
                if (obj instanceof Guidance) {
                    return ((ContentElement)obj).getType().equals(((Guidance)GuidanceDescriptionPage.this.contentElement).getType());
                }
                return false;
            }
        };
        ((ContentFilter)this.filter).setAdditionalFilters(new IFilter[]{new VariabilityBaseElementFilter((VariabilityElement)this.guidance)});
        return this.filter;
    }

    public void loadSectionDescription() {
        if (this.contentElement instanceof Whitepaper) {
            this.generalSectionDescription = AuthoringUIResources.whitepaper_generalInfoSection_desc;
            this.detailSectionDescription = AuthoringUIResources.whitepaper_detailSection_desc;
            this.variabilitySectionDescription = AuthoringUIResources.whitepaper_variabilitySection_desc;
            this.versionSectionDescription = AuthoringUIResources.whitepaper_versionInfoSection_desc;
            this.iconSectionDescription = AuthoringUIResources.whitepaper_iconSection_desc;
        } else if (this.contentElement instanceof Concept) {
            this.generalSectionDescription = AuthoringUIResources.concept_generalInfoSection_desc;
            this.detailSectionDescription = AuthoringUIResources.concept_detailSection_desc;
            this.variabilitySectionDescription = AuthoringUIResources.concept_variabilitySection_desc;
            this.versionSectionDescription = AuthoringUIResources.concept_versionInfoSection_desc;
            this.iconSectionDescription = AuthoringUIResources.concept_iconSection_desc;
        } else if (this.contentElement instanceof Checklist) {
            this.generalSectionDescription = AuthoringUIResources.checklist_generalInfoSection_desc;
            this.detailSectionDescription = AuthoringUIResources.checklist_detailSection_desc;
            this.variabilitySectionDescription = AuthoringUIResources.checklist_variabilitySection_desc;
            this.versionSectionDescription = AuthoringUIResources.checklist_versionInfoSection_desc;
            this.iconSectionDescription = AuthoringUIResources.checklist_iconSection_desc;
        } else if (this.contentElement instanceof Example) {
            this.generalSectionDescription = AuthoringUIResources.example_generalInfoSection_desc;
            this.detailSectionDescription = AuthoringUIResources.example_detailSection_desc;
            this.variabilitySectionDescription = AuthoringUIResources.example_variabilitySection_desc;
            this.versionSectionDescription = AuthoringUIResources.example_versionInfoSection_desc;
            this.iconSectionDescription = AuthoringUIResources.example_iconSection_desc;
        } else if (this.contentElement instanceof Guideline) {
            this.generalSectionDescription = AuthoringUIResources.guideline_generalInfoSection_desc;
            this.detailSectionDescription = AuthoringUIResources.guideline_detailSection_desc;
            this.variabilitySectionDescription = AuthoringUIResources.guideline_variabilitySection_desc;
            this.versionSectionDescription = AuthoringUIResources.guideline_versionInfoSection_desc;
            this.iconSectionDescription = AuthoringUIResources.guideline_iconSection_desc;
        } else if (this.contentElement instanceof EstimationConsiderations) {
            this.generalSectionDescription = AuthoringUIResources.estimationconsideration_generalInfoSection_desc;
            this.detailSectionDescription = AuthoringUIResources.estimationconsideration_detailSection_desc;
            this.variabilitySectionDescription = AuthoringUIResources.estimationconsideration_variabilitySection_desc;
            this.versionSectionDescription = AuthoringUIResources.estimationconsideration_versionInfoSection_desc;
            this.iconSectionDescription = AuthoringUIResources.estimationconsideration_iconSection_desc;
        } else if (this.contentElement instanceof Practice) {
            this.generalSectionDescription = AuthoringUIResources.practice_generalInfoSection_desc;
            this.detailSectionDescription = AuthoringUIResources.practice_detailSection_desc;
            this.variabilitySectionDescription = AuthoringUIResources.practice_variabilitySection_desc;
            this.versionSectionDescription = AuthoringUIResources.practice_versionInfoSection_desc;
            this.iconSectionDescription = AuthoringUIResources.practice_iconSection_desc;
        } else if (this.contentElement instanceof SupportingMaterial) {
            this.generalSectionDescription = AuthoringUIResources.supportingmaterial_generalInfoSection_desc;
            this.detailSectionDescription = AuthoringUIResources.supportingmaterial_detailSection_desc;
            this.variabilitySectionDescription = AuthoringUIResources.supportingmaterial_variabilitySection_desc;
            this.versionSectionDescription = AuthoringUIResources.supportingmaterial_versionInfoSection_desc;
            this.iconSectionDescription = AuthoringUIResources.supportingmaterial_iconSection_desc;
        } else if (this.contentElement instanceof Report) {
            this.generalSectionDescription = AuthoringUIResources.report_generalInfoSection_desc;
            this.detailSectionDescription = AuthoringUIResources.report_detailSection_desc;
            this.variabilitySectionDescription = AuthoringUIResources.report_variabilitySection_desc;
            this.versionSectionDescription = AuthoringUIResources.report_versionInfoSection_desc;
            this.iconSectionDescription = AuthoringUIResources.report_iconSection_desc;
        } else if (this.contentElement instanceof Roadmap) {
            this.generalSectionDescription = AuthoringUIResources.roadmap_generalInfoSection_desc;
            this.detailSectionDescription = AuthoringUIResources.roadmap_detailSection_desc;
            this.variabilitySectionDescription = AuthoringUIResources.roadmap_variabilitySection_desc;
            this.versionSectionDescription = AuthoringUIResources.roadmap_versionInfoSection_desc;
            this.iconSectionDescription = AuthoringUIResources.roadmap_iconSection_desc;
        } else if (this.contentElement instanceof Template) {
            this.generalSectionDescription = AuthoringUIResources.template_generalInfoSection_desc;
            this.detailSectionDescription = AuthoringUIResources.template_detailSection_desc;
            this.variabilitySectionDescription = AuthoringUIResources.template_variabilitySection_desc;
            this.versionSectionDescription = AuthoringUIResources.template_versionInfoSection_desc;
            this.iconSectionDescription = AuthoringUIResources.template_iconSection_desc;
        } else if (this.contentElement instanceof TermDefinition) {
            this.generalSectionDescription = AuthoringUIResources.termdefinition_generalInfoSection_desc;
            this.detailSectionDescription = AuthoringUIResources.termdefinition_detailSection_desc;
            this.variabilitySectionDescription = AuthoringUIResources.termdefinition_variabilitySection_desc;
            this.versionSectionDescription = AuthoringUIResources.termdefinition_versionInfoSection_desc;
            this.iconSectionDescription = AuthoringUIResources.termdefinition_iconSection_desc;
        } else if (this.contentElement instanceof ReusableAsset) {
            this.generalSectionDescription = AuthoringUIResources.resuableasset_generalInfoSection_desc;
            this.detailSectionDescription = AuthoringUIResources.resuableasset_detailSection_desc;
            this.variabilitySectionDescription = AuthoringUIResources.resuableasset_variabilitySection_desc;
            this.versionSectionDescription = AuthoringUIResources.resuableasset_versionInfoSection_desc;
            this.iconSectionDescription = AuthoringUIResources.reusableasset_iconSection_desc;
        } else if (this.contentElement instanceof ToolMentor) {
            this.generalSectionDescription = AuthoringUIResources.toolmentor_generalInfoSection_desc;
            this.detailSectionDescription = AuthoringUIResources.toolmentor_detailSection_desc;
            this.variabilitySectionDescription = AuthoringUIResources.toolmentor_variabilitySection_desc;
            this.versionSectionDescription = AuthoringUIResources.toolmentor_versionInfoSection_desc;
            this.iconSectionDescription = AuthoringUIResources.toolmentor_iconSection_desc;
        }
    }
}

