/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.authoring.ui.properties;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.provider.ItemProviderAdapter;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.epf.authoring.ui.AuthoringUIPlugin;
import org.eclipse.epf.authoring.ui.AuthoringUIResources;
import org.eclipse.epf.authoring.ui.AuthoringUIText;
import org.eclipse.epf.authoring.ui.actions.ProcessDeleteAction;
import org.eclipse.epf.authoring.ui.dialogs.ItemsFilterDialog;
import org.eclipse.epf.authoring.ui.editors.ProcessEditor;
import org.eclipse.epf.authoring.ui.filters.ActivityVariaibilityFilter;
import org.eclipse.epf.authoring.ui.forms.ProcessBreakdownStructureFormPage;
import org.eclipse.epf.authoring.ui.properties.FormUI;
import org.eclipse.epf.authoring.ui.properties.PropertiesResources;
import org.eclipse.epf.authoring.ui.properties.PropertiesUtil;
import org.eclipse.epf.authoring.ui.properties.WorkBreakdownElementGeneralSection;
import org.eclipse.epf.authoring.ui.views.ProcessViewer;
import org.eclipse.epf.common.utils.StrUtil;
import org.eclipse.epf.library.configuration.ProcessVariabilityConfigurator;
import org.eclipse.epf.library.edit.IConfigurator;
import org.eclipse.epf.library.edit.IFilter;
import org.eclipse.epf.library.edit.TngAdapterFactory;
import org.eclipse.epf.library.edit.command.DeleteMethodElementCommand;
import org.eclipse.epf.library.edit.command.IResourceAwareCommand;
import org.eclipse.epf.library.edit.itemsfilter.FilterConstants;
import org.eclipse.epf.library.edit.process.IBSItemProvider;
import org.eclipse.epf.library.edit.process.command.ActivityVariabilityCommand;
import org.eclipse.epf.library.edit.util.ProcessUtil;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.library.ui.LibraryUIText;
import org.eclipse.epf.library.ui.dialogs.ConvertActivityDialog;
import org.eclipse.epf.uma.Activity;
import org.eclipse.epf.uma.BreakdownElement;
import org.eclipse.epf.uma.CapabilityPattern;
import org.eclipse.epf.uma.DeliveryProcess;
import org.eclipse.epf.uma.Iteration;
import org.eclipse.epf.uma.MethodConfiguration;
import org.eclipse.epf.uma.Phase;
import org.eclipse.epf.uma.Process;
import org.eclipse.epf.uma.UmaPackage;
import org.eclipse.epf.uma.VariabilityElement;
import org.eclipse.epf.uma.VariabilityType;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class ActivityGeneralSection
extends WorkBreakdownElementGeneralSection {
    protected Activity element;
    private static final String NOT_APPLICABLE_TEXT = AuthoringUIResources.notApplicable_text;
    private static final String CONTRIBUTES_TEXT = AuthoringUIResources.contributes_text;
    private static final String EXTENDS_TEXT = AuthoringUIResources.extends_text;
    private static final String REPLACES_TEXT = AuthoringUIResources.replaces_text;
    private Text modelInfoText;
    private Label activityTypeLabel;
    private Label ctrl_type_label;
    private Button ctrl_type_button;
    private Combo ctrl_variability;
    private ComboViewer viewer_variability;
    private Text baseText;
    private Button selectButton;
    protected ILabelProvider variabilityLabelProvider = new AdapterFactoryLabelProvider((AdapterFactory)TngAdapterFactory.INSTANCE.getNavigatorView_ComposedAdapterFactory()){

        public String getText(Object object) {
            VariabilityType varObject = (VariabilityType)object;
            if (varObject == VariabilityType.NA_LITERAL) {
                return NOT_APPLICABLE_TEXT;
            }
            if (varObject == VariabilityType.CONTRIBUTES_LITERAL) {
                return CONTRIBUTES_TEXT;
            }
            if (varObject == VariabilityType.EXTENDS_LITERAL) {
                return EXTENDS_TEXT;
            }
            if (varObject == VariabilityType.REPLACES_LITERAL) {
                return REPLACES_TEXT;
            }
            return null;
        }
    };
    private IContentProvider variabilityContentProvider = new AdapterFactoryContentProvider((AdapterFactory)TngAdapterFactory.INSTANCE.getNavigatorView_ComposedAdapterFactory()){

        public Object[] getElements(Object object) {
            ArrayList<VariabilityType> variabilityTypesList = new ArrayList<VariabilityType>();
            variabilityTypesList.add(VariabilityType.NA_LITERAL);
            variabilityTypesList.add(VariabilityType.CONTRIBUTES_LITERAL);
            variabilityTypesList.add(VariabilityType.EXTENDS_LITERAL);
            variabilityTypesList.add(VariabilityType.REPLACES_LITERAL);
            return variabilityTypesList.toArray();
        }
    };
    static /* synthetic */ Class class$0;

    protected void init() {
        super.init();
        this.element = (Activity)this.getElement();
    }

    protected void createGeneralSection(Composite composite) {
        super.createGeneralSection(composite);
        FormUI.createLabel(this.toolkit, this.generalComposite, PropertiesResources.Activity_ModelInfo);
        this.modelInfoText = FormUI.createText(this.toolkit, this.generalComposite, -1, this.horizontalSpan);
        this.modelInfoText.setEnabled(false);
        this.modelInfoText.setText(this.getModelInfo());
        this.activityTypeLabel = FormUI.createLabel(this.toolkit, this.generalComposite, PropertiesResources.Activity_Type);
        this.ctrl_type_label = FormUI.createLabel(this.toolkit, this.generalComposite, "");
        GridData gridData = new GridData(1);
        gridData.horizontalSpan = 1;
        gridData.widthHint = 90;
        this.ctrl_type_label.setBackground(Display.getCurrent().getSystemColor(19));
        this.ctrl_type_label.setLayoutData((Object)gridData);
        this.ctrl_type_button = this.toolkit.createButton(this.generalComposite, AuthoringUIText.CHANGE_TYPE_BUTTON_TEXT, 8);
        gridData = new GridData(1);
        gridData.horizontalSpan = 1;
        this.ctrl_type_button.setLayoutData((Object)gridData);
        if (ConvertActivityDialog.getValidNewActivityTypes((Activity)this.element) == null) {
            this.ctrl_type_button.setVisible(false);
        }
        FormUI.createLabel(this.toolkit, this.generalComposite, "");
        FormUI.createLabel(this.toolkit, this.generalComposite, AuthoringUIText.VARIABILITY_TYPE_TEXT);
        this.ctrl_variability = FormUI.createCombo(this.toolkit, this.generalComposite, 2);
        gridData = new GridData(1);
        gridData.horizontalSpan = 1;
        this.ctrl_variability.setLayoutData((Object)gridData);
        this.viewer_variability = new ComboViewer(this.ctrl_variability);
        this.viewer_variability.getCombo().setLayoutData((Object)new GridData(1));
        this.viewer_variability.setContentProvider(this.variabilityContentProvider);
        this.viewer_variability.setLabelProvider((IBaseLabelProvider)this.variabilityLabelProvider);
        this.viewer_variability.setInput((Object)this.element);
        Label blankLabel = FormUI.createLabel(this.toolkit, this.generalComposite, "");
        GridData gridData2 = new GridData(1);
        gridData2.horizontalSpan = 2;
        blankLabel.setLayoutData((Object)gridData2);
        FormUI.createLabel(this.toolkit, this.generalComposite, AuthoringUIText.BASE_ELEMENT_TEXT);
        this.baseText = FormUI.createText(this.toolkit, this.generalComposite);
        GridData gd = new GridData(769);
        gd.horizontalSpan = 2;
        this.baseText.setLayoutData((Object)gd);
        this.baseText.setEnabled(false);
        this.selectButton = FormUI.createButton(this.toolkit, this.generalComposite, AuthoringUIText.SELECT_BUTTON_TEXT);
    }

    protected void addListeners() {
        super.addListeners();
        this.ctrl_type_button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ProcessEditor editor = ActivityGeneralSection.this.getEditor();
                if (editor.isDirty()) {
                    String title = AuthoringUIResources.changeActivityTypeWarningDialog_title;
                    String message = AuthoringUIResources.descriptionTabGuidanceWarningDialog_message1;
                    AuthoringUIPlugin.getDefault().getMsgDialog().displayWarning(title, message);
                } else if (ActivityGeneralSection.this.element instanceof Activity) {
                    ProcessDeleteAction deleteAction = new ProcessDeleteAction();
                    deleteAction.setEditingDomain(ActivityGeneralSection.this.getEditor().getEditingDomain());
                    deleteAction.selectionChanged((IStructuredSelection)new StructuredSelection((Object)ActivityGeneralSection.this.element));
                    Command cmd = deleteAction.createCommand(Collections.singleton(ActivityGeneralSection.this.element));
                    if (cmd instanceof DeleteMethodElementCommand) {
                        ActivityGeneralSection.this.nameText.removeListener(27, ActivityGeneralSection.this.nameDeactivateListener);
                        ActivityGeneralSection.this.presentationNameText.removeListener(27, ActivityGeneralSection.this.presentationNameDeactivateListener);
                        Activity newActivity = ConvertActivityDialog.queryUserAndConvert((Activity)ActivityGeneralSection.this.element, null, (DeleteMethodElementCommand)((DeleteMethodElementCommand)cmd));
                        if (newActivity != null) {
                            StructuredSelection sel = new StructuredSelection((Object)newActivity);
                            ActivityGeneralSection.this.getPropertySheetPage().selectionChanged(ActivityGeneralSection.this.getPart(), (ISelection)sel);
                            ActivityGeneralSection.this.refresh();
                            ((ProcessViewer)((ProcessBreakdownStructureFormPage)ActivityGeneralSection.this.getEditor().getActivePageInstance()).getViewer()).expandToLevel(newActivity, 3);
                        }
                        ActivityGeneralSection.this.nameText.addListener(27, ActivityGeneralSection.this.nameDeactivateListener);
                        ActivityGeneralSection.this.presentationNameText.addListener(27, ActivityGeneralSection.this.presentationNameDeactivateListener);
                    }
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.ctrl_variability.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                boolean status;
                IStructuredSelection selection = (IStructuredSelection)ActivityGeneralSection.this.viewer_variability.getSelection();
                VariabilityElement ve = ActivityGeneralSection.this.element.getVariabilityBasedOnElement();
                VariabilityType type = (VariabilityType)selection.getFirstElement();
                if (ve != null & ve instanceof Activity) {
                    if (ProcessUtil.hasContributorOrReplacer((Activity)((Activity)ve)) && type.equals(VariabilityType.EXTENDS_LITERAL)) {
                        Object[] args = new Object[]{ActivityGeneralSection.this.element.getName(), ((Activity)ve).getName()};
                        String message = AuthoringUIResources.bind((String)AuthoringUIResources.activity_variability_error_msg, (Object[])args);
                        String title = AuthoringUIResources.activity_variability_error_title;
                        AuthoringUIPlugin.getDefault().getMsgDialog().displayError(title, message, "");
                        VariabilityType variabilityType = ActivityGeneralSection.this.element.getVariabilityType();
                        StructuredSelection newVariabilitySelection = new StructuredSelection((Object)variabilityType);
                        ActivityGeneralSection.this.viewer_variability.setSelection((ISelection)newVariabilitySelection, true);
                        return;
                    }
                    status = ActivityGeneralSection.this.actionMgr.doAction(1, (EObject)ActivityGeneralSection.this.element, (EStructuralFeature)UmaPackage.eINSTANCE.getVariabilityElement_VariabilityType(), (Object)type, -1);
                    if (!status) {
                        return;
                    }
                    if ((ActivityGeneralSection.this.element.getPresentationName() == null || ActivityGeneralSection.this.element.getPresentationName().equals("")) && (type.equals(VariabilityType.CONTRIBUTES_LITERAL) || type.equals(VariabilityType.REPLACES_LITERAL))) {
                        ActivityGeneralSection.this.element.setPresentationName(ActivityGeneralSection.this.element.getName());
                    }
                }
                if (type == VariabilityType.NA_LITERAL) {
                    if (ve != null && !(status = ActivityGeneralSection.this.actionMgr.doAction(1, (EObject)ActivityGeneralSection.this.element, (EStructuralFeature)UmaPackage.eINSTANCE.getVariabilityElement_VariabilityBasedOnElement(), null, -1))) {
                        return;
                    }
                    ActivityGeneralSection.this.selectButton.setEnabled(false);
                    ActivityGeneralSection.this.baseText.setText("");
                } else {
                    ArrayList<VariabilityElement> selectionBaseList = new ArrayList<VariabilityElement>();
                    VariabilityElement base = ActivityGeneralSection.this.element.getVariabilityBasedOnElement();
                    selectionBaseList.add(base);
                    ActivityGeneralSection.this.selectButton.setEnabled(true);
                }
            }
        });
        this.selectButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MethodConfiguration config = ActivityGeneralSection.this.getConfiguration();
                String tabName = FilterConstants.PROCESSES;
                VariabilityType type = (VariabilityType)((IStructuredSelection)ActivityGeneralSection.this.viewer_variability.getSelection()).getFirstElement();
                ActivityVariaibilityFilter filter = new ActivityVariaibilityFilter(config, null, tabName, ActivityGeneralSection.this.element);
                ItemsFilterDialog fd = new ItemsFilterDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (IFilter)filter, tabName, null, config);
                fd.setBlockOnOpen(true);
                fd.setViewerSelectionSingle(true);
                fd.setTitle(tabName);
                fd.open();
                ArrayList selectedItems = fd.getSelectedItems();
                if (selectedItems != null && !selectedItems.isEmpty()) {
                    Object o = selectedItems.get(0);
                    if (o instanceof Activity) {
                        Activity act = (Activity)o;
                        if (ActivityGeneralSection.this.isDirectParent(act) || act instanceof Process && !(ActivityGeneralSection.this.element instanceof Process)) {
                            Object[] args = new Object[]{ActivityGeneralSection.this.element.getName()};
                            String message = AuthoringUIResources.bind((String)AuthoringUIResources.activity_variability_error_msg1, (Object[])args);
                            String title = AuthoringUIResources.activity_variability_error_title;
                            AuthoringUIPlugin.getDefault().getMsgDialog().displayError(title, message, "");
                            return;
                        }
                        if (ActivityGeneralSection.this.isCircularDependency((VariabilityElement)act)) {
                            Object[] args = new Object[]{ActivityGeneralSection.this.element.getName(), act.getName()};
                            String message = AuthoringUIResources.bind((String)AuthoringUIResources.activity_variability_error_msg2, (Object[])args);
                            String title = AuthoringUIResources.activity_variability_error_title;
                            AuthoringUIPlugin.getDefault().getMsgDialog().displayError(title, message, "");
                            return;
                        }
                        if (ProcessUtil.hasContributorOrReplacer((Activity)act) && type.equals(VariabilityType.EXTENDS_LITERAL)) {
                            Object[] args = new Object[]{ActivityGeneralSection.this.element.getName(), act.getName()};
                            String message = AuthoringUIResources.bind((String)AuthoringUIResources.activity_variability_error_msg, (Object[])args);
                            String title = AuthoringUIResources.activity_variability_error_title;
                            AuthoringUIPlugin.getDefault().getMsgDialog().displayError(title, message, "");
                            return;
                        }
                    }
                    if (o instanceof VariabilityElement) {
                        VariabilityElement ve = (VariabilityElement)o;
                        ProcessVariabilityConfigurator configurator = new ProcessVariabilityConfigurator(ActivityGeneralSection.this.getDefaultConfiguration(), null);
                        ActivityVariabilityCommand cmd = new ActivityVariabilityCommand(ActivityGeneralSection.this.element, ve, type, (IConfigurator)configurator);
                        boolean status = ActivityGeneralSection.this.actionMgr.execute((IResourceAwareCommand)cmd);
                        if (!status) {
                            return;
                        }
                        ActivityGeneralSection.this.baseText.setText(TngUtil.getLabelWithPath((Object)ve));
                    }
                }
            }
        });
    }

    private String getModelInfo() {
        String info = null;
        try {
            ItemProviderAdapter o = this.getAdapter();
            if (o instanceof IBSItemProvider) {
                IBSItemProvider adapter = (IBSItemProvider)o;
                info = adapter.getAttribute((Object)this.element, "model_info");
            }
        }
        catch (Exception exception) {}
        if (!StrUtil.isBlank(info)) {
            return info;
        }
        return PropertiesResources.Process_None;
    }

    protected void updateControls() {
        super.updateControls();
        this.ctrl_type_button.setEnabled(this.editable);
        this.ctrl_variability.setEnabled(this.editable);
        this.selectButton.setEnabled(this.editable);
        this.ctrl_variability.setEnabled(this.editable);
        if (((IStructuredSelection)this.viewer_variability.getSelection()).getFirstElement() == VariabilityType.NA_LITERAL) {
            this.selectButton.setEnabled(false);
        }
    }

    public void refresh() {
        try {
            if (this.getElement() instanceof Activity) {
                super.refresh();
                this.element = (Activity)this.getElement();
                this.modelInfoText.setText(this.getModelInfo());
                this.ctrl_type_label.setText(PropertiesUtil.getType(this.element));
                if (this.element instanceof Process && (this.element.getSuperActivities() == null || this.element.getSuperActivities() == null)) {
                    this.activityTypeLabel.setVisible(false);
                    this.ctrl_type_label.setVisible(false);
                    this.ctrl_type_button.setVisible(false);
                } else {
                    this.activityTypeLabel.setVisible(true);
                    this.ctrl_type_label.setVisible(true);
                    this.ctrl_type_button.setVisible(true);
                }
                VariabilityType variabilityType = this.element.getVariabilityType();
                StructuredSelection newVariabilitySelection = new StructuredSelection((Object)variabilityType);
                this.viewer_variability.setSelection((ISelection)newVariabilitySelection, true);
                if (this.element.getVariabilityBasedOnElement() != null) {
                    this.baseText.setText(TngUtil.getLabelWithPath((Object)this.element.getVariabilityBasedOnElement()));
                } else {
                    this.baseText.setText("");
                }
            }
        }
        catch (Exception ex) {
            this.logger.logError("Error refreshing Activity general section : " + this.element, (Throwable)ex);
        }
    }

    public String getNamePrefix() {
        if (this.element instanceof CapabilityPattern) {
            return String.valueOf(LibraryUIText.TEXT_CAPABILITY_PATTERN) + ": ";
        }
        if (this.element instanceof DeliveryProcess) {
            return String.valueOf(LibraryUIText.TEXT_DELIVERY_PROCESS) + ": ";
        }
        if (this.element instanceof Phase) {
            return String.valueOf(LibraryUIText.TEXT_PHASE) + ": ";
        }
        if (this.element instanceof Iteration) {
            return String.valueOf(LibraryUIText.TEXT_ITERATION) + ": ";
        }
        return String.valueOf(LibraryUIText.TEXT_ACTIVITY) + ": ";
    }

    private static void getParentsInScope(AdapterFactory adapterFactory, BreakdownElement element, List activityList) {
        ItemProviderAdapter adapter;
        Object parent;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.emf.edit.provider.ITreeItemContentProvider");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((parent = (adapter = (ItemProviderAdapter)adapterFactory.adapt((Notifier)element, (Object)clazz)).getParent((Object)element)) instanceof Activity) {
            activityList.add(parent);
            ActivityGeneralSection.getParentsInScope(adapterFactory, (BreakdownElement)parent, activityList);
        }
    }

    private boolean isDirectParent(Activity act) {
        ArrayList actList = new ArrayList();
        ActivityGeneralSection.getParentsInScope(this.getAdapterFactory(), (BreakdownElement)this.element, actList);
        return actList.contains(act);
    }

    private boolean isCircularDependency(VariabilityElement act) {
        VariabilityType type = act.getVariabilityType();
        while (!type.equals(VariabilityType.NA_LITERAL)) {
            VariabilityElement ve = act.getVariabilityBasedOnElement();
            if (ve != null && ve.equals(this.element)) {
                return true;
            }
            act = ve;
            type = ve.getVariabilityType();
        }
        return false;
    }
}

