/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw2d;

import org.eclipse.draw2d.AncestorListener;
import org.eclipse.draw2d.AnchorListener;
import org.eclipse.draw2d.ConnectionAnchorBase;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Point;

public abstract class AbstractConnectionAnchor
extends ConnectionAnchorBase
implements AncestorListener {
    private IFigure owner;

    public AbstractConnectionAnchor() {
    }

    public AbstractConnectionAnchor(IFigure owner) {
        this.setOwner(owner);
    }

    public void addAnchorListener(AnchorListener listener) {
        if (listener == null) {
            return;
        }
        if (this.listeners.size() == 0) {
            this.getOwner().addAncestorListener(this);
        }
        super.addAnchorListener(listener);
    }

    public void ancestorMoved(IFigure figure) {
        this.fireAnchorMoved();
    }

    public void ancestorAdded(IFigure ancestor) {
    }

    public void ancestorRemoved(IFigure ancestor) {
    }

    public IFigure getOwner() {
        return this.owner;
    }

    public Point getReferencePoint() {
        if (this.getOwner() == null) {
            return null;
        }
        Point ref = this.getOwner().getBounds().getCenter();
        this.getOwner().translateToAbsolute(ref);
        return ref;
    }

    public void removeAnchorListener(AnchorListener listener) {
        super.removeAnchorListener(listener);
        if (this.listeners.size() == 0) {
            this.getOwner().removeAncestorListener(this);
        }
    }

    public void setOwner(IFigure owner) {
        this.owner = owner;
    }
}

