/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.publishing.services.index;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.epf.library.util.ResourceHelper;
import org.eclipse.epf.publishing.services.index.HelpMessages;
import org.eclipse.epf.publishing.services.index.IO;
import org.eclipse.epf.publishing.services.index.KeyWordDef;
import org.eclipse.epf.publishing.services.index.KeyWordIndexHelper;

public class KeyWordStatic {
    public static final Pattern p_index_ref = Pattern.compile("<a\\s+?(.*?)>", 34);

    public static List getKeyWords(String realString) {
        if (realString == null) {
            System.err.println("KeyWordStatic:getKeyWords\n" + HelpMessages.INPUT_PARAMETER_NULL);
            return null;
        }
        ArrayList<KeyWordDef> anchors = new ArrayList<KeyWordDef>(2);
        Matcher m = p_index_ref.matcher(realString);
        while (m.find()) {
            Map attrMap;
            String keyWord;
            String attributes = m.group(1);
            if (attributes.length() == 0 || (keyWord = (String)(attrMap = ResourceHelper.getTagAttributes((String)attributes)).get("name")) == null || keyWord.length() == 0) continue;
            String cls = (String)attrMap.get("class");
            String key = null;
            String text = null;
            if (cls != null && cls.equals("index")) {
                key = (String)attrMap.get("key");
                text = (String)attrMap.get("text");
            }
            if (key == null && !keyWord.startsWith(KeyWordIndexHelper.defObj.getKeyWordPrefix())) continue;
            anchors.add(new KeyWordDef(keyWord, key, text));
        }
        return anchors;
    }

    public static String convertKeyWord(String keyWord) {
        return KeyWordStatic.convertKeyWord(keyWord, null, null);
    }

    public static String convertKeyWord(String keyWord, String key, String text) {
        if (keyWord == null) {
            System.err.println("KeyWordStatic:convertKeyWord\n" + HelpMessages.INPUT_PARAMETER_NULL);
            return null;
        }
        IO.printDebug("convertKeyWord " + keyWord);
        if (key != null && key.length() > 0) {
            if (text == null || text.length() == 0) {
                return key;
            }
            return String.valueOf(key) + KeyWordIndexHelper.defObj.levelSeparatorReplace + text;
        }
        if (!keyWord.startsWith(KeyWordIndexHelper.defObj.getKeyWordPrefix())) {
            System.out.println("KeyWordStatic:convertKeyWord\n" + keyWord + HelpMessages.KEYWORD_SYNTAX_ERROR + KeyWordIndexHelper.defObj.getKeyWordPrefix());
            return null;
        }
        String tmpK = keyWord.substring(3);
        String tmp = "";
        int i = 0;
        int pos = 0;
        while (i != -1) {
            i = tmpK.indexOf(KeyWordIndexHelper.defObj.getKeyWordLevelSeparator(), pos);
            if (i != -1) {
                tmp = String.valueOf(tmp) + tmpK.substring(pos, i);
                tmp = String.valueOf(tmp) + KeyWordIndexHelper.defObj.levelSeparatorReplace;
                pos = i + 2;
                continue;
            }
            tmp = String.valueOf(tmp) + tmpK.substring(pos);
        }
        return tmp.replace('_', ' ');
    }
}

