/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.publishing.util.http;

import java.io.IOException;
import java.io.PrintStream;
import java.net.URL;
import org.eclipse.epf.publishing.util.http.HttpClientTimeout;
import org.eclipse.epf.publishing.util.http.HttpTimeoutHandler;
import sun.net.www.http.HttpClient;
import sun.net.www.protocol.http.HttpURLConnection;

public class HttpURLConnectionTimeout
extends HttpURLConnection {
    private int timeout;
    private HttpTimeoutHandler timeoutHandler;

    public HttpURLConnectionTimeout(URL u, HttpTimeoutHandler handler, int timeout) throws IOException {
        super(u, handler);
        this.timeout = timeout;
        this.timeoutHandler = handler;
    }

    public HttpURLConnectionTimeout(URL u, String host, int port, int timeout) throws IOException {
        super(u, host, port);
        this.timeout = timeout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connect() throws IOException {
        if (this.connected) {
            return;
        }
        if ("http".equals(this.url.getProtocol())) {
            URL uRL = this.url;
            synchronized (uRL) {
                this.http = HttpClientTimeout.GetNew(this.url, this.timeout);
            }
        } else {
            this.http = new HttpClientTimeout(this.url, this.timeoutHandler.getProxy(), this.timeoutHandler.getProxyPort(), this.timeout);
        }
        this.ps = (PrintStream)this.http.getOutputStream();
        this.connected = true;
    }

    protected HttpClient getProxiedClient(URL url, String s, int i) throws IOException {
        return new HttpClientTimeout(url, s, i, this.timeout);
    }

    protected HttpClient getNewClient(URL url) throws IOException {
        return new HttpClientTimeout(url, null, -1, this.timeout);
    }
}

