/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.export.msp.test;

import java.math.BigInteger;
import java.util.Date;
import java.util.Iterator;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.epf.msproject.Assignment;
import org.eclipse.epf.msproject.DocumentRoot;
import org.eclipse.epf.msproject.MsprojectFactory;
import org.eclipse.epf.msproject.MsprojectPackage;
import org.eclipse.epf.msproject.PredecessorLink;
import org.eclipse.epf.msproject.Project;
import org.eclipse.epf.msproject.Task;
import org.eclipse.epf.msproject.util.MsprojectResourceFactoryImpl;

public class ReadAddExport {
    public static void main(String[] args) {
        MsprojectPackage projectPackage = MsprojectPackage.eINSTANCE;
        MsprojectFactory projectFactory = MsprojectFactory.eINSTANCE;
        EClass projectClass = projectPackage.getProject();
        System.out.println("$$$ TRACE: " + projectClass);
        DocumentRoot docRoot = projectFactory.createDocumentRoot();
        docRoot.getXMLNSPrefixMap().put((Object)"", (Object)"http://epf.eclipse.org/msproject");
        Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap().put("*", new MsprojectResourceFactoryImpl());
        ResourceSetImpl resSet = new ResourceSetImpl();
        URI fileURI = URI.createFileURI((String)"e:\\tng_data\\MSproject\\emf_msproj_test.xml");
        try {
            Resource res = resSet.getResource(fileURI, true);
            docRoot = (DocumentRoot)res.getEObject("/");
            Project proj = docRoot.getProject();
            ReadAddExport.printMspBS(proj);
            EList tasks = proj.getTasks().getTask();
            Task firstTask = (Task)tasks.get(3);
            System.out.println("$$$ predecessor = " + firstTask.getPredecessorLink());
            Task aTask = projectFactory.createTask();
            aTask.setOutlineLevel(new BigInteger("1"));
            aTask.setUID(new BigInteger("4"));
            aTask.setID(new BigInteger("4"));
            aTask.setType(new BigInteger("1"));
            aTask.setStart((Object)new Date());
            aTask.setSummary(false);
            aTask.setConstraintType(new BigInteger("2"));
            aTask.setName("RMC Summary Activity");
            PredecessorLink preLink = projectFactory.createPredecessorLink();
            aTask.getPredecessorLink().add((Object)preLink);
            preLink.setPredecessorUID(new BigInteger("3"));
            preLink.setType(new BigInteger("1"));
            preLink.setCrossProject(false);
            preLink.setLinkLag(new BigInteger("0"));
            preLink.setLagFormat(new BigInteger("7"));
            proj.getTasks().getTask().add((Object)aTask);
            System.out.println("$$$ predecessor = " + aTask.getPredecessorLink());
            res.save(null);
            res.unload();
            res = resSet.getResource(fileURI, true);
            docRoot = (DocumentRoot)res.getEObject("/");
            proj = docRoot.getProject();
            ReadAddExport.printMspBS(proj);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void printMspBS(Project proj) {
        System.out.println("\n$$$ read-in project = " + proj);
        EList tasks = proj.getTasks().getTask();
        Iterator iter = tasks.iterator();
        while (iter.hasNext()) {
            Task element = (Task)iter.next();
            System.out.println("$$$ a task = " + element);
        }
        EList resources = proj.getResources().getResource();
        Iterator iter2 = resources.iterator();
        while (iter2.hasNext()) {
            org.eclipse.epf.msproject.Resource element = (org.eclipse.epf.msproject.Resource)iter2.next();
            System.out.println("$$$ a resource = " + element);
        }
        EList assignments = proj.getAssignments().getAssignment();
        Iterator iter3 = assignments.iterator();
        while (iter3.hasNext()) {
            Assignment element = (Assignment)iter3.next();
            System.out.println("$$$ an assignment = " + element);
        }
        System.out.println("$$$===\n");
    }

    public static void printClasses(EPackage ePackage) {
        Iterator iter = ePackage.getEClassifiers().iterator();
        while (iter.hasNext()) {
            EClassifier classifier = (EClassifier)iter.next();
            System.out.println(classifier.getName());
            System.out.print("  ");
            if (classifier instanceof EClass) {
                EClass eClass = (EClass)classifier;
                Iterator aIter = eClass.getEAttributes().iterator();
                while (aIter.hasNext()) {
                    EAttribute attribute = (EAttribute)aIter.next();
                    System.out.print(String.valueOf(attribute.getName()) + " ");
                }
                Iterator rIter = eClass.getEReferences().iterator();
                while (rIter.hasNext()) {
                    EReference reference = (EReference)rIter.next();
                    System.out.print(String.valueOf(reference.getName()) + " ");
                }
            } else if (classifier instanceof EEnum) {
                EEnum eEnum = (EEnum)classifier;
                Iterator eIter = eEnum.getELiterals().iterator();
                while (eIter.hasNext()) {
                    EEnumLiteral literal = (EEnumLiteral)eIter.next();
                    System.out.print(String.valueOf(literal.getName()) + " ");
                }
            } else if (classifier instanceof EDataType) {
                EDataType eDataType = (EDataType)classifier;
                System.out.print(String.valueOf(eDataType.getInstanceClassName()) + " ");
            }
            System.out.println();
        }
    }
}

