/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.epf.library.ConfigurationAlreadyExistsException;
import org.eclipse.epf.library.ConfigurationManager;
import org.eclipse.epf.library.CreateLibraryManagerException;
import org.eclipse.epf.library.IConfigurationManager;
import org.eclipse.epf.library.ILibraryManager;
import org.eclipse.epf.library.ILibraryService;
import org.eclipse.epf.library.ILibraryServiceListener;
import org.eclipse.epf.library.LibraryManagerFactory;
import org.eclipse.epf.library.LibraryServiceException;
import org.eclipse.epf.library.LibraryServiceUtil;
import org.eclipse.epf.library.services.SafeUpdateController;
import org.eclipse.epf.uma.MethodConfiguration;
import org.eclipse.epf.uma.MethodLibrary;
import org.eclipse.epf.uma.UmaFactory;

public class LibraryService
implements ILibraryService {
    protected static final int EVENT_CREATE_LIBRARY = 1;
    protected static final int EVENT_OPEN_LIBRARY = 2;
    protected static final int EVENT_REOPEN_LIBRARY = 3;
    protected static final int EVENT_CLOSE_LIBRARY = 4;
    protected static final int EVENT_SET_CURRENT_LIBRARY = 5;
    protected static final int EVENT_SET_CURRENT_CONFIGURATION = 6;
    protected static ILibraryService instance = null;
    private Map libraryManagers = new HashMap();
    protected Map configManagers = new HashMap();
    protected List listeners = new ArrayList();
    protected MethodLibrary currentLibrary;
    protected MethodConfiguration currentConfig;
    static /* synthetic */ Class class$0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ILibraryService getInstance() {
        if (instance != null) return instance;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.epf.library.LibraryService");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Class<?> clazz2 = clazz;
        synchronized (clazz) {
            if (instance != null) return instance;
            instance = new LibraryService();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private LibraryService() {
        this.init();
    }

    protected void init() {
        LibraryManagerFactory.getInstance();
    }

    public MethodLibrary createMethodLibrary(String name, String type, Map params) throws LibraryServiceException {
        if (name == null || type == null || params == null) {
            throw new IllegalArgumentException();
        }
        try {
            ILibraryManager manager = LibraryManagerFactory.getInstance().createLibraryManager(type);
            MethodLibrary library = manager.createMethodLibrary(name, params);
            if (library != null) {
                this.setLibraryManager(manager);
                this.setCurrentMethodLibrary(library);
                this.notifyListeners(library, 1);
            }
            return library;
        }
        catch (Exception e) {
            throw new LibraryServiceException(e);
        }
    }

    public MethodLibrary openMethodLibrary(String type, Map params) throws LibraryServiceException {
        if (params == null) {
            throw new IllegalArgumentException();
        }
        try {
            ILibraryManager manager = LibraryManagerFactory.getInstance().createLibraryManager(type);
            MethodLibrary library = manager.openMethodLibrary(params);
            if (library != null) {
                this.setLibraryManager(manager);
                this.setCurrentMethodLibrary(library);
                this.notifyListeners(library, 2);
            }
            return library;
        }
        catch (CreateLibraryManagerException e) {
            throw e;
        }
        catch (Exception e) {
            throw new LibraryServiceException(e);
        }
    }

    public MethodLibrary reopenMethodLibrary(MethodLibrary library) throws LibraryServiceException {
        ILibraryManager manager = this.getLibraryManager(library);
        if (manager != null) {
            try {
                this.removeLibraryManager(manager);
                library = manager.reopenMethodLibrary();
                this.setLibraryManager(manager);
                this.setCurrentMethodLibrary(library);
                this.notifyListeners(library, 3);
            }
            catch (Exception e) {
                throw new LibraryServiceException(e);
            }
        }
        return null;
    }

    public MethodLibrary reopenCurrentMethodLibrary() throws LibraryServiceException {
        return this.reopenMethodLibrary(this.currentLibrary);
    }

    public void saveMethodLibrary(MethodLibrary library) throws LibraryServiceException {
        ILibraryManager manager = this.getLibraryManager(library);
        if (manager != null) {
            manager.saveMethodLibrary();
        }
    }

    public void saveCurrentMethodLibrary() throws LibraryServiceException {
        this.saveMethodLibrary(this.currentLibrary);
    }

    public void closeMethodLibrary(MethodLibrary library) throws LibraryServiceException {
        ILibraryManager manager = this.getLibraryManager(library);
        if (manager != null) {
            this.notifyListeners(library, 4);
            manager.closeMethodLibrary();
            if (this.currentLibrary == library) {
                this.setCurrentMethodLibrary(null);
            }
            this.removeLibraryManager(manager);
            manager.dispose();
        }
    }

    public void closeCurrentMethodLibrary() throws LibraryServiceException {
        if (this.currentLibrary != null) {
            this.closeMethodLibrary(this.currentLibrary);
        }
    }

    public void replaceMethodLibrary(MethodLibrary oldLibrary, MethodLibrary newLibrary) {
        ILibraryManager manager = this.getLibraryManager(oldLibrary);
        if (manager != null) {
            this.removeLibraryManager(manager);
            manager.setMethodLibrary(newLibrary);
            this.setLibraryManager(manager);
        }
    }

    public void addListener(ILibraryServiceListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(ILibraryServiceListener listener) {
        this.listeners.remove(listener);
    }

    public MethodLibrary getCurrentMethodLibrary() {
        return this.currentLibrary;
    }

    public void setCurrentMethodLibrary(MethodLibrary library) {
        this.currentLibrary = library;
        this.notifyListeners(library, 5);
    }

    public String getCurrentMethodLibraryPath() {
        ILibraryManager manager = this.getLibraryManager(this.currentLibrary);
        if (manager != null) {
            return manager.getMethodLibraryPath();
        }
        return null;
    }

    public ILibraryManager getLibraryManager(MethodLibrary library) {
        return (ILibraryManager)this.libraryManagers.get(library);
    }

    public void removeLibraryManager(ILibraryManager libMgr) {
        MethodLibrary lib;
        if (libMgr != null && (lib = libMgr.getMethodLibrary()) != null) {
            this.removeConfigurationManagers(lib);
            this.libraryManagers.remove(lib);
        }
    }

    public void setLibraryManager(ILibraryManager libMgr) {
        MethodLibrary lib = libMgr.getMethodLibrary();
        if (lib != null) {
            this.libraryManagers.put(lib, libMgr);
        }
    }

    public ILibraryManager getCurrentLibraryManager() {
        return this.getLibraryManager(this.currentLibrary);
    }

    public MethodConfiguration createMethodConfiguration(String name, MethodLibrary library) throws LibraryServiceException {
        MethodConfiguration config;
        if (name == null || library == null) {
            throw new IllegalArgumentException();
        }
        List configs = library.getPredefinedConfigurations();
        Iterator it = configs.iterator();
        while (it.hasNext()) {
            config = (MethodConfiguration)it.next();
            if (!name.equals(config.getName())) continue;
            throw new ConfigurationAlreadyExistsException();
        }
        config = UmaFactory.eINSTANCE.createMethodConfiguration();
        config.setName(name);
        configs.add(config);
        return config;
    }

    public MethodConfiguration getCurrentMethodConfiguration() {
        return this.currentConfig;
    }

    public void setCurrentMethodConfiguration(MethodConfiguration config) {
        this.currentConfig = config;
        this.notifyListeners(config, 6);
    }

    public IConfigurationManager getConfigurationManager(MethodConfiguration config) {
        if (config == null) {
            throw new IllegalArgumentException();
        }
        IConfigurationManager manager = (IConfigurationManager)this.configManagers.get(config);
        if (manager == null) {
            manager = new ConfigurationManager(config);
            this.configManagers.put(config, manager);
        }
        return manager;
    }

    public void removeConfigurationManager(MethodConfiguration config) {
        if (config == null) {
            throw new IllegalArgumentException();
        }
        IConfigurationManager mgr = (IConfigurationManager)this.configManagers.remove(config);
        if (mgr != null) {
            mgr.dispose();
        }
    }

    public void removeConfigurationManagers(MethodLibrary library) {
        if (library == null) {
            throw new IllegalArgumentException();
        }
        MethodConfiguration[] configs = LibraryServiceUtil.getMethodConfigurations(library);
        int i = 0;
        while (i < configs.length) {
            this.removeConfigurationManager(configs[i]);
            ++i;
        }
    }

    public IConfigurationManager getCurrentConfigurationManager() {
        if (this.currentConfig != null) {
            return this.getConfigurationManager(this.currentConfig);
        }
        return null;
    }

    protected void notifyListeners(final MethodLibrary library, int eventId) {
        Iterator it = this.listeners.iterator();
        while (it.hasNext()) {
            final ILibraryServiceListener listener = (ILibraryServiceListener)it.next();
            switch (eventId) {
                case 1: {
                    SafeUpdateController.syncExec(new Runnable(){

                        public void run() {
                            listener.libraryCreated(library);
                        }
                    });
                    break;
                }
                case 2: {
                    SafeUpdateController.syncExec(new Runnable(){

                        public void run() {
                            listener.libraryOpened(library);
                        }
                    });
                    break;
                }
                case 3: {
                    SafeUpdateController.syncExec(new Runnable(){

                        public void run() {
                            listener.libraryReopened(library);
                        }
                    });
                    break;
                }
                case 4: {
                    SafeUpdateController.syncExec(new Runnable(){

                        public void run() {
                            listener.libraryClosed(library);
                        }
                    });
                    break;
                }
                case 5: {
                    SafeUpdateController.syncExec(new Runnable(){

                        public void run() {
                            listener.librarySet(library);
                        }
                    });
                }
            }
        }
    }

    protected void notifyListeners(final MethodConfiguration config, int eventId) {
        Iterator it = this.listeners.iterator();
        while (it.hasNext()) {
            final ILibraryServiceListener listener = (ILibraryServiceListener)it.next();
            switch (eventId) {
                case 6: {
                    SafeUpdateController.syncExec(new Runnable(){

                        public void run() {
                            listener.configurationSet(config);
                        }
                    });
                }
            }
        }
    }
}

