/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.configuration;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.provider.ItemProviderAdapter;
import org.eclipse.epf.library.configuration.ConfigurationHelper;
import org.eclipse.epf.library.configuration.DefaultElementRealizer;
import org.eclipse.epf.library.configuration.ElementRealizer;
import org.eclipse.epf.library.edit.IConfigurator;
import org.eclipse.epf.library.edit.VariabilityInfo;
import org.eclipse.epf.library.services.SafeUpdateController;
import org.eclipse.epf.library.util.LibraryUtil;
import org.eclipse.epf.library.util.Log;
import org.eclipse.epf.uma.MethodConfiguration;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.MethodPackage;
import org.eclipse.epf.uma.VariabilityElement;
import org.eclipse.jface.viewers.Viewer;

public class ConfigurationFilter
extends AdapterImpl
implements IConfigurator {
    protected MethodConfiguration methodConfig;
    private Viewer viewer;

    public ConfigurationFilter(MethodConfiguration methodConfig, Viewer viewer) {
        this.methodConfig = methodConfig;
        this.viewer = viewer;
    }

    public boolean accept(Object obj) {
        if (this.methodConfig == null) {
            return true;
        }
        if ((obj = LibraryUtil.unwrap(obj)) instanceof MethodPackage) {
            return this.methodConfig.getMethodPackageSelection().contains(obj);
        }
        if (obj instanceof MethodElement) {
            return ConfigurationHelper.canShow((MethodElement)obj, this.methodConfig);
        }
        if (obj instanceof ItemProviderAdapter) {
            return true;
        }
        if (Log.DEBUG) {
            System.out.println("Object filtered: " + (obj == null ? null : obj.toString()));
        }
        return false;
    }

    public Collection getChildren(Object obj, EStructuralFeature childFeature) {
        if (this.methodConfig == null) {
            return null;
        }
        if (childFeature != null && childFeature.isMany() && obj instanceof MethodElement) {
            DefaultElementRealizer realizer = new DefaultElementRealizer(this.methodConfig);
            realizer.setDiscardContributor(true);
            List value = ConfigurationHelper.calc0nFeatureValue((MethodElement)obj, childFeature, (ElementRealizer)realizer);
            return value;
        }
        return null;
    }

    public void notifyChanged(final Notification msg) {
        if (this.viewer == null) {
            return;
        }
        SafeUpdateController.syncExec(new Runnable(){

            public void run() {
                switch (msg.getEventType()) {
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: {
                        ConfigurationFilter.this.viewer.refresh();
                    }
                }
            }
        });
    }

    public MethodConfiguration getMethodConfiguration() {
        return this.methodConfig;
    }

    public void setMethodConfiguration(MethodConfiguration config) {
        this.methodConfig = config;
    }

    private void resolveElementVariabilityList(VariabilityElement element, VariabilityInfo info, boolean includeBase) {
        List values;
        VariabilityElement e;
        if (this.methodConfig == null) {
            return;
        }
        List items = ConfigurationHelper.getContributors(element, this.methodConfig);
        if (items != null && items.size() > 0) {
            Iterator it = items.iterator();
            while (it.hasNext()) {
                e = (VariabilityElement)it.next();
                values = info.getContributors();
                if (!values.contains(e)) {
                    values.add(e);
                }
                this.resolveElementVariabilityList(e, info, false);
            }
        }
        if (ConfigurationHelper.isExtender(element)) {
            VariabilityElement base = element.getVariabilityBasedOnElement();
            e = (VariabilityElement)ConfigurationHelper.getCalculatedElement((MethodElement)base, this.methodConfig);
            if (includeBase && !(values = info.getInheritanceList()).contains(e)) {
                values.add(e);
            }
            this.resolveElementVariabilityList(e, info, includeBase);
        }
    }

    public VariabilityInfo getVariabilityInfo(VariabilityElement ve) {
        VariabilityElement e = (VariabilityElement)ConfigurationHelper.getCalculatedElement((MethodElement)ve, this.methodConfig);
        if (e == null) {
            return null;
        }
        VariabilityInfo info = new VariabilityInfo(ve);
        info.getInheritanceList().add(e);
        this.resolveElementVariabilityList(e, info, true);
        return info;
    }

    public Object resolve(Object element) {
        if (element instanceof VariabilityElement) {
            return ConfigurationHelper.getCalculatedElement((MethodElement)element, this.methodConfig);
        }
        return element;
    }
}

