/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.layout.elements;

import com.ibm.icu.util.StringTokenizer;
import java.util.ArrayList;
import org.eclipse.epf.library.edit.process.BreakdownElementWrapperItemProvider;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.library.layout.ElementLayoutManager;
import org.eclipse.epf.library.layout.IElementLayout;
import org.eclipse.epf.library.layout.elements.AbstractElementLayout;
import org.eclipse.epf.library.layout.elements.ProcessElementItem;
import org.eclipse.epf.library.layout.util.XmlElement;
import org.eclipse.epf.library.util.LibraryUtil;
import org.eclipse.epf.uma.Activity;
import org.eclipse.epf.uma.BreakdownElement;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.Process;

public abstract class AbstractProcessElementLayout
extends AbstractElementLayout {
    protected Process owningProcess = null;
    protected String elementProcessPath = null;
    protected String relProcessPath = null;
    protected String[] paths = null;

    public void init(ElementLayoutManager layoutManager, MethodElement element, Process owningProc, String path) {
        this.init(layoutManager, element);
        this.owningProcess = owningProc;
        this.elementProcessPath = path;
        if (this.owningProcess == null) {
            this.owningProcess = TngUtil.getOwningProcess((BreakdownElement)((BreakdownElement)this.element));
        }
        if (element instanceof Process) {
            this.owningProcess = (Process)element;
            this.relProcessPath = this.elementProcessPath = AbstractProcessElementLayout.makePath(null, element);
        }
        if (this.elementProcessPath == null && this.element instanceof BreakdownElement) {
            this.elementProcessPath = AbstractProcessElementLayout.getPath((BreakdownElement)this.element);
        }
        this.paths = AbstractProcessElementLayout.getPathArray(this.elementProcessPath);
    }

    public void setRelativeProcessPath(String path) {
        this.relProcessPath = path;
    }

    public String getRelativeProcessPath() {
        return this.relProcessPath;
    }

    public String getQueryString() {
        return ElementLayoutManager.getQueryString(this.owningProcess.getGuid(), this.elementProcessPath);
    }

    protected XmlElement getXmlElement() {
        XmlElement elementXml = super.getXmlElement();
        elementXml.setAttribute("queryString", this.getQueryString()).setAttribute("relProcessPath", this.relProcessPath);
        return elementXml;
    }

    protected Process getOwningProcess() {
        return this.owningProcess;
    }

    protected IElementLayout getLayout(ProcessElementItem item) {
        IElementLayout layout = this.layoutManager.createLayout(item.element, this.owningProcess, item.path);
        if (layout instanceof AbstractProcessElementLayout) {
            String relPath = AbstractProcessElementLayout.getRelativePath(item.path, this.elementProcessPath);
            ((AbstractProcessElementLayout)layout).setRelativeProcessPath(relPath);
        }
        return layout;
    }

    public static String makePath(String parentPath, MethodElement element) {
        if (parentPath == null || parentPath.length() == 0) {
            return element.getGuid();
        }
        return String.valueOf(parentPath) + "," + element.getGuid();
    }

    public static String getPath(BreakdownElement element) {
        String path = element.getGuid();
        BreakdownElement act = element;
        while (!(act instanceof Process) || !act.equals(TngUtil.getOwningProcess((BreakdownElement)element))) {
            Activity superActs = act.getSuperActivities();
            if (superActs == null) break;
            act = superActs;
            path = String.valueOf(act.getGuid()) + "," + path;
        }
        return path;
    }

    public static String getPath(BreakdownElementWrapperItemProvider wrapper) {
        Object e = LibraryUtil.unwrap(wrapper);
        if (!(e instanceof MethodElement)) {
            return null;
        }
        Object topItem = wrapper.getTopItem();
        StringBuffer path = new StringBuffer();
        path.append(((MethodElement)e).getGuid());
        Object parent = wrapper;
        while (parent != null && parent != topItem) {
            if (parent instanceof BreakdownElement) {
                parent = ((BreakdownElement)parent).getSuperActivities();
                e = parent;
            } else {
                if (!(parent instanceof BreakdownElementWrapperItemProvider)) break;
                parent = parent.getParent(parent);
                e = LibraryUtil.unwrap(parent);
            }
            if (!(e instanceof MethodElement)) continue;
            path.insert(0, String.valueOf(((MethodElement)e).getGuid()) + ",");
        }
        return path.toString();
    }

    public static String getRelativePath(String path, String parentPath) {
        if (path == null) {
            return path;
        }
        if (path.startsWith(parentPath)) {
            return path.substring(parentPath.length());
        }
        return path;
    }

    public static String[] getPathArray(String path) {
        if (path == null) {
            return new String[0];
        }
        ArrayList<String> items = new ArrayList<String>();
        StringTokenizer st = new StringTokenizer(path, ",");
        while (st.hasMoreTokens()) {
            String s = st.nextToken().trim();
            if (s.length() <= 0) continue;
            items.add(s);
        }
        String[] arr = new String[items.size()];
        items.toArray(arr);
        return arr;
    }

    public static String getOwningProcessGuidFromPath(String path) {
        if (path == null) {
            return null;
        }
        int index = path.indexOf(",");
        String guid = index < 0 ? path : path.substring(0, index);
        return guid;
    }

    public static String getParentPath(String path) {
        if (path == null) {
            return null;
        }
        int index = path.lastIndexOf(",");
        if (index > 0) {
            return path.substring(0, index);
        }
        return null;
    }
}

