/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.util;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.epf.library.layout.IContentValidator;
import org.eclipse.epf.library.util.ResourceHelper;
import org.eclipse.epf.uma.MethodElement;

public class ContentResourceScanner {
    protected static final Pattern p_image_ref = Pattern.compile("(<(img|iframe).*?src\\s*=\\s*\")(.*?)(\")", 34);
    private File sourceRootPath;
    private File targetRootPath;
    private IContentValidator validator;
    private List processedItems = new ArrayList();

    public ContentResourceScanner(File sourceRootPath) {
        this(sourceRootPath, null);
    }

    public ContentResourceScanner(File sourceRootPath, IContentValidator validator) {
        this.sourceRootPath = sourceRootPath;
        this.validator = validator;
    }

    public void setValidator(IContentValidator validator) {
        this.validator = validator;
    }

    public void setTargetRootPath(File targetRootPath) {
        this.targetRootPath = targetRootPath;
    }

    public void resolveResources(String content, String contentPath) {
        this.resolveResources(null, content, contentPath);
    }

    public void resolveResources(MethodElement owner, String content, String contentPath) {
        this.processedItems.clear();
        ResourceHelper.resolveResources(owner, null, content, contentPath, this.sourceRootPath, this.targetRootPath, this.processedItems, this.validator);
    }

    public String resolveResourcesPlugin(String content, String contentPath, String oldContentPath) {
        StringBuffer sb = new StringBuffer();
        try {
            Matcher m = ResourceHelper.p_image_ref.matcher(content);
            while (m.find()) {
                String url = m.group(3);
                url = this.processResourceUrlPlugin(url, contentPath, oldContentPath);
                m.appendReplacement(sb, String.valueOf(m.group(1)) + url + m.group(4));
            }
            m.appendTail(sb);
            content = sb.toString();
            sb = new StringBuffer();
            m = ResourceHelper.p_link_ref_gen.matcher(content);
            while (m.find()) {
                Matcher m2;
                StringBuffer sbLink = new StringBuffer();
                String urltext = " " + m.group(2) + " ";
                if (ResourceHelper.getGuidFromUrl(urltext) != null || !(m2 = ResourceHelper.p_link_href_picker.matcher(urltext)).find()) continue;
                String url = m2.group(1).trim().replaceAll("\"", "");
                url = this.processResourceUrlPlugin(url, contentPath, oldContentPath);
                m2.appendReplacement(sbLink, String.valueOf(urltext.substring(m2.start(), m2.start(1))) + url + urltext.substring(m2.end(1), m2.end()));
                m2.appendTail(sbLink);
                m.appendReplacement(sb, String.valueOf(content.substring(m.start(), m.start(2))) + sbLink.toString() + content.substring(m.end(2), m.end()));
            }
            m.appendTail(sb);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return sb.toString();
    }

    private String processResourceUrlPlugin(String url, String contentPath, String oldContentPath) {
        String imageFile = ResourceHelper.getFilePathFromUrl(url, oldContentPath);
        if (imageFile == null) {
            return url;
        }
        String newUrl = null;
        File source = new File(this.sourceRootPath.getParentFile(), imageFile);
        if (imageFile.indexOf(File.separator) != -1) {
            String oldPlugin = imageFile.substring(0, imageFile.indexOf(File.separator));
            String newPlugin = this.targetRootPath.getName();
            newUrl = url.replaceFirst(oldPlugin, newPlugin);
            imageFile = imageFile.substring(imageFile.indexOf(File.separator));
        }
        File dest = new File(this.targetRootPath, imageFile);
        ResourceHelper.copyFile(source, dest);
        return newUrl;
    }
}

