/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.rcp;

import org.eclipse.epf.rcp.MainActionBarAdvisor;
import org.eclipse.epf.rcp.MainPlugin;
import org.eclipse.epf.rcp.RCPResources;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.application.ActionBarAdvisor;
import org.eclipse.ui.application.IActionBarConfigurer;
import org.eclipse.ui.application.IWorkbenchConfigurer;
import org.eclipse.ui.application.IWorkbenchWindowConfigurer;
import org.eclipse.ui.application.WorkbenchWindowAdvisor;
import org.eclipse.ui.internal.ActionSetContributionItem;
import org.eclipse.ui.internal.PluginActionContributionItem;
import org.eclipse.ui.intro.IIntroPart;

public class MainWorkbenchWindowAdvisor
extends WorkbenchWindowAdvisor {
    private static String[] fileMenuRemovalList = new String[]{"org.eclipse.ui.edit.text.newTextEditor", "org.eclipse.ui.edit.text.openExternalFile", "converstLineDelimitersTo"};
    private MainActionBarAdvisor mainActionBar;

    public MainWorkbenchWindowAdvisor(IWorkbenchWindowConfigurer configurer) {
        super(configurer);
    }

    public ActionBarAdvisor createActionBarAdvisor(IActionBarConfigurer configurer) {
        this.mainActionBar = new MainActionBarAdvisor(configurer);
        return this.mainActionBar;
    }

    public void postWindowCreate() {
        IWorkbenchWindowConfigurer configurer = this.getWindowConfigurer();
        Object data = configurer.getData("isRestoredWorkbench");
        if (data == null) {
            configurer.getWindow().getShell().setLocation(30, 30);
            configurer.getWindow().getShell().setSize(1024, 760);
        }
    }

    public void preWindowOpen() {
        IWorkbenchWindowConfigurer configurer = this.getWindowConfigurer();
        configurer.setShowCoolBar(true);
        configurer.setShowPerspectiveBar(true);
        configurer.setShowStatusLine(true);
        configurer.setTitle(MainPlugin.getDefault().getString("productName"));
    }

    public void postWindowOpen() {
        IWorkbenchWindowConfigurer configurer = this.getWindowConfigurer();
        configurer.getWindow().getShell().setImage(MainPlugin.getDefault().getSharedImage("full/obj16/product.gif"));
        MenuManager fileMmenu = this.mainActionBar.getFileMenuManager();
        IContributionItem[] items = fileMmenu.getItems();
        int i = 0;
        while (i < items.length) {
            if (this.needToRemoveFrom(items[i].getId(), fileMenuRemovalList)) {
                fileMmenu.remove(items[i]);
            }
            ++i;
        }
        MenuManager helpMmenu = this.mainActionBar.getHelpMenuManager();
        items = helpMmenu.getItems();
        int i2 = 0;
        while (i2 < items.length) {
            ActionSetContributionItem element;
            if (items[i2] instanceof ActionSetContributionItem && (element = (ActionSetContributionItem)items[i2]).getId().equals("org.eclipse.update.ui.updateMenu")) {
                IContributionItem contribMenuMgr = element.getInnerItem();
                IContributionItem[] subMenuItems = ((MenuManager)contribMenuMgr).getItems();
                int j = 0;
                while (j < subMenuItems.length) {
                    IContributionItem innerItem = ((ActionSetContributionItem)subMenuItems[j]).getInnerItem();
                    if (innerItem instanceof PluginActionContributionItem && innerItem.getId().equals("org.eclipse.update.ui.configManager")) {
                        IAction action = ((PluginActionContributionItem)innerItem).getAction();
                        action.setText(RCPResources.menu_help_software_updates_manage_software_config_text);
                    }
                    ++j;
                }
            }
            ++i2;
        }
    }

    private boolean needToRemoveFrom(String id, String[] list) {
        boolean rc = false;
        int i = 0;
        while (i < list.length) {
            if (list[i].equals(id)) {
                rc = true;
                break;
            }
            ++i;
        }
        return rc;
    }

    public void postWindowRestore() throws WorkbenchException {
        IWorkbenchWindowConfigurer configurer = this.getWindowConfigurer();
        configurer.setData("isRestoredWorkbench", (Object)"true");
    }

    public void openIntro() {
        super.openIntro();
        IWorkbenchWindowConfigurer configurer = this.getWindowConfigurer();
        Object data = configurer.getData("isRestoredWorkbench");
        if (data == null) {
            return;
        }
        IWorkbenchConfigurer wbConfig = this.getWindowConfigurer().getWorkbenchConfigurer();
        IIntroPart introPart = wbConfig.getWorkbench().getIntroManager().getIntro();
        wbConfig.getWorkbench().getIntroManager().setIntroStandby(introPart, true);
        if (!this.isIntroViewExistsInLastSession()) {
            this.closeIntroView();
        }
    }

    private boolean isIntroViewExistsInLastSession() {
        IPreferenceStore store = MainPlugin.getDefault().getPreferenceStore();
        return store.getBoolean("welcome_intro_view_exists");
    }

    private void closeIntroView() {
        try {
            IViewPart vp = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().findView("org.eclipse.ui.internal.introview");
            PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().hideView(vp);
        }
        catch (Exception exception) {}
    }
}

