/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.intro.impl.model.url;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.core.commands.common.CommandException;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.util.Geometry;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IActionDelegate;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.internal.RectangleAnimation;
import org.eclipse.ui.internal.intro.impl.IntroPlugin;
import org.eclipse.ui.internal.intro.impl.Messages;
import org.eclipse.ui.internal.intro.impl.model.AbstractIntroPage;
import org.eclipse.ui.internal.intro.impl.model.IntroLaunchBarElement;
import org.eclipse.ui.internal.intro.impl.model.IntroModelRoot;
import org.eclipse.ui.internal.intro.impl.model.IntroPartPresentation;
import org.eclipse.ui.internal.intro.impl.model.IntroTheme;
import org.eclipse.ui.internal.intro.impl.model.IntroURLAction;
import org.eclipse.ui.internal.intro.impl.model.loader.ExtensionPointManager;
import org.eclipse.ui.internal.intro.impl.model.loader.ModelLoaderUtil;
import org.eclipse.ui.internal.intro.impl.model.url.ShowHelpURLHandler;
import org.eclipse.ui.internal.intro.impl.model.util.ModelUtil;
import org.eclipse.ui.internal.intro.impl.parts.StandbyPart;
import org.eclipse.ui.internal.intro.impl.presentations.BrowserIntroPartImplementation;
import org.eclipse.ui.internal.intro.impl.presentations.IntroLaunchBar;
import org.eclipse.ui.internal.intro.impl.util.DialogUtil;
import org.eclipse.ui.internal.intro.impl.util.Log;
import org.eclipse.ui.internal.intro.impl.util.StringUtil;
import org.eclipse.ui.internal.intro.impl.util.Util;
import org.eclipse.ui.intro.IIntroPart;
import org.eclipse.ui.intro.IIntroSite;
import org.eclipse.ui.intro.config.CustomizableIntroPart;
import org.eclipse.ui.intro.config.IIntroAction;
import org.eclipse.ui.intro.config.IIntroURL;
import org.eclipse.ui.intro.config.IntroURLFactory;

public class IntroURL
implements IIntroURL {
    public static final String INTRO_PROTOCOL = "http";
    public static final String INTRO_HOST_ID = "org.eclipse.ui.intro";
    public static final String SET_STANDBY_MODE = "setStandbyMode";
    public static final String SHOW_STANDBY = "showStandby";
    public static final String CLOSE = "close";
    public static final String SHOW_HELP_TOPIC = "showHelpTopic";
    public static final String SHOW_HELP = "showHelp";
    public static final String OPEN_BROWSER = "openBrowser";
    public static final String OPEN_URL = "openURL";
    public static final String RUN_ACTION = "runAction";
    public static final String SHOW_PAGE = "showPage";
    public static final String SHOW_MESSAGE = "showMessage";
    public static final String NAVIGATE = "navigate";
    public static final String SWITCH_TO_LAUNCH_BAR = "switchToLaunchBar";
    public static final String EXECUTE = "execute";
    public static final String KEY_ID = "id";
    public static final String KEY_PLUGIN_ID = "pluginId";
    public static final String KEY_CLASS = "class";
    public static final String KEY_STANDBY = "standby";
    public static final String KEY_PART_ID = "partId";
    public static final String KEY_INPUT = "input";
    public static final String KEY_MESSAGE = "message";
    public static final String KEY_URL = "url";
    public static final String KEY_DIRECTION = "direction";
    public static final String KEY_EMBED = "embed";
    public static final String KEY_EMBED_TARGET = "embedTarget";
    public static final String KEY_DECODE = "decode";
    public static final String KEY_COMAND = "command";
    public static final String VALUE_BACKWARD = "backward";
    public static final String VALUE_FORWARD = "forward";
    public static final String VALUE_HOME = "home";
    public static final String VALUE_TRUE = "true";
    public static final String VALUE_FALSE = "false";
    private String action = null;
    private Properties parameters = null;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    IntroURL(String action, Properties parameters) {
        this.action = action;
        this.parameters = parameters;
    }

    public boolean execute() {
        final boolean[] result = new boolean[1];
        Display display = Display.getCurrent();
        BusyIndicator.showWhile((Display)display, (Runnable)new Runnable(){

            public void run() {
                result[0] = IntroURL.this.doExecute();
            }
        });
        return result[0];
    }

    protected boolean doExecute() {
        if (Log.logInfo) {
            String msg = StringUtil.concat("Running Intro URL action ", this.action, " with parameters: ", this.parameters.toString()).toString();
            Log.info(msg);
        }
        if (this.action.equals(CLOSE)) {
            return this.closeIntro();
        }
        if (this.action.equals(SET_STANDBY_MODE)) {
            return this.setStandbyState(this.getParameter(KEY_STANDBY));
        }
        if (this.action.equals(SHOW_STANDBY)) {
            return this.handleStandbyState(this.getParameter(KEY_PART_ID), this.getParameter(KEY_INPUT));
        }
        if (this.action.equals(SHOW_HELP)) {
            return this.showHelp();
        }
        if (this.action.equals(SHOW_HELP_TOPIC)) {
            return this.showHelpTopic(this.getParameter(KEY_ID), this.getParameter(KEY_EMBED), this.getParameter(KEY_EMBED_TARGET));
        }
        if (this.action.equals(OPEN_BROWSER)) {
            return this.openBrowser(this.getParameter(KEY_URL), this.getParameter(KEY_PLUGIN_ID));
        }
        if (this.action.equals(OPEN_URL)) {
            return this.openURL(this.getParameter(KEY_URL), this.getParameter(KEY_PLUGIN_ID));
        }
        if (this.action.equals(RUN_ACTION)) {
            return this.runAction(this.getParameter(KEY_PLUGIN_ID), this.getParameter(KEY_CLASS), this.parameters, this.getParameter(KEY_STANDBY));
        }
        if (this.action.equals(EXECUTE)) {
            return this.executeCommand(this.getParameter(KEY_COMAND), this.getParameter(KEY_STANDBY));
        }
        if (this.action.equals(SHOW_PAGE)) {
            return this.showPage(this.getParameter(KEY_ID), this.getParameter(KEY_STANDBY));
        }
        if (this.action.equals(SHOW_MESSAGE)) {
            return this.showMessage(this.getParameter(KEY_MESSAGE));
        }
        if (this.action.equals(NAVIGATE)) {
            return this.navigate(this.getParameter(KEY_DIRECTION));
        }
        if (this.action.equals(SWITCH_TO_LAUNCH_BAR)) {
            return this.switchToLaunchBar();
        }
        return this.handleCustomAction();
    }

    private boolean closeIntro() {
        return IntroPlugin.closeIntro();
    }

    private boolean handleStandbyState(String partId, String input) {
        StandbyPart standbyPart;
        boolean success;
        CustomizableIntroPart introPart = (CustomizableIntroPart)IntroPlugin.getIntro();
        if (introPart == null) {
            introPart = (CustomizableIntroPart)IntroPlugin.showIntro(true);
        }
        introPart.getControl().setData("showStandbyPart", (Object)VALUE_TRUE);
        IntroPlugin.setIntroStandby(true);
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ui.internal.intro.impl.parts.StandbyPart");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return success = (standbyPart = (StandbyPart)introPart.getAdapter(clazz)).showContentPart(partId, input);
    }

    private boolean setStandbyState(String state) {
        if (state == null) {
            return false;
        }
        boolean standby = state.equals(VALUE_TRUE);
        IIntroPart introPart = IntroPlugin.showIntro(standby);
        return introPart != null;
    }

    private boolean runAction(String pluginId, String className, Properties parameters, String standbyState) {
        block9: {
            block8: {
                Object actionObject = ModelLoaderUtil.createClassInstance(pluginId, className);
                try {
                    if (actionObject instanceof IIntroAction) {
                        IIntroAction introAction = (IIntroAction)actionObject;
                        IIntroSite site = IntroPlugin.getDefault().getIntroModelRoot().getPresentation().getIntroPart().getIntroSite();
                        introAction.run(site, parameters);
                        break block8;
                    }
                    if (actionObject instanceof IAction) {
                        IAction action = (IAction)actionObject;
                        action.run();
                        break block8;
                    }
                    if (actionObject instanceof IActionDelegate) {
                        final IActionDelegate delegate = (IActionDelegate)actionObject;
                        if (delegate instanceof IWorkbenchWindowActionDelegate) {
                            ((IWorkbenchWindowActionDelegate)delegate).init(PlatformUI.getWorkbench().getActiveWorkbenchWindow());
                        }
                        Action proxy = new Action(this.action){

                            public void run() {
                                delegate.run((IAction)this);
                            }
                        };
                        proxy.run();
                        break block8;
                    }
                    return false;
                }
                catch (Exception e) {
                    Log.error("Could not run action: " + className, e);
                    return false;
                }
            }
            if (standbyState != null) break block9;
            return true;
        }
        return this.setStandbyState(standbyState);
    }

    private boolean executeCommand(String command, String standbyState) {
        block4: {
            ICommandService commandService = this.getCommandService();
            if (commandService == null) {
                Log.error("Could not get ICommandService while trying to execute: " + command, null);
                return false;
            }
            try {
                ParameterizedCommand pCommand = commandService.deserialize(command);
                pCommand.executeWithChecks(null, null);
                if (standbyState != null) break block4;
                return true;
            }
            catch (CommandException ex) {
                Log.error("Could not execute command: " + command, ex);
                return false;
            }
        }
        return this.setStandbyState(standbyState);
    }

    private ICommandService getCommandService() {
        IWorkbench wb = PlatformUI.getWorkbench();
        if (wb != null) {
            Object serviceObject;
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("org.eclipse.ui.commands.ICommandService");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((serviceObject = wb.getAdapter((Class)clazz)) != null) {
                ICommandService service = (ICommandService)serviceObject;
                return service;
            }
        }
        return null;
    }

    private boolean showHelpTopic(String href, String embed, String embedTarget) {
        return new ShowHelpURLHandler(this).showHelpTopic(href, embed, embedTarget);
    }

    private boolean showHelp() {
        PlatformUI.getWorkbench().getHelpSystem().displayHelp();
        return true;
    }

    private boolean openBrowser(String url, String pluginId) {
        url = ModelUtil.resolveURL(url, pluginId);
        return Util.openBrowser(url);
    }

    private boolean openURL(String url, String pluginId) {
        IntroModelRoot model = IntroPlugin.getDefault().getIntroModelRoot();
        String presentationStyle = model.getPresentation().getImplementationKind();
        if (presentationStyle.equals("html")) {
            url = ModelUtil.resolveURL(url, pluginId);
            BrowserIntroPartImplementation impl = (BrowserIntroPartImplementation)IntroPlugin.getDefault().getIntroModelRoot().getPresentation().getIntroPartImplementation();
            Browser browser = impl.getBrowser();
            return browser.setUrl(url);
        }
        return this.openBrowser(url, pluginId);
    }

    private boolean showMessage(String message) {
        if (message == null) {
            return false;
        }
        DialogUtil.displayInfoMessage(null, message);
        return true;
    }

    boolean showPage(String pageId, String standbyState) {
        CustomizableIntroPart currentIntroPart = (CustomizableIntroPart)IntroPlugin.getIntro();
        currentIntroPart.getControl().setRedraw(false);
        IntroModelRoot modelRoot = IntroPlugin.getDefault().getIntroModelRoot();
        boolean success = modelRoot.setCurrentPageId(pageId);
        if (!success) {
            success = this.includePageToShow(modelRoot, pageId);
        }
        currentIntroPart.getControl().setRedraw(true);
        if (success) {
            modelRoot.getPresentation().updateHistory(modelRoot.getCurrentPage());
            if (standbyState == null) {
                return true;
            }
            return this.setStandbyState(standbyState);
        }
        return false;
    }

    private boolean includePageToShow(IntroModelRoot model, String pageId) {
        AbstractIntroPage page = this.findPageToShow(pageId);
        if (page == null) {
            Log.warning("Could not find an Intro page with id=" + pageId);
            return false;
        }
        page.getChildren();
        String currentPresentationKind = model.getPresentation().getImplementationKind();
        IntroPartPresentation targetPresentation = ((IntroModelRoot)page.getParent()).getPresentation();
        String targetSharedStyle = targetPresentation.getSharedStyle(currentPresentationKind);
        AbstractIntroPage clonedPage = null;
        try {
            clonedPage = (AbstractIntroPage)page.clone();
        }
        catch (CloneNotSupportedException ex) {
            Log.error("Failed to clone Intro model node.", ex);
            return false;
        }
        clonedPage.setParent(model);
        if (targetSharedStyle != null) {
            clonedPage.insertStyle(targetSharedStyle, 0);
        }
        model.addChild(clonedPage);
        return model.setCurrentPageId(clonedPage.getId());
    }

    private AbstractIntroPage findPageToShow(String pageId) {
        Hashtable models = ExtensionPointManager.getInst().getIntroModels();
        Enumeration values = models.elements();
        while (values.hasMoreElements()) {
            IntroModelRoot model = (IntroModelRoot)values.nextElement();
            AbstractIntroPage page = (AbstractIntroPage)model.findChild(pageId, 12);
            if (page == null) continue;
            return page;
        }
        return null;
    }

    private boolean navigate(String direction) {
        CustomizableIntroPart introPart = (CustomizableIntroPart)IntroPlugin.getIntro();
        if (introPart == null) {
            return false;
        }
        Class<?> clazz = class$2;
        if (clazz == null) {
            try {
                clazz = class$2 = Class.forName("org.eclipse.ui.internal.intro.impl.model.IntroPartPresentation");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        IntroPartPresentation presentation = (IntroPartPresentation)introPart.getAdapter(clazz);
        if (direction.equalsIgnoreCase(VALUE_BACKWARD)) {
            return presentation.navigateBackward();
        }
        if (direction.equalsIgnoreCase(VALUE_FORWARD)) {
            return presentation.navigateForward();
        }
        if (direction.equalsIgnoreCase(VALUE_HOME)) {
            return presentation.navigateHome();
        }
        return false;
    }

    public String getAction() {
        return this.action;
    }

    public String getParameter(String parameterId) {
        String value = this.parameters.getProperty(parameterId);
        String decode = this.parameters.getProperty(KEY_DECODE);
        if (value != null) {
            try {
                if (decode != null && decode.equalsIgnoreCase(VALUE_TRUE)) {
                    return StringUtil.decode(value, "UTF-8");
                }
                return value;
            }
            catch (Exception e) {
                Log.error("Failed to decode URL: " + parameterId, e);
            }
        }
        return value;
    }

    private boolean handleCustomAction() {
        IntroURLAction command = ExtensionPointManager.getInst().getSharedConfigExtensionsManager().getCommand(this.action);
        if (command == null) {
            String message = Messages.IntroURL_badCommand;
            DialogUtil.displayInfoMessage(null, message, new Object[]{this.action});
            return false;
        }
        StringBuffer url = new StringBuffer();
        url.append("http://org.eclipse.ui.intro/");
        url.append(command.getReplaceValue().trim());
        if (command.getReplaceValue().indexOf("?") == -1) {
            url.append("?");
        } else {
            url.append("&");
        }
        url.append(this.retrieveInitialQuery());
        IIntroURL introURL = IntroURLFactory.createIntroURL(url.toString());
        if (introURL != null) {
            return introURL.execute();
        }
        return false;
    }

    private String retrieveInitialQuery() {
        StringBuffer query = new StringBuffer();
        Enumeration<Object> keys = this.parameters.keys();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            query.append(key);
            query.append("=");
            query.append(this.parameters.get(key));
            if (!keys.hasMoreElements()) continue;
            query.append("&");
        }
        return query.toString();
    }

    private boolean switchToLaunchBar() {
        IIntroPart intro = PlatformUI.getWorkbench().getIntroManager().getIntro();
        if (intro == null) {
            return false;
        }
        CustomizableIntroPart cpart = (CustomizableIntroPart)intro;
        IntroModelRoot modelRoot = IntroPlugin.getDefault().getIntroModelRoot();
        String pageId = modelRoot.getCurrentPageId();
        IntroTheme theme = modelRoot.getTheme();
        Rectangle bounds = cpart.getControl().getBounds();
        Rectangle startBounds = Geometry.toDisplay((Control)cpart.getControl().getParent(), (Rectangle)bounds);
        this.closeIntro();
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        IntroLaunchBarElement launchBarElement = modelRoot.getPresentation().getLaunchBarElement();
        if (launchBarElement == null) {
            return true;
        }
        IntroLaunchBar launchBar = new IntroLaunchBar(launchBarElement.getOrientation(), pageId, launchBarElement, theme);
        launchBar.createInActiveWindow();
        Rectangle endBounds = Geometry.toDisplay((Control)launchBar.getControl().getParent(), (Rectangle)launchBar.getControl().getBounds());
        RectangleAnimation animation = new RectangleAnimation(window.getShell(), startBounds, endBounds);
        animation.schedule();
        return true;
    }
}

