<?xml version="1.0" encoding="UTF-8"?>
<!-- 
    Copyright (c) 2005, 2006 IBM Corporation and others.
    All rights reserved. This program and the accompanying materials
    are made available under the terms of the Eclipse Public License v1.0
    which accompanies this distribution, and is available at
    http://www.eclipse.org/legal/epl-v10.html
    Contributors:
    IBM Corporation - initial implementation
-->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance">
	<xsl:include href="helper.xsl"/>
	<xsl:template match="/Element">
		<xsl:variable name="elementType" select="@Type"/>
		<xsl:variable name="elementTypeName" select="@TypeName"/>
		<xsl:variable name="elementName" select="@Name"/>
		<xsl:variable name="elementPresentationName" select="@DisplayName"/>
		<xsl:variable name="backPath" select="@BackPath"/>
		<xsl:variable name="imagePath" select="concat($backPath, 'images/')"/>
		<xsl:variable name="shapeImage" select="concat($backPath,@ShapeiconUrl)"/>
		<xsl:variable name="presentation" select="reference[@name='presentation']"/>
		<xsl:variable name="contentDescription" select="$presentation/Element"/>
		<xsl:variable name="copyright" select="copyright"/>
		<xsl:variable name="showTreeBrowser" select="@showTreeBrowser"/>
		<xsl:variable name="responsibleRole" select="reference[@name='responsibleRole']/Element[@Type='Role']"/>
		<xsl:variable name="queryString" select="@queryString"/>
		<xsl:variable name="relProcessPath" select="@relProcessPath"/>
		<html>
			<head>
				<title>
					<xsl:value-of select="$elementTypeName"/>: <xsl:value-of select="$elementPresentationName"/>
				</title>
				<xsl:call-template name="umaMetaTags">
					<xsl:with-param name="elementType" select="$elementType"/>
					<xsl:with-param name="elementName" select="$elementName"/>
					<xsl:with-param name="elementPresentationName" select="$elementPresentationName"/>
				</xsl:call-template>
				<meta name="element_type">
					<xsl:call-template name="mapping">
						<xsl:with-param name="elementType" select="$elementType"/>
					</xsl:call-template>
				</meta>
				<!-- <meta name="element_type" content="{$elementType}"/> -->
				<meta name="filetype" content="description"/>
				<meta name="role">
					<xsl:attribute name="content"><xsl:value-of select="$responsibleRole/@DisplayName"/></xsl:attribute>
				</meta>
				<link rel="StyleSheet" href="{$backPath}css/default.css" type="text/css"/>
				<script language="JavaScript" type="text/javascript" src="{$backPath}scripts/elementUrls.js"></script>
				<script language="JavaScript" type="text/javascript" src="{$backPath}scripts/contentpage.js"/>
				<script language="JavaScript" type="text/javascript" src="{$backPath}scripts/treetable.js"/>
				<script language="JavaScript" type="text/javascript" src="{$backPath}scripts/activitylayout.js"/>
				<script language="JavaScript" type="text/javascript">
					backPath = '<xsl:value-of select="$backPath"/>';
					imgPath = '<xsl:value-of select="$imagePath"/>';

					// get url parameters here
					// query string from url take precedence, if not, use the one passed in form xml
					// this handles both published site, and browsing, where user click in a node, there is no url parameter
					var defaultQueryStr = '<xsl:value-of select="$queryString"/>';
					var queryStr = location.search;
					if ( queryStr == null || queryStr == "" )
					{
						queryStr = defaultQueryStr;
					}
					var parameters = getUrlParameters(queryStr.substring(1));
					var par_proc = parameters["proc"];
					var par_path = parameters["path"];
//					document.write( "queryStr=" + queryStr + "&lt;br/&gt;");
//					document.write( "proc=" + par_proc + "&lt;br/&gt;");
//					document.write( "path=" + par_path + "&lt;br/&gt;");
					
					initialize(imgPath);
					
				</script>
			</head>
			<body onload="createSectionLinks('div', 'sectionHeading', '{$imagePath}');createTree('div', 'treeNode', '{$imagePath}');">
				<script language="JavaScript" type="text/javascript">buildProcessElementBreadCrumb(backPath);</script>
				<table border="0" cellpadding="0" cellspacing="0" width="100%">
					<tr>
						<td valign="top">
							<xsl:call-template name="overview">
								<xsl:with-param name="elementType" select="$elementType"/>
								<xsl:with-param name="elementTypeName" select="$elementTypeName"/>
								<xsl:with-param name="elementPresentationName" select="$elementPresentationName"/>
								<xsl:with-param name="elementIcon" select="$shapeImage"/>
								<xsl:with-param name="backPath" select="$backPath"/>
								<xsl:with-param name="showTreeBrowser" select="$showTreeBrowser"/>
							</xsl:call-template>
							<xsl:call-template name="activityTabs"/>
							<xsl:call-template name="workflowSection"/>
							<xsl:call-template name="tbsSection"/>
							<xsl:call-template name="copyright">
								<xsl:with-param name="copyright" select="$copyright"/>
							</xsl:call-template>
						</td>
					</tr>
				</table>
			</body>
		</html>
	</xsl:template>
	<xsl:template name="activityTabs">
		<xsl:variable name="imagePath" select="concat(/Element/@BackPath, 'images/')"/>
		<table width="100%" border="0" cellspacing="0" cellpadding="0">
			<tr valign="middle">
				<td class="tab">
					<img src="{$imagePath}shim.gif" width="10" height="17" alt=""/>
				</td>
				<td nowrap="nowrap" class="tab">
					<a class="tab">
						<xsl:call-template name="tabUrlAttribute">
							<xsl:with-param name="url" select="concat(/Element/@BackPath, tabs/tab[@name='Description']/@url)"/>
						</xsl:call-template>
						<xsl:value-of select="$descriptionText"/>
					</a>
				</td>
				<td width="21">
					<img src="{$imagePath}tab_middle-i_i.gif" width="21" height="17" align="absmiddle" alt=""/>
				</td>
				<td nowrap="nowrap" class="tab">
					<a class="tab">
						<xsl:call-template name="tabUrlAttribute">
							<xsl:with-param name="url" select="concat(/Element/@BackPath, tabs/tab[@name='WBS']/@url)"/>
						</xsl:call-template>
						<span style="white-space:nowrap;">
							<xsl:value-of select="$wbsText"/>
						</span>
					</a>
				</td>
				<td width="1">
					<img src="{$imagePath}tab_middle-i_a.gif" width="21" height="17" align="absmiddle" alt=""/>
				</td>
				<td nowrap="nowrap" class="activeTab">
					<span style="white-space:nowrap;">
						<xsl:value-of select="$tbsText"/>
					</span>
				</td>
				<td width="21">
					<img src="{$imagePath}tab_middle-a_i.gif" width="21" height="17" align="absmiddle" alt=""/>
				</td>
				<td nowrap="nowrap" class="tab">
					<a class="tab">
						<xsl:call-template name="tabUrlAttribute">
							<xsl:with-param name="url" select="concat(/Element/@BackPath, tabs/tab[@name='WPBS']/@url)"/>
						</xsl:call-template>
						<span style="white-space:nowrap;">
							<xsl:value-of select="$wpbsText"/>
						</span>
					</a>
				</td>
				<td width="21">
					<img src="{$imagePath}tab_end-i.gif" width="21" height="17" alt=""/>
				</td>
				<td width="50%">
					<img src="{$imagePath}shim.gif" width="10" height="17" alt=""/>
				</td>
			</tr>
			<tr>
				<td colspan="4">
					<img src="{$imagePath}shim.gif" alt="" height="2"/>
				</td>
				<td>
					<img src="{$imagePath}tab_space_middle.gif" width="21" height="2" alt=""/>
				</td>
				<td class="activeTab">
					<img src="{$imagePath}shim.gif" width="10" height="2" alt=""/>
				</td>
				<td>
					<img src="{$imagePath}tab_space.gif" width="21" height="2" alt=""/>
				</td>
				<td colspan="3">
					<img src="{$imagePath}shim.gif" height="2" alt=""/>
				</td>
			</tr>
			<tr>
				<td colspan="10" class="activeTab">
					<img src="{$imagePath}shim.gif" height="5" alt=""/>
				</td>
			</tr>
		</table>
	</xsl:template>
	<xsl:template name="workflowSection">
		<xsl:if test="count(breakdown[@name='Team Breakdown Structure']/Element[@Type='TeamProfile']) > 0">
			<div class="sectionHeading">
				<xsl:value-of select="$teamStructureText"/>
			</div>
			<div class="sectionContent">
				<p align="left"/>
				<script type="text/javascript" language="JavaScript">
		var teamTree = [
				<xsl:for-each select="breakdown[@name='Team Breakdown Structure']/Element[@Type='TeamProfile' and @hasSuperTeam = 'false' ]">
						<xsl:call-template name="teamStructure">
							<xsl:with-param name="element" select="."/>
						</xsl:call-template>
					</xsl:for-each>
	];
	buildTeamTree(par_proc, par_path, teamTree);
					</script>
			</div>
		</xsl:if>
	</xsl:template>
	<xsl:template name="teamStructure">
		<xsl:param name="element"/>
	["<xsl:value-of select="concat(/Element/@BackPath, $element/@Url)"/>", "<xsl:value-of select="$element/@DisplayName"/>", "<xsl:value-of select="$element/@relProcessPath"/>", "<xsl:value-of select="$element/@isSupressed"/>", 
		<xsl:if test="count($element/Element[@Type='TeamProfile']) > 0">
			<xsl:for-each select="$element/Element[@Type='TeamProfile']">
				<xsl:call-template name="teamStructure">
					<xsl:with-param name="element" select="."/>
				</xsl:call-template>
			</xsl:for-each>
		</xsl:if>
		],
	</xsl:template>
	<xsl:template name="tbsSection">
		<xsl:variable name="imagePath" select="concat(/Element/@BackPath, 'images/')"/>
		<div class="sectionHeading">
			<xsl:value-of select="$teamProfileBreakdownText"/>
		</div>
		<div class="sectionContent">
			<table class="breakdownTable" width="100%" border="0" cellpadding="0" cellspacing="1" bordercolor="#999999">
				<!--
				<tr valign="top">
					<th nowrap="nowrap">
						<xsl:value-of select="$prefixText"/>
					</th>
					<th width="600px">
						<xsl:value-of select="$breakdownElementText"/>
					</th>
					<th nowrap="nowrap">
						<xsl:value-of select="$modelInfoText"/>
					</th>
					<th nowrap="nowrap">
						<xsl:value-of select="$typeText"/>
					</th>
				</tr>
-->
				<script language="JavaScript">
					<xsl:for-each select="breakdown[@name='Team Breakdown Structure']/columns/column">
					wbsItemHtml.addColumn("<xsl:value-of select="@id"/>", "<xsl:value-of select="@label"/>");
					</xsl:for-each>
					wbsItemHtml.writeHeader();
				<xsl:for-each select="breakdown[@name='Team Breakdown Structure']/Element">
						<xsl:call-template name="wbsItem">
							<xsl:with-param name="element" select="."/>
							<xsl:with-param name="indent" select="0"/>
							<xsl:with-param name="parentNodeId" select=" '' "/>
						</xsl:call-template>
					</xsl:for-each>
				</script>
			</table>
		</div>
	</xsl:template>
	<xsl:template name="wbsItem">
		<xsl:param name="element"/>
		<xsl:param name="parentNodeId"/>
		<xsl:param name="indent"/>
		<xsl:variable name="imagePath" select="concat(/Element/@BackPath, 'images/')"/>
		<xsl:variable name="hasChildren">
			<xsl:choose>
				<xsl:when test="count($element/Element) > 0">true</xsl:when>
				<xsl:otherwise>false</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		wbsItemHtml.initRow("<xsl:value-of select="$element/@nodeId"/>", "<xsl:value-of select="$parentNodeId"/>", "<xsl:value-of select="$element/@relProcessPath"/>", "<xsl:value-of select="$element/@isSupressed"/>", <xsl:value-of select="$indent"/>, <xsl:value-of select="$hasChildren"/>, "<xsl:value-of select="$element/@Index"/>", "<xsl:value-of select="$element/attribute[@name='prefix']"/>", "<xsl:value-of select="$element/@DisplayName"/>", "<xsl:value-of select="concat(/Element/@BackPath, $element/@Url)"/>", "", "<xsl:value-of select="$element/@Predecessors"/>", "<xsl:value-of select="$element/@ModelInfo"/>", "<xsl:value-of select="$element/@TypeName"/>", "<xsl:value-of select="$element/attribute[@name='isRepeatable']"/>", "<xsl:value-of select="$element/attribute[@name='hasMultipleOccurrences']"/>", "<xsl:value-of select="$element/attribute[@name='isOptional']"/>", "<xsl:value-of select="$element/attribute[@name='isPlanned']"/>",  "<xsl:value-of select="$element/attribute[@name='isOngoing']"/>", "<xsl:value-of select="$element/attribute[@name='isEventDriven']"/>", "<xsl:value-of select="$element/@Team"/>", "", "","");
wbsItemHtml.writeRow();	
		<!--
		<tr class="treeNode">
			<xsl:attribute name="id"><xsl:value-of select="$element/@nodeId"/></xsl:attribute>
			<xsl:attribute name="parentId"><xsl:value-of select="$parentNodeId"/></xsl:attribute>
			<xsl:attribute name="relProcessPath"><xsl:value-of select="$element/@relProcessPath"/></xsl:attribute>
			<xsl:attribute name="isSupressed"><xsl:value-of select="$element/@isSupressed"/></xsl:attribute>
			<td bgcolor="#cccccc">
				<xsl:value-of select="$element/attribute[@name='prefix']"/>&#160;</td>
			<td width="100%">
					<xsl:call-template name="createTreeNode">
					<xsl:with-param name="indent" select="$indent"/>
					<xsl:with-param name="hasChildren" select="$hasChildren"/>				
					<xsl:with-param name="title" select="$element/@DisplayName"/>			
					<xsl:with-param name="url" select="concat(/Element/@BackPath, $element/@Url)"/>
					<xsl:with-param name="relProcessPath" select="$element/@relProcessPath"/>
					</xsl:call-template>

			</td>
			<td nowrap="nowrap" bgcolor="#cccccc">
				<xsl:value-of select="$element/@ModelInfo"/>&#160;</td>
			<td nowrap="nowrap">
				<xsl:value-of select="$element/@TypeName"/>
			</td>
		</tr>
-->
		<xsl:if test="count($element/Element) > 0">
			<xsl:for-each select="$element/Element">
				<xsl:call-template name="wbsItem">
					<xsl:with-param name="element" select="."/>
					<xsl:with-param name="indent" select="$indent+1"/>
					<xsl:with-param name="parentNodeId" select="$element/@nodeId"/>
				</xsl:call-template>
			</xsl:for-each>
		</xsl:if>
	</xsl:template>
</xsl:stylesheet>
