<?xml version="1.0" encoding="UTF-8"?>
<!-- 
    Copyright (c) 2005, 2006 IBM Corporation and others.
    All rights reserved. This program and the accompanying materials
    are made available under the terms of the Eclipse Public License v1.0
    which accompanies this distribution, and is available at
    http://www.eclipse.org/legal/epl-v10.html
    Contributors:
    IBM Corporation - initial implementation
-->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance">
	<xsl:param name="activityEntryStateText"/>
	<xsl:param name="activityExitStateText"/>
	<xsl:param name="additionalInfoText"/>
	<xsl:param name="additionallyPerformsText"/>
	<xsl:param name="additionalPerformerText"/>
	<xsl:param name="additionalText"/>
	<xsl:param name="aggregatesText"/>
	<xsl:param name="alternativesText"/>
	<xsl:param name="applicationText"/>
	<xsl:param name="assetsText"/>
	<xsl:param name="assignmentApproachesText"/>
	<xsl:param name="assistingText"/>
	<xsl:param name="backgroundText"/>
	<xsl:param name="basedOnMethodRoleText"/>
	<xsl:param name="basedOnMethodTaskText"/>
	<xsl:param name="basedOnMethodWorkProductText"/>
	<xsl:param name="breakdownElementText"/>
	<xsl:param name="briefOutlineText"/>
	<xsl:param name="checkItemsText"/>
	<xsl:param name="checklistsText"/>
	<xsl:param name="checklistText"/>
	<xsl:param name="collapseAllText"/>
	<xsl:param name="communicationsMaterialsText"/>
	<xsl:param name="conceptsText"/>
	<xsl:param name="containedArtifactsText"/>
	<xsl:param name="containerArtifactText"/>
	<xsl:param name="contentElementsText"/>
	<xsl:param name="contentReferencesText"/>
	<xsl:param name="contentsText"/>
	<xsl:param name="contextText"/>
	<xsl:param name="contributesText"/>
	<xsl:param name="deliverablePropertiesText"/>
	<xsl:param name="deliveredPartsText"/>
	<xsl:param name="dependentText"/>
	<xsl:param name="descriptionText"/>
	<xsl:param name="disciplinesText"/>
	<xsl:param name="disciplineText"/>
	<xsl:param name="domainText"/>
	<xsl:param name="educationMaterialsText"/>
	<xsl:param name="elementDoesNotExistText"/>
	<xsl:param name="elementMightBeDeletedText"/>
	<xsl:param name="elementNameText"/>
	<xsl:param name="elementTypeText"/>
	<xsl:param name="entryStateText"/>
	<xsl:param name="estimatingTechniqueText"/>
	<xsl:param name="eventDrivenText"/>
	<xsl:param name="examplesText"/>
	<xsl:param name="exitStateText"/>
	<xsl:param name="expandAllText"/>
	<xsl:param name="extendsText"/>
	<xsl:param name="externalDescriptionText"/>
	<xsl:param name="externalIdText"/>
	<xsl:param name="externalText"/>
	<xsl:param name="goalsText"/>
	<xsl:param name="guidelinesText"/>
	<xsl:param name="guidText"/>
	<xsl:param name="illustrationsText"/>
	<xsl:param name="impactingText"/>
	<xsl:param name="impactOfNotHavingText"/>
	<xsl:param name="includedPatternsText"/>
	<xsl:param name="indexText"/>
	<xsl:param name="infoAboutMissingElementText"/>
	<xsl:param name="inputsText"/>
	<xsl:param name="inputToText"/>
	<xsl:param name="isNotValidText"/>
	<xsl:param name="keyConsiderationsText"/>
	<xsl:param name="levelsOfAdoptionText"/>
	<xsl:param name="mainDescriptionText"/>
	<xsl:param name="mainResponsibleText"/>
	<xsl:param name="mainText"/>
	<xsl:param name="mandatoryText"/>
	<xsl:param name="missingElementText"/>
	<xsl:param name="modelInfoText"/>
	<xsl:param name="modifiedByText"/>
	<xsl:param name="modifiesText"/>
	<xsl:param name="moreInfoText"/>
	<xsl:param name="multipleOccurrencesText"/>
	<xsl:param name="noneText"/>
	<xsl:param name="notationText"/>
	<xsl:param name="notAvailableText"/>
	<xsl:param name="ongoingText"/>
	<xsl:param name="optionalText"/>
	<xsl:param name="outputFromText"/>
	<xsl:param name="outputsText"/>
	<xsl:param name="packagingGuidanceText"/>
	<xsl:param name="packagingInstructionsText"/>
	<xsl:param name="pageNotInstalledText"/>
	<xsl:param name="parentActivitiesText"/>
	<xsl:param name="performingRolesText"/>
	<xsl:param name="performsText"/>
	<xsl:param name="plannedText"/>
	<xsl:param name="planningDataText"/>
	<xsl:param name="pleaseFixLinkText"/>
	<xsl:param name="pluginNameText"/>
	<xsl:param name="predecessorsText"/>
	<xsl:param name="predecessorText"/>
	<xsl:param name="prefixText"/>
	<xsl:param name="primaryPerformerText"/>
	<xsl:param name="problemText"/>
	<xsl:param name="projectCharacteristicsText"/>
	<xsl:param name="projectMemberExpertiseText"/>
	<xsl:param name="projectSpecificsText"/>
	<xsl:param name="propertiesText"/>
	<xsl:param name="purposeText"/>
	<xsl:param name="reasonsForNotNeedingText"/>
	<xsl:param name="referenceWorkflowsText"/>
	<xsl:param name="relatedElementsText"/>
	<xsl:param name="relationshipsText"/>
	<xsl:param name="repeatableText"/>
	<xsl:param name="replacesText"/>
	<xsl:param name="reportsText"/>
	<xsl:param name="representationOptionsText"/>
	<xsl:param name="responsibleForText"/>
	<xsl:param name="responsibleText"/>
	<xsl:param name="reusableAssetsText"/>
	<xsl:param name="riskLevelText"/>
	<xsl:param name="roadmapText"/>
	<xsl:param name="roleSetsText"/>
	<xsl:param name="rolesText"/>
	<xsl:param name="scaleText"/>
	<xsl:param name="scopeText"/>
	<xsl:param name="skillsText"/>
	<xsl:param name="staffingText"/>
	<xsl:param name="stepsText"/>
	<xsl:param name="subcategoriesText"/>
	<xsl:param name="subdomainsText"/>
	<xsl:param name="subPracticesText"/>
	<xsl:param name="subTeamsText"/>
	<xsl:param name="summaryText"/>
	<xsl:param name="supportingMaterialsText"/>
	<xsl:param name="synonymsText"/>
	<xsl:param name="tailoringText"/>
	<xsl:param name="tasksText"/>
	<xsl:param name="tbsText"/>
	<xsl:param name="teamProfileBreakdownText"/>
	<xsl:param name="teamRolesText"/>
	<xsl:param name="teamStructureText"/>
	<xsl:param name="teamText"/>
	<xsl:param name="techniquesText"/>
	<xsl:param name="templateFilesText"/>
	<xsl:param name="templatesText"/>
	<xsl:param name="toolMentorsText"/>
	<xsl:param name="toolText"/>
	<xsl:param name="typeofContractText"/>
	<xsl:param name="typeText"/>
	<xsl:param name="usageGuidanceText"/>
	<xsl:param name="usageNotesText"/>
	<xsl:param name="usageText"/>
	<xsl:param name="wbsText"/>
	<xsl:param name="whitepapersText"/>
	<xsl:param name="workBreakdownText"/>
	<xsl:param name="workflowText"/>
	<xsl:param name="workProductBreakdownText"/>
	<xsl:param name="workProductDependenciesText"/>
	<xsl:param name="workProductsText"/>
	<xsl:param name="workProductTypesText"/>
	<xsl:param name="wpbsText"/>
	<xsl:param name="estimationConsiderationsText"/>
	<xsl:param name="activityReferencesText"/>	
	
	<xsl:template name="umaMetaTags">
		<xsl:param name="elementType"/>
		<xsl:param name="elementName"/>
		<xsl:param name="elementPresentationName"/>
		<meta name="uma.type" content="{$elementType}"/>
		<meta name="uma.name" content="{$elementName}"/>
		<meta name="uma.presentationName" content="{$elementPresentationName}"/>
		<xsl:if test="$elementType = 'Role'">
			<xsl:call-template name="roleMetaInfo"/>
		</xsl:if>
		<xsl:if test="$elementType = 'Task'">
			<xsl:call-template name="taskMetaInfo"/>
		</xsl:if>
		<xsl:if test="$elementType = 'Artifact' or $elementType = 'Deliverable' or $elementType = 'Outcome'">
			<xsl:call-template name="workProductMetaInfo"/>
		</xsl:if>
		<xsl:if test="$elementType = 'ToolMentor'">
			<xsl:call-template name="toolMentorMetaInfo"/>
		</xsl:if>
	</xsl:template>
	<xsl:template name="workProductMetaInfo">
		<xsl:variable name="domain" select="reference[@name='domain']/Element"/>
		<xsl:variable name="workProductTypes" select="referenceList[@name='workProductTypes']/Element[@Type='WorkProductType']"/>
		<meta name="uma.category" content="{$domain/@Type}:{$domain/@Name}:{$domain/@DisplayName}"/>
		<xsl:if test="count($workProductTypes) > 0">
			<xsl:for-each select="$workProductTypes">
				<meta name="uma.category" content="{$workProductTypes/@Type}:{$workProductTypes/@Name}:{$workProductTypes/@DisplayName}"/>
			</xsl:for-each>
		</xsl:if>
	</xsl:template>
	<xsl:template name="taskMetaInfo">
		<xsl:variable name="disciplines" select="referenceList[@name='disciplines']/Element[@Type='Discipline']"/>
		<xsl:if test="count($disciplines) > 0">
			<xsl:for-each select="$disciplines">
				<meta name="uma.category" content="{$disciplines/@Type}:{$disciplines/@Name}:{$disciplines/@DisplayName}"/>
			</xsl:for-each>
		</xsl:if>
	</xsl:template>
	<xsl:template name="roleMetaInfo">
		<xsl:variable name="roleSets" select="referenceList[@name='roleSets']/Element[@Type='RoleSet']"/>
		<xsl:if test="$roleSets/@Name != ''">
			<meta name="uma.category" content="{$roleSets/@Type}:{$roleSets/@Name}:{$roleSets/@DisplayName}"/>
		</xsl:if>
	</xsl:template>
	<xsl:template name="toolMentorMetaInfo">
		<xsl:variable name="tool" select="reference[@name='tool']/Element"/>
		<xsl:if test="$tool/@Name != ''">
			<meta name="uma.category" content="{$tool/@Type}:{$tool/@Name}:{$tool/@DisplayName}"/>
		</xsl:if>
	</xsl:template>
	<xsl:template name="overview">
		<xsl:param name="elementType"/>
		<xsl:param name="elementTypeName"/>
		<xsl:param name="elementPresentationName"/>
		<xsl:param name="elementIcon"/>
		<xsl:param name="backPath"/>
		<xsl:param name="showTreeBrowser"/>
		<xsl:variable name="prefix" select="attribute[@name='prefix']"/>
		<xsl:variable name="briefDescription" select="attribute[@name='briefDescription']"/>
		<xsl:variable name="synonyms" select="reference/Element/attribute[@name='synonyms']"/>
		<xsl:variable name="externalId" select="reference/Element/attribute[@name='externalId']"/>
		<xsl:variable name="imagePath" select="concat(/Element/@BackPath, 'images/')"/>
		<table border="0" cellspacing="0" cellpadding="0">
			<tr>
				<td class="pageTitle" nowrap="true">
					<xsl:choose>
						<xsl:when test="$elementType = 'CustomCategory' or $elementType = 'SupportingMaterial' or $elementType = 'Summary'">
							<xsl:value-of select="$elementPresentationName"/>
						</xsl:when>
						<xsl:when test="$elementType = 'TeamProfile' and $prefix != ''">
							<xsl:value-of select="$elementTypeName"/>: <xsl:value-of select="$prefix"/> - <xsl:value-of select="$elementPresentationName"/>
						</xsl:when>
						<xsl:otherwise>
							<xsl:value-of select="$elementTypeName"/>: <xsl:value-of select="$elementPresentationName"/>
						</xsl:otherwise>
					</xsl:choose>
					<xsl:if test="$externalId != ''">
						(<xsl:value-of select="$externalId"/>)
					</xsl:if>
				</td>
				<xsl:if test="$showTreeBrowser">
					<td width="100%" class="expandCollapseLink" align="right">
						<a href="{$backPath}index.htm"/>
						<script language="JavaScript" type="text/javascript" src="{$backPath}scripts/treebrowser.js"/>
					</td>
				</xsl:if>
			</tr>
		</table>
		<table width="100%" border="0" cellpadding="0" cellspacing="0">
			<tr>
				<td class="pageTitleSeparator">
					<img src="{$imagePath}shim.gif" alt="" height="1"/>
				</td>
			</tr>
		</table>
		<xsl:choose>
			<xsl:when test="$elementType = 'CustomCategory' and $briefDescription = ''">
				<br/>
			</xsl:when>
			<xsl:otherwise>
				<div class="overview">
					<table width="97%" border="0" cellspacing="0" cellpadding="0">
						<tr>
							<xsl:if test="$briefDescription != ''">
								<td width="50">
									<img src="{$elementIcon}" alt=""/>
								</td>
							</xsl:if>
							<td>
								<table class="overviewTable" border="0" cellspacing="0" cellpadding="0">
									<tr>
										<td valign="top">
											<xsl:value-of disable-output-escaping="yes" select="$briefDescription"/>
										</td>
									</tr>
									<xsl:if test="$elementType = 'Role'">
										<xsl:call-template name="roleKeyInfo"/>
									</xsl:if>
									<xsl:if test="$elementType = 'Task'">
										<xsl:call-template name="taskKeyInfo"/>
									</xsl:if>
									<xsl:if test="$elementType = 'Artifact' or $elementType = 'Deliverable' or $elementType = 'Outcome'">
										<xsl:call-template name="workProductKeyInfo"/>
									</xsl:if>
									<xsl:if test="$elementType = 'ToolMentor'">
										<xsl:call-template name="toolMentorKeyInfo"/>
									</xsl:if>
									<xsl:if test="$elementType = 'TaskDescriptor'">
										<xsl:call-template name="taskDescriptorKeyInfo"/>
									</xsl:if>
									<xsl:if test="$elementType = 'RoleDescriptor'">
										<xsl:call-template name="roleDescriptorKeyInfo"/>
									</xsl:if>
									<xsl:if test="$elementType = 'WorkProductDescriptor'">
										<xsl:call-template name="workProductDescriptorKeyInfo"/>
									</xsl:if>
								</table>
							</td>
						</tr>
					</table>
				</div>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="roleKeyInfo">
		<xsl:variable name="synonyms" select="reference/Element/attribute[@name='synonyms']"/>
		<xsl:variable name="baseRole" select="reference[@name='variabilityBasedOnElement']/Element[@Type='Role']"/>
		<xsl:variable name="roleSets" select="referenceList[@name='roleSets']/Element[@Type='RoleSet']"/>
		<xsl:variable name="variabilityType" select="attribute[@name='variabilityType']"/>
		<xsl:if test="$synonyms != ''">
			<tr>
				<td>
					<xsl:value-of select="$synonymsText"/>:&#160;
					<xsl:value-of disable-output-escaping="yes" select="$synonyms"/>
				</td>
			</tr>
		</xsl:if>
		<xsl:if test="count($baseRole) > 0">
			<tr>
				<td>
					<xsl:if test="$variabilityType = 'replaces'">
						<xsl:value-of select="$replacesText"/>:&#160;
					</xsl:if>
					<xsl:if test="$variabilityType = 'contributes'">
						<xsl:value-of select="$contributesText"/>:&#160;
					</xsl:if>
					<xsl:if test="$variabilityType = 'extends'">
						<xsl:value-of select="$extendsText"/>:&#160;
					</xsl:if>
					<xsl:for-each select="$baseRole">
						<xsl:call-template name="addElementWithLink">
							<xsl:with-param name="element" select="."/>
						</xsl:call-template>
					</xsl:for-each>
				</td>
			</tr>
		</xsl:if>
		<xsl:if test="count($roleSets) > 0">
		<xsl:variable name="size" select="count($roleSets)" />
			<tr>
				<td>
					<xsl:value-of select="$roleSetsText"/>:&#160;	
					<xsl:for-each select="$roleSets">

					<xsl:call-template name="addElementWithLink">
							<xsl:with-param name="element" select="."/>
						</xsl:call-template>
						<xsl:if test="position() != $size">,&#160;</xsl:if>

						
					</xsl:for-each>
				</td>
			</tr>
		</xsl:if>
	</xsl:template>
	<xsl:template name="roleDescriptorKeyInfo">
		<xsl:variable name="sourceRole" select="reference[@name='Role']/Element[@Type='Role']"/>
		<xsl:if test="count($sourceRole) > 0">
			<tr>
				<td>
					<xsl:value-of select="$basedOnMethodRoleText"/>:&#160;
					<xsl:for-each select="$sourceRole">
						<xsl:call-template name="addElementWithLink">
							<xsl:with-param name="element" select="."/>
						</xsl:call-template>
					</xsl:for-each>
				</td>
			</tr>
		</xsl:if>
	</xsl:template>
	<xsl:template name="taskKeyInfo">
		<xsl:variable name="disciplines" select="referenceList[@name='disciplines']/Element[@Type='Discipline']"/>
		<xsl:variable name="baseTask" select="reference[@name='variabilityBasedOnElement']/Element"/>
		<xsl:if test="count($disciplines) > 0">
			<tr>
				<td>
					<xsl:value-of select="$disciplinesText"/>:&#160;
					<xsl:for-each select="$disciplines">
						<xsl:call-template name="addElementWithLink">
							<xsl:with-param name="element" select="."/>
						</xsl:call-template>
						<xsl:if test="count($disciplines) > position()">,&#160;</xsl:if>
					</xsl:for-each>
					<xsl:if test="count($baseTask) > 0">
						<xsl:if test="count($disciplines) > 0">
							<br/>
						</xsl:if>
						<xsl:value-of select="$extendsText"/>:&#160;			
						<xsl:for-each select="$baseTask">
							<xsl:call-template name="addElementWithLink">
								<xsl:with-param name="element" select="."/>
							</xsl:call-template>
						</xsl:for-each>
					</xsl:if>
				</td>
			</tr>
		</xsl:if>
	</xsl:template>
	<xsl:template name="taskDescriptorKeyInfo">
		<xsl:variable name="sourceTask" select="reference[@name='Task']/Element[@Type='Task']"/>
		<xsl:if test="count($sourceTask) > 0">
			<tr>
				<td>
					<xsl:value-of select="$basedOnMethodTaskText"/>:&#160;
					<xsl:for-each select="$sourceTask">
						<xsl:call-template name="addElementWithLink">
							<xsl:with-param name="element" select="."/>
						</xsl:call-template>
					</xsl:for-each>
				</td>
			</tr>
		</xsl:if>
	</xsl:template>
	<xsl:template name="workProductDescriptorKeyInfo">
		<xsl:variable name="sourceWorkProduct" select="reference[@name='WorkProduct']/Element"/>
		<xsl:if test="count($sourceWorkProduct) > 0">
			<tr>
				<td>
					<xsl:value-of select="$basedOnMethodWorkProductText"/>:&#160;
					<xsl:for-each select="$sourceWorkProduct">
						<xsl:call-template name="addElementWithLink">
							<xsl:with-param name="element" select="."/>
						</xsl:call-template>
					</xsl:for-each>
				</td>
			</tr>
		</xsl:if>
	</xsl:template>
	<xsl:template name="workProductKeyInfo">
		<xsl:variable name="domain" select="reference[@name='domain']/Element"/>
		<xsl:variable name="baseWorkProduct" select="reference[@name='variabilityBasedOnElement']/Element"/>
		<xsl:variable name="workProductTypes" select="referenceList[@name='workProductTypes']/Element[@Type='WorkProductType']"/>
		<xsl:variable name="variabilityType" select="attribute[@name='variabilityType']"/>
		<tr>
			<td>
				<xsl:if test="count($domain) > 0">
					<xsl:value-of select="$domainText"/>:&#160;
					<xsl:for-each select="$domain">
						<xsl:call-template name="addElementWithLink">
							<xsl:with-param name="element" select="."/>
						</xsl:call-template>
					</xsl:for-each>
				</xsl:if>
				<xsl:if test="count($workProductTypes) > 0">
					<xsl:if test="count($domain) > 0">
						<br/>
					</xsl:if>
					<xsl:value-of select="$workProductTypesText"/>:&#160;
					<xsl:for-each select="$workProductTypes">
						<xsl:call-template name="addElementWithLink">
							<xsl:with-param name="element" select="."/>
						</xsl:call-template>
						<xsl:if test="count($workProductTypes) > position()">,&#160;</xsl:if>
					</xsl:for-each>
				</xsl:if>
				<xsl:if test="count($baseWorkProduct) > 0">
					<xsl:if test="count($domain) + count($workProductTypes) > 0">
						<br/>
					</xsl:if>
					<xsl:if test="$variabilityType = 'replaces'">
						<xsl:value-of select="$replacesText"/>:&#160;
					</xsl:if>
					<xsl:if test="$variabilityType = 'contributes'">
						<xsl:value-of select="$contributesText"/>:&#160;
					</xsl:if>
					<xsl:if test="$variabilityType = 'extends'">
						<xsl:value-of select="$extendsText"/>:&#160;
					</xsl:if>
					<xsl:for-each select="$baseWorkProduct">
						<xsl:call-template name="addElementWithLink">
							<xsl:with-param name="element" select="."/>
						</xsl:call-template>
					</xsl:for-each>
				</xsl:if>
			</td>
		</tr>
	</xsl:template>
	<xsl:template name="toolMentorKeyInfo">
		<xsl:variable name="tool" select="reference[@name='tool']/Element"/>
		<tr>
			<td>
				<xsl:if test="count($tool) > 0">
					<xsl:value-of select="$toolText"/>:&#160;
					<xsl:for-each select="$tool">
						<xsl:call-template name="addElementWithLink">
							<xsl:with-param name="element" select="."/>
						</xsl:call-template>
					</xsl:for-each>
				</xsl:if>
			</td>
		</tr>
	</xsl:template>
	<xsl:template name="overviewSeparator">
		<xsl:variable name="imagePath" select="concat(/Element/@BackPath, 'images/')"/>
		<table id="overviewSeparator" width="100%" border="0" cellpadding="0" cellspacing="0">
			<tr>
				<td class="overviewSeparator">
					<img src="{$imagePath}shim.gif" alt="" height="1"/>
				</td>
			</tr>
			<tr>
				<td>
					<img src="{$imagePath}shim.gif" alt="" height="5"/>
				</td>
			</tr>
		</table>
	</xsl:template>
	<xsl:template name="illustrationsSection">
		<xsl:variable name="examples" select="referenceList/Element[@Type='Example']"/>
		<xsl:variable name="reusableAssets" select="referenceList/Element[@Type='ReusableAsset']"/>
		<xsl:if test="count($examples) + count($reusableAssets) > 0">
			<div class="sectionHeading">
				<xsl:value-of select="$illustrationsText"/>
			</div>
			<div class="sectionContent">
				<table class="sectionTable" border="0" cellspacing="0" cellpadding="0">
					<xsl:call-template name="addExamples">
						<xsl:with-param name="examples" select="$examples"/>
					</xsl:call-template>
					<xsl:call-template name="addReusableAssets">
						<xsl:with-param name="reusableAssets" select="$reusableAssets"/>
					</xsl:call-template>
				</table>
			</div>
		</xsl:if>
	</xsl:template>
	<xsl:template name="purposeSection">
		<xsl:param name="description"/>
		<xsl:variable name="purpose" select="$description/attribute[@name='purpose']"/>
		<xsl:if test="$purpose != ''">
			<div class="sectionHeading">
				<xsl:value-of select="$purposeText"/>
			</div>
			<div class="sectionContent">
				<table class="sectionTable" border="0" cellspacing="0" cellpadding="0">
					<tr valign="top">
						<td class="sectionTableCell">
							<xsl:value-of disable-output-escaping="yes" select="$purpose"/>
						</td>
					</tr>
				</table>
			</div>
		</xsl:if>
	</xsl:template>
	<xsl:template name="keyConsiderationsSection">
		<xsl:param name="description"/>
		<xsl:variable name="keyConsiderations" select="$description/attribute[@name='keyConsiderations']"/>
		<xsl:if test="$keyConsiderations != ''">
			<div class="sectionHeading">
				<xsl:value-of select="$keyConsiderationsText"/>
			</div>
			<div class="sectionContent">
				<table class="sectionTable" border="0" cellspacing="0" cellpadding="0">
					<tr valign="top">
						<td class="sectionTableCell">
							<xsl:value-of disable-output-escaping="yes" select="$keyConsiderations"/>
						</td>
					</tr>
				</table>
			</div>
		</xsl:if>
	</xsl:template>
	<xsl:template name="examplesSection">
		<xsl:variable name="examples" select="referenceList[@name='examples']"/>
		<xsl:if test="$examples != ''">
			<div class="sectionHeading">
				<xsl:value-of select="$examplesText"/>
			</div>
			<div class="sectionContent">
				<table class="sectionTable" border="0" cellspacing="0" cellpadding="0">
					<tr valign="top">
						<td class="sectionTableCell">
							<ul>
								<xsl:for-each select="$examples/Element[@Type='Example']">
									<li>
										<xsl:call-template name="addElementWithLink">
											<xsl:with-param name="element" select="."/>
										</xsl:call-template>
									</li>
								</xsl:for-each>
							</ul>
						</td>
					</tr>
				</table>
			</div>
		</xsl:if>
	</xsl:template>
	<xsl:template name="mainDescriptionSection">
		<xsl:param name="description"/>
		<xsl:variable name="mainDescription" select="$description/attribute[@name='mainDescription']"/>
		<xsl:if test="$mainDescription != ''">
			<div class="sectionHeading">
				<xsl:value-of select="$mainDescriptionText"/>
			</div>
			<div class="sectionContent">
				<table class="sectionTable" border="0" cellspacing="0" cellpadding="0">
					<tr valign="top">
						<td class="sectionTableCell">
							<xsl:value-of disable-output-escaping="yes" select="$mainDescription"/>
						</td>
					</tr>
				</table>
			</div>
		</xsl:if>
	</xsl:template>
	<xsl:template name="refinedDescriptionSection">
		<xsl:param name="description"/>
		<xsl:variable name="refinedDescription" select="$description/attribute[@name='refinedDescription']"/>
		<xsl:if test="$refinedDescription != ''">
			<div class="sectionHeading">
				<xsl:value-of select="$mainDescriptionText"/>
			</div>
			<div class="sectionContent">
				<table class="sectionTable" border="0" cellspacing="0" cellpadding="0">
					<tr valign="top">
						<td class="sectionTableCell">
							<xsl:value-of disable-output-escaping="yes" select="$refinedDescription"/>
						</td>
					</tr>
				</table>
			</div>
		</xsl:if>
	</xsl:template>
	<xsl:template name="assetsSection">
		<xsl:variable name="reusableAssets" select="referenceList/Element[@Type='ReusableAsset']"/>
		<xsl:if test="$reusableAssets != '' ">
			<div class="sectionHeading">
				<xsl:value-of select="$assetsText"/>
			</div>
			<div class="sectionContent">
				<table class="sectionTable" border="0" cellspacing="0" cellpadding="0">
					<xsl:call-template name="addReusableAssets">
						<xsl:with-param name="reusableAssets" select="$reusableAssets"/>
					</xsl:call-template>
				</table>
			</div>
		</xsl:if>
	</xsl:template>
	<xsl:template name="anotationSection">
		<xsl:param name="description"/>
		<xsl:variable name="briefOutline" select="$description/attribute[@name='briefOutline']"/>
		<xsl:variable name="representationOptions" select="$description/attribute[@name='representationOptions']"/>
		<xsl:if test="$briefOutline != '' or $representationOptions != ''">
			<div class="sectionHeading">
				<xsl:value-of select="$notationText"/>
			</div>
			<div class="sectionContent">
				<table class="sectionTable" border="0" cellspacing="0" cellpadding="0">
					<xsl:if test="$briefOutline != ''">
						<tr valign="top">
							<th class="sectionTableHeading" scope="row">
								<xsl:value-of select="$briefOutlineText"/>
							</th>
							<td class="sectionTableCell">
								<xsl:value-of disable-output-escaping="yes" select="$briefOutline"/>
							</td>
						</tr>
					</xsl:if>
					<xsl:if test="$representationOptions != ''">
						<tr valign="top">
							<th class="sectionTableHeading" scope="row">
								<xsl:value-of select="$representationOptionsText"/>
							</th>
							<td class="sectionTableCell">
								<xsl:value-of disable-output-escaping="yes" select="$representationOptions"/>
							</td>
						</tr>
					</xsl:if>
				</table>
			</div>
		</xsl:if>
	</xsl:template>
	<xsl:template name="tailoringSection">
		<xsl:param name="description"/>
		<xsl:variable name="impactOfNotHaving" select="$description/attribute[@name='impactOfNotHaving']"/>
		<xsl:variable name="reasonsForNotNeeding" select="$description/attribute[@name='reasonsForNotNeeding']"/>
		<xsl:variable name="representationOptions" select="$description/attribute[@name='representationOptions']"/>
		<xsl:if test="$impactOfNotHaving != '' or $reasonsForNotNeeding != '' or $representationOptions != ''">
			<div class="sectionHeading">
				<xsl:value-of select="$tailoringText"/>
			</div>
			<div class="sectionContent">
				<table class="sectionTable" border="0" cellspacing="0" cellpadding="0">
					<xsl:if test="$impactOfNotHaving != ''">
						<tr valign="top">
							<th class="sectionTableHeading" scope="row">
								<xsl:value-of select="$impactOfNotHavingText"/>
							</th>
							<td class="sectionTableCell">
								<xsl:value-of disable-output-escaping="yes" select="$impactOfNotHaving"/>
							</td>
						</tr>
					</xsl:if>
					<xsl:if test="$reasonsForNotNeeding != ''">
						<tr valign="top">
							<th class="sectionTableHeading" scope="row">
								<xsl:value-of select="$reasonsForNotNeedingText"/>
							</th>
							<td class="sectionTableCell">
								<xsl:value-of disable-output-escaping="yes" select="$reasonsForNotNeeding"/>
							</td>
						</tr>
					</xsl:if>
					<xsl:if test="$representationOptions != ''">
						<tr valign="top">
							<th class="sectionTableHeading" scope="row">
								<xsl:value-of select="$representationOptionsText"/>
							</th>
							<td class="sectionTableCell">
								<xsl:value-of disable-output-escaping="yes" select="$representationOptions"/>
							</td>
						</tr>
					</xsl:if>
				</table>
			</div>
		</xsl:if>
	</xsl:template>
	<xsl:template name="copyright">
		<xsl:param name="copyright"/>
		<table class="copyright" border="0" cellspacing="0" cellpadding="0">
			<tr>
				<td class="copyright">
					<xsl:value-of disable-output-escaping="yes" select="$copyright"/>
				</td>
			</tr>
		</table>
	</xsl:template>
	<xsl:template name="generalTextFieldSection">
		<xsl:param name="fieldLabel"/>
		<xsl:param name="fieldText"/>
		<xsl:if test="$fieldText != ''">
			<div class="sectionHeading">
				<xsl:value-of select="$fieldLabel"/>
			</div>
			<div class="sectionContent">
				<table class="sectionTable" border="0" cellspacing="0" cellpadding="0">
					<tr valign="top">
						<td class="sectionTableCell">
							<xsl:value-of disable-output-escaping="yes" select="$fieldText"/>
						</td>
					</tr>
				</table>
			</div>
		</xsl:if>
	</xsl:template>
	<xsl:template name="addChecklists">
		<xsl:param name="checklists"/>
		<xsl:if test="count($checklists) > 0">
			<tr valign="top">
				<th class="sectionTableHeading" scope="row">
					<xsl:value-of select="$checklistsText"/>
				</th>
				<td class="sectionTableCell">
					<ul>
						<xsl:for-each select="$checklists">
							<li>
								<xsl:call-template name="addElementWithLink">
									<xsl:with-param name="element" select="."/>
								</xsl:call-template>
							</li>
						</xsl:for-each>
					</ul>
				</td>
			</tr>
		</xsl:if>
	</xsl:template>
	<xsl:template name="addConcepts">
		<xsl:param name="concepts"/>
		<xsl:if test="count($concepts) > 0">
			<tr valign="top">
				<th class="sectionTableHeading" scope="row">
					<xsl:value-of select="$conceptsText"/>
				</th>
				<td class="sectionTableCell">
					<ul>
						<xsl:for-each select="$concepts">
							<li>
								<xsl:call-template name="addElementWithLink">
									<xsl:with-param name="element" select="."/>
								</xsl:call-template>
							</li>
						</xsl:for-each>
					</ul>
				</td>
			</tr>
		</xsl:if>
	</xsl:template>
	<xsl:template name="addExamples">
		<xsl:param name="examples"/>
		<xsl:if test="count($examples) > 0">
			<tr valign="top">
				<th class="sectionTableHeading" scope="row">
					<xsl:value-of select="$examplesText"/>
				</th>
				<td class="sectionTableCell">
					<ul>
						<xsl:for-each select="$examples">
							<li>
								<xsl:call-template name="addElementWithLink">
									<xsl:with-param name="element" select="."/>
								</xsl:call-template>
							</li>
						</xsl:for-each>
					</ul>
				</td>
			</tr>
		</xsl:if>
	</xsl:template>
	<xsl:template name="addGuidelines">
		<xsl:param name="guidelines"/>
		<xsl:if test="count($guidelines) > 0">
			<tr valign="top">
				<th class="sectionTableHeading" scope="row">
					<xsl:value-of select="$guidelinesText"/>
				</th>
				<td class="sectionTableCell">
					<ul>
						<xsl:for-each select="$guidelines">
							<li>
								<xsl:call-template name="addElementWithLink">
									<xsl:with-param name="element" select="."/>
								</xsl:call-template>
							</li>
						</xsl:for-each>
					</ul>
				</td>
			</tr>
		</xsl:if>
	</xsl:template>
	<xsl:template name="addReports">
		<xsl:param name="reports"/>
		<xsl:if test="count($reports) > 0">
			<tr valign="top">
				<th class="sectionTableHeading" scope="row">
					<xsl:value-of select="$reportsText"/>
				</th>
				<td class="sectionTableCell">
					<ul>
						<xsl:for-each select="$reports">
							<li>
								<xsl:call-template name="addElementWithLink">
									<xsl:with-param name="element" select="."/>
								</xsl:call-template>
							</li>
						</xsl:for-each>
					</ul>
				</td>
			</tr>
		</xsl:if>
	</xsl:template>
	<xsl:template name="addReusableAssets">
		<xsl:param name="reusableAssets"/>
		<xsl:if test="count($reusableAssets) > 0">
			<tr valign="top">
				<th class="sectionTableHeading" scope="row">
					<xsl:value-of select="$reusableAssetsText"/>
				</th>
				<td class="sectionTableCell">
					<ul>
						<xsl:for-each select="$reusableAssets">
							<li>
								<xsl:call-template name="addElementWithLink">
									<xsl:with-param name="element" select="."/>
								</xsl:call-template>
							</li>
						</xsl:for-each>
					</ul>
				</td>
			</tr>
		</xsl:if>
	</xsl:template>
	<xsl:template name="addSupportingMaterials">
		<xsl:param name="supportingMaterials"/>
		<xsl:if test="count($supportingMaterials) > 0">
			<tr valign="top">
				<th class="sectionTableHeading" scope="row">
					<xsl:value-of select="$supportingMaterialsText"/>
				</th>
				<td class="sectionTableCell">
					<ul>
						<xsl:for-each select="$supportingMaterials">
							<li>
								<xsl:call-template name="addElementWithLink">
									<xsl:with-param name="element" select="."/>
								</xsl:call-template>
							</li>
						</xsl:for-each>
					</ul>
				</td>
			</tr>
		</xsl:if>
	</xsl:template>
	<xsl:template name="addTechniques">
		<xsl:param name="techniques"/>
		<xsl:if test="count($techniques) > 0">
			<tr valign="top">
				<th class="sectionTableHeading" scope="row">
					<xsl:value-of select="$techniquesText"/>
				</th>
				<td class="sectionTableCell">
					<ul>
						<xsl:for-each select="$techniques">
							<li>
								<xsl:call-template name="addElementWithLink">
									<xsl:with-param name="element" select="."/>
								</xsl:call-template>
							</li>
						</xsl:for-each>
					</ul>
				</td>
			</tr>
		</xsl:if>
	</xsl:template>
	<xsl:template name="addTemplates">
		<xsl:param name="templates"/>
		<xsl:if test="count($templates) > 0">
			<tr valign="top">
				<th class="sectionTableHeading" scope="row">
					<xsl:value-of select="$templatesText"/>
				</th>
				<td class="sectionTableCell">
					<ul>
						<xsl:for-each select="$templates">
							<li>
								<xsl:call-template name="addElementWithLink">
									<xsl:with-param name="element" select="."/>
								</xsl:call-template>
							</li>
						</xsl:for-each>
					</ul>
				</td>
			</tr>
		</xsl:if>
	</xsl:template>
	<xsl:template name="addWhitePapers">
		<xsl:param name="whitePapers"/>
		<xsl:if test="count($whitePapers) > 0">
			<tr valign="top">
				<th class="sectionTableHeading" scope="row">
					<xsl:value-of select="$whitepapersText"/>
				</th>
				<td class="sectionTableCell">
					<ul>
						<xsl:for-each select="$whitePapers">
							<li>
								<xsl:call-template name="addElementWithLink">
									<xsl:with-param name="element" select="."/>
								</xsl:call-template>
							</li>
						</xsl:for-each>
					</ul>
				</td>
			</tr>
		</xsl:if>
	</xsl:template>
	<xsl:template name="addEstimationConsiderations">
		<xsl:param name="estimationConsiderations"/>
		<xsl:if test="count($estimationConsiderations) > 0">
			<tr valign="top">
				<th class="sectionTableHeading" scope="row">
					<xsl:value-of select="$estimationConsiderationsText"/>
				</th>
				<td class="sectionTableCell">
					<ul>
						<xsl:for-each select="$estimationConsiderations">
							<li>
								<xsl:call-template name="addElementWithLink">
									<xsl:with-param name="element" select="."/>
								</xsl:call-template>
							</li>
						</xsl:for-each>
					</ul>
				</td>
			</tr>
		</xsl:if>
	</xsl:template>
	<xsl:template name="addToolMentors">
		<xsl:param name="toolMentors"/>
		<xsl:if test="count($toolMentors) > 0">
			<tr valign="top">
				<th class="sectionTableHeading" scope="row">
					<xsl:value-of select="$toolMentorsText"/>
				</th>
				<td class="sectionTableCell">
					<ul>
						<xsl:for-each select="$toolMentors">
							<li>
								<xsl:call-template name="addElementWithLink">
									<xsl:with-param name="element" select="."/>
								</xsl:call-template>
							</li>
						</xsl:for-each>
					</ul>
				</td>
			</tr>
		</xsl:if>
	</xsl:template>
	<!-- add general references -->
	<xsl:template name="addReferences">
		<xsl:param name="refName"/>
		<xsl:param name="refElement"/>
		<xsl:if test="$refElement">
			<xsl:if test="count($refElement)>0">
				<tr valign="top">
					<th class="sectionTableHeading" scope="row">
						<xsl:value-of select="$refName"/>
					</th>
					<td class="sectionTableCell">
						<ul>
							<xsl:for-each select="$refElement">
								<li>
									<xsl:call-template name="addElementWithLink">
										<xsl:with-param name="element" select="."/>
									</xsl:call-template>
								</li>
							</xsl:for-each>
						</ul>
					</td>
				</tr>
			</xsl:if>
		</xsl:if>
	</xsl:template>
	<xsl:template name="notationSection">
		<xsl:param name="description"/>
		<xsl:variable name="externalDescription" select="$description/attribute[@name='externalDescription']"/>
		<xsl:variable name="packagingGuidance" select="$description/attribute[@name='packagingGuidance']"/>
		<xsl:if test="$externalDescription != '' or $packagingGuidance != '' ">
			<div class="sectionHeading">
				<xsl:value-of select="$notationText"/>
			</div>
			<div class="sectionContent">
				<table class="sectionTable" border="0" cellspacing="0" cellpadding="0">
					<xsl:if test="$externalDescription != ''">
						<tr valign="top">
							<th class="sectionTableHeading" scope="row">
								<xsl:value-of select="$externalDescriptionText"/>
							</th>
							<td class="sectionTableCell">
								<xsl:value-of disable-output-escaping="yes" select="$externalDescription"/>
							</td>
						</tr>
					</xsl:if>
					<xsl:if test="$packagingGuidance != ''">
						<tr valign="top">
							<th class="sectionTableHeading" scope="row">
								<xsl:value-of select="$packagingGuidanceText"/>
							</th>
							<td class="sectionTableCell">
								<xsl:value-of disable-output-escaping="yes" select="$packagingGuidance"/>
							</td>
						</tr>
					</xsl:if>
				</table>
			</div>
		</xsl:if>
	</xsl:template>
	<xsl:template name="property">
		<xsl:param name="fieldLabel"/>
		<xsl:param name="fieldText"/>
		<xsl:variable name="imagePath" select="concat(/Element/@BackPath, 'images/')"/>
		<xsl:if test="$fieldText != '' ">
			<tr valign="top">
				<th class="sectionTableHeading" scope="row">
					<xsl:value-of select="$fieldLabel"/>
				</th>
				<xsl:choose>
					<xsl:when test="$fieldText = 'true' or $fieldText = 'false'">
						<td class="sectionTableCell" align="left">
							<img width="20" height="15" alt="">
								<xsl:attribute name="src"><xsl:choose><xsl:when test="$fieldText = 'true'"><xsl:value-of select="$imagePath"/>true.gif</xsl:when><xsl:otherwise><xsl:value-of select="$imagePath"/>indent.gif</xsl:otherwise></xsl:choose></xsl:attribute>
							</img>
							<!--
							<label for="cbox1"/>
							<input type="checkbox" name="property">
								<xsl:attribute name="readonly">true</xsl:attribute>
								<xsl:if test="$fieldText = 'true'">
									<xsl:attribute name="checked">checked</xsl:attribute>
								</xsl:if>
								<xsl:attribute name="id">cbox1</xsl:attribute>
								<xsl:attribute name="value">cbox1</xsl:attribute>
								<xsl:attribute name="onclick"><xsl:choose><xsl:when test="$fieldText = 'true'">
	 								this.checked=true;
 								</xsl:when><xsl:otherwise>
 									this.checked=false;
 								</xsl:otherwise></xsl:choose></xsl:attribute>
							</input>
							-->
						</td>
					</xsl:when>
					<xsl:otherwise>
						<td class="sectionTableCell">
							<xsl:value-of disable-output-escaping="yes" select="$fieldText"/>
						</td>
					</xsl:otherwise>
				</xsl:choose>
			</tr>
		</xsl:if>
	</xsl:template>
	<!-- add general list without references -->
	<xsl:template name="addcontexts">
		<xsl:param name="refName"/>
		<xsl:param name="refElement"/>
		<xsl:if test="$refElement">
			<xsl:if test="count($refElement)>0">
				<tr valign="top">
					<th class="sectionTableHeading" scope="row">
						<xsl:value-of select="$refName"/>
					</th>
					<td class="sectionTableCell">
						<ul>
							<xsl:for-each select="$refElement">
								<li>
									<a>
										<xsl:value-of select="@DisplayName"/>
									</a>
								</li>
							</xsl:for-each>
						</ul>
					</td>
				</tr>
			</xsl:if>
		</xsl:if>
	</xsl:template>
	<xsl:template name="addElementWithLink">
		<xsl:param name="element"/>
		<xsl:choose>
			<xsl:when test="$element/@Url != '' ">
				<a>
					<xsl:attribute name="href"><xsl:value-of select="/Element/@BackPath"/><xsl:value-of select="$element/@Url"/></xsl:attribute>
					<xsl:value-of disable-output-escaping="yes" select="$element/@DisplayName"/>
				</a>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of disable-output-escaping="yes" select="$element/@DisplayName"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="mapping">
		<xsl:param name="elementType"/>
		<xsl:choose>
			<xsl:when test="$elementType = 'Task'">
				<xsl:attribute name="content"><xsl:value-of select="'activity'"/></xsl:attribute>
			</xsl:when>
			<xsl:when test="$elementType = 'ToolMentor'">
				<xsl:attribute name="content"><xsl:value-of select="'tool_mentor'"/></xsl:attribute>
			</xsl:when>
			<xsl:when test="$elementType = 'Outcome'">
				<xsl:attribute name="content"><xsl:value-of select="'artifact'"/></xsl:attribute>
			</xsl:when>
			<xsl:when test="$elementType = 'Deliverable'">
				<xsl:attribute name="content"><xsl:value-of select="'artifact'"/></xsl:attribute>
			</xsl:when>
			<xsl:when test="$elementType = 'Activity'">
				<xsl:attribute name="content"><xsl:value-of select="'workflow_detail'"/></xsl:attribute>
			</xsl:when>
			<xsl:when test="$elementType = 'Concept'">
				<xsl:attribute name="content"><xsl:value-of select="'concept'"/></xsl:attribute>
			</xsl:when>
			<xsl:when test="$elementType = 'Example'">
				<xsl:attribute name="content"><xsl:value-of select="'example'"/></xsl:attribute>
			</xsl:when>
			<xsl:otherwise>
				<xsl:attribute name="content"><xsl:value-of select="'other'"/></xsl:attribute>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<!-- activity specific common templates -->
	<xsl:template name="tabUrlAttribute">
		<xsl:param name="url"/>
		<xsl:attribute name="href">javascript:location.href=getTabUrl('<xsl:value-of select="$url"/>', queryStr);</xsl:attribute>
	</xsl:template>
	<xsl:template name="itemUrlAttribute">
		<xsl:param name="url"/>
		<xsl:param name="relProcessPath"/>
		<xsl:attribute name="href">javascript:location.href=getActivityItemUrl('<xsl:value-of select="$url"/>', par_proc, par_path, '<xsl:value-of select="$relProcessPath"/>');</xsl:attribute>
	</xsl:template>
	<xsl:template name="displayDiagram">
		<xsl:param name="diagram"/>
		<p>
			<map name="{$diagram/map/@name}">
				<xsl:for-each select="$diagram/map/area">
					<area>
						<xsl:attribute name="href">javascript:location.href=getActivityItemUrl('<xsl:value-of select="@href"/>', par_proc, par_path, ',<xsl:value-of select="@guid"/>');</xsl:attribute>
						<xsl:attribute name="alt"><xsl:value-of select="@alt"/></xsl:attribute>
						<xsl:attribute name="coords"><xsl:value-of select="@coords"/></xsl:attribute>
						<xsl:attribute name="shape"><xsl:value-of select="@shape"/></xsl:attribute>
					</area>
				</xsl:for-each>
			</map>
			<script language="JavaScript">
				
				// get the image from path, if not, use the default one (which is for browsing)
				var diagram_img = getDiagramImageUrl(par_proc, par_path, '<xsl:value-of select="$diagram/@name"/>');
				if ( diagram_img == null ) {
					diagram_img = '<xsl:value-of select="$diagram/map/@src"/>';
				}
				var attributes = ' src="' + diagram_img + '" border="0"  alt="<xsl:value-of select="$diagram/map/@alt"/>" usemap="#<xsl:value-of select="$diagram/map/@name"/>"';
				<![CDATA[
				document.write('<img ' + attributes + '/>');
				]]></script>
		</p>
	</xsl:template>
	<xsl:template name="createTreeNode">
		<xsl:param name="indent"/>
		<xsl:param name="hasChildren"/>
		<xsl:param name="title"/>
		<xsl:param name="url"/>
		<xsl:param name="relProcessPath"/>
		<script language="JavaScript">writeTreeNodeTable(<xsl:value-of select="$indent"/>, <xsl:value-of select="$hasChildren"/>, "<xsl:value-of select="$title"/>", "<xsl:value-of select="$url"/>", "<xsl:value-of select="$relProcessPath"/>");</script>
	</xsl:template>
</xsl:stylesheet>